/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public enum PHPVersion {
    PHP5("php5"),
    PHP5_3("php5.3"),
    PHP5_4("php5.4"),
    PHP5_5("php5.5"),
    PHP5_6("php5.6"),
    PHP7_0("php7.0"),
    PHP7_1("php7.1");

    private String alias;

    private PHPVersion(String alias) {
        this.alias = alias;
        Aliases.map.put(alias, this);
    }

    public String getAlias() {
        return this.alias;
    }

    public static PHPVersion byAlias(String alias) {
        return (PHPVersion)((Object)Aliases.map.get(alias));
    }

    public boolean isLessThan(PHPVersion phpVersion) {
        return this.ordinal() < phpVersion.ordinal();
    }

    public boolean isGreaterThan(PHPVersion phpVersion) {
        return this.ordinal() > phpVersion.ordinal();
    }

    public static Collection<PHPVersion> getAllVersions() {
        return Aliases.map.values();
    }

    public static PHPVersion[] supportedVersions() {
        return new PHPVersion[]{PHP7_1, PHP7_0, PHP5_6, PHP5_5, PHP5_4, PHP5_3, PHP5};
    }

    public static PHPVersion getLatestVersion() {
        return PHP7_0;
    }

    public static PHPVersion translate(org.eclipse.php.core.PHPVersion phpVersion) {
        return PHPVersion.valueOf(phpVersion.name());
    }

    public org.eclipse.php.core.PHPVersion toApi() {
        return org.eclipse.php.core.PHPVersion.valueOf(this.name());
    }

    public static PHPVersion fromApi(org.eclipse.php.core.PHPVersion api) {
        return PHPVersion.valueOf(api.name());
    }

    private static class Aliases {
        private static Map<String, PHPVersion> map = new HashMap<String, PHPVersion>();

        private Aliases() {
        }
    }
}

