/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.task.ITaskReporter;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.builder.AbstractBuildParticipantType;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPToolkitUtil;
import org.eclipse.php.internal.core.compiler.ast.nodes.Comment;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.preferences.TaskPatternsProvider;
import org.eclipse.php.internal.core.preferences.TaskTagsProvider;
import org.eclipse.wst.sse.core.internal.provisional.tasks.TaskTag;

public class TaskTagBuildParticipantFactory
extends AbstractBuildParticipantType
implements IExecutableExtension {
    protected String natureId = null;

    public IBuildParticipant createBuildParticipant(IScriptProject project) throws CoreException {
        if (this.natureId != null) {
            return new TaskTagBuildParticipantParticipant(project);
        }
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.natureId = config.getAttribute("nature");
    }

    private static class TaskTagBuildParticipantParticipant
    implements IBuildParticipant {
        private IScriptProject project;

        public TaskTagBuildParticipantParticipant(IScriptProject project) {
            this.project = project;
        }

        private void checkForTodo(Pattern[] todos, List<Scalar> foundTaskTags, int commentStart, String comment) {
            ArrayList<Matcher> matchers = this.createMatcherList(todos, comment);
            int startPosition = 0;
            Matcher matcher = this.getMinimalMatcher(matchers, startPosition);
            while (matcher != null) {
                int startIndex = matcher.start();
                int endIndex = matcher.end();
                foundTaskTags.add(new Scalar(commentStart + startIndex, commentStart + endIndex, matcher.group(), 2));
                startPosition = endIndex;
                matcher = this.getMinimalMatcher(matchers, startPosition);
            }
        }

        private ArrayList<Matcher> createMatcherList(Pattern[] todos, String content) {
            ArrayList<Matcher> list = new ArrayList<Matcher>(todos.length);
            int i = 0;
            while (i < todos.length) {
                list.add(i, todos[i].matcher(content));
                ++i;
            }
            return list;
        }

        private Matcher getMinimalMatcher(ArrayList<Matcher> matchers, int startPosition) {
            Matcher minimal = null;
            int size = matchers.size();
            int i = 0;
            while (i < size) {
                Matcher tmp = matchers.get(i);
                if (tmp.find(startPosition)) {
                    if (minimal == null || tmp.start() < minimal.start()) {
                        minimal = tmp;
                    }
                    ++i;
                    continue;
                }
                matchers.remove(i);
                --size;
            }
            return minimal;
        }

        private int getTaskPriority(TaskTag[] taskTags, String taskStr) {
            String taskTagLowerCase = taskStr.toLowerCase();
            int i = 0;
            while (i < taskTags.length) {
                TaskTag taskTag = taskTags[i];
                if (taskTag.getTag().toLowerCase().equals(taskTagLowerCase)) {
                    return taskTag.getPriority();
                }
                ++i;
            }
            return 1;
        }

        private void reportTask(IDocument document, IFile file, ITaskReporter taskReporter, int offset, Scalar nextTaskTag, int priority) throws BadLocationException, CoreException {
            int lineNumber = document.getLineOfOffset(offset);
            String taskStr = this.getTaskStr(document, lineNumber, offset, nextTaskTag);
            int charEnd = offset + taskStr.length();
            this.createMarker(file, taskStr, lineNumber, priority, offset, charEnd);
        }

        private void createMarker(IFile file, String taskStr, int lineNumber, int priority, int offset, int charEnd) throws CoreException {
            IMarker marker = file.createMarker("org.eclipse.php.core.phpTaskMarker");
            if (!marker.exists()) {
                return;
            }
            marker.setAttribute("org.eclipse.core.resources.taskmarker", true);
            marker.setAttribute("lineNumber", lineNumber + 1);
            marker.setAttribute("charStart", offset);
            marker.setAttribute("charEnd", charEnd);
            marker.setAttribute("message", (Object)taskStr);
            marker.setAttribute("userEditable", false);
            marker.setAttribute("priority", priority);
        }

        private String getTaskStr(IDocument document, int lineNumber, int offset, Scalar nextTaskTag) throws BadLocationException {
            IRegion lineInformation = document.getLineInformation(lineNumber);
            int lineStart = lineInformation.getOffset();
            int lineEnd = lineStart + lineInformation.getLength();
            int taskEnd = nextTaskTag != null ? Math.min(nextTaskTag.start(), lineEnd) : lineEnd;
            String taskStr = document.get(offset, taskEnd - offset);
            taskStr = taskStr.trim();
            return taskStr;
        }

        public void build(IBuildContext context) throws CoreException {
            if (Boolean.TRUE.equals(context.get("IN_LIBRARY_FOLDER"))) {
                return;
            }
            if (context.getFile() == null) {
                return;
            }
            if (context.getFile().getType() != 1 || !PHPToolkitUtil.isPhpFile(context.getFile())) {
                return;
            }
            try {
                context.getFile().deleteMarkers("org.eclipse.php.core.phpTaskMarker", false, 2);
            }
            catch (CoreException coreException) {}
            ModuleDeclaration moduleDeclaration = (ModuleDeclaration)context.get(IBuildContext.ATTR_MODULE_DECLARATION);
            if (moduleDeclaration instanceof PHPModuleDeclaration) {
                try {
                    TaskTag[] taskTags;
                    Pattern[] todos;
                    if (this.project != null && this.project.getProject() != null) {
                        todos = TaskPatternsProvider.getInstance().getPatternsForProject(this.project.getProject());
                        taskTags = TaskTagsProvider.getInstance().getProjectTaskTags(this.project.getProject());
                    } else {
                        todos = TaskPatternsProvider.getInstance().getPatternsForWorkspace();
                        taskTags = TaskTagsProvider.getInstance().getWorkspaceTaskTags();
                    }
                    if (taskTags == null) {
                        taskTags = TaskTagsProvider.getInstance().getWorkspaceTaskTags();
                    }
                    Document document = new Document(new String(context.getContents()));
                    for (Comment comment : ((PHPModuleDeclaration)moduleDeclaration).getCommentList()) {
                        ArrayList<Scalar> foundTaskTags = new ArrayList<Scalar>();
                        this.checkForTodo(todos, foundTaskTags, comment.start(), document.get(comment.start(), comment.end() - comment.start()));
                        if (foundTaskTags.isEmpty()) {
                            comment.setTaskTags(null);
                            continue;
                        }
                        comment.setTaskTags(foundTaskTags);
                        int i = 0;
                        while (i < foundTaskTags.size()) {
                            Scalar foundTaskTag = (Scalar)foundTaskTags.get(i);
                            String taskKeyword = document.get(foundTaskTag.start(), foundTaskTag.end() - foundTaskTag.start());
                            int priority = this.getTaskPriority(taskTags, taskKeyword);
                            this.reportTask((IDocument)document, context.getFile(), context.getTaskReporter(), foundTaskTag.start(), i + 1 < foundTaskTags.size() ? (Scalar)foundTaskTags.get(i + 1) : null, priority);
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    Logger.logException(e);
                }
            }
        }
    }
}

