/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractGlobalStatementContext;
import org.eclipse.php.internal.core.format.PHPHeuristicScanner;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class GlobalStatementContext
extends AbstractGlobalStatementContext {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        try {
            IModelElement enclosingElement = this.getEnclosingElement();
            if (enclosingElement == null) {
                int actualOffset = offset - 1;
                try {
                    PHPHeuristicScanner scanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)this.getDocument(), actualOffset, true);
                    int index = scanner.findOpeningPeer(actualOffset, -2, '{', '}');
                    if (index != -1) {
                        ITextRegion textRegion = this.getPHPToken(index);
                        while (textRegion.getStart() != 0 && textRegion.getType() != "PHP_CURLY_CLOSE") {
                            if (textRegion.getType() == "PHP_CLASS") return false;
                            if (textRegion.getType() == "PHP_INTERFACE") return false;
                            if (textRegion.getType() == "PHP_TRAIT") return false;
                            if (textRegion.getType() == "PHP_FUNCTION") {
                                return false;
                            }
                            actualOffset = textRegion.getStart() - 1;
                            textRegion = this.getPhpScriptRegion().getPhpToken(actualOffset);
                        }
                    }
                }
                catch (BadLocationException e1) {
                    PHPCorePlugin.log(e1);
                }
            }
            while (true) {
                if (!(enclosingElement instanceof IField)) {
                    if (!(enclosingElement instanceof IMethod)) {
                        if (!(enclosingElement instanceof IType)) return true;
                        if (PHPFlags.isNamespace(((IType)enclosingElement).getFlags())) return true;
                    }
                    if (!(enclosingElement instanceof IType)) return false;
                    if (!this.isBeforeName(offset, (ISourceReference)enclosingElement)) return false;
                    return true;
                }
                enclosingElement = enclosingElement.getParent();
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        return true;
    }
}

