/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.context.FileContext;

public class InUseTraitStrategy
extends AbstractCompletionStrategy {
    public InUseTraitStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public InUseTraitStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof AbstractCompletionContext)) {
            return;
        }
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        int offset = abstractContext.getOffset();
        ISourceModule sourceModule = abstractContext.getSourceModule();
        List<String> useTypes = abstractContext.getUseTypes();
        String prefix = abstractContext.getPrefix();
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
        FileContext fileContext = new FileContext(sourceModule, moduleDeclaration, offset);
        ISourceRange replacementRange = this.getReplacementRange(abstractContext);
        for (String useType : useTypes) {
            PHPClassType type;
            IType[] modelElements;
            if (!StringUtils.startsWithIgnoreCase((CharSequence)useType.trim(), (CharSequence)prefix) || (modelElements = PHPTypeInferenceUtils.getModelElements((IEvaluatedType)(type = PHPClassType.fromTraitName(useType, sourceModule, offset)), (ISourceModuleContext)fileContext, offset)) == null) continue;
            IType[] iTypeArray = modelElements;
            int n = modelElements.length;
            int n2 = 0;
            while (n2 < n) {
                IType typeElement = iTypeArray[n2];
                reporter.reportType(typeElement, "", replacementRange, 2);
                ++n2;
            }
        }
    }
}

