/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTagKinds;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.util.MagicMemberUtil;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;

public class PHPDocTag
extends ASTNode
implements PHPDocTagKinds {
    private static final String ELLIPSIS_DOLLAR = "...$";
    private final TagKind tagKind;
    private final String matchedTag;
    private String value;
    private List<Scalar> texts;
    private VariableReference variableReference;
    private TypeReference singleTypeReference;
    private List<TypeReference> typeReferences;
    private List<SimpleReference> allReferencesWithOrigOrder;
    private List<String> descTexts;
    private String trimmedDescText;

    public PHPDocTag(int start, int end, TagKind tag, String matchedTag, String value, List<Scalar> texts) {
        super(start, end);
        if (start < 0 || start > end || tag == null || matchedTag == null || value == null || texts == null) {
            throw new IllegalArgumentException();
        }
        this.tagKind = tag;
        this.matchedTag = matchedTag;
        this.value = value;
        this.texts = texts;
        this.updateReferences(start, end);
    }

    @NonNull
    public List<Scalar> getTexts() {
        return this.texts;
    }

    @NonNull
    public List<String> getDescTexts() {
        return this.descTexts;
    }

    @NonNull
    public String getTrimmedDescText() {
        return this.trimmedDescText;
    }

    private String getTrimmedDescText(int wordsToSkip) {
        String text = this.value.trim();
        if (wordsToSkip == 0) {
            return text;
        }
        String[] split = MagicMemberUtil.WHITESPACE_SEPERATOR.split(text);
        int i = 0;
        while (i < wordsToSkip) {
            int index = text.indexOf(split[i]);
            text = text.substring(split[i].length() + index);
            ++i;
        }
        return text.trim();
    }

    private List<String> getDescTexts(int wordsToSkip) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < this.texts.size()) {
            String text = this.texts.get(i).getValue();
            if (wordsToSkip <= 0) {
                result.add(text);
            } else if (!StringUtils.isBlank((CharSequence)text)) {
                List<String> commentWords = Arrays.asList(MagicMemberUtil.WHITESPACE_SEPERATOR.split(text.trim()));
                if ((commentWords = PHPDocTag.removeEmptyString(commentWords)).size() <= wordsToSkip) {
                    wordsToSkip -= commentWords.size();
                } else {
                    text = this.removeFirstWords(text, commentWords, wordsToSkip);
                    result.add(text);
                    wordsToSkip = 0;
                }
            }
            ++i;
        }
        return result;
    }

    @NonNull
    public static List<String> removeEmptyString(List<String> commentWords) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < commentWords.size()) {
            String word = commentWords.get(i);
            if (word.trim().length() != 0) {
                result.add(word);
            }
            ++i;
        }
        return result;
    }

    private String removeFirstWords(String text, List<String> commentWords, int wordSize) {
        int i = 0;
        while (i < wordSize) {
            int index = text.indexOf(commentWords.get(i));
            text = text.substring(commentWords.get(i).length() + index);
            ++i;
        }
        return text.trim();
    }

    private static int getClassStartIndex(String line, int startIndex) {
        int i = startIndex;
        while (i < line.length()) {
            if (line.charAt(i) != '|') {
                return i;
            }
            ++i;
        }
        return i;
    }

    private static int getClassEndIndex(String line, int startIndex) {
        int i = startIndex;
        while (i < line.length()) {
            if (line.charAt(i) == '|') {
                return i;
            }
            ++i;
        }
        return i;
    }

    private void splitSingleTypeReference(TypeReference reference, List<TypeReference> types) {
        String word = reference.getName();
        int valueStart = reference.sourceStart();
        int classStart = PHPDocTag.getClassStartIndex(word, 0);
        int classEnd = PHPDocTag.getClassEndIndex(word, classStart);
        while (classStart < classEnd) {
            String className = word.substring(classStart, classEnd);
            types.add(new TypeReference(valueStart + classStart, valueStart + classEnd, className));
            classStart = PHPDocTag.getClassStartIndex(word, classEnd);
            classEnd = PHPDocTag.getClassEndIndex(word, classStart);
        }
    }

    private void updateReferences(int start, int end) {
        int secondWordEnd;
        int secondWordStart;
        int firstWordEnd;
        int firstWordStart;
        this.variableReference = null;
        this.singleTypeReference = null;
        this.typeReferences = new ArrayList<TypeReference>();
        this.allReferencesWithOrigOrder = new ArrayList<SimpleReference>();
        this.descTexts = new ArrayList<String>();
        int valueStart = start + this.matchedTag.length();
        int wordsToSkip = 0;
        if (this.tagKind == TagKind.RETURN || this.tagKind == TagKind.VAR || this.tagKind == TagKind.THROWS || this.tagKind == TagKind.SEE) {
            String word;
            int wordStart = PHPTextSequenceUtilities.readForwardSpaces(this.value, 0);
            int wordEnd = PHPTextSequenceUtilities.readForwardUntilSpaces(this.value, wordStart);
            if (this.tagKind == TagKind.VAR && wordStart < wordEnd && (word = this.value.substring(wordStart, wordEnd)).charAt(0) == '$') {
                this.variableReference = new VariableReference(valueStart + wordStart, valueStart + wordEnd, word);
                this.allReferencesWithOrigOrder.add((SimpleReference)this.variableReference);
                ++wordsToSkip;
                wordStart = PHPTextSequenceUtilities.readForwardSpaces(this.value, wordEnd);
                wordEnd = PHPTextSequenceUtilities.readForwardUntilSpaces(this.value, wordStart);
            }
            if (wordStart < wordEnd) {
                word = this.value.substring(wordStart, wordEnd);
                this.singleTypeReference = new TypeReference(valueStart + wordStart, valueStart + wordEnd, word);
                this.splitSingleTypeReference(this.singleTypeReference, this.typeReferences);
                this.allReferencesWithOrigOrder.addAll(this.typeReferences);
                ++wordsToSkip;
                wordStart = PHPTextSequenceUtilities.readForwardSpaces(this.value, wordEnd);
                wordEnd = PHPTextSequenceUtilities.readForwardUntilSpaces(this.value, wordStart);
            }
            if (this.tagKind == TagKind.VAR && this.variableReference == null && wordStart < wordEnd && (word = this.value.substring(wordStart, wordEnd)).charAt(0) == '$') {
                this.variableReference = new VariableReference(valueStart + wordStart, valueStart + wordEnd, word);
                this.allReferencesWithOrigOrder.add((SimpleReference)this.variableReference);
                ++wordsToSkip;
            }
        } else if ((this.tagKind == TagKind.PARAM || this.tagKind == TagKind.PROPERTY || this.tagKind == TagKind.PROPERTY_READ || this.tagKind == TagKind.PROPERTY_WRITE) && (firstWordStart = PHPTextSequenceUtilities.readForwardSpaces(this.value, 0)) < (firstWordEnd = PHPTextSequenceUtilities.readForwardUntilSpaces(this.value, firstWordStart)) && (secondWordStart = PHPTextSequenceUtilities.readForwardSpaces(this.value, firstWordEnd)) < (secondWordEnd = PHPTextSequenceUtilities.readForwardUntilSpaces(this.value, secondWordStart))) {
            String firstWord = this.value.substring(firstWordStart, firstWordEnd);
            String secondWord = this.value.substring(secondWordStart, secondWordEnd);
            if (firstWord.charAt(0) == '$' || firstWord.startsWith(ELLIPSIS_DOLLAR)) {
                this.variableReference = new VariableReference(valueStart + firstWordStart, valueStart + firstWordEnd, firstWord);
                this.singleTypeReference = new TypeReference(valueStart + secondWordStart, valueStart + secondWordEnd, secondWord);
                this.splitSingleTypeReference(this.singleTypeReference, this.typeReferences);
                this.allReferencesWithOrigOrder.add((SimpleReference)this.variableReference);
                this.allReferencesWithOrigOrder.addAll(this.typeReferences);
                wordsToSkip = 2;
            } else if (secondWord.charAt(0) == '$' || secondWord.startsWith(ELLIPSIS_DOLLAR)) {
                this.variableReference = new VariableReference(valueStart + secondWordStart, valueStart + secondWordEnd, secondWord);
                this.singleTypeReference = new TypeReference(valueStart + firstWordStart, valueStart + firstWordEnd, firstWord);
                this.splitSingleTypeReference(this.singleTypeReference, this.typeReferences);
                this.allReferencesWithOrigOrder.addAll(this.typeReferences);
                this.allReferencesWithOrigOrder.add((SimpleReference)this.variableReference);
                wordsToSkip = 2;
            }
        }
        this.descTexts = this.getDescTexts(wordsToSkip);
        this.trimmedDescText = this.getTrimmedDescText(wordsToSkip);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((ASTNode)this);
        if (visit) {
            for (SimpleReference ref : this.allReferencesWithOrigOrder) {
                ref.traverse(visitor);
            }
        }
        visitor.endvisit((ASTNode)this);
    }

    public int getKind() {
        return 68;
    }

    @NonNull
    public TagKind getTagKind() {
        return this.tagKind;
    }

    @NonNull
    public String getMatchedTag() {
        return this.matchedTag;
    }

    @NonNull
    public String getValue() {
        return this.value;
    }

    public VariableReference getVariableReference() {
        return this.variableReference;
    }

    public TypeReference getSingleTypeReference() {
        return this.singleTypeReference;
    }

    @NonNull
    public List<TypeReference> getTypeReferences() {
        return this.typeReferences;
    }

    @NonNull
    public List<SimpleReference> getAllReferencesWithOrigOrder() {
        return this.allReferencesWithOrigOrder;
    }

    public boolean isValidMethodDescriptorTag() {
        return this.isValidParamTag() || this.isValidPropertiesTag();
    }

    public boolean isValidPropertiesTag() {
        return (this.tagKind == TagKind.PROPERTY || this.tagKind == TagKind.PROPERTY_READ || this.tagKind == TagKind.PROPERTY_WRITE) && this.singleTypeReference != null && this.variableReference != null;
    }

    public boolean isValidParamTag() {
        return this.tagKind == TagKind.PARAM && this.singleTypeReference != null && this.variableReference != null;
    }

    public boolean isValidVarTag() {
        return this.tagKind == TagKind.VAR && this.singleTypeReference != null;
    }

    public void adjustStart(int start) {
        this.setStart(this.sourceStart() + start);
        this.setEnd(this.sourceEnd() + start);
    }

    public static enum TagKind {
        ABSTRACT("abstract"),
        AUTHOR("author"),
        DEPRECATED("deprecated"),
        FINAL("final"),
        GLOBAL("global"),
        NAME("name"),
        RETURN("return"),
        PARAM("param"),
        SEE("see"),
        STATIC("static"),
        STATICVAR("staticvar"),
        TODO("todo"),
        VAR("var"),
        PACKAGE("package"),
        ACCESS("access"),
        CATEGORY("category"),
        COPYRIGHT("copyright"),
        DESC("desc"),
        EXAMPLE("example"),
        FILESOURCE("filesource"),
        IGNORE("ignore"),
        INTERNAL("internal"),
        LICENSE("license"),
        LINK("link"),
        SINCE("since"),
        SUBPACKAGE("subpackage"),
        TUTORIAL("tutorial"),
        USES("uses"),
        VERSION("version"),
        THROWS("throws"),
        PROPERTY("property"),
        PROPERTY_READ("property-read"),
        PROPERTY_WRITE("property-write"),
        METHOD("method"),
        NAMESPACE("namespace"),
        INHERITDOC("inheritdoc", "{@inheritdoc}"),
        EXCEPTION("exception"),
        MAGIC("magic");

        String name;
        String value;

        private TagKind(String name) {
            this(name, String.valueOf('@') + name);
        }

        private TagKind(String name, String value) {
            this.name = name;
            this.value = value;
            Mapping.mapIds.put(this.getId(), this);
            Mapping.mapNames.put(this.name, this);
            Mapping.mapValues.put(this.value, this);
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        @NonNull
        public String getValue() {
            return this.value;
        }

        public int getId() {
            return this.ordinal();
        }

        @Nullable
        public static TagKind getTagKind(int tagId) {
            return (TagKind)((Object)Mapping.mapIds.get(tagId));
        }

        @Nullable
        public static TagKind getTagKindFromName(String name) {
            return (TagKind)((Object)Mapping.mapNames.get(name));
        }

        @Nullable
        public static TagKind getTagKindFromValue(String value) {
            return (TagKind)((Object)Mapping.mapValues.get(value));
        }

        private static final class Mapping {
            private static final Map<Integer, TagKind> mapIds = new HashMap<Integer, TagKind>();
            private static final Map<String, TagKind> mapNames = new TreeMap<String, TagKind>(String.CASE_INSENSITIVE_ORDER);
            private static final Map<String, TagKind> mapValues = new TreeMap<String, TagKind>(String.CASE_INSENSITIVE_ORDER);

            private Mapping() {
            }
        }
    }
}

