/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.parser;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;

public class DocumentorLexer
implements IDocumentorLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int ST_IN_FIRST_LINE = 2;
    public static final int ST_IN_SHORT_DESC = 4;
    public static final int ST_IN_LONG_DESC = 6;
    public static final int ST_IN_TAGS = 8;
    private static final int[] ZZ_LEXSTATE;
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0001\u0001\u0002\u0001\u0000\u0001\u0000\u0001\u0003\u0012\u0000\u0001\u0001\t\u0000\u0001\u0004\u0002\u0000\u0001\b\u0001\n\u0001\u0005\u0010\u0000\u0001\u0007\u001a\b\u0006\u0000\u001a\b\u0001\u0006\u0001\u0000\u0001\t\u0007\u0000\u0001\u0000\u1fa2\u0000\u0001\u0000\u0001\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\udfe6\u0000";
    private static final char[] ZZ_CMAP;
    private static final int[] ZZ_ACTION;
    private static final String ZZ_ACTION_PACKED_0 = "\u0005\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0002\u0002\u0002\u0003\u0001\u0002\u0002\u0004\u0003\u0002\u0002\u0005\u0004\u0002\u0002\u0006\u0001\u0002\u0002\u0001\u0002\u0002\u0002\u0001\u0002\u0002\u0004\u0000\u0001\u0007\u0003\b\u0001\u0000\u0002\u0001\u0002\u0000\u0001\u0001\u0001\t\u0001\u0000\u0001\n\u0002\u0000\u0001\u000b\u0001\u0001\u0002\u0000\u0001\f\u0002\u0000\u0001\u0001\u0001\u0000\u0001\r\u0001\u000e\u0001\u000f\u0002\u0000\u0002\u0010\u0002\u0000\u0001\n\u0001\r\u0001\u0000\u0001\u0011\u0001\u0000\u0001\u0011";
    private static final int[] ZZ_ROWMAP;
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u000b\u0000\u0016\u0000!\u0000,\u00007\u0000B\u0000M\u0000X\u0000c\u0000n\u0000y\u0000n\u0000\u0084\u0000\u008f\u0000n\u0000\u009a\u0000\u00a5\u0000\u00b0\u0000\u00bb\u0000n\u0000\u00c6\u0000\u00d1\u0000\u00dc\u0000\u00e7\u0000\u00f2\u0000n\u0000\u00fd\u0000\u0108\u0000\u0113\u0000\u011e\u0000\u0129\u0000\u0134\u0000\u013f\u0000\u014a\u0000\u0155\u0000\u0160\u0000\u016b\u0000\u0176\u0000\u008f\u0000\u00a5\u0000n\u0000\u0181\u0000n\u0000\u018c\u0000\u00b0\u0000\u00bb\u0000\u00d1\u0000\u00dc\u0000\u00e7\u0000\u0197\u0000n\u0000\u01a2\u0000\u00e7\u0000\u00f2\u0000\u0108\u0000n\u0000\u01ad\u0000\u0129\u0000\u0134\u0000n\u0000\u0155\u0000\u0160\u0000\u01b8\u0000\u01c3\u0000\u0160\u0000\u01ce\u0000\u01d9\u0000\u01e4\u0000\u01ef\u0000n\u0000\u01fa\u0000\u0205\u0000\u0210\u0000n\u0000n\u0000\u021b\u0000\u0210\u0000\u0226\u0000n";
    private static final int[] ZZ_TRANS;
    private static final String ZZ_TRANS_PACKED_0 = "\u0010\u000b\u0001\f\u0005\u000b\u0010\r\u0001\u000e\u0005\r\u0001\u000b\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0005\u000b\u0001\u0013\u0001\u000b\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u000b\u0001\u0018\u0001\u0019\u0002\u000b\u0001\u0013\u0001\u000b\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u001d\u0007\u000b\u0001\u001e\u0001\u001b\u0001\u001c\u0001\u001f\u0001\u000b\u0001\u0018\u0001\u0019\u0004\u000b\u0001 \u0001\u001b\u0001\u001c\u0001!\u0007\u000b\u0001\"\u0001\u001b\u0001\u001c\u0001#\u0001\u000b\u0001$\u0001%\u0003\u000b\u000f\u0000\u0001&\n\u0000\u0001'\u0007\u0000\u0001(\u0002\u0000\u0001)\b\u0000\u0001\u0010\r\u0000\u0001*\u0006\u0000\u0001+\u0001,\u0001-\u0006\u0000\u0001.\u0001\u0000\u0001/\u0001\u0015\u0001\u0016\u00010\u0001\u0000\u00011\u00012\u0005\u0000\u0001\u0015\t\u0000\u00013\u0001\u0015\u0001\u0016\u0001\u0000\u00014\u00011\u00012\n\u0000\u00015\u000b\u0000\u00016\u0003\u0000\u00017\u0002\u0000\u00018\b\u0000\u0001\u001b\r\u0000\u00019\u0006\u0000\u0001\u001e\u0002\u0000\u0001\u001f\u0001\u0000\u00011\u00012\u0004\u0000\u0001:\u0003\u0000\u00019\u00011\u00012\u0004\u0000\u0001;\u0002\u0000\u0001<\u000b\u0000\u0001=\u0006\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0001>\u0001?\u0004\u0000\u0001@\u0003\u0000\u0001=\u0001>\u0001?\n\u0000\u0001A\u000b\u0000\u0001B\u0006\u0000\u0001C\n\u0000\u0001D\u0007\u0000\u0001+\u0001,\u0001-\t\u0000\u0001,\t\u0000\u00013\u0001\u0015\u0001\u0016\u0002\u0000\u00011\u00012\u000b\u0000\u0001E\u0003\u0000\u0001:\u0004\u0000\u00011\u00012\u0004\u0000\u0001@\u0004\u0000\u0001>\u0001?\u000b\u0000\u0001F\u0003\u0000\u0001C\u0001G\u0001H\b\u0000\u0001D\u0004\u0000\u0001I\u0001J\u000b\u0000\u0001E\u0001K\t\u0000\u0001F\u0001L\u0003\u0000\u0001G\u000f\u0000\u0001M\u000b\u0000\u0001N\n\u0000\u0001O\n\u0000\u0001O\u0001P\u0001\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG;
    private static final int[] ZZ_ATTRIBUTE;
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0005\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0002\u0001\u0001\t\u0004\u0001\u0001\t\u0005\u0001\u0001\t\n\u0001\u0004\u0000\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\u0000\u0002\u0001\u0002\u0000\u0001\u0001\u0001\t\u0001\u0000\u0001\u0001\u0002\u0000\u0001\t\u0001\u0001\u0002\u0000\u0001\t\u0002\u0000\u0001\u0001\u0001\u0000\u0003\u0001\u0002\u0000\u0001\t\u0001\u0001\u0002\u0000\u0002\t\u0001\u0000\u0001\u0001\u0001\u0000\u0001\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private int zzFinalHighSurrogate = 0;
    private String shortDesc;
    private String longDesc;
    private ArrayList<PHPDocTag> tagList;
    private PHPDocTag.TagKind currTagKind;
    private int tagPosition;
    private String matchedTag;
    private StringBuilder sBuffer;
    private int numOfLines;
    private List<Scalar> textList;
    int maxNumberofLines = 4;
    private int _zzPushbackPos;
    private String oldString = null;
    private boolean useOldString = false;
    private int startPos = 0;

    static {
        int[] nArray = new int[10];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        ZZ_LEXSTATE = nArray;
        ZZ_CMAP = DocumentorLexer.zzUnpackCMap(ZZ_CMAP_PACKED);
        ZZ_ACTION = DocumentorLexer.zzUnpackAction();
        ZZ_ROWMAP = DocumentorLexer.zzUnpackRowMap();
        ZZ_TRANS = DocumentorLexer.zzUnpackTrans();
        ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
        ZZ_ATTRIBUTE = DocumentorLexer.zzUnpackAttribute();
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[80];
        int offset = 0;
        offset = DocumentorLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[80];
        int offset = 0;
        offset = DocumentorLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[561];
        int offset = 0;
        offset = DocumentorLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[80];
        int offset = 0;
        offset = DocumentorLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public PHPDocBlock parse() {
        this.oldString = null;
        this.shortDesc = "";
        this.longDesc = "";
        this.tagList = new ArrayList();
        this.currTagKind = null;
        this.tagPosition = 0;
        this.matchedTag = "";
        this.sBuffer = new StringBuilder();
        this.numOfLines = 1;
        this.textList = new ArrayList<Scalar>();
        this.useOldString = true;
        int start = this.zzStartRead - this._zzPushbackPos;
        try {
            this.next_token();
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        if (!this.tagList.isEmpty() && !this.textList.isEmpty()) {
            Scalar lastText = this.textList.get(this.textList.size() - 1);
            PHPDocTag lastTag = this.tagList.get(this.tagList.size() - 1);
            if (lastText.sourceEnd() >= lastTag.sourceEnd()) {
                this.textList.remove(this.textList.size() - 1);
                if (!this.isBlank(lastText.getValue())) {
                    lastTag.getTexts().add(lastText);
                }
            }
        }
        PHPDocTag[] tags = new PHPDocTag[this.tagList.size()];
        this.tagList.toArray(tags);
        PHPDocBlock rv = new PHPDocBlock(start, this.zzMarkedPos - this._zzPushbackPos, this.shortDesc, this.longDesc, tags, this.textList);
        return rv;
    }

    private boolean isBlank(String value) {
        char[] line = value.toCharArray();
        int i = 0;
        while (i < line.length) {
            char c = line[i];
            if (c != '\t' && c != ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void startTagsState(PHPDocTag.TagKind firstState, int position) {
        this.updateStartPos();
        this.hendleDesc();
        this.currTagKind = firstState;
        this.tagPosition = position - this._zzPushbackPos;
        this.matchedTag = firstState.getValue();
        this.sBuffer = new StringBuilder();
        this.yybegin(8);
    }

    private int findTagPosition() {
        int i = this.zzStartRead;
        while (i < this.zzMarkedPos) {
            if (this.zzBuffer[i] == '@' || this.zzBuffer[i] == '{') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void setNewTag(PHPDocTag.TagKind newTag, int position) {
        this.updateStartPos();
        this.setTagValue();
        this.sBuffer = new StringBuilder();
        this.currTagKind = newTag;
        this.tagPosition = position - this._zzPushbackPos;
        this.matchedTag = newTag.getValue();
    }

    private void setTagValue() {
        String value = this.sBuffer.toString();
        if (this.currTagKind == PHPDocTag.TagKind.DESC) {
            this.shortDesc = String.valueOf(this.shortDesc) + value;
            return;
        }
        PHPDocTag basicPHPDocTag = new PHPDocTag(this.tagPosition, this.zzStartRead - this._zzPushbackPos, this.currTagKind, this.matchedTag, value, this.getTexts(this.tagPosition, this.zzStartRead - this._zzPushbackPos, true));
        this.tagList.add(basicPHPDocTag);
    }

    private List<Scalar> getTexts(int start, int end, boolean remove) {
        ArrayList<Scalar> result = new ArrayList<Scalar>();
        Iterator<Scalar> iterator = this.textList.iterator();
        while (iterator.hasNext()) {
            Scalar scalar = iterator.next();
            if (scalar.sourceStart() < start || scalar.sourceEnd() > end) continue;
            result.add(scalar);
            if (!remove) continue;
            iterator.remove();
        }
        return result;
    }

    private void appendText() {
        if (this.oldString != null) {
            this.sBuffer.append(this.oldString);
        }
        String sb = new String(this.zzBuffer, this.startPos, this.zzMarkedPos - this.startPos);
        this.addText(sb);
        this.sBuffer.append(sb);
        this.updateStartPos();
    }

    private void addText(String string) {
        this.textList.add(new Scalar(this.startPos - this._zzPushbackPos, this.startPos - this._zzPushbackPos + string.length(), string, 2));
    }

    private void hendleDesc() {
        if (this.zzLexicalState == 4 || this.zzLexicalState == 2) {
            this.shortDesc = this.sBuffer.toString().trim();
        } else {
            this.longDesc = this.sBuffer.toString().trim();
        }
        this.sBuffer = new StringBuilder();
    }

    private void startLongDescState(boolean withNewLine) {
        this.hendleDesc();
        this.updateStartPos();
        if (!withNewLine) {
            this.addText("");
        }
        this.yybegin(6);
    }

    private void handleNewLine() {
        this.appendText();
        if (this.numOfLines == 4) {
            int firstLineEnd = this.sBuffer.indexOf("\n", 1);
            this.shortDesc = this.sBuffer.substring(0, firstLineEnd);
            this.shortDesc = this.shortDesc.trim();
            this.sBuffer.delete(0, firstLineEnd);
            this.yybegin(6);
        } else {
            ++this.numOfLines;
        }
    }

    private void appendLastText() {
        String sb = new String(this.zzBuffer, this.startPos, this.zzMarkedPos - this.startPos - 2);
        this.addText(sb);
        this.sBuffer.append(sb);
        this.updateStartPos();
    }

    private void handleDocEnd_shortDesc() {
        this.appendLastText();
        if (this.numOfLines == this.maxNumberofLines) {
            int firstLineEnd = this.sBuffer.indexOf("\n", 1);
            this.shortDesc = this.sBuffer.substring(0, firstLineEnd);
            this.shortDesc = this.shortDesc.trim();
            this.sBuffer.delete(0, firstLineEnd);
            this.longDesc = this.sBuffer.toString().trim();
        } else {
            this.shortDesc = this.sBuffer.toString().trim();
        }
    }

    private void handleDocEnd_longDesc() {
        this.appendLastText();
        this.longDesc = this.sBuffer.toString().trim();
    }

    private void handleDocEnd_inTags() {
        this.appendLastText();
        this.setTagValue();
    }

    @Override
    public void reset(Reader reader, char[] buffer, int[] parameters) {
        this.zzReader = reader;
        this.zzBuffer = buffer;
        this.zzMarkedPos = parameters[0];
        this._zzPushbackPos = parameters[1];
        this.zzCurrentPos = parameters[2];
        this.zzStartRead = parameters[3];
        this.zzEndRead = parameters[4];
        this.yyline = parameters[5];
        this.yychar = 0;
        this.yycolumn = 0;
        this.zzAtEOF = parameters[7] != 0;
        this.zzEOFDone = parameters[8] != 0;
        this.zzFinalHighSurrogate = parameters[9];
        this.oldString = null;
        this.zzAtBOL = !this.zzAtEOF;
        this.zzLexicalState = 0;
    }

    @Override
    public int[] getParameters() {
        return new int[]{this.zzMarkedPos, this._zzPushbackPos, this.zzCurrentPos, this.zzStartRead, this.zzEndRead, this.yyline, this.zzAtBOL ? 1 : 0, this.zzAtEOF ? 1 : 0, this.zzEOFDone ? 1 : 0, this.zzFinalHighSurrogate};
    }

    @Override
    public char[] getBuffer() {
        return this.zzBuffer;
    }

    public DocumentorLexer(Reader in) {
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[0x110000];
        int i = 0;
        int j = 0;
        while (i < 88) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int requested;
        int numRead;
        if (this.useOldString) {
            String saveOldString = this.oldString;
            this.oldString = new String(this.zzBuffer, this.startPos, this.zzMarkedPos - this.startPos);
            if (saveOldString != null) {
                this.oldString = String.valueOf(saveOldString) + this.oldString;
            }
        }
        if (this.zzStartRead > 0) {
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this._zzPushbackPos -= this.zzStartRead;
            this.startPos = 0;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length - this.zzFinalHighSurrogate) {
            char[] newBuffer = new char[this.zzBuffer.length * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, requested = this.zzBuffer.length - this.zzEndRead)) == 0) {
            throw new IOException("Reader returned 0 characters.");
        }
        if (numRead > 0) {
            this.zzEndRead += numRead;
            if (numRead == requested && Character.isHighSurrogate(this.zzBuffer[this.zzEndRead - 1])) {
                --this.zzEndRead;
                this.zzFinalHighSurrogate = 1;
            }
            return false;
        }
        return true;
    }

    private int yy_advance() throws IOException {
        if (this.zzCurrentPos < this.zzEndRead) {
            return this.zzBuffer[this.zzCurrentPos++];
        }
        if (this.zzAtEOF) {
            return -1;
        }
        String saveOldString = this.oldString;
        this.oldString = null;
        if (this.zzRefill()) {
            this.oldString = saveOldString;
            return -1;
        }
        this.oldString = saveOldString;
        return this.zzBuffer[this.zzCurrentPos++];
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.startPos = 0;
        this._zzPushbackPos = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.zzFinalHighSurrogate = 0;
        this.oldString = null;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private void updateStartPos() {
        this.updateStartPos(this.zzMarkedPos);
    }

    private void updateStartPos(int position) {
        this.startPos = position;
        this.oldString = null;
    }

    public final boolean isEOF() {
        return this.zzAtEOF;
    }

    private void zzDoEOF() throws IOException {
        if (!this.zzEOFDone) {
            this.zzEOFDone = true;
            this.yyclose();
        }
    }

    public int next_token() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block44: while (true) {
            int zzInput;
            boolean eof;
            int zzMarkedPosL = this.zzMarkedPos;
            boolean zzR = false;
            int zzCurrentPosL = this.zzStartRead;
            while (zzCurrentPosL < zzMarkedPosL) {
                int zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
                int zzCharCount = Character.charCount(zzCh);
                switch (zzCh) {
                    case 11: 
                    case 12: 
                    case 133: 
                    case 8232: 
                    case 8233: {
                        ++this.yyline;
                        zzR = false;
                        break;
                    }
                    case 13: {
                        ++this.yyline;
                        zzR = true;
                        break;
                    }
                    case 10: {
                        if (zzR) {
                            zzR = false;
                            break;
                        }
                        ++this.yyline;
                        break;
                    }
                    default: {
                        zzR = false;
                    }
                }
                zzCurrentPosL += zzCharCount;
            }
            if (zzR) {
                boolean zzPeek;
                if (zzMarkedPosL < zzEndReadL) {
                    zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                } else if (this.zzAtEOF) {
                    zzPeek = false;
                } else {
                    eof = this.zzRefill();
                    zzEndReadL = this.zzEndRead;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    if (eof) {
                        zzPeek = false;
                    } else {
                        boolean bl = zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                    }
                }
                if (zzPeek) {
                    --this.yyline;
                }
            }
            if (zzMarkedPosL > this.zzStartRead) {
                switch (zzBufferL[zzMarkedPosL - 1]) {
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        this.zzAtBOL = true;
                        break;
                    }
                    case '\r': {
                        if (zzMarkedPosL < zzEndReadL) {
                            this.zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
                            break;
                        }
                        if (this.zzAtEOF) {
                            this.zzAtBOL = false;
                            break;
                        }
                        boolean eof2 = this.zzRefill();
                        zzMarkedPosL = this.zzMarkedPos;
                        zzEndReadL = this.zzEndRead;
                        zzBufferL = this.zzBuffer;
                        if (eof2) {
                            this.zzAtBOL = false;
                            break;
                        }
                        this.zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
                        break;
                    }
                    default: {
                        this.zzAtBOL = false;
                    }
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzAtBOL ? ZZ_LEXSTATE[this.zzLexicalState + 1] : ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                this.zzDoEOF();
                return -1;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    this.updateStartPos();
                }
                case 18: {
                    continue block44;
                }
                case 2: 
                case 19: {
                    continue block44;
                }
                case 3: {
                    System.out.print(this.yytext());
                }
                case 20: {
                    continue block44;
                }
                case 4: {
                    this.handleNewLine();
                }
                case 21: {
                    continue block44;
                }
                case 5: {
                    this.startLongDescState(false);
                }
                case 22: {
                    continue block44;
                }
                case 6: {
                    this.appendText();
                }
                case 23: {
                    continue block44;
                }
                case 7: {
                    this.maxNumberofLines = 4;
                    this.handleDocEnd_shortDesc();
                    return -1;
                }
                case 24: {
                    continue block44;
                }
                case 8: {
                    this.appendText();
                    this.startLongDescState(true);
                }
                case 25: {
                    continue block44;
                }
                case 9: {
                    this.maxNumberofLines = 5;
                    this.handleDocEnd_shortDesc();
                    return -1;
                }
                case 26: {
                    continue block44;
                }
                case 10: {
                    int position = this.findTagPosition();
                    PHPDocTag.TagKind tagkind = PHPDocTag.TagKind.getTagKindFromValue(new String(this.zzBuffer, position, this.zzMarkedPos - position));
                    if (tagkind != null) {
                        this.startTagsState(tagkind, position);
                        continue block44;
                    }
                    this.updateStartPos(position);
                }
                case 27: {
                    continue block44;
                }
                case 11: {
                    this.handleDocEnd_longDesc();
                    return -1;
                }
                case 28: {
                    continue block44;
                }
                case 12: {
                    this.handleDocEnd_inTags();
                    return -1;
                }
                case 29: {
                    continue block44;
                }
                case 13: {
                    int position = this.findTagPosition();
                    PHPDocTag.TagKind tagkind = PHPDocTag.TagKind.getTagKindFromValue(new String(this.zzBuffer, position, this.zzMarkedPos - position));
                    if (tagkind != null) {
                        this.setNewTag(tagkind, position);
                        continue block44;
                    }
                    this.updateStartPos(position);
                }
                case 30: {
                    continue block44;
                }
                case 14: {
                    this.yypushback(this.yylength());
                    this.updateStartPos();
                    this.yybegin(2);
                }
                case 31: {
                    continue block44;
                }
                case 15: {
                    this.updateStartPos();
                    this.yybegin(4);
                }
                case 32: {
                    continue block44;
                }
                case 16: {
                    this.updateStartPos();
                    this.yybegin(4);
                }
                case 33: {
                    continue block44;
                }
                case 17: {
                    int position = this.findTagPosition();
                    PHPDocTag.TagKind tagkind = PHPDocTag.TagKind.getTagKindFromValue(new String(this.zzBuffer, position, this.zzMarkedPos - position));
                    if (tagkind != null) {
                        this.startTagsState(tagkind, position);
                        continue block44;
                    }
                    this.updateStartPos(position);
                    this.yybegin(4);
                }
                case 34: {
                    continue block44;
                }
            }
            this.zzScanError(1);
        }
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            System.out.println("Usage : java DocumentorLexer [ --encoding <name> ] <inputfile(s)>");
        } else {
            int firstFilePos = 0;
            String encodingName = "UTF-8";
            if (argv[0].equals("--encoding")) {
                firstFilePos = 2;
                encodingName = argv[1];
                try {
                    Charset.forName(encodingName);
                }
                catch (Exception exception) {
                    System.out.println("Invalid encoding '" + encodingName + "'");
                    return;
                }
            }
            int i = firstFilePos;
            while (i < argv.length) {
                DocumentorLexer scanner = null;
                try {
                    FileInputStream stream = new FileInputStream(argv[i]);
                    InputStreamReader reader = new InputStreamReader((InputStream)stream, encodingName);
                    scanner = new DocumentorLexer(reader);
                    while (!scanner.zzAtEOF) {
                        scanner.next_token();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("File not found : \"" + argv[i] + "\"");
                }
                catch (IOException e) {
                    System.out.println("IO error scanning file \"" + argv[i] + "\"");
                    System.out.println(e);
                }
                catch (Exception e) {
                    System.out.println("Unexpected exception:");
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }
}

