/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramSocket;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.PHPRuntime;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.XDebugDebuggerSettingsUtil;
import org.eclipse.php.internal.debug.core.zend.communication.DebugConnection;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerSettingsUtil;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.daemon.DaemonPlugin;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.server.core.tunneling.SSHTunnel;
import org.eclipse.php.internal.server.core.tunneling.SSHTunnelFactory;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class PHPLaunchUtilities {
    public static final String ID_PHPDebugOutput = "org.eclipse.debug.ui.PHPDebugOutput";
    public static final String ID_PHPBrowserOutput = "org.eclipse.debug.ui.PHPBrowserOutput";
    private static DebuggerDelayProgressMonitorDialog progressDialog;

    public static void showDebugView() {
        if (!Platform.getPreferencesService().getBoolean("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS, true, null)) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page != null) {
                    try {
                        IViewPart debugOutputPart = page.findView(PHPLaunchUtilities.ID_PHPDebugOutput);
                        IViewPart browserOutputPart = page.findView(PHPLaunchUtilities.ID_PHPBrowserOutput);
                        boolean shouldShowDebug = false;
                        if (debugOutputPart == null || !page.isPartVisible((IWorkbenchPart)debugOutputPart)) {
                            shouldShowDebug = true;
                        }
                        if (browserOutputPart != null && page.isPartVisible((IWorkbenchPart)browserOutputPart)) {
                            shouldShowDebug = false;
                        }
                        if (shouldShowDebug) {
                            page.showView(PHPLaunchUtilities.ID_PHPDebugOutput);
                        }
                    }
                    catch (Exception e) {
                        Logger.logException("Error switching to the Debug Output view", e);
                    }
                }
            }
        });
    }

    public static boolean hasPHPDebugLaunch() {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int i = 0;
        while (i < launches.length) {
            if (!launches[i].isTerminated() && "debug".equals(launches[i].getLaunchMode()) && launches[i].getDebugTarget() instanceof PHPDebugTarget) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean notifyPreviousLaunches(ILaunch newLaunch) throws CoreException {
        if (!"debug".equals(newLaunch.getLaunchMode())) {
            return true;
        }
        if (!PHPLaunchUtilities.hasPHPDebugLaunch()) {
            return true;
        }
        final IPreferenceStore store = PHPUiPlugin.getDefault().getPreferenceStore();
        String option = store.getString("allowMultipleLaunches");
        if ("always".equals(option)) {
            return true;
        }
        if ("never".equals(option)) {
            final Display disp = Display.getDefault();
            disp.syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)disp.getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_phpLaunchTitle, (String)PHPDebugCoreMessages.PHPLaunchUtilities_activeLaunchDetected);
                }
            });
            return false;
        }
        final DialogResultHolder resultHolder = new DialogResultHolder();
        final Display disp = Display.getDefault();
        disp.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialogWithToggle m = MessageDialogWithToggle.openYesNoQuestion((Shell)disp.getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_confirmation, (String)PHPDebugCoreMessages.PHPLaunchUtilities_multipleLaunchesPrompt, (String)PHPDebugCoreMessages.PHPLaunchUtilities_rememberDecision, (boolean)false, (IPreferenceStore)store, (String)"allowMultipleLaunches");
                resultHolder.setReturnCode(m.getReturnCode());
            }
        });
        switch (resultHolder.getReturnCode()) {
            case 0: 
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        return true;
    }

    public static void switchToPHPPerspective() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                String perspectiveID = "org.eclipse.php.perspective";
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (PHPLaunchUtilities.shouldSwitchToPHPPerspective(perspectiveID)) {
                    try {
                        workbench.showPerspective(perspectiveID, window);
                    }
                    catch (WorkbenchException e) {
                        PHPUiPlugin.log((Throwable)e);
                    }
                }
            }
        });
    }

    private static boolean shouldSwitchToPHPPerspective(String perspectiveID) {
        IPreferenceStore store = PHPUiPlugin.getDefault().getPreferenceStore();
        String option = store.getString("switchBackToPHPPerspective");
        if ("always".equals(option)) {
            return true;
        }
        if ("never".equals(option)) {
            return false;
        }
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor perspective = registry.findPerspectiveWithId(perspectiveID);
        if (perspective == null) {
            return false;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IPerspectiveDescriptor current;
            IWorkbenchPage page = window.getActivePage();
            if (page != null && (current = page.getPerspective()) != null && current.getId().equals(perspectiveID)) {
                return false;
            }
            MessageDialogWithToggle m = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_PHPPerspectiveSwitchTitle, (String)NLS.bind((String)PHPDebugCoreMessages.PHPLaunchUtilities_PHPPerspectiveSwitchMessage, (Object[])new String[]{perspective.getLabel()}), (String)PHPDebugCoreMessages.PHPLaunchUtilities_rememberDecision, (boolean)false, (IPreferenceStore)store, (String)"switchBackToPHPPerspective");
            int result = m.getReturnCode();
            switch (result) {
                case 0: 
                case 2: {
                    return true;
                }
                case 3: {
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean checkDebugAllPages(ILaunchConfiguration newLaunchConfiguration, final ILaunch newLaunch) throws CoreException {
        if (PHPDebugPlugin.supportsMultipleDebugAllPages()) {
            return true;
        }
        newLaunch.setAttribute("debugPages", newLaunchConfiguration.getAttribute("debugPages", "debugAllPages"));
        PHPLaunchUtilities.checkAutoRemoveLaunches();
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        boolean hasContiniousLaunch = false;
        int i = 0;
        while (!hasContiniousLaunch && i < launches.length) {
            ILaunch launch = launches[i];
            if (launch != newLaunch && "debug".equals(launch.getLaunchMode()) && (PHPLaunchUtilities.isDebugAllPages(launch) || PHPLaunchUtilities.isStartDebugFrom(launch))) {
                hasContiniousLaunch = true;
            }
            ++i;
        }
        boolean newLaunchIsDebug = "debug".equals(newLaunch.getLaunchMode());
        final boolean newIsDebugAllPages = newLaunchIsDebug && PHPLaunchUtilities.isDebugAllPages(newLaunch);
        boolean newIsStartDebugFrom = newLaunchIsDebug && PHPLaunchUtilities.isStartDebugFrom(newLaunch);
        final boolean fHasContiniousLaunch = hasContiniousLaunch;
        if ((fHasContiniousLaunch || newIsDebugAllPages || newIsStartDebugFrom) && launches.length > 1) {
            final DialogResultHolder resultHolder = new DialogResultHolder();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (fHasContiniousLaunch) {
                        resultHolder.setResult(MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_confirmation, (String)PHPDebugCoreMessages.PHPLaunchUtilities_0));
                    } else if (newIsDebugAllPages) {
                        resultHolder.setResult(MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_confirmation, (String)PHPDebugCoreMessages.PHPLaunchUtilities_7));
                    } else {
                        resultHolder.setResult(MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_confirmation, (String)PHPDebugCoreMessages.PHPLaunchUtilities_8));
                    }
                    if (resultHolder.getResult()) {
                        PHPDebugPlugin.setDisableAutoRemoveLaunches(true);
                        PHPLaunchUtilities.removeAndTerminateOldLaunches(newLaunch);
                    } else {
                        DebugPlugin.getDefault().getLaunchManager().removeLaunch(newLaunch);
                    }
                }
            });
            return resultHolder.getResult();
        }
        if (newIsDebugAllPages || newIsStartDebugFrom) {
            PHPDebugPlugin.setDisableAutoRemoveLaunches(true);
        } else {
            PHPDebugPlugin.setDisableAutoRemoveLaunches(!PHPDebugPlugin.getDefault().getInitialAutoRemoveLaunches());
            DebugUIPlugin.getDefault().getLaunchConfigurationManager().launchAdded(newLaunch);
        }
        return true;
    }

    private static void checkAutoRemoveLaunches() {
        if (DebugPlugin.getDefault().getLaunchManager().getLaunches().length == 1) {
            PHPDebugPlugin.setDisableAutoRemoveLaunches(false);
        }
    }

    public static boolean isDebugAllPages(ILaunch launch) throws CoreException {
        String attribute = launch.getAttribute("debugPages");
        return attribute != null && attribute.equals("debugAllPages");
    }

    public static boolean isStartDebugFrom(ILaunch launch) throws CoreException {
        String attribute = launch.getAttribute("debugPages");
        return attribute != null && attribute.equals("debugFrom");
    }

    private static void removeAndTerminateOldLaunches(ILaunch newLaunch) {
        ILaunch[] launches;
        ILaunchManager lManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] iLaunchArray = launches = lManager.getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch element = iLaunchArray[n2];
            ILaunch launch = element;
            if (launch != newLaunch) {
                if (!launch.isTerminated()) {
                    try {
                        launch.terminate();
                    }
                    catch (DebugException e) {
                        Logger.logException(e);
                    }
                }
                lManager.removeLaunch(launch);
            }
            ++n2;
        }
    }

    public static void showWaitForDebuggerMessage(final DebugConnection debugConnection) {
        if (progressDialog != null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                progressDialog = new DebuggerDelayProgressMonitorDialog();
                if (progressDialog.open() == 1) {
                    debugConnection.disconnect();
                }
                progressDialog = null;
            }
        });
    }

    public static void hideWaitForDebuggerMessage() {
        if (progressDialog != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (progressDialog != null) {
                        progressDialog.close();
                    }
                }
            });
            progressDialog = null;
        }
    }

    public static void showLaunchErrorMessage() {
        PHPLaunchUtilities.showDebuggerErrorMessage(PHPDebugCoreMessages.Debugger_Launch_Error, PHPDebugCoreMessages.Debugger_Error_Message);
    }

    public static void showLaunchErrorMessage(String errorMessage) {
        PHPLaunchUtilities.showDebuggerErrorMessage(PHPDebugCoreMessages.Debugger_Launch_Error, errorMessage);
    }

    public static void showDebuggerErrorMessage(final String title, final String errorMessage) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)title, (String)errorMessage);
            }
        });
    }

    public static void openLaunchConfigurationDialog(final ILaunchConfiguration configuration, final String mode) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ILaunchGroup group;
                ILaunchConfiguration conf = configuration;
                try {
                    ILaunchConfiguration underlyingConfig;
                    String underlyingHandle = configuration.getAttribute(DebugUIPlugin.ATTR_LAUNCHING_CONFIG_HANDLE, "");
                    if (underlyingHandle.length() > 0 && (underlyingConfig = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(underlyingHandle)) != null) {
                        conf = underlyingConfig;
                    }
                }
                catch (CoreException coreException) {}
                if ((group = DebugUITools.getLaunchGroup((ILaunchConfiguration)conf, (String)mode)) != null) {
                    DebugUITools.openLaunchConfigurationDialog((Shell)Display.getDefault().getActiveShell(), (ILaunchConfiguration)conf, (String)group.getIdentifier(), null);
                }
            }
        });
    }

    public static String[] getEnvironment(ILaunchConfiguration configuration, String[] additionalEnv) throws CoreException {
        if (additionalEnv == null) {
            additionalEnv = new String[]{};
        }
        Map<String, String> additionalEnvMap = PHPLaunchUtilities.asAttributesMap(additionalEnv);
        String[] totalEnv = null;
        String[] launchConfigurationEnvironment = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        if (launchConfigurationEnvironment != null) {
            Map<String, String> envMap = PHPLaunchUtilities.asAttributesMap(launchConfigurationEnvironment);
            envMap.putAll(additionalEnvMap);
            totalEnv = PHPLaunchUtilities.asAttributesArray(envMap);
        } else {
            Map nativeEnvironment = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
            nativeEnvironment.putAll(additionalEnvMap);
            totalEnv = PHPLaunchUtilities.asAttributesArray(nativeEnvironment);
        }
        return totalEnv;
    }

    public static Map<String, String> asAttributesMap(String[] attributesArray) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (attributesArray == null) {
            return map;
        }
        String[] stringArray = attributesArray;
        int n = attributesArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            try {
                if (attribute != null) {
                    int index = attribute.indexOf(61);
                    map.put(attribute.substring(0, index), attribute.substring(index + 1));
                }
            }
            catch (Exception e) {
                Logger.logException("Error while parsing launch attribute '" + attribute + '\'', e);
            }
            ++n2;
        }
        return map;
    }

    public static String[] asAttributesArray(Map<String, String> attributesMap) {
        String[] attributes = new String[attributesMap.size()];
        int index = 0;
        for (Map.Entry<String, String> entry : attributesMap.entrySet()) {
            attributes[index++] = String.valueOf(entry.getKey()) + '=' + entry.getValue();
        }
        return attributes;
    }

    public static Map<String, String> getPHPCGILaunchEnvironment(String fileName, String query, String phpConfigDir, String phpExeDir, String[] scriptArguments) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("REQUEST_METHOD", "GET");
        env.put("SCRIPT_FILENAME", fileName);
        env.put("SCRIPT_NAME", fileName);
        env.put("PATH_TRANSLATED", fileName);
        env.put("PATH_INFO", fileName);
        StringBuilder queryStringBuf = new StringBuilder(query);
        queryStringBuf.append("&debug_host=127.0.0.1");
        if (scriptArguments != null) {
            String[] stringArray = scriptArguments;
            int n = scriptArguments.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                queryStringBuf.append('&').append(arg);
                ++n2;
            }
        }
        env.put("QUERY_STRING", queryStringBuf.toString());
        env.put("REDIRECT_STATUS", "1");
        env.put("PHPRC", phpConfigDir);
        PHPLaunchUtilities.appendLibrarySearchPathEnv(env, new File(phpExeDir));
        return env;
    }

    public static Server getPHPServer(ILaunchConfiguration configuration) throws CoreException {
        String serverName = configuration.getAttribute("name", "");
        return ServersManager.getServer((String)serverName);
    }

    public static PHPexeItem getPHPExe(ILaunchConfiguration configuration) throws CoreException {
        PHPexeItem item = null;
        String path = configuration.getAttribute("org.eclipse.php.debug.core.PHP_CONTAINER", null);
        if (path == null) {
            IProject project = null;
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            String projectName = configuration.getAttribute("org.eclipse.php.debug.core.PHP_Project", null);
            if (projectName != null) {
                project = workspaceRoot.getProject(projectName);
            } else {
                Path filePath;
                IResource scriptRes;
                String phpScriptString = configuration.getAttribute("ATTR_FILE", null);
                if (phpScriptString != null && (scriptRes = workspaceRoot.findMember((IPath)(filePath = new Path(phpScriptString)))) != null) {
                    project = scriptRes.getProject();
                }
            }
            item = PHPDebugPlugin.getPHPexeItem(project);
        } else {
            IPath exePath = Path.fromPortableString((String)path);
            PHPVersion version = PHPRuntime.getPHPVersion(exePath);
            if (version == null) {
                String exeName = exePath.lastSegment();
                item = PHPexes.getInstance().getItem(exeName);
            } else {
                item = PHPDebugPlugin.getPHPexeItem(version);
            }
        }
        return item;
    }

    public static Map<String, String> getPHP54BuildinServerLaunchEnvironment(String fileName, String query, String phpConfigDir, String phpExeDir, String[] scriptArguments) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("REQUEST_METHOD", "GET");
        StringBuilder queryStringBuf = new StringBuilder(query);
        queryStringBuf.append("&debug_host=127.0.0.1");
        if (scriptArguments != null) {
            String[] stringArray = scriptArguments;
            int n = scriptArguments.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                queryStringBuf.append('&').append(arg);
                ++n2;
            }
        }
        env.put("QUERY_STRING", queryStringBuf.toString());
        env.put("REDIRECT_STATUS", "1");
        env.put("PHPRC", phpConfigDir);
        PHPLaunchUtilities.appendLibrarySearchPathEnv(env, new File(phpExeDir));
        return env;
    }

    public static void appendLibrarySearchPathEnv(Map<String, String> env, File phpExeDir) {
        String variable = PHPLaunchUtilities.getLibrarySearchEnvVariable();
        if (variable == null) {
            return;
        }
        String value = PHPLaunchUtilities.getLibrarySearchEnvValue(variable, phpExeDir, false);
        env.put(variable, value);
    }

    public static String getLibrarySearchPathEnv(File phpExeDir, boolean quoted) {
        String variable = PHPLaunchUtilities.getLibrarySearchEnvVariable();
        if (variable == null) {
            return null;
        }
        String value = PHPLaunchUtilities.getLibrarySearchEnvValue(variable, phpExeDir, quoted);
        return variable + '=' + value;
    }

    public static String getLibrarySearchPathEnv(File phpExeDir) {
        return PHPLaunchUtilities.getLibrarySearchPathEnv(phpExeDir, false);
    }

    private static String getLibrarySearchEnvValue(String variable, File phpExeDir, boolean quoted) {
        File libDirectory;
        StringBuilder buf = new StringBuilder();
        if (quoted) {
            buf.append('\"');
        }
        if ((libDirectory = new File(phpExeDir.getParentFile(), "lib")).exists()) {
            buf.append(libDirectory.getAbsolutePath());
        } else {
            buf.append(phpExeDir.getAbsolutePath());
        }
        try {
            String env = System.getenv(variable);
            if (env != null) {
                buf.append(File.pathSeparatorChar).append(env);
            }
        }
        catch (Throwable throwable) {}
        if (quoted) {
            buf.append('\"');
        }
        return buf.toString();
    }

    private static String getLibrarySearchEnvVariable() {
        String os = Platform.getOS();
        if ("win32".equals(os)) {
            return null;
        }
        if ("macosx".equals(os)) {
            return "DYLD_FALLBACK_LIBRARY_PATH";
        }
        return "LD_LIBRARY_PATH";
    }

    public static String[] getCommandLine(ILaunchConfiguration configuration, String phpExe, String phpConfigDir, String scriptPath, String[] args, String phpVersion) throws CoreException {
        PHPexeItem[] phpItems;
        IProject project = PHPLaunchUtilities.getProject(configuration);
        String aspTags = ProjectOptions.isSupportingAspTags((IProject)project) ? "on" : "off";
        String shortOpenTag = ProjectOptions.useShortTags((IProject)project) ? "on" : "off";
        boolean builtIn = false;
        PHPexeItem[] pHPexeItemArray = phpItems = PHPexes.getInstance().getAllItems();
        int n = phpItems.length;
        int n2 = 0;
        while (n2 < n) {
            PHPexeItem item = pHPexeItemArray[n2];
            if (item.getExecutable().getAbsolutePath().equals(phpExe)) {
                builtIn = !item.isEditable() || !item.isLoadDefaultINI();
                break;
            }
            ++n2;
        }
        LinkedList<String> cmdLineList = new LinkedList<String>();
        if (builtIn) {
            cmdLineList.addAll(Arrays.asList(phpExe, "-n", "-c", phpConfigDir, "-d", "asp_tags=" + aspTags, "-d", "short_open_tag=" + shortOpenTag, scriptPath));
        } else {
            cmdLineList.addAll(Arrays.asList(phpExe, "-c", phpConfigDir, "-d", "asp_tags=" + aspTags, "-d", "short_open_tag=" + shortOpenTag, scriptPath));
        }
        if (args != null) {
            cmdLineList.addAll(Arrays.asList(args));
        }
        return cmdLineList.toArray(new String[cmdLineList.size()]);
    }

    public static String[] getCommandLine(ILaunchConfiguration configuration, String phpExe, String phpConfigDir, String scriptPath, String[] args) throws CoreException {
        return PHPLaunchUtilities.getCommandLine(configuration, phpExe, phpConfigDir, scriptPath, args, null);
    }

    public static String[] getCommandLineForPHP54BuildinServer(ILaunchConfiguration configuration, String phpExe, String phpConfigDir, String server, String root, String routerFile, String[] args, boolean useDefaultPHPIni) throws CoreException {
        String shortOpenTag;
        IProject project = PHPLaunchUtilities.getProject(configuration);
        String aspTags = ProjectOptions.isSupportingAspTags((IProject)project) ? "on" : "off";
        String string = shortOpenTag = ProjectOptions.useShortTags((IProject)project) ? "on" : "off";
        if (server.startsWith("http://")) {
            server = server.substring(7);
        } else if (server.startsWith("https://")) {
            server = server.substring(8);
        }
        LinkedList<String> cmdLineList = new LinkedList<String>();
        if (routerFile == null) {
            cmdLineList.addAll(Arrays.asList(phpExe, "-S", server, "-t", root, useDefaultPHPIni ? "" : "-n", "-c", phpConfigDir, "-d", "asp_tags=" + aspTags, "-d", "short_open_tag=" + shortOpenTag));
        } else {
            cmdLineList.addAll(Arrays.asList(phpExe, "-S", server, "-t", root, routerFile, useDefaultPHPIni ? "" : "-n", "-c", phpConfigDir, "-d", "asp_tags=" + aspTags, "-d", "short_open_tag=" + shortOpenTag));
        }
        if (args != null) {
            cmdLineList.addAll(Arrays.asList(args));
        }
        return cmdLineList.toArray(new String[cmdLineList.size()]);
    }

    public static String[] getCommandLineForPHP54BuildinServer(ILaunchConfiguration configuration, String phpExe, String phpConfigDir, String server, String root, String routerFile, String[] args) throws CoreException {
        return PHPLaunchUtilities.getCommandLineForPHP54BuildinServer(configuration, phpExe, phpConfigDir, server, root, routerFile, args, false);
    }

    public static IProject getProject(IDebugTarget target) {
        ILaunch launch = target.getLaunch();
        if (launch == null) {
            return null;
        }
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        if (launchConfiguration == null) {
            return null;
        }
        return PHPLaunchUtilities.getProject(launchConfiguration);
    }

    private static IProject getProject(ILaunchConfiguration configuration) {
        String fileNameString;
        block5: {
            String projectName = configuration.getAttribute("org.eclipse.php.debug.core.PHP_Project", null);
            if (projectName != null) {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
            fileNameString = configuration.getAttribute("ATTR_FILE", null);
            if (fileNameString != null) break block5;
            return null;
        }
        try {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            Path filePath = new Path(fileNameString);
            IResource res = workspaceRoot.findMember((IPath)filePath);
            if (res != null) {
                return res.getProject();
            }
        }
        catch (CoreException ce) {
            Logger.logException(ce);
        }
        return null;
    }

    public static String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String arguments = configuration.getAttribute("exeDebugArguments", null);
        if (arguments == null || arguments.trim().equals("")) {
            return new String[0];
        }
        return DebugPlugin.parseArguments((String)VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(arguments));
    }

    public static boolean isUsingASPTags(IProject project) {
        PreferencesSupport preferencesSupport = new PreferencesSupport(PHPCorePlugin.getPluginId());
        String value = preferencesSupport.getPreferencesValue("use_asp_tags_as_php", null, project);
        if (value == null) {
            value = preferencesSupport.getWorkspacePreferencesValue("use_asp_tags_as_php");
        }
        return Boolean.valueOf(value);
    }

    public static String generateQuery(ILaunch launch, IDebugParametersInitializer debugParametersInitializer) {
        StringBuilder buf = new StringBuilder();
        Hashtable<String, String> parameters = debugParametersInitializer.getDebugParameters(launch);
        Enumeration<String> e = parameters.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            buf.append(key).append('=');
            try {
                buf.append(URLEncoder.encode(parameters.get(key), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            if (!e.hasMoreElements()) continue;
            buf.append('&');
        }
        return buf.toString();
    }

    public static SSHTunnel getSSHTunnel(ILaunchConfiguration configuration) {
        try {
            if (configuration.getAttribute("org.eclipse.php.debug.core.UseSSHTunnel", false)) {
                String remoteHost = PHPLaunchUtilities.getDebugHost(configuration);
                int port = PHPLaunchUtilities.getDebugPort(configuration);
                if (remoteHost != null && remoteHost.length() > 0 && port > -1) {
                    String userName = configuration.getAttribute("org.eclipse.php.debug.core.SSHTunnelUserName", "");
                    String password = PHPLaunchUtilities.getSecurePreferences(remoteHost).get(userName, "");
                    return SSHTunnelFactory.getSSHTunnel((String)remoteHost, (String)userName, (String)password, (int)port, (int)port);
                }
            }
        }
        catch (CoreException e) {
            Logger.logException("Error obtaining an SSHTunnel instance", e);
        }
        catch (StorageException e) {
            Logger.logException("Error accessing the secured storage for the debug SSH tunnel", e);
        }
        return null;
    }

    public static int getDebugPort(ILaunchConfiguration launchConfiguration) {
        int port = -1;
        try {
            String debuggerID = launchConfiguration.getAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, PHPDebugPlugin.getCurrentDebuggerId());
            AbstractDebuggerConfiguration debuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration(debuggerID);
            port = debuggerConfiguration.getPort();
            Server server = ServersManager.getServer((String)launchConfiguration.getAttribute("name", ""));
            int customPort = -1;
            if ("org.eclipse.php.debug.core.zendDebugger".equals(debuggerID)) {
                if (server != null) {
                    customPort = ZendDebuggerSettingsUtil.getDebugPort(server.getUniqueId());
                }
            } else if ("org.eclipse.php.debug.core.xdebugDebugger".equals(debuggerID) && server != null) {
                customPort = XDebugDebuggerSettingsUtil.getDebugPort(server.getUniqueId());
            }
            if (customPort != -1) {
                port = customPort;
            }
        }
        catch (Exception e) {
            Logger.logException("Could not retrieve the debugger's port number", e);
        }
        return port;
    }

    public static String getDebugHost(ILaunchConfiguration launchConfiguration) {
        String url;
        block4: {
            url = launchConfiguration.getAttribute("base_url", "");
            if (url != null && url.length() != 0) break block4;
            return null;
        }
        try {
            return new URL(url).getHost();
        }
        catch (CoreException e) {
            Logger.logException("Could not retrieve the host name", e);
        }
        catch (MalformedURLException e) {
            Logger.logException("Could not retrieve the host name", e);
        }
        return null;
    }

    public static ISecurePreferences getSecurePreferences(String host) {
        String hostPath = "";
        if (host != null) {
            hostPath = String.valueOf('/') + host;
        }
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        ISecurePreferences node = root.node("/org.eclipse.php/DEBUG" + hostPath);
        return node;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isPortAvailable(int port) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        ss = new ServerSocket(port);
        ss.setReuseAddress(true);
        ds = new DatagramSocket(port);
        ds.setReuseAddress(true);
        if (ds != null) {
            ds.close();
        }
        if (ss == null) return true;
        try {
            ss.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
        catch (IOException iOException) {
            try {
                if (ds != null) {
                    ds.close();
                }
                if (ss == null) return false;
            }
            catch (Throwable throwable) {
                if (ds != null) {
                    ds.close();
                }
                if (ss == null) throw throwable;
                try {
                    ss.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                ss.close();
                return false;
            }
            catch (IOException iOException3) {}
            return false;
        }
    }

    public static boolean isDebugDaemonActive(int port, String debuggerId) {
        return DaemonPlugin.getDefault().validateCommunicationDaemons(debuggerId, port);
    }

    public static boolean isLaunchConfigurationTypeOf(ILaunchConfiguration launchConfiguration, String launchConfigurationType) {
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(launchConfigurationType);
        try {
            if (launchConfiguration.getType().equals(type)) {
                return true;
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return false;
    }

    private static class DebuggerDelayProgressMonitorDialog
    extends ProgressMonitorDialog {
        public DebuggerDelayProgressMonitorDialog() {
            super(null);
            this.setBlockOnOpen(true);
            this.setCancelable(true);
        }

        protected void createCancelButton(Composite parent) {
            this.cancel = this.createButton(parent, 1, PHPDebugCoreMessages.PHPLaunchUtilities_terminate, true);
            if (this.arrowCursor == null) {
                this.arrowCursor = new Cursor((Device)this.cancel.getDisplay(), 0);
            }
            this.cancel.setCursor(this.arrowCursor);
            this.setOperationCancelButtonEnabled(this.enableCancelButton);
        }

        protected Control createDialogArea(Composite parent) {
            Control c = super.createDialogArea(parent);
            this.getProgressMonitor().beginTask(PHPDebugCoreMessages.PHPLaunchUtilities_waitingForDebugger, -1);
            return c;
        }
    }

    private static class DialogResultHolder {
        private int returnCode;
        private boolean result;

        private DialogResultHolder() {
        }

        public boolean getResult() {
            return this.result;
        }

        public void setResult(boolean result) {
            this.result = result;
        }

        public int getReturnCode() {
            return this.returnCode;
        }

        public void setReturnCode(int returnCode) {
            this.returnCode = returnCode;
        }
    }
}

