/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences.phps;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.php.internal.debug.core.PHPExeUtil;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.preferences.phps.Messages;
import org.eclipse.php.internal.debug.ui.wizards.PHPExeEditDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;

public class PHPExeVerifier
extends Job {
    private static final String WIN_VC_DOWNLOAD = "http://www.microsoft.com/en-us/download/details.aspx?id=30679";
    private final PHPexeItem[] exeItems;

    private PHPExeVerifier(PHPexeItem[] exeItems) {
        super("");
        this.setSystem(true);
        this.setUser(false);
        this.exeItems = exeItems;
    }

    public static void verify(PHPexeItem ... exeItems) {
        new PHPExeVerifier(exeItems).schedule();
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(Messages.PHPExeVerifier_Verifying_PHP_exes, this.exeItems.length);
        int i = 0;
        while (i < this.exeItems.length) {
            this.verify(this.exeItems[i]);
            monitor.worked(1);
            ++i;
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    private void verify(final PHPexeItem exeItem) {
        if (Platform.getOS().equals("win32")) {
            File exeLocation = exeItem.getExecutable();
            if (exeLocation == null || !exeLocation.exists() || !exeLocation.getName().contains("php")) {
                return;
            }
            boolean valid = true;
            try {
                String version = PHPExeUtil.fetchVersion((File)exeLocation);
                if (version == null || version.isEmpty()) {
                    valid = false;
                }
            }
            catch (IOException e) {
                valid = false;
                Logger.logException("Failed to verify PHP executable: ", e);
            }
            if (!valid) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        new ErrorDialog(exeItem).open();
                    }
                });
            }
        }
    }

    private static class ErrorDialog
    extends MessageDialog {
        private PHPexeItem exeItem;

        public ErrorDialog(PHPexeItem exeItem) {
            super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.PHPExeVerifier_PHP_executable_verification, null, null, 1, new String[]{"OK"}, 0);
            this.exeItem = exeItem;
        }

        protected Control createMessageArea(Composite composite) {
            Image image = this.getImage();
            if (image != null) {
                this.imageLabel = new Label(composite, 0);
                image.setBackground(this.imageLabel.getBackground());
                this.imageLabel.setImage(image);
                GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
            }
            Composite descriptionComposite = new Composite(composite, 0);
            GridLayout layout = new GridLayout(1, true);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 10;
            descriptionComposite.setLayout((Layout)layout);
            Link messageError = new Link(descriptionComposite, 64);
            messageError.setLayoutData((Object)new GridData(768));
            messageError.setText(MessageFormat.format(Messages.PHPExeVerifier_Unable_to_verify_PHP_exe_error_message, this.exeItem.getName()));
            messageError.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PHPExeEditDialog dialog = new PHPExeEditDialog(ErrorDialog.this.getShell(), ErrorDialog.this.exeItem, PHPexes.getInstance().getAllItems());
                    if (dialog.open() != 0) {
                        return;
                    }
                    PHPexes.getInstance().save();
                }
            });
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)messageError);
            Link messageReason = new Link(descriptionComposite, 64);
            messageReason.setLayoutData((Object)new GridData(768));
            messageReason.setText(Messages.PHPExeVerifier_Unable_to_verify_PHP_exe_reason_message);
            messageReason.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(PHPExeVerifier.WIN_VC_DOWNLOAD));
                    }
                    catch (Exception exception) {}
                }
            });
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)messageReason);
            return composite;
        }
    }
}

