/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.ui.preferences;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.php.formatter.ui.FormatterMessages;
import org.eclipse.php.formatter.ui.preferences.ProfileManager;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RenameProfileDialog
extends StatusDialog {
    private Label fNameLabel;
    private Text fNameText;
    private final StatusInfo fOk;
    private final StatusInfo fEmpty;
    private final StatusInfo fDuplicate;
    private final StatusInfo fNoMessage;
    private final ProfileManager.Profile fProfile;
    private final ProfileManager fManager;
    private ProfileManager.Profile fRenamedProfile;

    public RenameProfileDialog(Shell parentShell, ProfileManager.Profile profile, ProfileManager manager) {
        super(parentShell);
        this.fManager = manager;
        this.setTitle(FormatterMessages.RenameProfileDialog_dialog_title);
        this.fProfile = profile;
        this.fOk = new StatusInfo();
        this.fDuplicate = new StatusInfo(4, FormatterMessages.RenameProfileDialog_status_message_profile_with_this_name_already_exists);
        this.fEmpty = new StatusInfo(4, FormatterMessages.RenameProfileDialog_status_message_profile_name_empty);
        this.fNoMessage = new StatusInfo(4, "");
    }

    public Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        this.fNameLabel = new Label(composite, 0);
        this.fNameLabel.setText(FormatterMessages.RenameProfileDialog_dialog_label_enter_a_new_name);
        this.fNameLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fNameText = new Text(composite, 2052);
        this.fNameText.setSelection(0, this.fProfile.getName().length());
        this.fNameText.setLayoutData((Object)gd);
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenameProfileDialog.this.doValidation();
            }
        });
        this.fNameText.setText(this.fProfile.getName());
        this.fNameText.selectAll();
        RenameProfileDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void doValidation() {
        String name = this.fNameText.getText().trim();
        if (name.length() == 0) {
            this.updateStatus((IStatus)this.fEmpty);
            return;
        }
        if (name.equals(this.fProfile.getName())) {
            this.updateStatus((IStatus)this.fNoMessage);
            return;
        }
        if (this.fManager.containsName(name)) {
            this.updateStatus((IStatus)this.fDuplicate);
            return;
        }
        this.updateStatus((IStatus)this.fOk);
    }

    public ProfileManager.Profile getRenamedProfile() {
        return this.fRenamedProfile;
    }

    protected void okPressed() {
        if (!this.getStatus().isOK()) {
            return;
        }
        this.fRenamedProfile = this.fProfile.rename(this.fNameText.getText(), this.fManager);
        super.okPressed();
    }
}

