/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.move;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.refactoring.core.move.PHPMoveProcessor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PHPMoveProcessorTestCase0027202 {
    private IProject project1;
    private IProject project2;

    @Before
    public void setUp() throws Exception {
        this.project1 = TestUtils.createProject((String)"project1");
        IFolder folder = TestUtils.createFolder((IProject)this.project1, (String)"src");
        TestUtils.createFile((IFolder)folder, (String)"test1.php", (String)"<?php class TestRenameClass{}?>");
        this.project2 = TestUtils.createProject((String)"project2");
        folder = TestUtils.createFolder((IProject)this.project2, (String)"src");
        TestUtils.createFile((IProject)this.project2, (String)"test2.php", (String)"<?php include('src/test1.php'); ?>");
        TestUtils.waitForIndexer();
    }

    @After
    public void tearDown() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
        this.project2.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testMove() {
        StructuredSelection selection = new StructuredSelection((Object)this.project1.getProject().getFolder("/src"));
        PHPMoveProcessor processor = new PHPMoveProcessor((IStructuredSelection)selection);
        processor.setDestination((IContainer)this.project2);
        processor.setUpdateReferences(true);
        RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)0L, (long)status.getSeverity());
        status = processor.checkFinalConditions((IProgressMonitor)new NullProgressMonitor(), null);
        Assert.assertEquals((long)4L, (long)status.getSeverity());
    }
}

