/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.wizard;

import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.refactoring.core.move.PHPMoveProcessor;
import org.eclipse.php.refactoring.ui.PHPRefactoringUIMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RefactoringDropMoveWizardPage
extends UserInputWizardPage {
    private Button fReferenceCheckbox;
    private PHPMoveProcessor processor;

    public RefactoringDropMoveWizardPage() {
        super(PHPRefactoringUIMessages.getString("RefactoringMoveWizardPage.0"));
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.processor = this.getPHPMoveProcessor();
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        result.setLayout((Layout)new GridLayout());
        this.verifyDestination(this.processor.getDestination(), true);
        this.addUpdateReferenceComponent(result);
        Dialog.applyDialogFont((Control)result);
    }

    private final void verifyDestination(Object selected, boolean initialVerification) {
        try {
            RefactoringStatus status = this.verifyDestination(selected);
            if (initialVerification) {
                this.setPageComplete(status.isOK());
            } else {
                this.setPageComplete(status);
            }
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
            this.setPageComplete(false);
        }
    }

    protected RefactoringStatus verifyDestination(Object selected) throws Exception {
        RefactoringStatus refactoringStatus = selected instanceof IContainer ? this.processor.setDestination((IContainer)selected) : RefactoringStatus.createFatalErrorStatus((String)PHPRefactoringUIMessages.getString("RefactoringMoveWizardPage.2"));
        return refactoringStatus;
    }

    private PHPMoveProcessor getPHPMoveProcessor() {
        return (PHPMoveProcessor)this.getRefactoring().getAdapter(PHPMoveProcessor.class);
    }

    private void addUpdateReferenceComponent(Composite result) {
        final PHPMoveProcessor processor = this.getPHPMoveProcessor();
        this.fReferenceCheckbox = new Button(result, 32);
        this.fReferenceCheckbox.setText(PHPRefactoringUIMessages.getString("RefactoringMoveWizardPage.3"));
        this.fReferenceCheckbox.setSelection(processor.getUpdateReferences());
        this.fReferenceCheckbox.setEnabled(true);
        this.fReferenceCheckbox.setSelection(true);
        processor.setUpdateReferences(true);
        this.getRefactoringWizard().setForcePreviewReview(true);
        this.fReferenceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                processor.setUpdateReferences(((Button)e.widget).getSelection());
                RefactoringDropMoveWizardPage.this.getRefactoringWizard().setForcePreviewReview(processor.getUpdateReferences());
            }
        });
    }
}

