/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hyperlink;

import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.ICodeAssist;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ModelElementHyperlink;
import org.eclipse.dltk.ui.actions.OpenAction;
import org.eclipse.dltk.ui.infoviews.ModelElementArray;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class PHPHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static final String NEW = "new";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (region == null) return null;
        if (!(textEditor instanceof PHPStructuredEditor)) {
            return null;
        }
        ISourceModule input = EditorUtility.getEditorInputModelElement((IEditorPart)textEditor, (boolean)false);
        if (input == null) {
            return null;
        }
        PHPVersion phpVersion = ProjectOptions.getPhpVersion((IProject)input.getScriptProject().getProject());
        boolean namespacesSupported = phpVersion.isGreaterThan(PHPVersion.PHP5);
        IDocument document = textViewer.getDocument();
        int offset = region.getOffset();
        try {
            IRegion wordRegion = PHPHyperlinkDetector.findWord(document, offset, namespacesSupported);
            if (wordRegion == null) {
                return null;
            }
            try {
                String text = document.get(wordRegion.getOffset(), wordRegion.getLength());
                if (text.equals(NEW)) {
                    return null;
                }
            }
            catch (BadLocationException badLocationException) {}
            Object[] elements = null;
            elements = ((ICodeAssist)input).codeSelect(wordRegion.getOffset(), wordRegion.getLength());
            if ((elements == null || elements.length == 0) && input instanceof ISourceModule) {
                elements = PHPModelUtils.getTypeInString((ISourceModule)input, (IRegion)wordRegion);
            }
            if (elements == null) return null;
            if (elements.length <= 0) return null;
            ModelElementHyperlink link = elements.length == 1 ? new ModelElementHyperlink(wordRegion, (Object)elements[0], new OpenAction((IEditorPart)textEditor)) : new ModelElementHyperlink(wordRegion, (Object)new ModelElementArray(elements), new OpenAction((IEditorPart)textEditor));
            return new IHyperlink[]{link};
        }
        catch (ModelException modelException) {
            return null;
        }
    }

    public static IRegion findWord(IDocument document, int offset, boolean namespacesSupported) {
        int start = -2;
        int end = -1;
        try {
            char c;
            int pos = offset;
            int rightmostNsSeparator = -1;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c) && (!namespacesSupported || c != '\\')) break;
                if (namespacesSupported && c == '\\' && rightmostNsSeparator == -1) {
                    rightmostNsSeparator = pos;
                }
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c) && (!namespacesSupported || c != '\\')) break;
                if (namespacesSupported && c == '\\') {
                    rightmostNsSeparator = pos;
                }
                ++pos;
            }
            end = pos;
            if (rightmostNsSeparator != -1) {
                if (rightmostNsSeparator > offset) {
                    end = rightmostNsSeparator;
                } else {
                    start = rightmostNsSeparator;
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        if (start >= -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }
}

