/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.saveparticipant;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.core.manipulation.SourceModuleChange;
import org.eclipse.dltk.ui.editor.saveparticipant.IPostSaveListener;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.php.internal.core.format.ICodeFormattingProcessor;
import org.eclipse.php.internal.core.format.IFormatterProcessorFactory;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class CodeFormatSaveParticipant
implements IPostSaveListener {
    public static final String ID = "CodeFormat";
    public static final String EDITOR_SAVE_PARTICIPANT_PREFIX = "editor_save_participant_";
    private boolean formatOnSaveEnabled = false;

    public String getName() {
        return "Format source code";
    }

    public String getId() {
        return ID;
    }

    public void updateSaveActionsState(@Nullable IProject project) {
        PreferencesSupport prefSupport = new PreferencesSupport("org.eclipse.php.ui");
        String formatOnSavePref = prefSupport.getPreferencesValue("cleanup.format.on.save", null, project);
        this.formatOnSaveEnabled = Boolean.parseBoolean(formatOnSavePref);
    }

    public boolean isEnabled(ISourceModule compilationUnit) {
        return new PreferencesLookupDelegate(compilationUnit.getScriptProject().getProject()).getBoolean("org.eclipse.php.ui", "editor_save_participant_CodeFormat");
    }

    public boolean needsChangedRegions(ISourceModule compilationUnit) throws CoreException {
        return false;
    }

    public void saved(ISourceModule compilationUnit, IRegion[] changedRegions, IProgressMonitor monitor) throws CoreException {
        IScriptProject project = compilationUnit.getScriptProject();
        this.updateSaveActionsState(project != null ? project.getProject() : null);
        if (!this.formatOnSaveEnabled) {
            return;
        }
        IContentFormatter formatter = PHPUiPlugin.getDefault().getActiveFormatter();
        if (formatter instanceof IFormatterProcessorFactory) {
            try {
                Document document = new Document(compilationUnit.getSource());
                ICodeFormattingProcessor processor = ((IFormatterProcessorFactory)formatter).getCodeFormattingProcessor((IDocument)document, ProjectOptions.getPhpVersion((IModelElement)project), ProjectOptions.useShortTags((IModelElement)project), (IRegion)new Region(0, document.getLength()));
                MultiTextEdit edits = processor.getTextEdits();
                if (edits.hasChildren()) {
                    SourceModuleChange change = new SourceModuleChange("Format " + compilationUnit.getElementName(), compilationUnit);
                    change.setSaveMode(4);
                    change.setEdit((TextEdit)edits);
                    change.perform(monitor);
                }
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.php.ui", e.toString(), (Throwable)e));
            }
        }
    }
}

