/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.test;

import java.io.BufferedReader;
import java.io.Reader;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.api.RepositoryPackage;
import org.eclipse.php.composer.api.json.ParseException;
import org.eclipse.php.composer.api.test.ComposertTestCase;
import org.junit.Test;

public class JsonParserTest
extends ComposertTestCase {
    @Test
    public void testException() {
        try {
            new ComposerPackage("{\n\"bla\":'arg\n}");
            JsonParserTest.fail();
        }
        catch (ParseException e) {
            JsonParserTest.assertEquals((String)"Unterminated string at line 3 column 2", (String)e.getMessage());
        }
    }

    @Test
    public void testComposerPackage() {
        try {
            this.doTestComposerPackage(new ComposerPackage(this.loadFile("composer.json")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testDependencies() {
        try {
            this.doTestDependencies(new ComposerPackage(this.loadFile("dependencies.json")));
        }
        catch (Exception e) {
            e.printStackTrace();
            JsonParserTest.fail();
        }
    }

    @Test
    public void testSupport() {
        try {
            this.doTestSupport(new ComposerPackage(this.loadFile("support.json")));
        }
        catch (Exception e) {
            e.printStackTrace();
            JsonParserTest.fail();
        }
    }

    @Test
    public void testConfig() {
        try {
            this.doTestConfig(new ComposerPackage(this.loadFile("config.json")));
        }
        catch (Exception e) {
            e.printStackTrace();
            JsonParserTest.fail();
        }
    }

    @Test
    public void testScripts() {
        try {
            this.doTestScripts(new ComposerPackage(this.loadFile("scripts.json")));
        }
        catch (Exception e) {
            e.printStackTrace();
            JsonParserTest.fail();
        }
    }

    public void testRepositories() {
        try {
            this.doTestRepositories(new ComposerPackage(this.loadFile("repositories.json")));
        }
        catch (Exception e) {
            e.printStackTrace();
            JsonParserTest.fail();
        }
    }

    @Test
    public void testAutoload() {
        try {
            this.doTestAutoload(new ComposerPackage(this.loadFile("autoload.json")));
        }
        catch (Exception e) {
            e.printStackTrace();
            JsonParserTest.fail();
        }
    }

    @Test
    public void testEmptyJson() {
        try {
            ComposerPackage phpPackage = new ComposerPackage(this.loadFile("empty.json"));
            JsonParserTest.assertNotNull((Object)phpPackage);
        }
        catch (Exception e) {
            e.printStackTrace();
            JsonParserTest.fail();
        }
    }

    @Test
    public void testParserOrder() {
        try {
            Reader core = this.loadFile("keeko-core.json");
            BufferedReader reader = new BufferedReader(this.loadFile("keeko-core.json"));
            StringBuilder out = new StringBuilder();
            String line = null;
            String ls = System.getProperty("line.separator");
            while ((line = reader.readLine()) != null) {
                out.append(line);
                out.append(ls);
            }
            String contents = out.toString().trim();
            ComposerPackage phpPackage = new ComposerPackage(core);
            JsonParserTest.assertEquals((String)contents, (String)phpPackage.toJson());
        }
        catch (Exception e) {
            e.printStackTrace();
            JsonParserTest.fail();
        }
    }

    @Test
    public void testPackageJson() {
        try {
            RepositoryPackage phpPackage = RepositoryPackage.fromPackageRepository((Reader)this.loadFile("packagist.json"));
            JsonParserTest.assertNotNull((Object)phpPackage);
            JsonParserTest.assertEquals((String)"friendsofsymfony/user-bundle", (String)phpPackage.getName());
            JsonParserTest.assertEquals((String)"Symfony FOSUserBundle", (String)phpPackage.getDescription());
            JsonParserTest.assertNotNull((Object)phpPackage.getVersions());
            JsonParserTest.assertTrue((phpPackage.getVersions().size() > 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            JsonParserTest.fail();
        }
    }

    @Test
    public void testReactJson() {
        try {
            RepositoryPackage phpPackage = RepositoryPackage.fromPackageRepository((Reader)this.loadFile("react.json"));
            JsonParserTest.assertNotNull((Object)phpPackage);
            JsonParserTest.assertEquals((String)"react/react", (String)phpPackage.getName());
            JsonParserTest.assertEquals((String)"Nuclear Reactor written in PHP.", (String)phpPackage.getDescription());
            JsonParserTest.assertNotNull((Object)phpPackage.getVersions());
            JsonParserTest.assertTrue((phpPackage.getVersions().size() > 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            JsonParserTest.fail();
        }
    }
}

