/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.php.composer.api.ComposerConstants;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.api.entities.AbstractIterableJsonObject;
import org.eclipse.php.composer.api.entities.Version;

public class Versions
extends AbstractIterableJsonObject<ComposerPackage> {
    private Map<String, Version> detailedVersions = null;
    private SortedMap<String, List<Integer>> majors = new TreeMap<String, List<Integer>>();

    @Override
    protected void doParse(Object obj) {
        this.clear();
        if (obj instanceof LinkedHashMap) {
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                ComposerPackage pkg = new ComposerPackage(entry.getValue());
                this.set((String)entry.getKey(), pkg);
            }
        }
    }

    public String getDefaultVersion() {
        NavigableSet sortedVersions = new TreeSet(this.properties.keySet()).descendingSet();
        String[] stringArray = ComposerConstants.STABILITIES;
        int n = ComposerConstants.STABILITIES.length;
        int n2 = 0;
        while (n2 < n) {
            String stability = stringArray[n2];
            for (String version : sortedVersions) {
                Version v = this.getDetailedVersion(version);
                if (v == null || !Objects.equals(stability, v.getStability())) continue;
                return version;
            }
            ++n2;
        }
        return sortedVersions.isEmpty() ? null : (String)sortedVersions.iterator().next();
    }

    public Set<String> toSet() {
        return this.properties.keySet();
    }

    public String[] toArray() {
        return this.properties.keySet().toArray(new String[0]);
    }

    private void compileDetailedVersions() {
        if (this.detailedVersions == null) {
            this.detailedVersions = new HashMap<String, Version>();
            String[] stringArray = this.toArray();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String version = stringArray[n2];
                this.compileDetailedVersion(version);
                ++n2;
            }
        }
    }

    private void compileDetailedVersion(String version) {
        String major;
        Version v = new Version(version);
        this.detailedVersions.put(version, v);
        if (v.getStability() == "stable" && (major = v.getMajor()) != null) {
            if (!this.majors.containsKey(major)) {
                this.majors.put(major, new ArrayList());
            }
            List majorList = (List)this.majors.get(major);
            String minor = v.getMinor();
            if (minor != null && !majorList.contains(minor)) {
                ((List)this.majors.get(major)).add(Integer.parseInt(minor));
                Collections.sort(majorList);
                Collections.reverse(majorList);
            }
        }
    }

    private void prepareDetailedVersions() {
        if (this.detailedVersions == null) {
            this.compileDetailedVersions();
        }
    }

    public List<Version> getDetailedVersions() {
        this.prepareDetailedVersions();
        ArrayList<Version> all = new ArrayList<Version>();
        all.addAll(this.detailedVersions.values());
        return all;
    }

    public String[] getMajors() {
        this.prepareDetailedVersions();
        return this.majors.keySet().toArray(new String[0]);
    }

    public String getRecentMajor() {
        this.prepareDetailedVersions();
        if (this.majors.size() > 0) {
            return this.majors.firstKey();
        }
        return null;
    }

    public String[] getMinors(String major) {
        this.prepareDetailedVersions();
        if (this.majors.containsKey(major)) {
            return ((List)this.majors.get(major)).toArray(new String[0]);
        }
        return null;
    }

    public String getRecentMinor(String major) {
        if (major == null) {
            return null;
        }
        this.prepareDetailedVersions();
        if (this.majors.containsKey(major) && ((List)this.majors.get(major)).size() > 0) {
            return ((Integer)((List)this.majors.get(major)).get(0)).toString();
        }
        return null;
    }

    public void set(String version, ComposerPackage composerPackage) {
        if (this.detailedVersions != null) {
            this.compileDetailedVersion(version);
        }
        super.set(version, composerPackage);
        Collections.sort(this.sortOrder);
    }

    @Override
    public void remove(String version) {
        if (this.detailedVersions != null) {
            String major;
            Version v = this.getDetailedVersion(version);
            this.detailedVersions.remove(version);
            if (v.getStability() == "stable" && (major = v.getMajor()) != null && this.majors.containsKey(major)) {
                List majorList = (List)this.majors.get(major);
                String minor = v.getMinor();
                if (minor != null && majorList.contains(minor)) {
                    majorList.remove(minor);
                    Collections.sort(majorList);
                }
                if (majorList.size() == 0) {
                    this.majors.remove(major);
                }
            }
        }
        super.remove(version);
    }

    public Version getDetailedVersion(String version) {
        this.prepareDetailedVersions();
        if (this.detailedVersions.containsKey(version)) {
            return this.detailedVersions.get(version);
        }
        return null;
    }
}

