/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.facet;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.facet.PHPFacets;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class FacetManager {
    public static IFacetedProject installFacets(IProject project, PHPVersion version, IProgressMonitor monitor) {
        IFile composerJson;
        IFacetedProject facetedProject;
        block7: {
            try {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                if ((facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor)) != null) break block7;
                Logger.log(4, "Unable to create faceted composer project.");
                return null;
            }
            catch (CoreException ex) {
                Logger.logException(ex.getMessage(), ex);
                return null;
            }
        }
        IProjectFacet coreFacet = ProjectFacetsManager.getProjectFacet((String)"php.core.component");
        IProjectFacet composerFacet = ProjectFacetsManager.getProjectFacet((String)"php.composer.component");
        if (!facetedProject.hasProjectFacet(coreFacet)) {
            facetedProject.installProjectFacet(coreFacet.getDefaultVersion(), null, monitor);
            facetedProject.installProjectFacet(PHPFacets.convertToFacetVersion((PHPVersion)version), null, monitor);
        }
        if (!facetedProject.hasProjectFacet(composerFacet)) {
            facetedProject.installProjectFacet(composerFacet.getVersion("1"), (Object)composerFacet, monitor);
        }
        if (!(composerJson = project.getFile("composer.json")).exists()) {
            ComposerPackage composerPackage = new ComposerPackage();
            composerPackage.setName(String.valueOf(project.getName().toLowerCase()) + "/" + project.getName().toLowerCase());
            composerPackage.setDescription("");
            composerJson.create((InputStream)new ByteArrayInputStream(composerPackage.toJson().getBytes()), 0, monitor);
        }
        return facetedProject;
    }

    public static void uninstallFacets(IProject project, IProgressMonitor monitor) {
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
            IProjectFacet composerFacet = ProjectFacetsManager.getProjectFacet((String)"php.composer.component");
            facetedProject.uninstallProjectFacet(composerFacet.getVersion("1"), (Object)composerFacet, monitor);
        }
        catch (CoreException ex) {
            Logger.logException(ex.getMessage(), ex);
        }
    }

    public static boolean hasComposerFacet(IProject project) {
        try {
            IFacetedProject fProj = ProjectFacetsManager.create((IProject)project);
            if (fProj != null) {
                return fProj.hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)"php.composer.component"));
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return false;
    }
}

