/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.visitor;

import java.util.Iterator;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.composer.api.collection.Psr;
import org.eclipse.php.composer.api.objects.Namespace;
import org.eclipse.php.composer.core.model.ModelAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.ArrayCreation;
import org.eclipse.php.internal.core.compiler.ast.nodes.ArrayElement;
import org.eclipse.php.internal.core.compiler.ast.nodes.InfixExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.compiler.ast.visitor.PHPASTVisitor;

public class AutoloadVisitor
extends PHPASTVisitor {
    protected ISourceModule source;
    private NamespaceVisitor visitor;

    public AutoloadVisitor(ISourceModule source) {
        this.source = source;
    }

    public boolean visit(ArrayCreation s) throws Exception {
        this.visitor = new NamespaceVisitor();
        s.traverse((ASTVisitor)this.visitor);
        Psr psr0 = this.visitor.getPsr0();
        if (psr0.size() > 0) {
            ModelAccess.getInstance().updatePsr0(psr0, this.source.getScriptProject());
        }
        return true;
    }

    public Psr getPsr0() {
        if (this.visitor != null) {
            return this.visitor.getPsr0();
        }
        return null;
    }

    protected class NamespaceVisitor
    extends PHPASTVisitor {
        protected Psr psr0 = new Psr();

        protected NamespaceVisitor() {
        }

        public boolean visit(ArrayElement element) throws Exception {
            if (!(element.getKey() instanceof Scalar)) {
                return false;
            }
            if (element.getValue() instanceof InfixExpression) {
                Scalar namespace = (Scalar)element.getKey();
                Scalar path = (Scalar)((InfixExpression)element.getValue()).getRight();
                VariableReference reference = (VariableReference)((InfixExpression)element.getValue()).getLeft();
                this.extractPsr0(namespace, path, reference);
                return false;
            }
            if (element.getValue() instanceof ArrayCreation) {
                Scalar namespace = (Scalar)element.getKey();
                ArrayCreation paths = (ArrayCreation)element.getValue();
                Iterator iterator = paths.getElements().iterator();
                if (iterator.hasNext()) {
                    ArrayElement elem = (ArrayElement)iterator.next();
                    if (elem.getValue() instanceof InfixExpression) {
                        Scalar path = (Scalar)((InfixExpression)elem.getValue()).getRight();
                        VariableReference reference = (VariableReference)((InfixExpression)elem.getValue()).getLeft();
                        this.extractPsr0(namespace, path, reference);
                    }
                    return false;
                }
            }
            return true;
        }

        protected void extractPsr0(Scalar namespace, Scalar path, VariableReference reference) {
            String resourcePath = "";
            if ("$baseDir".equals(reference.getName())) {
                resourcePath = path.getValue().replace("'", "");
            } else if ("$vendorDir".equals(reference.getName())) {
                resourcePath = "vendor" + path.getValue().replace("'", "");
            }
            if (resourcePath.startsWith("/")) {
                resourcePath = resourcePath.replaceFirst("/", "");
            }
            String ns = namespace.getValue().replace("'", "").replace("\\\\", "\\");
            this.psr0.add(new Namespace(ns, resourcePath));
        }

        public Psr getPsr0() {
            return this.psr0;
        }
    }
}

