/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.wizard;

import java.io.File;
import java.net.URI;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.ui.converter.String2KeywordsConverter;
import org.eclipse.php.composer.ui.wizard.AbstractValidator;
import org.eclipse.php.composer.ui.wizard.DetectGroup;
import org.eclipse.php.composer.ui.wizard.LocationGroup;
import org.eclipse.php.composer.ui.wizard.project.BasicSettingsGroup;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.ui.wizards.CompositeData;
import org.eclipse.php.internal.ui.wizards.IPHPProjectCreateWizardPage;
import org.eclipse.php.internal.ui.wizards.NameGroup;
import org.eclipse.php.internal.ui.wizards.PHPProjectWizardFirstPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractWizardFirstPage
extends WizardPage
implements IPHPProjectCreateWizardPage,
Observer {
    public NameGroup nameGroup;
    public LocationGroup PHPLocationGroup;
    public PHPProjectWizardFirstPage.VersionGroup versionGroup;
    protected String initialName;
    protected Composite composite;
    protected AbstractValidator validator;
    protected DetectGroup detectGroup;
    protected ComposerPackage composerPackage;
    protected String2KeywordsConverter keywordConverter;

    protected AbstractWizardFirstPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setFont(parent.getFont());
        this.composite.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), false));
        this.composite.setLayoutData((Object)new GridData(256));
        this.initialName = "";
        this.nameGroup = new NameGroup(this.composite, this.initialName, this.getShell());
        this.nameGroup.addObserver((Observer)this);
        this.validator = this.getValidator();
        this.beforeLocationGroup();
        this.PHPLocationGroup = new LocationGroup(this.composite, this.nameGroup, this.getShell());
        CompositeData data = new CompositeData();
        data.setParetnt(this.composite);
        data.setSettings(this.getDialogSettings());
        data.setObserver((Observer)this.PHPLocationGroup);
        this.versionGroup = new PHPProjectWizardFirstPage.VersionGroup(this, this.composite, PHPVersion.PHP5_3){

            public IEnvironment getEnvironment() {
                return AbstractWizardFirstPage.this.getEnvironment();
            }
        };
        this.detectGroup = new DetectGroup(this.composite, this.PHPLocationGroup, this.nameGroup);
        this.nameGroup.addObserver((Observer)this.PHPLocationGroup);
        this.PHPLocationGroup.addObserver(this.detectGroup);
        this.nameGroup.notifyObservers();
        this.nameGroup.addObserver((Observer)this.validator);
        this.PHPLocationGroup.addObserver(this.validator);
        Dialog.applyDialogFont((Control)this.composite);
        this.afterLocationGroup();
        this.setControl((Control)this.composite);
        this.composerPackage = new ComposerPackage();
        this.keywordConverter = new String2KeywordsConverter(this.composerPackage);
        this.finishControlSetup();
        this.setHelpContext((Control)this.composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.nameGroup.setFocus();
        }
    }

    public void performFinish(IProgressMonitor monitor) {
    }

    protected abstract void finishControlSetup();

    protected abstract void beforeLocationGroup();

    protected abstract void afterLocationGroup();

    protected abstract AbstractValidator getValidator();

    @Override
    public abstract void update(Observable var1, Object var2);

    public abstract void initPage();

    protected abstract void setHelpContext(Control var1);

    public GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.nameGroup.getName());
    }

    public IEnvironment getEnvironment() {
        return this.PHPLocationGroup.getEnvironment();
    }

    public boolean isInWorkspace() {
        return this.PHPLocationGroup.isInWorkspace();
    }

    public boolean isInLocalServer() {
        return this.PHPLocationGroup.isInLocalServer();
    }

    public boolean canCreate(File file) {
        while (!file.exists()) {
            if ((file = file.getParentFile()) != null) continue;
            return false;
        }
        return file.canWrite();
    }

    public URI getLocationURI() {
        IEnvironment environment = this.getEnvironment();
        return environment.getURI(this.PHPLocationGroup.getLocation());
    }

    public IPath getPath() {
        return this.PHPLocationGroup.getLocation();
    }

    public boolean getDetect() {
        return this.detectGroup.mustDetect();
    }

    public boolean hasPhpSourceFolder() {
        return true;
    }

    public boolean isDefaultVersionSelected() {
        return false;
    }

    public boolean getUseAspTagsValue() {
        return this.versionGroup != null && this.versionGroup.fConfigurationBlock.getUseAspTagsValue();
    }

    public PHPVersion getPHPVersionValue() {
        if (this.versionGroup != null) {
            return PHPVersion.fromApi((org.eclipse.php.core.PHPVersion)this.versionGroup.fConfigurationBlock.getPHPVersionValue());
        }
        return null;
    }

    public ComposerPackage getPackage() {
        return this.composerPackage;
    }

    public void updatePackageFromSettingsGroup(BasicSettingsGroup settingsGroup) {
        if (settingsGroup.getVendor() != null && this.nameGroup.getName() != null) {
            this.composerPackage.setName(String.format("%s/%s", settingsGroup.getVendor(), this.nameGroup.getName()));
        }
        if (settingsGroup.getDescription().length() > 0) {
            this.composerPackage.setDescription(settingsGroup.getDescription());
        }
        if (settingsGroup.getLicense().length() > 0) {
            this.composerPackage.getLicense().clear();
            this.composerPackage.getLicense().add(settingsGroup.getLicense());
        }
        if (settingsGroup.getType().length() > 0) {
            this.composerPackage.setType(settingsGroup.getType());
        }
        if (settingsGroup.getKeywords().length() > 0) {
            this.keywordConverter.convert(settingsGroup.getKeywords());
        }
    }
}

