/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.dom_ast;

import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ASTParser;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.scanner.AstLexer;
import org.eclipse.php.internal.core.ast.scanner.php5.PhpAstLexer;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class CommentMapperTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();

    @Test
    public void variable() throws Exception {
        String str = "<?php \r\n// comment of $a\r\n$a; ?>";
        this.parseAndCompare(str);
    }

    @Test
    public void variableTwoComments() throws Exception {
        String str = "<?php \r\n// comment of $a\r\n// comment of $a\r\n$a; ?>";
        this.parseAndCompare(str);
    }

    @Test
    public void variableMultiple() throws Exception {
        String str = "<?php \r\n/** \r\ncomment of $a */\r\n$a; ?>";
        this.parseAndCompare(str);
    }

    @Test
    public void function() throws Exception {
        String str = "<?php \r\n// comment of foo()\r\nfunction foo() {\r\n   }; ?>";
        this.parseAndCompare(str);
    }

    @Test
    public void testClass() throws Exception {
        String str = "<?php \r\n// comment of A\r\nclass A {\r\n}; ?>";
        this.parseAndCompare(str);
    }

    @Test
    public void method() throws Exception {
        String str = "<?php \r\n class A {\r\n // comment of method foo()\r\n public function foo() {  }  \r\n} ?>";
        this.parseAndCompareInner(str, 0);
    }

    @Test
    public void field() throws Exception {
        String str = "<?php \r\n class A {\r\n // comment of field $a \r\n public $a = 5;\r\n } ?>";
        this.parseAndCompareInner(str, 0);
    }

    @Test
    public void methodSecond() throws Exception {
        String str = "<?php \r\n class A {\r\n // comment of method foo()\r\n public function foo() {  }  \r\n \r\n // comment of method bar()\r\n public function bar() {  } \r\n } ?>";
        this.parseAndCompareInner(str, 1);
    }

    @Test
    public void fieldSecond() throws Exception {
        String str = "<?php \r\n class A {\r\n // comment of field $a \r\n public $a = 5;\r\n \r\n/** \r\n * comment of field $a */ \r\n public $b = 5;\r\n } ?>";
        this.parseAndCompareInner(str, 1);
    }

    public void parseAndCompare(String programStr) throws Exception {
        Document document = new Document(programStr);
        StringReader reader = new StringReader(programStr);
        Program program = ASTParser.newParser((Reader)reader, (PHPVersion)PHPVersion.PHP5, (boolean)ProjectOptions.useShortTags(null)).createAST((IProgressMonitor)new NullProgressMonitor());
        program.initCommentMapper((IDocument)document, (AstLexer)new PhpAstLexer((Reader)reader));
        Statement node = (Statement)program.statements().get(0);
        int extendedLength = program.getExtendedLength((ASTNode)node);
        assert (extendedLength > node.getLength());
    }

    public void parseAndCompareInner(String programStr, int index) throws Exception {
        Document document = new Document(programStr);
        StringReader reader = new StringReader(programStr);
        Program program = ASTParser.newParser((Reader)reader, (PHPVersion)PHPVersion.PHP5, (boolean)ProjectOptions.useShortTags(null)).createAST((IProgressMonitor)new NullProgressMonitor());
        program.initCommentMapper((IDocument)document, (AstLexer)new PhpAstLexer((Reader)reader));
        ClassDeclaration node = (ClassDeclaration)program.statements().get(0);
        Statement statement = (Statement)node.getBody().statements().get(index);
        int extendedLength = program.getExtendedLength((ASTNode)statement);
        assert (extendedLength > statement.getLength());
    }
}

