/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.rewrite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.BodyDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Comment;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewriteFlattener;
import org.eclipse.php.internal.core.ast.rewrite.IndentManipulation;
import org.eclipse.php.internal.core.ast.rewrite.NodeInfoStore;
import org.eclipse.php.internal.core.ast.rewrite.RewriteEventStore;
import org.eclipse.php.internal.core.format.DefaultCodeFormattingProcessor;
import org.eclipse.php.internal.core.format.ICodeFormattingProcessor;
import org.eclipse.php.internal.core.format.IFormatterProcessorFactory;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

final class ASTRewriteFormatter {
    private static IFormatterProcessorFactory contentFormatter;
    private final String lineDelimiter;
    private final int tabWidth;
    private final int indentWidth;
    private final NodeInfoStore placeholders;
    private final RewriteEventStore eventStore;
    private final Map<?, ?> options;
    private IDocument document;
    private PHPVersion phpVersion;
    private boolean useShortTags;
    public static final Prefix NONE;
    public static final Prefix SPACE;
    public static final Prefix ASSERT_COMMENT;
    public final BlockContext IF_BLOCK_WITH_ELSE = new BlockFormattingPrefixSuffix("if (true)", "else{}", 8);
    public final BlockContext IF_BLOCK_NO_ELSE = new BlockFormattingPrefix("if (true)", 8);
    public final BlockContext ELSE_AFTER_STATEMENT = new BlockFormattingPrefix("if (true) foo(); else ", 15);
    public final BlockContext ELSE_AFTER_BLOCK = new BlockFormattingPrefix("if (true) {} else ", 11);
    public final BlockContext FOR_BLOCK = new BlockFormattingPrefix("for (;;) ", 7);
    public final BlockContext WHILE_BLOCK = new BlockFormattingPrefix("while (true)", 11);
    public final BlockContext DO_BLOCK = new BlockFormattingPrefixSuffix("do ", "while (true);", 1);

    static {
        NONE = new ConstPrefix("");
        SPACE = new ConstPrefix(" ");
        ASSERT_COMMENT = new ConstPrefix(" : ");
    }

    public ASTRewriteFormatter(IDocument document, NodeInfoStore placeholders, RewriteEventStore eventStore, Map<?, ?> options, String lineDelimiter, PHPVersion version, boolean useShortTags) {
        this.document = document;
        this.placeholders = placeholders;
        this.eventStore = eventStore;
        if (options == null) {
            options = PHPCorePlugin.getOptions();
        }
        this.options = options;
        this.lineDelimiter = lineDelimiter;
        this.tabWidth = IndentManipulation.getTabWidth(options);
        this.indentWidth = IndentManipulation.getIndentWidth(options);
        this.phpVersion = version;
    }

    public NodeInfoStore getPlaceholders() {
        return this.placeholders;
    }

    public RewriteEventStore getEventStore() {
        return this.eventStore;
    }

    public int getTabWidth() {
        return this.tabWidth;
    }

    public int getIndentWidth() {
        return this.indentWidth;
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public String getFormattedResult(ASTNode node, int initialIndentationLevel, Collection<NodeMarker> resultingMarkers) {
        ExtendedFlattener flattener = new ExtendedFlattener(this.eventStore);
        node.accept(flattener);
        Position[] markers = flattener.getMarkers();
        int i = 0;
        while (i < markers.length) {
            resultingMarkers.add(markers[i]);
            ++i;
        }
        String unformatted = flattener.getResult();
        TextEdit edit = this.formatNode(node, unformatted, initialIndentationLevel);
        if (edit == null) {
            if (initialIndentationLevel > 0) {
                String indentString = this.createIndentString(initialIndentationLevel);
                ReplaceEdit[] edits = IndentManipulation.getChangeIndentEdits(unformatted, 0, this.tabWidth, this.indentWidth, indentString);
                edit = new MultiTextEdit();
                edit.addChild((TextEdit)new InsertEdit(0, indentString));
                edit.addChildren((TextEdit[])edits);
            } else {
                return unformatted;
            }
        }
        return ASTRewriteFormatter.evaluateFormatterEdit(unformatted, edit, markers);
    }

    public String createIndentString(int indentationUnits) {
        try {
            return this.createCodeFormatter(this.options, (IRegion)new Region(0, 0), this.document).createIndentationString(indentationUnits);
        }
        catch (Exception e) {
            Logger.logException(e);
            return "";
        }
    }

    public String getIndentString(String currentLine) {
        return IndentManipulation.extractIndentString(currentLine, this.tabWidth, this.indentWidth);
    }

    public String changeIndent(String code, int codeIndentLevel, String newIndent) {
        return IndentManipulation.changeIndent(code, codeIndentLevel, this.tabWidth, this.indentWidth, newIndent, this.lineDelimiter);
    }

    public int computeIndentUnits(String line) {
        return IndentManipulation.measureIndentUnits(line, this.tabWidth, this.indentWidth);
    }

    public static String evaluateFormatterEdit(String string, TextEdit edit, Position[] positions) {
        try {
            Document doc = ASTRewriteFormatter.createDocument(string, positions);
            edit.apply((IDocument)doc, 0);
            if (positions != null) {
                int i = 0;
                while (i < positions.length) {
                    Assert.isTrue((!positions[i].isDeleted ? 1 : 0) != 0, (String)"Position got deleted");
                    ++i;
                }
            }
            return doc.get();
        }
        catch (BadLocationException e) {
            Assert.isTrue((boolean)false, (String)("Fromatter created edits with wrong positions: " + e.getMessage()));
            return null;
        }
    }

    public TextEdit formatString(int kind, String string, int offset, int length, int indentationLevel) {
        try {
            ICodeFormattingProcessor codeFormatter = this.createCodeFormatter(this.options, (IRegion)new Region(offset, length), (IDocument)ASTRewriteFormatter.createDocument(string, null));
            return codeFormatter.getTextEdits();
        }
        catch (Exception e) {
            Logger.logException(e);
            return new MultiTextEdit();
        }
    }

    private ICodeFormattingProcessor createCodeFormatter(Map<?, ?> options, IRegion region, IDocument document) throws Exception {
        if (ASTRewriteFormatter.getContentFormatter() != null) {
            return contentFormatter.getCodeFormattingProcessor(document, this.phpVersion, this.useShortTags, region);
        }
        return new DefaultCodeFormattingProcessor(options);
    }

    private static IFormatterProcessorFactory getContentFormatter() {
        if (contentFormatter != null) {
            return contentFormatter;
        }
        String formatterExtensionName = "org.eclipse.php.ui.phpFormatterProcessor";
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(formatterExtensionName);
        int i = 0;
        while (i < elements.length) {
            final IConfigurationElement element = elements[i];
            if (element.getName().equals("processor")) {
                final Object[] elementObject = new Object[1];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        elementObject[0] = element.createExecutableExtension("class");
                    }

                    public void handleException(Throwable exception) {
                        Logger.logException(exception);
                    }
                });
                if (elementObject[0] instanceof IFormatterProcessorFactory) {
                    contentFormatter = (IFormatterProcessorFactory)elementObject[0];
                }
            }
            ++i;
        }
        return contentFormatter;
    }

    private TextEdit formatNode(ASTNode node, String str, int indentationLevel) {
        String indent = this.createIndentString(Math.max(0, indentationLevel - 1));
        String prefix = String.valueOf(indent) + "<?php ";
        String suffix = "";
        if (node instanceof Statement) {
            if (node.getType() == 55) {
                prefix = String.valueOf(prefix) + "switch(1) {";
                suffix = "}";
            }
            if (node instanceof MethodDeclaration) {
                prefix = String.valueOf(prefix) + "class x{";
                suffix = "}";
            }
        } else if (node instanceof Assignment) {
            prefix = "<?php\n";
            suffix = ";";
        } else if (node instanceof Expression && node.getType() != 63) {
            node.getClass();
        } else if (!(node instanceof BodyDeclaration)) {
            if (node instanceof Comment) {
                prefix = String.valueOf(prefix) + "class x{";
                suffix = "}";
            } else if (node.getType() == 9) {
                prefix = String.valueOf(prefix) + "try {}";
            }
        }
        String concatStr = String.valueOf(prefix) + str + suffix;
        TextEdit edit = this.formatString(0, concatStr, prefix.length(), str.length(), indentationLevel);
        if (prefix.length() > 0) {
            edit = ASTRewriteFormatter.shifEdit(edit, prefix.length(), prefix);
        }
        return edit;
    }

    private static TextEdit shifEdit(TextEdit oldEdit, int diff, String prefix) {
        Object newEdit;
        int editOffset;
        ReplaceEdit edit;
        if (oldEdit instanceof ReplaceEdit) {
            edit = (ReplaceEdit)oldEdit;
            editOffset = edit.getOffset();
            newEdit = editOffset >= diff ? new ReplaceEdit(editOffset - diff, edit.getLength(), edit.getText()) : ASTRewriteFormatter.getEndPrefixInsertion(edit.getText());
        } else if (oldEdit instanceof InsertEdit) {
            edit = (InsertEdit)oldEdit;
            editOffset = edit.getOffset();
            newEdit = editOffset >= diff ? new InsertEdit(editOffset - diff, edit.getText()) : new InsertEdit(0, edit.getText());
        } else if (oldEdit instanceof DeleteEdit) {
            edit = (DeleteEdit)oldEdit;
            editOffset = edit.getOffset();
            newEdit = editOffset >= diff ? new DeleteEdit(editOffset - diff, edit.getLength()) : new DeleteEdit(0, edit.getLength() - (diff - editOffset));
        } else if (oldEdit instanceof MultiTextEdit) {
            newEdit = new MultiTextEdit();
        } else {
            return null;
        }
        TextEdit[] children = oldEdit.getChildren();
        int i = 0;
        while (i < children.length) {
            TextEdit shifted = ASTRewriteFormatter.shifEdit(children[i], diff, prefix);
            if (shifted != null) {
                newEdit.addChild(shifted);
            }
            ++i;
        }
        return newEdit;
    }

    private static InsertEdit getEndPrefixInsertion(String newPrefix) {
        StringBuilder newPrefixEnding = new StringBuilder();
        char[] newPrefixArr = newPrefix.toCharArray();
        int i = newPrefixArr.length - 1;
        while (i >= 0) {
            char c = newPrefixArr[i];
            if (c != ' ' && c != '\r' && c != '\n' && c != '\t') break;
            newPrefixEnding.append(c);
            --i;
        }
        return new InsertEdit(0, newPrefixEnding.reverse().toString());
    }

    private static Document createDocument(String string, Position[] positions) throws IllegalArgumentException {
        Document doc;
        block5: {
            doc = new Document(string);
            try {
                if (positions == null) break block5;
                doc.addPositionCategory("myCategory");
                doc.addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater("myCategory"){

                    protected boolean notDeleted() {
                        int start = this.fOffset;
                        int end = start + this.fLength;
                        if (start < this.fPosition.offset && this.fPosition.offset + this.fPosition.length < end) {
                            this.fPosition.offset = end;
                            return false;
                        }
                        return true;
                    }
                });
                int i = 0;
                while (i < positions.length) {
                    try {
                        doc.addPosition("myCategory", positions[i]);
                    }
                    catch (BadLocationException badLocationException) {
                        throw new IllegalArgumentException("Position outside of string. offset: " + positions[i].offset + ", length: " + positions[i].length + ", string size: " + string.length());
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
        return doc;
    }

    public static interface BlockContext {
        public String[] getPrefixAndSuffix(int var1, ASTNode var2, RewriteEventStore var3);
    }

    private class BlockFormattingPrefix
    implements BlockContext {
        private String prefix;
        private int start;

        public BlockFormattingPrefix(String prefix, int start) {
            this.start = start;
            this.prefix = prefix;
        }

        @Override
        public String[] getPrefixAndSuffix(int indent, ASTNode node, RewriteEventStore events) {
            String nodeString = ASTRewriteFlattener.asString(node, events);
            String str = String.valueOf(this.prefix) + nodeString;
            Position pos = new Position(this.start, this.prefix.length() + 1 - this.start);
            return new String[]{str.substring(pos.offset + 1, pos.offset + pos.length - 1), ""};
        }
    }

    private class BlockFormattingPrefixSuffix
    implements BlockContext {
        private String prefix;
        private String suffix;
        private int start;

        public BlockFormattingPrefixSuffix(String prefix, String suffix, int start) {
            this.start = start;
            this.suffix = suffix;
            this.prefix = prefix;
        }

        @Override
        public String[] getPrefixAndSuffix(int indent, ASTNode node, RewriteEventStore events) {
            String nodeString = ASTRewriteFlattener.asString(node, events);
            int nodeStart = this.prefix.length();
            int nodeEnd = nodeStart + nodeString.length() - 1;
            String str = String.valueOf(this.prefix) + nodeString + this.suffix;
            Position pos1 = new Position(this.start, nodeStart + 1 - this.start);
            Position pos2 = new Position(nodeEnd, 2);
            return new String[]{str.substring(pos1.offset + 1, pos1.offset + pos1.length - 1), str.substring(pos2.offset + 1, pos2.offset + pos2.length - 1)};
        }
    }

    public static class ConstPrefix
    implements Prefix {
        private String prefix;

        public ConstPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public String getPrefix(int indent) {
            return this.prefix;
        }
    }

    private class ExtendedFlattener
    extends ASTRewriteFlattener {
        private ArrayList<NodeMarker> positions;

        public ExtendedFlattener(RewriteEventStore store) {
            super(store);
            this.positions = new ArrayList();
        }

        @Override
        public void preVisit(ASTNode node) {
            Object placeholderData;
            TextEditGroup trackData = ASTRewriteFormatter.this.getEventStore().getTrackedNodeData(node);
            if (trackData != null) {
                this.addMarker(trackData, this.result.length(), 0);
            }
            if ((placeholderData = ASTRewriteFormatter.this.getPlaceholders().getPlaceholderData(node)) != null) {
                this.addMarker(placeholderData, this.result.length(), 0);
            }
        }

        @Override
        public void postVisit(ASTNode node) {
            TextEditGroup trackData;
            Object placeholderData = ASTRewriteFormatter.this.getPlaceholders().getPlaceholderData(node);
            if (placeholderData != null) {
                this.fixupLength(placeholderData, this.result.length());
            }
            if ((trackData = ASTRewriteFormatter.this.getEventStore().getTrackedNodeData(node)) != null) {
                this.fixupLength(trackData, this.result.length());
            }
        }

        @Override
        public boolean visit(Block node) {
            if (ASTRewriteFormatter.this.getPlaceholders().isCollapsed(node)) {
                this.visitList(node, Block.STATEMENTS_PROPERTY, null);
                return false;
            }
            return super.visit(node);
        }

        private NodeMarker addMarker(Object annotation, int startOffset, int length) {
            NodeMarker marker = new NodeMarker();
            marker.offset = startOffset;
            marker.length = length;
            marker.data = annotation;
            this.positions.add(marker);
            return marker;
        }

        private void fixupLength(Object data, int endOffset) {
            int i = this.positions.size() - 1;
            while (i >= 0) {
                NodeMarker marker = this.positions.get(i);
                if (marker.data == data) {
                    marker.length = endOffset - marker.offset;
                    return;
                }
                --i;
            }
        }

        public NodeMarker[] getMarkers() {
            return this.positions.toArray(new NodeMarker[this.positions.size()]);
        }
    }

    public static class NodeMarker
    extends Position {
        public Object data;
    }

    public static interface Prefix {
        public String getPrefix(int var1);
    }
}

