/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.codeassist.contexts.NamespacePHPDocTagContext;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public abstract class NamespaceAbstractPHPDocTagStartContext
extends NamespacePHPDocTagContext {
    private IType[] namespaces;
    private boolean isGlobal;
    private IType[] possibleNamespaces;
    private IType currentNS;
    private String nsPrefix;

    @Override
    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        String tagName = this.getTagName();
        if (!this.getTags().contains(tagName)) {
            return false;
        }
        TextSequence statementText = this.getStatementText();
        String statementTextString = statementText.toString();
        StringTokenizer st = new StringTokenizer(statementTextString);
        Stack<String> stack = new Stack<String>();
        while (st.hasMoreElements()) {
            stack.add((String)st.nextElement());
        }
        if (!stack.empty()) {
            String lastWord = (String)stack.pop();
            String[] elements = lastWord.split("[|]");
            if (elements.length > 1) {
                lastWord = elements[elements.length - 1];
            }
            if (lastWord.indexOf(92) >= 0) {
                if (!stack.empty() && this.isPrefix(lastWord)) {
                    lastWord.startsWith("\\");
                    if (lastWord.startsWith("\\") && lastWord.lastIndexOf(92) == 0) {
                        this.isGlobal = true;
                    } else {
                        this.initRelativeNamespace(sourceModule, offset, lastWord);
                    }
                    lastWord = (String)stack.pop();
                    return lastWord.endsWith(tagName);
                }
            } else {
                this.initRelativeNamespace(sourceModule, offset, lastWord);
                lastWord = (String)stack.pop();
                return lastWord.endsWith(tagName);
            }
        }
        return false;
    }

    private void initRelativeNamespace(ISourceModule sourceModule, int offset, String lastWord) {
        String nsName = lastWord;
        String fullName = lastWord;
        this.nsPrefix = null;
        if (lastWord.lastIndexOf(92) > 0) {
            this.nsPrefix = lastWord.substring(0, lastWord.lastIndexOf(92));
            nsName = nsName.substring(0, nsName.lastIndexOf(92) + 1);
            try {
                this.namespaces = PHPModelUtils.getNamespaceOf(nsName, sourceModule, offset, null, null);
            }
            catch (ModelException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
        } else {
            this.namespaces = PhpModelAccess.NULL_TYPES;
        }
        if (lastWord.startsWith("\\")) {
            this.nsPrefix = null;
        } else {
            this.currentNS = null;
            try {
                IModelElement enclosingElement = this.getEnclosingElement();
                if (enclosingElement != null) {
                    IType type = (IType)enclosingElement.getAncestor(7);
                    if (type != null && type.getParent() instanceof IType) {
                        type = (IType)type.getParent();
                    }
                    if (type != null && PHPFlags.isNamespace(type.getFlags())) {
                        this.currentNS = type;
                        fullName = String.valueOf('\\') + this.currentNS.getElementName() + '\\' + lastWord;
                    }
                }
            }
            catch (ModelException e1) {
                e1.printStackTrace();
            }
            if (this.currentNS != null) {
                this.nsPrefix = this.nsPrefix == null ? this.currentNS.getElementName() : String.valueOf(this.currentNS.getElementName()) + '\\' + this.nsPrefix;
            }
        }
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
        if (fullName.startsWith("\\")) {
            fullName = fullName.substring(1);
        }
        this.possibleNamespaces = PhpModelAccess.getDefault().findNamespaces(null, fullName, ISearchEngine.MatchRule.PREFIX, 0, 0, scope, null);
        this.possibleNamespaces = CodeAssistUtils.removeDuplicatedElements((IModelElement[])this.possibleNamespaces).toArray(new IType[0]);
    }

    public IType[] getNamespaces() {
        return this.namespaces;
    }

    public IType[] getPossibleNamespaces() {
        return this.possibleNamespaces;
    }

    public IType getCurrentNS() {
        return this.currentNS;
    }

    public String getNsPrefix() {
        return this.nsPrefix;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    protected abstract List<String> getTags();

    private boolean isPrefix(String lastWord) {
        return this.getPrefixWithoutProcessing().endsWith(lastWord);
    }

    @Override
    public int getPrefixEnd() throws BadLocationException {
        IPhpScriptRegion phpScriptRegion;
        ITextRegion nextRegion;
        ITextRegion phpToken = this.getPHPToken();
        if (phpToken.getType() == "PHP_NS_SEPARATOR" && phpToken.getLength() == "\\".length() && (nextRegion = (phpScriptRegion = this.getPhpScriptRegion()).getPhpToken(phpToken.getEnd())).getType() == "PHP_LABEL") {
            return this.getRegionCollection().getStartOffset() + phpScriptRegion.getStart() + nextRegion.getTextEnd();
        }
        return super.getPrefixEnd();
    }
}

