/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.Collection;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalElementStrategy;
import org.eclipse.php.internal.core.language.keywords.PHPKeywords;

public abstract class KeywordsStrategy
extends GlobalElementStrategy {
    public KeywordsStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public KeywordsStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        AbstractCompletionContext concreteContext = (AbstractCompletionContext)context;
        ISourceModule sourceModule = concreteContext.getSourceModule();
        String prefix = concreteContext.getPrefix();
        ISourceRange replaceRange = this.getReplacementRange(concreteContext);
        boolean whithoutSpace = this.isInsertMode() && concreteContext.hasSpaceAtPosition(concreteContext.getOffset());
        boolean withoutSemicolon = concreteContext.getNextWord().trim().equals(";");
        Collection<PHPKeywords.KeywordData> keywordsList = PHPKeywords.getInstance(sourceModule.getScriptProject().getProject()).findByPrefix(prefix);
        for (PHPKeywords.KeywordData keyword : keywordsList) {
            if (this.filterKeyword(keyword)) continue;
            String suffix = keyword.suffix;
            if (whithoutSpace && suffix.endsWith(" ")) {
                suffix = suffix.substring(0, suffix.length() - 1);
            } else if (withoutSemicolon && suffix.endsWith(";")) {
                suffix = suffix.substring(0, suffix.length() - 1);
            }
            reporter.reportKeyword(keyword.name, suffix, replaceRange);
        }
    }

    @Override
    public ISourceRange getReplacementRange(ICompletionContext context) throws BadLocationException {
        if (!this.isInsertMode()) {
            return this.getReplacementRangeWithSpaceAtPrefixEnd(context);
        }
        return super.getReplacementRange(context);
    }

    protected abstract boolean filterKeyword(PHPKeywords.KeywordData var1);
}

