/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.search;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassName;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FullyQualifiedTraitMethodReference;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.TraitAliasStatement;
import org.eclipse.php.internal.core.ast.nodes.TraitDeclaration;
import org.eclipse.php.internal.core.ast.nodes.TraitPrecedenceStatement;
import org.eclipse.php.internal.core.ast.nodes.TraitUseStatement;
import org.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org.eclipse.php.internal.core.search.AbstractOccurrencesFinder;
import org.eclipse.php.internal.core.search.IOccurrencesFinder;
import org.eclipse.php.internal.core.search.Messages;

public class TraitNameOccurrencesFinder
extends AbstractOccurrencesFinder {
    private static final String SELF = "self";
    public static final String ID = "TraitNameOccurrencesFinder";
    private String className;
    private TraitDeclaration originalDeclarationNode;
    private Identifier nameNode;
    private Map<Identifier, String> nodeToFullName = new HashMap<Identifier, String>();

    @Override
    public String initialize(Program root, ASTNode node) {
        this.fASTRoot = root;
        if (node instanceof Identifier) {
            ASTNode parent;
            this.nameNode = this.getIdentifierForSelf((Identifier)node);
            this.className = this.nameNode.getName();
            if (this.nameNode.getParent() instanceof NamespaceName) {
                this.nameNode = (NamespaceName)this.nameNode.getParent();
            }
            if ((parent = node.getParent()) instanceof TraitDeclaration) {
                this.originalDeclarationNode = (TraitDeclaration)parent;
            }
            return null;
        }
        this.fDescription = "OccurrencesFinder_occurrence_description";
        return this.fDescription;
    }

    @Override
    protected void findOccurrences() {
        this.fDescription = Messages.format(BASE_DESCRIPTION, this.className);
        this.fASTRoot.accept(this);
        if (this.nodeToFullName.containsKey(this.nameNode)) {
            String fullName = this.nodeToFullName.get(this.nameNode);
            for (Identifier nameNode : this.nodeToFullName.keySet()) {
                if (!this.nodeToFullName.get(nameNode).equals(fullName)) continue;
                this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(nameNode.getStart(), nameNode.getLength(), this.getOccurrenceType(nameNode), this.fDescription));
            }
        }
    }

    @Override
    public boolean visit(StaticConstantAccess staticDispatch) {
        Expression className = staticDispatch.getClassName();
        if (className instanceof Identifier) {
            this.dealIdentifier((Identifier)className);
        }
        return false;
    }

    @Override
    public boolean visit(StaticFieldAccess staticDispatch) {
        Expression className = staticDispatch.getClassName();
        if (className instanceof Identifier) {
            this.dealIdentifier((Identifier)className);
        }
        return false;
    }

    @Override
    public boolean visit(StaticMethodInvocation staticDispatch) {
        Expression className = staticDispatch.getClassName();
        if (className instanceof Identifier) {
            this.dealIdentifier((Identifier)className);
        }
        return true;
    }

    @Override
    public boolean visit(ClassName className) {
        if (className.getName() instanceof Identifier) {
            Identifier identifier = (Identifier)className.getName();
            this.dealIdentifier(identifier);
        }
        return false;
    }

    @Override
    public boolean visit(TraitDeclaration traitDeclaration) {
        if (this.originalDeclarationNode == null || this.originalDeclarationNode == traitDeclaration) {
            this.dealIdentifier(traitDeclaration.getName());
        }
        return true;
    }

    @Override
    public boolean visit(TraitUseStatement part) {
        for (NamespaceName namespace : part.getTraitList()) {
            if (!(namespace instanceof Identifier)) continue;
            this.dealIdentifier(namespace);
        }
        return true;
    }

    @Override
    public boolean visit(TraitPrecedenceStatement tps) {
        if (tps.getPrecedence().getMethodReference().getClassName() instanceof Identifier) {
            this.dealIdentifier(tps.getPrecedence().getMethodReference().getClassName());
        }
        for (NamespaceName namespace : tps.getPrecedence().getTrList()) {
            if (!(namespace instanceof Identifier)) continue;
            this.dealIdentifier(namespace);
        }
        return false;
    }

    @Override
    public boolean visit(TraitAliasStatement tas) {
        FullyQualifiedTraitMethodReference reference;
        int type = tas.getAlias().getTraitMethod().getType();
        if (type == 73 && (reference = (FullyQualifiedTraitMethodReference)tas.getAlias().getTraitMethod()).getClassName() != null) {
            this.dealIdentifier(reference.getClassName());
        }
        return false;
    }

    private void dealIdentifier(Identifier identifier) {
        Identifier newIdentifier = this.getIdentifierForSelf(identifier);
        String fullName = TraitNameOccurrencesFinder.getFullName(newIdentifier, (Map<String, UseStatementPart>)this.fLastUseParts, this.fCurrentNamespace);
        this.nodeToFullName.put(identifier, fullName);
    }

    private Identifier getIdentifierForSelf(Identifier identifier) {
        Identifier newIdentifier = identifier;
        if (SELF.equals(identifier.getName())) {
            ClassDeclaration cd;
            ASTNode parent = identifier.getParent();
            while (parent != null && !(parent instanceof ClassDeclaration)) {
                parent = parent.getParent();
            }
            if (parent != null && (cd = (ClassDeclaration)parent).getName() != null) {
                newIdentifier = cd.getName();
            }
        }
        return newIdentifier;
    }

    private boolean checkForNameEquality(Identifier identifier) {
        return identifier != null && this.className != null && this.className.equalsIgnoreCase(identifier.getName());
    }

    @Override
    protected int getOccurrenceType(ASTNode node) {
        return 2;
    }

    @Override
    public String getElementName() {
        return this.className;
    }

    @Override
    public String getID() {
        return ID;
    }
}

