/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.context.MethodContext;
import org.eclipse.php.internal.core.typeinference.evaluators.PHPEvaluationUtils;

public class FormalParameterEvaluator
extends GoalEvaluator {
    public static final String ELLIPSIS = "...";
    private IEvaluatedType result;

    public FormalParameterEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        ExpressionTypeGoal typedGoal = (ExpressionTypeGoal)this.goal;
        FormalParameter parameter = (FormalParameter)typedGoal.getExpression();
        SimpleReference type = parameter.getParameterType();
        IContext context = typedGoal.getContext();
        if (type != null && !"array".equals(type.getName())) {
            if (context instanceof MethodContext) {
                FullyQualifiedReference fqn;
                MethodContext methodContext = (MethodContext)context;
                String typeName = type.getName();
                String namespace = null;
                if (type instanceof FullyQualifiedReference && (fqn = (FullyQualifiedReference)type).getNamespace() != null) {
                    namespace = fqn.getNamespace().getName();
                }
                if (namespace == null) {
                    String fullName = PHPModelUtils.getFullName(typeName, methodContext.getSourceModule(), parameter.start());
                    typeName = PHPModelUtils.extractElementName(fullName);
                    namespace = PHPModelUtils.extractNameSpaceName(fullName);
                }
                this.result = namespace != null ? new PHPClassType(namespace, typeName) : new PHPClassType(typeName);
                if (parameter.isVariadic()) {
                    MultiTypeType multiType = new MultiTypeType();
                    multiType.addType(this.result);
                    this.result = multiType;
                }
            } else {
                this.result = PHPClassType.fromSimpleReference(type);
            }
        } else if (context instanceof MethodContext) {
            MethodContext methodContext = (MethodContext)context;
            PHPMethodDeclaration methodDeclaration = (PHPMethodDeclaration)methodContext.getMethodNode();
            ISourceModule sourceModule = methodContext.getSourceModule();
            PHPDocBlock[] docBlocks = new PHPDocBlock[]{};
            try {
                IMethod method;
                IModelElement element = sourceModule.getElementAt(methodDeclaration.getNameStart());
                docBlocks = element instanceof IMethod ? ((method = (IMethod)element).getDeclaringType() != null ? PHPModelUtils.getTypeHierarchyMethodDoc(method.getDeclaringType(), methodContext.getCache() != null ? methodContext.getCache().getSuperTypeHierarchy(method.getDeclaringType(), null) : null, method.getElementName(), true, null) : new PHPDocBlock[]{methodDeclaration.getPHPDoc()}) : new PHPDocBlock[]{methodDeclaration.getPHPDoc()};
            }
            catch (CoreException coreException) {}
            PHPDocBlock[] pHPDocBlockArray = docBlocks;
            int n = docBlocks.length;
            int n2 = 0;
            while (n2 < n) {
                PHPDocBlock docBlock = pHPDocBlockArray[n2];
                if (this.result != null) break;
                if (docBlock != null) {
                    PHPDocTag[] pHPDocTagArray = docBlock.getTags(PHPDocTag.TagKind.PARAM);
                    int n3 = pHPDocTagArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        PHPDocTag tag = pHPDocTagArray[n4];
                        if (tag.isValidParamTag()) {
                            String parameterName = parameter.getName();
                            if (parameter.isVariadic()) {
                                parameterName = ELLIPSIS + parameterName;
                            }
                            if (tag.getVariableReference().getName().equals(parameterName)) {
                                MultiTypeType multiType = new MultiTypeType();
                                for (TypeReference paramType : tag.getTypeReferences()) {
                                    String typeName = paramType.getName();
                                    typeName = PHPEvaluationUtils.extractArrayType(typeName);
                                    multiType.addType((IEvaluatedType)PHPClassType.fromTypeName(typeName, sourceModule, paramType.sourceStart()));
                                }
                                if (multiType.size() == 1) {
                                    this.result = multiType.get(0);
                                    break;
                                }
                                if (multiType.size() <= 1) break;
                                this.result = multiType;
                                break;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            if (this.result == null && parameter.getInitialization() instanceof Scalar) {
                Scalar scalar = (Scalar)parameter.getInitialization();
                this.result = PHPSimpleTypes.fromString(scalar.getType());
                if (this.result == null) {
                    this.result = new PHPClassType(scalar.getType());
                }
            }
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return this.result;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        return IGoal.NO_GOALS;
    }
}

