/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util.text;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.documentModel.parser.AbstractPhpLexer;
import org.eclipse.php.internal.core.documentModel.parser.PhpLexerFactory;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.php.internal.core.util.text.TextSequenceUtilities;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class PHPTextSequenceUtilities {
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("function[ \\t\\n\\r]", 2);
    private static final Pattern CLASS_PATTERN = Pattern.compile("(class|interface)[ \\t\\n\\r]", 2);
    private static final String LBRACE = "{";
    private static final String RBRACE = "}";
    private static final String LPAREN = "(";
    private static final String RPAREN = ")";
    private static final String COMMA = ",";
    private static final String LBRACKET = "[";
    private static final String RBRACKET = "]";
    private static final String OBJECT_OPERATOR = "->";
    private static final String PAAMAYIM_NEKUDOTAYIM = "::";

    private PHPTextSequenceUtilities() {
    }

    @NonNull
    public static TextSequence getStatement(int offset, @NonNull IStructuredDocumentRegion sdRegion, boolean removeComments) {
        int documentOffset = offset;
        if (documentOffset == sdRegion.getEndOffset()) {
            --documentOffset;
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(documentOffset);
        IStructuredDocumentRegion container = sdRegion;
        if (tRegion instanceof ITextRegionContainer) {
            container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
        }
        if (tRegion != null && tRegion.getType() == "PHP_CLOSE") {
            tRegion = container.getRegionAtCharacterOffset(container.getStartOffset() + tRegion.getStart() - 1);
        }
        if (tRegion != null && tRegion.getType() == "PHP_CONTENT") {
            IPhpScriptRegion phpScriptRegion = (IPhpScriptRegion)tRegion;
            try {
                int startOffset = container.getStartOffset() + phpScriptRegion.getStart();
                ITextRegion startTokenRegion = documentOffset == startOffset ? phpScriptRegion.getPhpToken(0) : phpScriptRegion.getPhpToken(offset - startOffset - 1);
                ArrayList<IRegion> comments = new ArrayList<IRegion>();
                while (startTokenRegion.getStart() != 0) {
                    String type = startTokenRegion.getType();
                    if (removeComments && PHPPartitionTypes.isPHPCommentState(type)) {
                        comments.add((IRegion)new Region(phpScriptRegion.getStart() + startTokenRegion.getStart(), startTokenRegion.getLength()));
                    }
                    if (type == "PHP_CURLY_CLOSE" || type == "PHP_CURLY_OPEN" || type == "PHP_SEMICOLON") {
                        startOffset += startTokenRegion.getEnd();
                        break;
                    }
                    startTokenRegion = phpScriptRegion.getPhpToken(startTokenRegion.getStart() - 1);
                }
                TextSequence textSequence = TextSequenceUtilities.createTextSequence(sdRegion, startOffset, offset - startOffset);
                if (removeComments) {
                    textSequence = PHPTextSequenceUtilities.removeComments(textSequence, comments);
                }
                return textSequence.subTextSequence(PHPTextSequenceUtilities.readForwardSpaces(textSequence, 0), textSequence.length());
            }
            catch (BadLocationException badLocationException) {}
        }
        return TextSequenceUtilities.createTextSequence(sdRegion, 0, 0);
    }

    @NonNull
    public static Region getStatementRegion(int offset, @NonNull IStructuredDocumentRegion sdRegion, boolean ignoreStartComments) {
        TextSequence textSequence = PHPTextSequenceUtilities.getStatement(offset, sdRegion, ignoreStartComments);
        return new Region(textSequence.getOriginalOffset(0), textSequence.length());
    }

    @NonNull
    private static TextSequence removeComments(@NonNull TextSequence textSequence, List<IRegion> comments) {
        int seqStart = textSequence.getOriginalOffset(0);
        for (IRegion commentStartRegion : comments) {
            int start;
            int end;
            int textSequenceLength = textSequence.length();
            if (textSequenceLength == 0 || (end = (start = commentStartRegion.getOffset() - seqStart) + commentStartRegion.getLength()) <= 0) break;
            if (start >= textSequenceLength) continue;
            start = Math.max(0, start);
            end = Math.min(textSequenceLength, end);
            textSequence = textSequence.cutTextSequence(start, end);
        }
        return textSequence;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static int getMethodEndIndex(@NonNull CharSequence textSequence, int offset, boolean allowToStartWithWhitespaces) {
        int length = textSequence.length();
        if (allowToStartWithWhitespaces) {
            while (offset < length && Character.isWhitespace(textSequence.charAt(offset))) {
                ++offset;
            }
        }
        if (offset >= length) return -1;
        if (textSequence.charAt(offset) != '(') return -1;
        ++offset;
        while (offset < length && textSequence.charAt(offset) != ')') {
            ++offset;
        }
        if (textSequence.length() <= offset) return -1;
        if (textSequence.charAt(offset) != ')') return -1;
        return offset + 1;
    }

    public static int isInFunctionDeclaration(@NonNull TextSequence textSequence) {
        Matcher matcher = FUNCTION_PATTERN.matcher(textSequence);
        while (matcher.find()) {
            String type;
            int functionStart = matcher.start();
            if (functionStart != 0 && Character.isJavaIdentifierStart(textSequence.charAt(functionStart - 1)) || !PHPPartitionTypes.isPHPRegularState(type = TextSequenceUtilities.getType(textSequence, functionStart + 1))) continue;
            boolean possibleReturnType = false;
            boolean returnType = false;
            int offset = matcher.end();
            while (offset < textSequence.length()) {
                if (textSequence.charAt(offset) == ')') {
                    type = TextSequenceUtilities.getType(textSequence, offset);
                    if (PHPPartitionTypes.isPHPRegularState(type)) {
                        possibleReturnType = true;
                    }
                } else {
                    if ((possibleReturnType || returnType) && textSequence.charAt(offset) == '{') break;
                    if (possibleReturnType && textSequence.charAt(offset) == ':') {
                        possibleReturnType = false;
                        returnType = true;
                    } else if (possibleReturnType && !Character.isWhitespace(textSequence.charAt(offset))) break;
                }
                ++offset;
            }
            if (offset != textSequence.length()) continue;
            return functionStart;
        }
        return -1;
    }

    private static boolean isClassOrInterfaceKeyword(@NonNull TextSequence textSequence, int classStartOffset) {
        if (classStartOffset == 0) {
            return true;
        }
        int offset = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, classStartOffset);
        if (offset == 0) {
            return true;
        }
        if (offset == classStartOffset && Character.isJavaIdentifierStart(textSequence.charAt(offset - 1))) {
            return false;
        }
        assert (OBJECT_OPERATOR.length() == 2 && PAAMAYIM_NEKUDOTAYIM.length() == 2);
        if (offset < 2) {
            return true;
        }
        String s = textSequence.subSequence(offset - 2, offset).toString();
        return !OBJECT_OPERATOR.equals(s) && !PAAMAYIM_NEKUDOTAYIM.equals(s);
    }

    public static int isInClassDeclaration(@NonNull TextSequence textSequence) {
        Matcher matcher = CLASS_PATTERN.matcher(textSequence);
        while (matcher.find()) {
            int endOffset;
            String type;
            int startOffset = matcher.start();
            if (!PHPTextSequenceUtilities.isClassOrInterfaceKeyword(textSequence, startOffset) || !PHPPartitionTypes.isPHPRegularState(type = TextSequenceUtilities.getType(textSequence, startOffset + 1))) continue;
            int offset = endOffset = matcher.end();
            while (offset < textSequence.length()) {
                if (textSequence.charAt(offset) == '}' && PHPPartitionTypes.isPHPRegularState(type = TextSequenceUtilities.getType(textSequence, offset))) break;
                ++offset;
            }
            if (offset != textSequence.length()) continue;
            return endOffset;
        }
        return -1;
    }

    public static int readNamespaceStartIndex(@NonNull CharSequence textSequence, int startPosition, boolean includeDollar) {
        boolean onBackslash = false;
        boolean onWhitespace = false;
        int oldStartPosition = startPosition;
        startPosition = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, startPosition);
        while (startPosition > 0) {
            char ch = textSequence.charAt(startPosition - 1);
            if (!Character.isLetterOrDigit(ch) && ch != '_') {
                if (ch == '\\') {
                    if (onBackslash) break;
                    onBackslash = true;
                    onWhitespace = false;
                } else {
                    if (!Character.isWhitespace(ch)) break;
                    onWhitespace = true;
                    onBackslash = false;
                }
            } else {
                if (onWhitespace) break;
                onBackslash = false;
                onWhitespace = false;
            }
            --startPosition;
        }
        if (includeDollar && startPosition > 0 && textSequence.charAt(startPosition - 1) == '$') {
            --startPosition;
        }
        int n = startPosition = startPosition >= 0 ? PHPTextSequenceUtilities.readForwardSpaces(textSequence, startPosition) : startPosition;
        if (startPosition > oldStartPosition) {
            startPosition = oldStartPosition;
        }
        return startPosition;
    }

    public static int readNamespaceEndIndex(@NonNull CharSequence textSequence, int startPosition, boolean includeDollar) {
        boolean onBackslash = false;
        boolean onWhitespace = false;
        int length = textSequence.length();
        if (includeDollar && startPosition < length && textSequence.charAt(startPosition) == '$') {
            ++startPosition;
        }
        while (startPosition < length) {
            char ch = textSequence.charAt(startPosition);
            if (!Character.isLetterOrDigit(ch) && ch != '_') {
                if (ch == '\\') {
                    if (onBackslash) break;
                    onBackslash = true;
                    onWhitespace = false;
                } else {
                    if (!Character.isWhitespace(ch)) break;
                    onWhitespace = true;
                    onBackslash = false;
                }
            } else {
                if (onWhitespace) break;
                onBackslash = false;
                onWhitespace = false;
            }
            ++startPosition;
        }
        return startPosition >= 0 ? PHPTextSequenceUtilities.readBackwardSpaces(textSequence, startPosition) : startPosition;
    }

    public static int readIdentifierStartIndex(@NonNull CharSequence textSequence, int startPosition, boolean includeDollar) {
        while (startPosition > 0) {
            char ch = textSequence.charAt(startPosition - 1);
            if (!Character.isLetterOrDigit(ch) && ch != '_') break;
            --startPosition;
        }
        if (includeDollar && startPosition > 0 && textSequence.charAt(startPosition - 1) == '$') {
            --startPosition;
        }
        return startPosition;
    }

    public static int readIdentifierEndIndex(@NonNull CharSequence textSequence, int startPosition, boolean includeDollar) {
        int length = textSequence.length();
        if (includeDollar && startPosition < length && textSequence.charAt(startPosition) == '$') {
            ++startPosition;
        }
        while (startPosition < length) {
            char ch = textSequence.charAt(startPosition);
            if (!Character.isLetterOrDigit(ch) && ch != '_') break;
            ++startPosition;
        }
        return startPosition;
    }

    public static int readIdentifierStartIndex(@NonNull PHPVersion phpVersion, @NonNull CharSequence textSequence, int startPosition, boolean includeDollar) {
        if (phpVersion.isLessThan(PHPVersion.PHP5_3)) {
            return PHPTextSequenceUtilities.readIdentifierStartIndex(textSequence, startPosition, includeDollar);
        }
        return PHPTextSequenceUtilities.readNamespaceStartIndex(textSequence, startPosition, includeDollar);
    }

    public static int readIdentifierEndIndex(@NonNull PHPVersion phpVersion, @NonNull CharSequence textSequence, int startPosition, boolean includeDollar) {
        if (phpVersion.isLessThan(PHPVersion.PHP5_3)) {
            return PHPTextSequenceUtilities.readIdentifierEndIndex(textSequence, startPosition, includeDollar);
        }
        return PHPTextSequenceUtilities.readNamespaceEndIndex(textSequence, startPosition, includeDollar);
    }

    @Nullable
    public static ISourceRange getEnclosingIdentifier(@NonNull CharSequence textSequence, int pos) {
        if (pos < 0 || pos >= textSequence.length()) {
            return null;
        }
        int start = PHPTextSequenceUtilities.readIdentifierStartIndex(textSequence, pos, true);
        int end = PHPTextSequenceUtilities.readIdentifierEndIndex(textSequence, pos, true);
        if (start < 0 || start > end) {
            return null;
        }
        return new SourceRange(start, end - start + 1);
    }

    public static int readBackwardSpaces(@NonNull CharSequence textSequence, int startPosition) {
        int rv = startPosition;
        while (rv > 0) {
            if (!Character.isWhitespace(textSequence.charAt(rv - 1))) break;
            --rv;
        }
        return rv;
    }

    public static int readForwardSpaces(@NonNull IDocument document, int startPosition, int endPosition) throws BadLocationException {
        int rv = startPosition;
        while (rv < endPosition) {
            if (!Character.isWhitespace(document.getChar(rv))) break;
            ++rv;
        }
        return rv;
    }

    public static int readForwardSpaces(@NonNull CharSequence textSequence, int startPosition) {
        int rv = startPosition;
        while (rv < textSequence.length()) {
            if (!Character.isWhitespace(textSequence.charAt(rv))) break;
            ++rv;
        }
        return rv;
    }

    public static int readForwardUntilSpaces(@NonNull CharSequence textSequence, int startPosition) {
        int rv = startPosition;
        while (rv < textSequence.length()) {
            if (Character.isWhitespace(textSequence.charAt(rv))) break;
            ++rv;
        }
        return rv;
    }

    public static int readForwardUntilDelim(@NonNull CharSequence textSequence, int startPosition, @NonNull char[] delims) {
        int rv = startPosition;
        while (rv < textSequence.length()) {
            char c = textSequence.charAt(rv);
            if (PHPTextSequenceUtilities.isDelimiter(c, delims)) break;
            ++rv;
        }
        return rv;
    }

    private static boolean isDelimiter(char c, @NonNull char[] delims) {
        char[] cArray = delims;
        int n = delims.length;
        int n2 = 0;
        while (n2 < n) {
            char curr = cArray[n2];
            if (curr == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Deprecated
    public static int getPrivousTriggerIndex(@NonNull CharSequence textSequence, int startPosition) {
        return PHPTextSequenceUtilities.getPreviousTriggerIndex(textSequence, startPosition);
    }

    public static int getPreviousTriggerIndex(@NonNull CharSequence textSequence, int startPosition) {
        int rv = startPosition;
        int bracketsNum = 0;
        char inStringMode = '\u0000';
        boolean inWhiteSpaceBeforeLiteral = false;
        boolean inLiteral = false;
        while (rv > 0) {
            char currChar = textSequence.charAt(rv - 1);
            if (currChar == '\'' || currChar == '\"') {
                char c = inStringMode == '\u0000' ? currChar : (inStringMode = inStringMode == currChar ? (char)'\u0000' : inStringMode);
            }
            if (inStringMode == '\u0000') {
                if (Character.isLetterOrDigit(currChar) || currChar == '$') {
                    if (inWhiteSpaceBeforeLiteral && bracketsNum == 0) {
                        return -1;
                    }
                    inLiteral = true;
                } else {
                    if (inLiteral && Character.isWhitespace(currChar)) {
                        inWhiteSpaceBeforeLiteral = true;
                    }
                    if (!Character.isWhitespace(currChar)) {
                        inWhiteSpaceBeforeLiteral = false;
                    }
                    inLiteral = false;
                }
                if (!Character.isLetterOrDigit(currChar) && currChar != '_' && currChar != '$' && !Character.isWhitespace(currChar)) {
                    switch (currChar) {
                        case '(': 
                        case '[': 
                        case '{': {
                            if (--bracketsNum >= 0) break;
                            return -1;
                        }
                        case ')': 
                        case ']': 
                        case '}': {
                            ++bracketsNum;
                            break;
                        }
                        case ':': {
                            if (bracketsNum != 0 || rv < 2) break;
                            if (textSequence.charAt(rv - 2) == ':') {
                                return rv - 2;
                            }
                            return -1;
                        }
                        case '>': {
                            if (bracketsNum != 0 || rv < 2) break;
                            if (textSequence.charAt(rv - 2) == '-') {
                                return rv - 2;
                            }
                            return -1;
                        }
                        default: {
                            if (bracketsNum != 0) break;
                            return -1;
                        }
                    }
                }
            }
            --rv;
        }
        return -1;
    }

    public static int readIdentifierListStartIndex(@NonNull CharSequence textSequence, int endPosition) {
        int startPosition;
        int listStartPosition = startPosition = endPosition;
        boolean beforeWhitespace = false;
        boolean beforeComma = false;
        while (startPosition > 0) {
            char ch = textSequence.charAt(startPosition - 1);
            if (Character.isLetterOrDigit(ch) || ch == '_') {
                if (beforeWhitespace) {
                    return --listStartPosition;
                }
                listStartPosition = startPosition;
                beforeComma = false;
            } else if (ch == ',') {
                if (beforeComma) {
                    return endPosition;
                }
                beforeComma = true;
                beforeWhitespace = false;
            } else if (Character.isWhitespace(ch) && !beforeComma) {
                beforeWhitespace = true;
            } else {
                return --listStartPosition;
            }
            --startPosition;
        }
        return listStartPosition;
    }

    @NonNull
    public static String[] getArgNames(@Nullable PHPVersion phpVersion, @Nullable CharSequence textSequence) {
        ArrayList<String> args = new ArrayList<String>();
        if (textSequence != null && textSequence.length() > 2) {
            if (textSequence.charAt(textSequence.length() - 1) == ')') {
                textSequence = textSequence.subSequence(0, textSequence.length() - 1);
            }
            if (textSequence != null && textSequence.charAt(0) == '(') {
                textSequence = textSequence.subSequence(1, textSequence.length());
            }
            if (textSequence == null) {
                return args.toArray(new String[args.size()]);
            }
            if (phpVersion == null) {
                phpVersion = PHPVersion.getLatestVersion();
            }
            AbstractPhpLexer lexer = PhpLexerFactory.createLexer(new StringReader(textSequence.toString()), phpVersion);
            lexer.initialize(lexer.getScriptingState());
            String symbol = null;
            int level = 0;
            int argIndex = 0;
            do {
                try {
                    symbol = lexer.getNextToken();
                    if (symbol == null) continue;
                    CharSequence text = textSequence.subSequence(lexer.getTokenStart(), lexer.getTokenStart() + lexer.getLength());
                    if (symbol.equals("PHP_TOKEN")) {
                        if (text.equals(LPAREN) || text.equals(LBRACE) || text.equals(LBRACKET)) {
                            ++level;
                            continue;
                        }
                        if (text.equals(RPAREN) || text.equals(RBRACE) || text.equals(RBRACKET)) {
                            --level;
                            continue;
                        }
                        if (level != 0 || !text.equals(COMMA)) continue;
                        ++argIndex;
                        continue;
                    }
                    if (level == 0 && symbol.equals("PHP_CONSTANT_ENCAPSED_STRING")) {
                        if (args.size() >= argIndex + 1) continue;
                        args.add(text.toString());
                        continue;
                    }
                    if (level != 0 || symbol.equals("WHITESPACE")) continue;
                    if (args.size() < argIndex + 1) {
                        args.add(null);
                        continue;
                    }
                    args.set(argIndex, null);
                }
                catch (IOException iOException) {
                    symbol = null;
                }
            } while (symbol != null);
        }
        return args.toArray(new String[args.size()]);
    }

    @Nullable
    public static String suggestObjectOperator(@NonNull CharSequence statement) {
        String insert = null;
        int statementPosition = (statement = statement.toString().trim()).length() - 1;
        if (statementPosition < 0) {
            return null;
        }
        char charAt = statement.charAt(statementPosition);
        if (charAt == '>') {
            return null;
        }
        if (charAt == '-') {
            insert = String.valueOf('>');
        } else if (charAt == ':') {
            if (statementPosition > 0 && statement.charAt(statementPosition - 1) == ':') {
                return null;
            }
            insert = String.valueOf(':');
        } else {
            statementPosition = PHPTextSequenceUtilities.readBackwardSpaces(statement, statementPosition);
            switch (statement.charAt(statementPosition)) {
                case ')': 
                case ']': 
                case '}': {
                    insert = OBJECT_OPERATOR;
                    break;
                }
                case ':': 
                case '>': {
                    return null;
                }
                default: {
                    int identStart = PHPTextSequenceUtilities.readIdentifierStartIndex(statement, statementPosition, true);
                    if (identStart < 0) {
                        return null;
                    }
                    insert = statement.charAt(identStart) == '$' || statement.charAt(identStart) == '}' ? OBJECT_OPERATOR : ((identStart = PHPTextSequenceUtilities.readBackwardSpaces(statement, identStart - 1)) > 1 && statement.charAt(identStart) == '>' && statement.charAt(identStart - 1) == '-' ? OBJECT_OPERATOR : PAAMAYIM_NEKUDOTAYIM);
                }
            }
        }
        return insert;
    }
}

