/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPToolkitUtil;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.php.internal.core.preferences.TaskTagsProvider;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.tasks.TaskTag;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.xml.core.internal.parser.ContextRegionContainer;

@Deprecated
public class PHPTodoTaskValidator
extends AbstractValidator {
    protected TaskTag[] taskTags = null;

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1 || !PHPToolkitUtil.isPhpFile((IFile)resource)) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IReporter reporter = result.getReporter(monitor);
        this.validateFile(reporter, (IFile)resource, kind);
        return result;
    }

    public void validateFile(IReporter reporter, IFile file, int kind) {
        if (this.taskTags == null || kind == 0) {
            this.populateTaskTags(file);
        }
        try {
            file.deleteMarkers("org.eclipse.php.core.phpTaskMarker", false, 2);
        }
        catch (CoreException coreException) {}
        IStructuredModel model = null;
        try {
            try {
                model = StructuredModelManager.getModelManager().getExistingModelForRead(file);
            }
            catch (Exception exception) {
                try {
                    model = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(file);
                }
                catch (Exception exception2) {}
            }
            if (model == null) {
                return;
            }
            try {
                IStructuredDocumentRegion[] sdRegions;
                IStructuredDocumentRegion[] iStructuredDocumentRegionArray = sdRegions = model.getStructuredDocument().getStructuredDocumentRegions();
                int n = sdRegions.length;
                int n2 = 0;
                while (n2 < n) {
                    IStructuredDocumentRegion structuredDocumentRegion = iStructuredDocumentRegionArray[n2];
                    IStructuredDocument document = structuredDocumentRegion.getParentDocument();
                    ITextRegionList textRegions = structuredDocumentRegion.getRegions();
                    int i = 0;
                    while (i < textRegions.size()) {
                        ITextRegion textRegion = textRegions.get(i);
                        int regionStart = structuredDocumentRegion.getStartOffset(textRegion);
                        if (textRegion instanceof ContextRegionContainer) {
                            textRegion = this.extractPhpScriptRegion(textRegion);
                            regionStart += textRegion.getStart();
                        }
                        if (textRegion instanceof PhpScriptRegion) {
                            PhpScriptRegion scriptRegion = (PhpScriptRegion)textRegion;
                            try {
                                ITextRegion[] phpTokens = scriptRegion.getPhpTokens(0, textRegion.getLength());
                                int j = 0;
                                while (j < phpTokens.length) {
                                    ITextRegion phpToken = phpTokens[j];
                                    if ("PHPDOC_TODO".equals(phpToken.getType())) {
                                        int offset = regionStart + phpToken.getStart();
                                        int length = phpToken.getLength();
                                        String taskKeyword = document.get(offset, phpToken.getLength());
                                        int priority = this.getTaskPriority(taskKeyword);
                                        if (j + 1 < phpTokens.length) {
                                            int k = j + 1;
                                            while (k < phpTokens.length) {
                                                ITextRegion phpNextToken = phpTokens[k];
                                                if ("PHPDOC_TODO".equals(phpNextToken.getType())) break;
                                                length += phpNextToken.getLength();
                                                ++k;
                                            }
                                        }
                                        try {
                                            this.reportTask(document, file, reporter, offset, length, priority);
                                        }
                                        catch (CoreException e) {
                                            Logger.logException("Failed creating task", e);
                                        }
                                    }
                                    ++j;
                                }
                            }
                            catch (BadLocationException e) {
                                Logger.logException(CoreMessages.getString("PHPTodoTaskAstParser_0"), e);
                            }
                        }
                        ++i;
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                Logger.logException("Failed validating file for tasks " + file, e);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
                model = null;
            }
        }
    }

    private void populateTaskTags(IFile file) {
        TaskTagsProvider taskTagsProvider = TaskTagsProvider.getInstance();
        this.getTaskTags(file.getProject(), taskTagsProvider);
    }

    public void cleanup(IReporter reporter) {
    }

    private void getTaskTags(IProject project, TaskTagsProvider taskTagsProvider) {
        this.taskTags = taskTagsProvider.getProjectTaskTags(project);
        if (this.taskTags == null) {
            this.taskTags = taskTagsProvider.getWorkspaceTaskTags();
        }
    }

    public IFile getFile(String delta) {
        IFile res = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(delta));
        return res instanceof IFile ? res : null;
    }

    private int getTaskPriority(String taskStr) {
        String taskTagLowerCase = taskStr.toLowerCase();
        int i = 0;
        while (i < this.taskTags.length) {
            TaskTag taskTag = this.taskTags[i];
            if (taskTag.getTag().toLowerCase().equals(taskTagLowerCase)) {
                return taskTag.getPriority();
            }
            ++i;
        }
        return 1;
    }

    private void reportTask(IStructuredDocument document, IFile file, IReporter taskReporter, int offset, int length, int priority) throws BadLocationException, CoreException {
        int lineNumber = document.getLineOfOffset(offset);
        String taskStr = this.getTaskStr(document, lineNumber, offset, length);
        int charEnd = offset + taskStr.length();
        this.createMarker(file, taskStr, lineNumber, priority, offset, charEnd);
    }

    private void createMarker(IFile file, String taskStr, int lineNumber, int priority, int offset, int charEnd) throws CoreException {
        IMarker marker = file.createMarker("org.eclipse.php.core.phpTaskMarker");
        marker.setAttribute("org.eclipse.core.resources.taskmarker", true);
        marker.setAttribute("lineNumber", lineNumber + 1);
        marker.setAttribute("charStart", offset);
        marker.setAttribute("charEnd", charEnd);
        marker.setAttribute("message", (Object)taskStr);
        marker.setAttribute("userEditable", false);
        marker.setAttribute("priority", priority);
    }

    private String getTaskStr(IStructuredDocument document, int lineNumber, int offset, int length) throws BadLocationException {
        IRegion lineInformation = document.getLineInformation(lineNumber);
        int lineStart = lineInformation.getOffset();
        int lineEnd = lineStart + lineInformation.getLength();
        int tokenEnd = offset + length;
        int taskEnd = Math.min(tokenEnd, lineEnd);
        String taskStr = document.get(offset, taskEnd - offset);
        taskStr = taskStr.trim();
        return taskStr;
    }

    private ITextRegion extractPhpScriptRegion(ITextRegion textRegion) {
        ContextRegionContainer container = (ContextRegionContainer)textRegion;
        ITextRegionList containerRegions = container.getRegions();
        int z = 0;
        while (z < containerRegions.size()) {
            ITextRegion containerTextRegion = containerRegions.get(z);
            if (containerTextRegion instanceof PhpScriptRegion) {
                return containerTextRegion;
            }
            ++z;
        }
        return textRegion;
    }
}

