/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.IPHPDataType;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.model.IVirtualPartition;
import org.eclipse.php.internal.debug.core.model.VirtualPartition;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.AbstractDBGpValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractDBGpContainerValue
extends AbstractDBGpValue {
    protected IVariable[] fCurrentVariables = null;
    protected IVariable[] fPreviousVariables = null;
    protected Map<String, IVirtualPartition> fCurrentPartitions = new LinkedHashMap<String, IVirtualPartition>();
    protected Map<String, IVirtualPartition> fPreviousPartitions = new LinkedHashMap<String, IVirtualPartition>();

    public AbstractDBGpContainerValue(DBGpVariable owner) {
        super(owner);
    }

    @Override
    public synchronized IVariable[] getVariables() throws DebugException {
        if (this.fCurrentVariables == null) {
            this.fetchVariables();
        }
        if (!this.hasPages()) {
            return this.fCurrentVariables;
        }
        return this.fCurrentPartitions.values().toArray(new IVariable[this.fCurrentPartitions.size()]);
    }

    protected abstract IVariable createVariable(Node var1);

    @Override
    protected void update(Node descriptor) {
        super.update(descriptor);
        this.fPreviousVariables = this.fCurrentVariables;
        this.fCurrentVariables = null;
        String childCountNumber = DBGpResponse.getAttribute(this.fDescriptor, "numchildren");
        int childCount = 0;
        this.fHasVariables = false;
        if (childCountNumber != null && childCountNumber.trim().length() != 0) {
            try {
                childCount = Integer.parseInt(childCountNumber);
                if (childCount > 0) {
                    this.fHasVariables = true;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    protected boolean hasPages() {
        return this.fCurrentPartitions.size() > 0;
    }

    protected boolean canProcess(Node property) {
        return property == null || "error".equalsIgnoreCase(property.getNodeName());
    }

    protected void fetchVariables() {
        block17: {
            int pageSize;
            int childCount;
            block16: {
                this.fCurrentVariables = new IVariable[0];
                this.fPreviousPartitions = this.fCurrentPartitions;
                this.fCurrentPartitions = new LinkedHashMap<String, IVirtualPartition>();
                String childCountString = DBGpResponse.getAttribute(this.fDescriptor, "numchildren");
                childCount = 0;
                if (childCountString != null && childCountString.trim().length() != 0) {
                    try {
                        childCount = Integer.parseInt(childCountString);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                String pageSizeStr = null;
                pageSizeStr = DBGpResponse.getAttribute(this.fDescriptor, "pagesize");
                pageSize = ((DBGpTarget)this.getDebugTarget()).getMaxChildren();
                if (pageSizeStr != null && pageSizeStr.trim().length() != 0) {
                    try {
                        pageSize = Integer.parseInt(pageSizeStr);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (childCount > pageSize) break block16;
                NodeList childProperties = this.fDescriptor.getChildNodes();
                int childrenReceived = childProperties.getLength();
                if (childCount != childrenReceived) {
                    DBGpTarget target = (DBGpTarget)this.getDebugTarget();
                    switch (this.getOwner().getKind()) {
                        case EVAL: {
                            this.fDescriptor = target.eval(this.getOwner().getFullName(), 0);
                            break;
                        }
                        default: {
                            this.fDescriptor = target.getProperty(this.getOwner().getFullName(), String.valueOf(this.getOwner().getStackLevel()), 0);
                        }
                    }
                    if (this.canProcess(this.fDescriptor)) {
                        this.fCurrentVariables = new IVariable[]{new DBGpUnreachableVariable(this.getDebugTarget())};
                        return;
                    }
                    childProperties = this.fDescriptor.getChildNodes();
                    childCount = childrenReceived = childProperties.getLength();
                }
                this.fCurrentVariables = new IVariable[childCount];
                if (childrenReceived <= 0) break block17;
                int i = 0;
                while (i < childrenReceived) {
                    Node childProperty = childProperties.item(i);
                    IVariable child = this.createVariable(childProperty);
                    this.fCurrentVariables[i] = this.merge(child);
                    ++i;
                }
                break block17;
            }
            int subCount = (int)Math.ceil((double)childCount / (double)pageSize);
            int i = 0;
            while (i < subCount) {
                String partitionId;
                IVirtualPartition partition;
                int startIndex = i * pageSize;
                int endIndex = (i + 1) * pageSize - 1;
                if (endIndex > childCount) {
                    endIndex = childCount - 1;
                }
                if ((partition = this.fPreviousPartitions.get(partitionId = String.valueOf(String.valueOf(startIndex)) + '-' + String.valueOf(endIndex))) != null) {
                    partition.setProvider(new DBGpPage(i));
                    this.fCurrentPartitions.put(partitionId, partition);
                } else {
                    this.fCurrentPartitions.put(partitionId, new VirtualPartition((IDebugElement)this, new DBGpPage(i), startIndex, endIndex));
                }
                ++i;
            }
        }
    }

    protected IVariable merge(IVariable variable) {
        if (this.fPreviousVariables == null) {
            return variable;
        }
        if (!(variable instanceof DBGpVariable)) {
            return variable;
        }
        DBGpVariable incoming = (DBGpVariable)variable;
        if (incoming.getFullName().isEmpty()) {
            return incoming;
        }
        IVariable[] iVariableArray = this.fPreviousVariables;
        int n = this.fPreviousVariables.length;
        int n2 = 0;
        while (n2 < n) {
            DBGpVariable previous;
            IVariable stored = iVariableArray[n2];
            if (stored instanceof DBGpVariable && (previous = (DBGpVariable)stored).getFullName().equals(incoming.getFullName())) {
                ((DBGpVariable)stored).update(incoming.getDescriptor());
                return stored;
            }
            ++n2;
        }
        return variable;
    }

    protected class DBGpPage
    implements IVirtualPartition.IVariableProvider {
        private final int fPage;
        private IVariable[] fPartitionVariables = null;

        public DBGpPage(int page) {
            this.fPage = page;
        }

        @Override
        public synchronized IVariable[] getVariables() throws DebugException {
            if (this.fPartitionVariables == null) {
                Node node = AbstractDBGpContainerValue.this.getOwner().getNode(this.fPage);
                if (AbstractDBGpContainerValue.this.canProcess(node)) {
                    return new IVariable[]{new DBGpUnreachableVariable(AbstractDBGpContainerValue.this.getDebugTarget())};
                }
                NodeList childProperties = node.getChildNodes();
                int childrenReceived = childProperties.getLength();
                this.fPartitionVariables = new IVariable[childrenReceived];
                if (childrenReceived > 0) {
                    int i = 0;
                    while (i < childrenReceived) {
                        Node childProperty = childProperties.item(i);
                        IVariable child = AbstractDBGpContainerValue.this.createVariable(childProperty);
                        this.fPartitionVariables[i] = AbstractDBGpContainerValue.this.merge(child);
                        ++i;
                    }
                }
                IVariable[] concat = Arrays.copyOf(AbstractDBGpContainerValue.this.fCurrentVariables, AbstractDBGpContainerValue.this.fCurrentVariables.length + this.fPartitionVariables.length);
                System.arraycopy(this.fPartitionVariables, 0, concat, AbstractDBGpContainerValue.this.fCurrentVariables.length, this.fPartitionVariables.length);
                AbstractDBGpContainerValue.this.fCurrentVariables = concat;
            }
            return this.fPartitionVariables;
        }
    }

    protected static class DBGpUnreachableVariable
    extends DBGpElement
    implements IVariable,
    IVariableFacet {
        private DBGpUnreachableValue fValue;
        protected final Set<IVariableFacet.Facet> fFacets = new HashSet<IVariableFacet.Facet>();

        public DBGpUnreachableVariable(IDebugTarget target) {
            super(target);
            this.fValue = new DBGpUnreachableValue(target);
            this.addFacets(IVariableFacet.Facet.VIRTUAL_UNINIT);
        }

        public void setValue(String expression) throws DebugException {
        }

        public void setValue(IValue value) throws DebugException {
        }

        public boolean supportsValueModification() {
            return false;
        }

        public boolean verifyValue(String expression) throws DebugException {
            return false;
        }

        public boolean verifyValue(IValue value) throws DebugException {
            return false;
        }

        public IValue getValue() throws DebugException {
            return this.fValue;
        }

        public String getName() throws DebugException {
            return IPHPDataType.DataType.PHP_UNINITIALIZED.getText();
        }

        public String getReferenceTypeName() throws DebugException {
            return null;
        }

        public boolean hasValueChanged() throws DebugException {
            return false;
        }

        @Override
        public boolean hasFacet(IVariableFacet.Facet facet) {
            return this.fFacets.contains((Object)facet);
        }

        @Override
        public void addFacets(IVariableFacet.Facet ... facets) {
            IVariableFacet.Facet[] facetArray = facets;
            int n = facets.length;
            int n2 = 0;
            while (n2 < n) {
                IVariableFacet.Facet facet = facetArray[n2];
                this.fFacets.add(facet);
                ++n2;
            }
        }

        protected class DBGpUnreachableValue
        extends DBGpElement
        implements IValue {
            public DBGpUnreachableValue(IDebugTarget target) {
                super(target);
            }

            public String getReferenceTypeName() throws DebugException {
                return null;
            }

            public String getValueString() throws DebugException {
                return null;
            }

            public boolean isAllocated() throws DebugException {
                return false;
            }

            public IVariable[] getVariables() throws DebugException {
                return new IVariable[0];
            }

            public boolean hasVariables() throws DebugException {
                return false;
            }
        }
    }
}

