/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.model;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.DebugTargetProxy;
import org.eclipse.php.internal.debug.ui.model.PHPThreadEventHandler;

public class PHPMultiDebugTargetProxy
extends DebugTargetProxy {
    private IDebugTarget debugTarget;

    public PHPMultiDebugTargetProxy(IDebugTarget debugTarget) {
        super(debugTarget);
        this.debugTarget = debugTarget;
    }

    protected DebugEventHandler[] createEventHandlers() {
        return new DebugEventHandler[]{new PHPThreadEventHandler((AbstractModelProxy)this)};
    }

    protected boolean containsEvent(DebugEvent event) {
        Object source = event.getSource();
        if (source instanceof IDebugElement) {
            ILaunch launch = ((IDebugElement)source).getLaunch();
            if (launch == null) {
                return false;
            }
            IDebugTarget debugTarget = launch.getDebugTarget();
            if (debugTarget != null) {
                return debugTarget.equals(this.debugTarget);
            }
        }
        return false;
    }

    protected ModelDelta getNextSuspendedThreadDelta(IThread currentThread, boolean reverse) {
        if (this.debugTarget != null) {
            try {
                IThread[] threads = this.debugTarget.getThreads();
                ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
                ILaunch launch = this.debugTarget.getLaunch();
                int launchIndex = this.indexOf(manager.getLaunches(), this.debugTarget.getLaunch());
                int targetIndex = this.indexOf(this.debugTarget.getLaunch().getChildren(), this.debugTarget);
                ArrayList<IThread> chosen = new ArrayList<IThread>();
                boolean takeNext = currentThread == null;
                int startIdx = reverse ? threads.length - 1 : 0;
                int endIdx = reverse ? -1 : threads.length;
                int increment = reverse ? -1 : 1;
                int i = startIdx;
                while (i != endIdx) {
                    IThread thread = threads[i];
                    if (thread.isSuspended()) {
                        IBreakpoint[] bps = thread.getBreakpoints();
                        if (bps != null && bps.length > 0) {
                            chosen.add(thread);
                        } else if (thread.isSuspended()) {
                            chosen.add(thread);
                        }
                    }
                    takeNext = takeNext || thread.equals(currentThread);
                    i += increment;
                }
                if (!chosen.isEmpty()) {
                    ModelDelta delta = new ModelDelta((Object)manager, 0);
                    ModelDelta node = delta.addNode((Object)launch, launchIndex, 0, this.debugTarget.getLaunch().getChildren().length);
                    node = node.addNode((Object)this.debugTarget, targetIndex, 0, threads.length);
                    int i2 = 0;
                    while (i2 < chosen.size()) {
                        IThread t = (IThread)chosen.get(i2);
                        IStackFrame frame = t.getTopStackFrame();
                        if (frame != null) {
                            ModelDelta next = node.addNode((Object)t, i2, 0x100000, t.getStackFrames().length);
                            next = next.addNode((Object)frame, 0, 0x200000, 0);
                        }
                        ++i2;
                    }
                    return delta;
                }
            }
            catch (DebugException debugException) {}
        }
        return null;
    }
}

