/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.pathmapper;

import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.internal.debug.core.pathmapper.BestMatchPathComparator;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.debug.ui.pathmapper.Messages;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class MapLocalFileDialog
extends TrayDialog {
    private static final Object[] EMPTY = new Object[0];
    private static final Object EXTERNAL_CONTAINER = new Object();
    private String title;
    private VirtualPath path;
    private PathEntry[] pathEntries;
    private PathEntry result;
    private TreeViewer entriesViewer;

    public MapLocalFileDialog(Shell shell, String title, VirtualPath path, PathEntry[] pathEntries) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.title = title;
        this.path = path;
        this.pathEntries = pathEntries;
    }

    public PathEntry getResult() {
        return this.result;
    }

    public void create() {
        super.create();
        this.getShell().forceActive();
        this.getShell().setActive();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        newShell.setData("org.eclipse.ui.help", (Object)"org.eclipse.php.help.path_mapping");
        newShell.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent arg0) {
                Program.launch((String)"org.eclipse.php.help.path_mapping");
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        FontData[] fontData;
        parent = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 2;
        this.initializeDialogUnits((Control)parent);
        FontData[] fontDataArray = fontData = parent.getFont().getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData d = fontDataArray[n2];
            d.setStyle(1);
            ++n2;
        }
        Font boldFont = new Font(parent.getFont().getDevice(), fontData);
        Label remoteLabel = new Label(parent, 0);
        remoteLabel.setText(Messages.OpenLocalFileSearchFilter_Select_the_local_resource_match);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        remoteLabel.setLayoutData((Object)layoutData);
        Label label = new Label(parent, 0);
        label.setFont(boldFont);
        label.setText(this.path.toString());
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.horizontalIndent = this.convertVerticalDLUsToPixels(10);
        label.setLayoutData((Object)layoutData);
        this.entriesViewer = new TreeViewer(parent, 2820);
        layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        layoutData.minimumHeight = this.convertVerticalDLUsToPixels(80);
        layoutData.verticalIndent = 10;
        this.entriesViewer.getControl().setLayoutData((Object)layoutData);
        this.entriesViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.entriesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.entriesViewer.setSorter((ViewerSorter)new Sorter());
        this.entriesViewer.setInput((Object)this);
        this.entriesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MapLocalFileDialog.this.validate();
            }
        });
        this.entriesViewer.expandAll();
        return parent;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.validate();
        return control;
    }

    protected void validate() {
        Button okButton = this.getButton(0);
        okButton.setEnabled(false);
        this.result = null;
        Object selectedElement = ((IStructuredSelection)this.entriesViewer.getSelection()).getFirstElement();
        if (selectedElement instanceof PathEntry) {
            okButton.setEnabled(true);
            this.result = (PathEntry)selectedElement;
        } else {
            okButton.setEnabled(false);
        }
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == MapLocalFileDialog.this) {
                HashSet<Object> containers = new HashSet<Object>();
                PathEntry[] pathEntryArray = MapLocalFileDialog.this.pathEntries;
                int n = pathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PathEntry entry = pathEntryArray[n2];
                    if (entry.getType() == PathEntry.Type.EXTERNAL) {
                        containers.add(EXTERNAL_CONTAINER);
                    } else if (entry.getType() == PathEntry.Type.INCLUDE_VAR || entry.getType() == PathEntry.Type.INCLUDE_FOLDER) {
                        containers.add(entry.getContainer());
                    } else if (entry.getType() == PathEntry.Type.WORKSPACE) {
                        containers.add(((IResource)entry.getContainer()).getProject());
                    }
                    ++n2;
                }
                return containers.toArray();
            }
            if (parentElement instanceof PathEntry) {
                return EMPTY;
            }
            HashSet<PathEntry> entries = new HashSet<PathEntry>();
            PathEntry[] pathEntryArray = MapLocalFileDialog.this.pathEntries;
            int n = pathEntryArray.length;
            int n3 = 0;
            while (n3 < n) {
                PathEntry entry = pathEntryArray[n3];
                if (entry.getType() == PathEntry.Type.EXTERNAL && parentElement == EXTERNAL_CONTAINER) {
                    entries.add(entry);
                } else if ((entry.getType() == PathEntry.Type.INCLUDE_VAR || entry.getType() == PathEntry.Type.INCLUDE_FOLDER) && entry.getContainer() == parentElement) {
                    entries.add(entry);
                } else if (entry.getType() == PathEntry.Type.WORKSPACE && ((IResource)entry.getContainer()).getProject() == parentElement) {
                    entries.add(entry);
                }
                ++n3;
            }
            return entries.toArray();
        }

        public Object getParent(Object element) {
            PathEntry entry;
            if (element == MapLocalFileDialog.this) {
                return null;
            }
            if (element instanceof PathEntry) {
                entry = (PathEntry)element;
                if (entry.getType() == PathEntry.Type.EXTERNAL) {
                    return EXTERNAL_CONTAINER;
                }
                if (entry.getType() == PathEntry.Type.INCLUDE_VAR || entry.getType() == PathEntry.Type.INCLUDE_FOLDER) {
                    return entry.getContainer();
                }
                if (entry.getType() == PathEntry.Type.WORKSPACE) {
                    return ((IResource)entry.getContainer()).getProject();
                }
            }
            PathEntry[] pathEntryArray = MapLocalFileDialog.this.pathEntries;
            int n = pathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                entry = pathEntryArray[n2];
                if (entry.getType() == PathEntry.Type.EXTERNAL && element == EXTERNAL_CONTAINER) {
                    return entry;
                }
                if (entry.getType() == PathEntry.Type.INCLUDE_VAR || entry.getType() == PathEntry.Type.INCLUDE_FOLDER && entry.getContainer() == element) {
                    return entry;
                }
                if (entry.getType() == PathEntry.Type.WORKSPACE && ((IResource)entry.getContainer()).getProject() == element) {
                    return entry;
                }
                ++n2;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return !(element instanceof PathEntry);
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class LabelProvider
    extends ScriptUILabelProvider {
        private LabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IBuildpathEntry) {
                IBuildpathEntry includePathEntry = (IBuildpathEntry)element;
                if (includePathEntry.getEntryKind() == 4) {
                    return PHPPluginImages.get((String)"org.eclipse.php.ui.envvar_obj.png");
                }
                return PHPPluginImages.get((String)"org.eclipse.php.ui.library_obj.png");
            }
            if (element instanceof PathEntry) {
                return PHPPluginImages.get((String)"org.eclipse.php.ui.phpfile.png");
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element == EXTERNAL_CONTAINER) {
                return Messages.OpenLocalFileSearchFilter_External_files;
            }
            if (element instanceof IBuildpathEntry) {
                IBuildpathEntry includePathEntry = (IBuildpathEntry)element;
                return EnvironmentPathUtils.getLocalPathString((IPath)includePathEntry.getPath());
            }
            if (!(element instanceof PathEntry)) {
                return super.getText(element);
            }
            PathEntry entry = (PathEntry)element;
            String path = entry.getResolvedPath();
            if (entry.getType() == PathEntry.Type.WORKSPACE) {
                VirtualPath tmpPath = entry.getAbstractPath().clone();
                tmpPath.removeFirstSegment();
                path = tmpPath.toString();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
            }
            if (entry.getType() == PathEntry.Type.INCLUDE_FOLDER || entry.getType() == PathEntry.Type.INCLUDE_VAR) {
                IPath p;
                IBuildpathEntry includePathEntry = (IBuildpathEntry)entry.getContainer();
                String includePath = EnvironmentPathUtils.getLocalPathString((IPath)includePathEntry.getPath());
                if (includePathEntry.getEntryKind() == 4 && (p = DLTKCore.getResolvedVariablePath((IPath)includePathEntry.getPath())) != null) {
                    includePath = p.toOSString();
                }
                if (includePath != null && path.startsWith(includePath)) {
                    path = path.substring(includePath.length());
                }
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
            }
            return path;
        }
    }

    private class Sorter
    extends ViewerSorter {
        private BestMatchPathComparator comparator;

        public Sorter() {
            this.comparator = new BestMatchPathComparator(MapLocalFileDialog.this.path);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof PathEntry && e2 instanceof PathEntry) {
                return this.comparator.compare((PathEntry)e1, (PathEntry)e2);
            }
            if (e1 == EXTERNAL_CONTAINER) {
                return 1;
            }
            if (e1 instanceof IResource) {
                return -1;
            }
            return 0;
        }
    }
}

