/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.wizard;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.refactoring.core.extract.variable.ExtractVariableRefactoring;
import org.eclipse.php.refactoring.ui.PHPRefactoringUIMessages;
import org.eclipse.php.refactoring.ui.wizard.RowLayouter;
import org.eclipse.php.refactoring.ui.wizard.TextInputWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExtractVariableWizard
extends RefactoringWizard {
    static final String DIALOG_SETTING_SECTION = "ExtractVariableWizard";

    public ExtractVariableWizard(ExtractVariableRefactoring ref) {
        super((Refactoring)ref, 36);
        this.setDefaultPageTitle(PHPRefactoringUIMessages.getString("ExtractVariableWizard.0"));
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new ExtractTempInputPage(this.getExtractVariableRefactoring().guessTempNames()));
    }

    private ExtractVariableRefactoring getExtractVariableRefactoring() {
        return (ExtractVariableRefactoring)this.getRefactoring();
    }

    private static class ExtractTempInputPage
    extends TextInputWizardPage {
        private static final String COM_ZEND_PHP_REFACTORING_UI_ASSI_DECORATION = "org.eclipse.php.refactoring.ui.AssiDecoration";
        private static final String TRIGGER_KEY = "Ctrl+Space";
        private static final String DECLARE_FINAL = "declareFinal";
        private static final String REPLACE_ALL = "replaceOccurrences";
        private final boolean fInitialValid;
        private static final String DESCRIPTION = PHPRefactoringUIMessages.getString("ExtractVariableWizard.1");
        private String[] fTempNameProposals;
        private IDialogSettings fSettings;

        public ExtractTempInputPage(String[] tempNameProposals) {
            super(DESCRIPTION, true, tempNameProposals.length == 0 ? "" : tempNameProposals[0]);
            Assert.isNotNull((Object)tempNameProposals);
            this.fTempNameProposals = tempNameProposals;
            this.fInitialValid = tempNameProposals.length > 0;
        }

        public void createControl(Composite parent) {
            this.loadSettings();
            Composite result = new Composite(parent, 0);
            this.setControl((Control)result);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.verticalSpacing = 8;
            result.setLayout((Layout)layout);
            RowLayouter layouter = new RowLayouter(2);
            Label label = new Label(result, 0);
            label.setText(PHPRefactoringUIMessages.getString("ExtractVariableWizard.2"));
            Text text = this.createTextInputField(result);
            text.selectAll();
            text.setLayoutData((Object)new GridData(768));
            this.creatContentAssit(text);
            this.installContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter());
            layouter.perform((Control)label, (Control)text, 1);
            this.addReplaceAllCheckbox(result, layouter);
            this.validateTextField(text.getText());
            Dialog.applyDialogFont((Control)result);
        }

        private void creatContentAssit(Text text) {
            ControlDecoration cd = new ControlDecoration((Control)text, 16512);
            FieldDecoration dec = this.getCueDecoration();
            cd.setImage(dec.getImage());
            cd.setDescriptionText(dec.getDescription());
            cd.setShowOnlyOnFocus(false);
            cd.show();
        }

        FieldDecoration getCueDecoration() {
            FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
            FieldDecoration dec = registry.getFieldDecoration(COM_ZEND_PHP_REFACTORING_UI_ASSI_DECORATION);
            if (dec == null) {
                FieldDecoration standardDecoration = registry.getFieldDecoration("DEC_CONTENT_PROPOSAL");
                registry.registerFieldDecoration(COM_ZEND_PHP_REFACTORING_UI_ASSI_DECORATION, NLS.bind((String)PHPRefactoringUIMessages.getString("ExtractVariableWizard.6"), (Object)TRIGGER_KEY), standardDecoration.getImage());
                dec = registry.getFieldDecoration(COM_ZEND_PHP_REFACTORING_UI_ASSI_DECORATION);
            }
            return dec;
        }

        void installContentProposalAdapter(Control control, IControlContentAdapter contentAdapter) {
            KeyStroke keyStroke;
            boolean propagate = false;
            char[] autoActivationCharacters = null;
            int autoActivationDelay = 1000;
            try {
                keyStroke = KeyStroke.getInstance((String)TRIGGER_KEY);
            }
            catch (ParseException parseException) {
                keyStroke = KeyStroke.getInstance((int)0x1000013);
            }
            ContentProposalAdapter adapter = new ContentProposalAdapter(control, contentAdapter, this.getContentProposalProvider(), keyStroke, autoActivationCharacters);
            adapter.setAutoActivationDelay(autoActivationDelay);
            adapter.setPropagateKeys(propagate);
            adapter.setFilterStyle(this.getContentAssistFilterStyle());
            adapter.setProposalAcceptanceStyle(this.getContentAssistAcceptance());
        }

        private int getContentAssistAcceptance() {
            return 2;
        }

        private int getContentAssistFilterStyle() {
            return 2;
        }

        private IContentProposalProvider getContentProposalProvider() {
            return new IContentProposalProvider(){

                public IContentProposal[] getProposals(String contents, int position) {
                    IContentProposal[] proposals = new IContentProposal[ExtractTempInputPage.this.fTempNameProposals.length];
                    int i = 0;
                    while (i < ExtractTempInputPage.this.fTempNameProposals.length) {
                        final String user = ExtractTempInputPage.this.fTempNameProposals[i];
                        proposals[i] = new IContentProposal(){

                            public String getContent() {
                                return user;
                            }

                            public String getLabel() {
                                return user;
                            }

                            public String getDescription() {
                                return null;
                            }

                            public int getCursorPosition() {
                                return user.length();
                            }
                        };
                        ++i;
                    }
                    return proposals;
                }
            };
        }

        private void loadSettings() {
            this.fSettings = this.getDialogSettings().getSection(ExtractVariableWizard.DIALOG_SETTING_SECTION);
            if (this.fSettings == null) {
                this.fSettings = this.getDialogSettings().addNewSection(ExtractVariableWizard.DIALOG_SETTING_SECTION);
                this.fSettings.put(DECLARE_FINAL, false);
                this.fSettings.put(REPLACE_ALL, true);
            }
            this.getExtractVariableRefactoring().setReplaceAllOccurrences(this.fSettings.getBoolean(REPLACE_ALL));
        }

        private void addReplaceAllCheckbox(Composite result, RowLayouter layouter) {
            String title = PHPRefactoringUIMessages.getString("ExtractVariableWizard.3");
            boolean defaultValue = this.getExtractVariableRefactoring().getReplaceAllOccurrences();
            final Button checkBox = ExtractTempInputPage.createCheckbox(result, title, defaultValue, layouter);
            this.getExtractVariableRefactoring().setReplaceAllOccurrences(checkBox.getSelection());
            checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExtractTempInputPage.this.fSettings.put(ExtractTempInputPage.REPLACE_ALL, checkBox.getSelection());
                    ExtractTempInputPage.this.getExtractVariableRefactoring().setReplaceAllOccurrences(checkBox.getSelection());
                }
            });
        }

        @Override
        protected void textModified(String text) {
            this.getExtractVariableRefactoring().setNewVariableName(text);
            super.textModified(text);
        }

        @Override
        protected RefactoringStatus validateTextField(String text) {
            return this.getExtractVariableRefactoring().checkNewVariableName(text);
        }

        private ExtractVariableRefactoring getExtractVariableRefactoring() {
            return (ExtractVariableRefactoring)this.getRefactoring();
        }

        private static Button createCheckbox(Composite parent, String title, boolean value, RowLayouter layouter) {
            Button checkBox = new Button(parent, 32);
            checkBox.setText(title);
            checkBox.setSelection(value);
            layouter.perform((Control)checkBox);
            return checkBox;
        }

        @Override
        protected boolean isInitialInputValid() {
            return this.fInitialValid;
        }
    }
}

