/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.Stack;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.CommentHandler;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class RemoveBlockCommentHandler
extends CommentHandler
implements IHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IDocument document;
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ITextEditor textEditor = null;
        if (editor instanceof ITextEditor) {
            textEditor = (ITextEditor)editor;
        } else {
            Object o = editor.getAdapter(ITextEditor.class);
            if (o != null) {
                textEditor = (ITextEditor)o;
            }
        }
        if (textEditor != null && (document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput())) != null) {
            ITextSelection textSelection = this.getCurrentSelection(textEditor);
            if (this.isMoreThanOneContextBlockSelected(document, textSelection)) {
                org.eclipse.wst.sse.ui.internal.handlers.RemoveBlockCommentHandler removeBlockCommentHandlerWST = new org.eclipse.wst.sse.ui.internal.handlers.RemoveBlockCommentHandler();
                return removeBlockCommentHandlerWST.execute(event);
            }
            if (textSelection.isEmpty()) {
                return null;
            }
            if (document instanceof IStructuredDocument) {
                int selectionOffset = textSelection.getOffset();
                IStructuredDocument sDoc = (IStructuredDocument)document;
                IStructuredDocumentRegion sdRegion = sDoc.getRegionAtCharacterOffset(selectionOffset);
                ITextRegion textRegion = sdRegion.getRegionAtCharacterOffset(selectionOffset);
                IStructuredDocumentRegion container = sdRegion;
                if (textRegion instanceof ITextRegionContainer) {
                    container = (ITextRegionContainer)textRegion;
                    textRegion = container.getRegionAtCharacterOffset(selectionOffset);
                }
                if (textRegion.getType() == "PHP_CONTENT") {
                    this.processAction(textEditor, document, textSelection);
                } else {
                    org.eclipse.wst.sse.ui.internal.handlers.RemoveBlockCommentHandler removeBlockCommentHandlerWST = new org.eclipse.wst.sse.ui.internal.handlers.RemoveBlockCommentHandler();
                    return removeBlockCommentHandlerWST.execute(event);
                }
            }
        }
        return null;
    }

    @Override
    void processAction(ITextEditor textEditor, IDocument document, ITextSelection textSelection) {
        block11: {
            int selectionOffset = textSelection.getOffset();
            int selectionLength = textSelection.getLength();
            IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForEdit(document);
            if (model != null) {
                try {
                    model.beginRecording((Object)this, PHPUIMessages.RemoveBlockComment_tooltip);
                    model.aboutToChangeModel();
                    if (!(document instanceof IStructuredDocument)) break block11;
                    IStructuredDocument sDoc = (IStructuredDocument)document;
                    IStructuredDocumentRegion regionAtCharacterOffset = sDoc.getRegionAtCharacterOffset(selectionOffset);
                    int docRegionOffset = regionAtCharacterOffset.getStartOffset();
                    ITextRegion textRegion = regionAtCharacterOffset.getRegionAtCharacterOffset(selectionOffset);
                    Stack<TextLocation> phpCommentLocationStack = new Stack<TextLocation>();
                    try {
                        int textRegionOffset = textRegion.getStart();
                        int normelizedOffset = textRegionOffset + docRegionOffset;
                        ITextRegion[] phpTokens = ((PhpScriptRegion)textRegion).getPhpTokens(selectionOffset - normelizedOffset, selectionLength);
                        int lastOffsetParsed = -1;
                        ITextRegion[] iTextRegionArray = phpTokens;
                        int n = phpTokens.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ITextRegion token = iTextRegionArray[n2];
                            if (lastOffsetParsed < token.getEnd() && PHPPartitionTypes.isPHPMultiLineCommentState((String)token.getType())) {
                                ITextRegion startToken = this.findCommentStartToken(token, (PhpScriptRegion)textRegion);
                                TextLocation commentOffsets = new TextLocation(startToken.getStart() + normelizedOffset, startToken.getEnd() + normelizedOffset);
                                boolean result = this.validateAndPushLocation(phpCommentLocationStack, commentOffsets);
                                assert (result);
                                lastOffsetParsed = commentOffsets.endOffset - normelizedOffset;
                                ITextRegion endToken = this.findCommentEndToken(token, (PhpScriptRegion)textRegion);
                                commentOffsets = new TextLocation(endToken.getStart() + normelizedOffset, endToken.getEnd() + normelizedOffset);
                                result = this.validateAndPushLocation(phpCommentLocationStack, commentOffsets);
                                assert (result);
                                lastOffsetParsed = commentOffsets.endOffset - normelizedOffset;
                            }
                            ++n2;
                        }
                        int i = phpCommentLocationStack.size();
                        while (i > 0) {
                            TextLocation location = (TextLocation)phpCommentLocationStack.pop();
                            document.replace(location.startOffset, location.endOffset - location.startOffset, "");
                            --i;
                        }
                    }
                    catch (BadLocationException e) {
                        Logger.log(202, e.getMessage(), e);
                    }
                }
                finally {
                    model.changedModel();
                    model.endRecording((Object)this);
                    model.releaseFromEdit();
                }
            }
        }
    }

    private boolean validateAndPushLocation(Stack<TextLocation> phpCommentLocationStack, TextLocation commentOffsets) {
        if (commentOffsets != null && !phpCommentLocationStack.contains(commentOffsets)) {
            phpCommentLocationStack.push(commentOffsets);
            return true;
        }
        return false;
    }

    private ITextRegion findCommentStartToken(ITextRegion token, PhpScriptRegion phpScriptRegion) throws BadLocationException {
        assert (PHPPartitionTypes.isPHPMultiLineCommentState((String)token.getType()));
        if (PHPPartitionTypes.isPHPMultiLineCommentStartRegion((String)token.getType())) {
            return token;
        }
        ITextRegion previousToken = phpScriptRegion.getPhpToken(token.getStart() - 1);
        return this.findCommentStartToken(previousToken, phpScriptRegion);
    }

    private ITextRegion findCommentEndToken(ITextRegion token, PhpScriptRegion phpScriptRegion) throws BadLocationException {
        assert (PHPPartitionTypes.isPHPMultiLineCommentState((String)token.getType()));
        if (PHPPartitionTypes.isPHPMultiLineCommentEndRegion((String)token.getType())) {
            return token;
        }
        ITextRegion nextToken = phpScriptRegion.getPhpToken(token.getEnd());
        return this.findCommentEndToken(nextToken, phpScriptRegion);
    }

    public class TextLocation {
        protected int startOffset;
        protected int endOffset;

        public TextLocation(int start, int end) {
            this.startOffset = start;
            this.endOffset = end;
        }

        public boolean equals(TextLocation arg0) {
            return this.startOffset == arg0.startOffset && this.endOffset == arg0.endOffset;
        }
    }
}

