/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.format.IndentationObject;
import org.eclipse.php.internal.core.format.IndentationUtils;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.autoEdit.IndentLineAutoEditStrategy;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class CurlyOpenAutoEditStrategy
extends IndentLineAutoEditStrategy
implements IAutoEditStrategy {
    private StringBuffer helpBuffer = new StringBuffer();

    public CurlyOpenAutoEditStrategy() {
    }

    public CurlyOpenAutoEditStrategy(IndentationObject indentationObject) {
        this.setIndentationObject(indentationObject);
    }

    @Override
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (command.text != null && command.text.endsWith("{")) {
            this.setIndentationObject(null);
            this.autoIndentBeforeCurlyOpen((IStructuredDocument)document, command);
        }
    }

    private void autoIndentBeforeCurlyOpen(IStructuredDocument document, DocumentCommand command) {
        int startOffset = command.offset;
        int endOffset = startOffset + command.length;
        this.helpBuffer.setLength(0);
        try {
            IRegion startlineInfo = document.getLineInformationOfOffset(startOffset);
            int lineNumber = document.getLineOfOffset(startOffset);
            if (IndentationUtils.isBlanks((IStructuredDocument)document, (int)startlineInfo.getOffset(), (int)startOffset)) {
                this.placeMatchingBlanks(document, this.helpBuffer, lineNumber, startOffset);
                int endSelection = command.offset + command.length;
                command.offset = startlineInfo.getOffset();
                command.length = command.length == 0 ? endOffset - command.offset : endSelection - command.offset;
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        command.text = String.valueOf(this.helpBuffer.toString()) + command.text;
    }

    protected String getCommandText() {
        return "{";
    }
}

