/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.ui.autoEdit.CaseDefaultAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.CurlyCloseAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.CurlyOpenAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.IAppliedAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.IndentLineAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.MatchingBracketAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.PHPAutoIndentStrategy;
import org.eclipse.php.internal.ui.autoEdit.PhpDocAutoIndentStrategy;
import org.eclipse.php.internal.ui.autoEdit.QuotesAutoEditStrategy;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class MainAutoEditStrategy
implements IAutoEditStrategy {
    private static IAutoEditStrategy indentLineAutoEditStrategy = new IndentLineAutoEditStrategy();
    private static IAutoEditStrategy curlyOpenAutoEditStrategy = new CurlyOpenAutoEditStrategy();
    private static IAutoEditStrategy curlyCloseAutoEditStrategy = new CurlyCloseAutoEditStrategy();
    private static IAutoEditStrategy matchingBracketAutoEditStrategy = new MatchingBracketAutoEditStrategy();
    private static IAutoEditStrategy quotesAutoEditStrategy = new QuotesAutoEditStrategy();
    private static IAppliedAutoEditStrategy caseDefaultAutoEditStrategy = new CaseDefaultAutoEditStrategy();
    private static IAutoEditStrategy docBlockAutoEditStrategy = new PhpDocAutoIndentStrategy();
    private static IAutoEditStrategy autoIndentStrategy = new PHPAutoIndentStrategy();

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        String nextPartitionType;
        String previousPartitionType;
        if (command.text == null) {
            return;
        }
        String partitionType = FormatterUtils.getPartitionType((IStructuredDocument)((IStructuredDocument)document), (int)command.offset);
        if (partitionType == "org.eclipse.php.PHP_DOC" || partitionType == "org.eclipse.php.PHP_MULTI_LINE_COMMENT") {
            docBlockAutoEditStrategy.customizeDocumentCommand(document, command);
            return;
        }
        String string = previousPartitionType = command.offset > 0 ? FormatterUtils.getPartitionType((IStructuredDocument)((IStructuredDocument)document), (int)(command.offset - 1)) : null;
        if (previousPartitionType == "org.eclipse.php.PHP_QUOTED_STRING" && partitionType == "org.eclipse.php.PHP_QUOTED_STRING" && (nextPartitionType = FormatterUtils.getPartitionType((IStructuredDocument)((IStructuredDocument)document), (int)command.offset, (boolean)true)) == "org.eclipse.php.PHP_QUOTED_STRING") {
            quotesAutoEditStrategy.customizeDocumentCommand(document, command);
            return;
        }
        if (partitionType == "org.eclipse.php.PHP_DEFAULT" || partitionType == "org.eclipse.php.PHP_SINGLE_LINE_COMMENT" || partitionType == "org.eclipse.php.PHP_QUOTED_STRING") {
            caseDefaultAutoEditStrategy.customizeDocumentCommand(document, command);
            if (caseDefaultAutoEditStrategy.wasApplied()) {
                return;
            }
            matchingBracketAutoEditStrategy.customizeDocumentCommand(document, command);
            curlyOpenAutoEditStrategy.customizeDocumentCommand(document, command);
            curlyCloseAutoEditStrategy.customizeDocumentCommand(document, command);
            indentLineAutoEditStrategy.customizeDocumentCommand(document, command);
            quotesAutoEditStrategy.customizeDocumentCommand(document, command);
            autoIndentStrategy.customizeDocumentCommand(document, command);
        }
    }
}

