/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.navigator;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.php.core.libfolders.LibraryFolderManager;
import org.eclipse.php.internal.core.PHPToolkitUtil;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.util.PHPPluginImages;

public class PHPNavigatorLabelDecorator
implements ILightweightLabelDecorator {
    private LibraryFolderManager lfm = LibraryFolderManager.getInstance();

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IFolder) {
            IDecorationContext context = decoration.getDecorationContext();
            if (context instanceof DecorationContext) {
                ((DecorationContext)context).putProperty("org.eclipse.jface.viewers.IDecoration.disableReplace", (Object)Boolean.TRUE);
            }
            IFolder folder = (IFolder)element;
            IScriptProject project = DLTKCore.create((IProject)folder.getProject());
            try {
                if (PHPToolkitUtil.isPhpProject((IProject)folder.getProject()) && project.isOnBuildpath((IResource)folder)) {
                    if (this.lfm.isInLibraryFolder((IResource)folder)) {
                        decoration.addOverlay(PHPPluginImages.DESC_OBJS_PHP_LIBFOLDER, 5);
                    } else {
                        decoration.addOverlay(DLTKPluginImages.DESC_OBJS_PACKFRAG_ROOT, 5);
                    }
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

