/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.problem.DefaultProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.core.CorrectionEngine;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.dltk.ui.editor.ScriptMarkerAnnotation;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.contentassist.CompletionProposalComparator;
import org.eclipse.php.internal.ui.text.correction.AssistContext;
import org.eclipse.php.internal.ui.text.correction.IProblemLocation;
import org.eclipse.php.internal.ui.text.correction.PHPCorrectionProcessor;
import org.eclipse.php.internal.ui.text.correction.ProblemLocation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class CorrectionMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private static final IMarkerResolution[] NO_RESOLUTIONS = new IMarkerResolution[0];

    public IMarkerResolution[] getResolutions(IMarker marker) {
        return CorrectionMarkerResolutionGenerator.internalGetResolutions(marker);
    }

    public boolean hasResolutions(IMarker marker) {
        return CorrectionMarkerResolutionGenerator.internalHasResolutions(marker);
    }

    private static boolean internalHasResolutions(IMarker marker) {
        String id = marker.getAttribute("id", "");
        IProblemIdentifier problemId = DefaultProblemIdentifier.decode((String)id);
        ISourceModule cu = CorrectionMarkerResolutionGenerator.getSourceModule(marker);
        return cu != null && problemId != null && PHPCorrectionProcessor.hasCorrections(cu, problemId, MarkerUtilities.getMarkerType((IMarker)marker));
    }

    private static IMarkerResolution[] internalGetResolutions(IMarker marker) {
        IProblemLocation location;
        IEditorInput input;
        if (!CorrectionMarkerResolutionGenerator.internalHasResolutions(marker)) {
            return NO_RESOLUTIONS;
        }
        ISourceModule cu = CorrectionMarkerResolutionGenerator.getSourceModule(marker);
        if (cu != null && (input = EditorUtility.getEditorInput((Object)cu)) != null && (location = CorrectionMarkerResolutionGenerator.findProblemLocation(input, marker)) != null) {
            AssistContext context = new AssistContext(cu, location.getOffset(), location.getLength());
            ArrayList proposals = new ArrayList();
            PHPCorrectionProcessor.collectCorrections(context, new IProblemLocation[]{location}, proposals);
            Collections.sort(proposals, new CompletionProposalComparator());
            int nProposals = proposals.size();
            IMarkerResolution[] resolutions = new IMarkerResolution[nProposals];
            int i = 0;
            while (i < nProposals) {
                resolutions[i] = new CorrectionMarkerResolution(context.getCompilationUnit(), location.getOffset(), location.getLength(), (IScriptCompletionProposal)proposals.get(i), marker);
                ++i;
            }
            return resolutions;
        }
        return NO_RESOLUTIONS;
    }

    private static ISourceModule getSourceModule(IMarker marker) {
        IModelElement element;
        IResource res = marker.getResource();
        if (res instanceof IFile && res.isAccessible() && (element = DLTKCore.create((IFile)((IFile)res))) instanceof ISourceModule) {
            return (ISourceModule)element;
        }
        return null;
    }

    private static IProblemLocation findProblemLocation(IEditorInput input, IMarker marker) {
        IAnnotationModel model = DLTKUIPlugin.getDocumentProvider().getAnnotationModel((Object)input);
        if (model != null) {
            Iterator iter = model.getAnnotationIterator();
            while (iter.hasNext()) {
                Position pos;
                ScriptMarkerAnnotation annot;
                Annotation curr = (Annotation)iter.next();
                if (!(curr instanceof ScriptMarkerAnnotation) || !marker.equals((Object)(annot = (ScriptMarkerAnnotation)curr).getMarker()) || (pos = model.getPosition((Annotation)annot)) == null) continue;
                return new ProblemLocation(pos.getOffset(), pos.getLength(), (IScriptAnnotation)annot);
            }
        } else {
            ISourceModule cu = CorrectionMarkerResolutionGenerator.getSourceModule(marker);
            return CorrectionMarkerResolutionGenerator.createFromMarker(marker, cu);
        }
        return null;
    }

    private static IProblemLocation createFromMarker(IMarker marker, ISourceModule cu) {
        try {
            String id = marker.getAttribute("id", "");
            IProblemIdentifier problemId = DefaultProblemIdentifier.decode((String)id);
            int start = marker.getAttribute("charStart", -1);
            int end = marker.getAttribute("charEnd", -1);
            int severity = marker.getAttribute("severity", 0);
            String[] arguments = CorrectionEngine.getProblemArguments((IMarker)marker);
            String markerType = marker.getType();
            if (cu != null && problemId != null && start != -1 && end != -1) {
                boolean isError = severity == 2;
                return new ProblemLocation(start, end - start, problemId, arguments, isError, markerType);
            }
        }
        catch (CoreException e) {
            PHPUiPlugin.log(e);
        }
        return null;
    }

    public static class CorrectionMarkerResolution
    implements IMarkerResolution2 {
        private ISourceModule fSourceModule;
        private int fOffset;
        private int fLength;
        private IScriptCompletionProposal fProposal;
        private final IMarker fMarker;

        public CorrectionMarkerResolution(ISourceModule cu, int offset, int length, IScriptCompletionProposal proposal, IMarker marker) {
            this.fSourceModule = cu;
            this.fOffset = offset;
            this.fLength = length;
            this.fProposal = proposal;
            this.fMarker = marker;
        }

        public String getLabel() {
            return this.fProposal.getDisplayString();
        }

        public void run(IMarker marker) {
            try {
                IEditorPart part = EditorUtility.isOpenInEditor((Object)this.fSourceModule);
                if (part == null && (part = DLTKUIPlugin.openInEditor((IModelElement)this.fSourceModule, (boolean)true, (boolean)false)) instanceof ITextEditor) {
                    ((ITextEditor)part).selectAndReveal(this.fOffset, this.fLength);
                }
                if (part != null) {
                    IEditorInput input = part.getEditorInput();
                    IDocument doc = DLTKUIPlugin.getDocumentProvider().getDocument((Object)input);
                    this.fProposal.apply(doc);
                }
            }
            catch (CoreException e) {
                PHPUiPlugin.log(e);
            }
        }

        public String getDescription() {
            return this.fProposal.getAdditionalProposalInfo();
        }

        public Image getImage() {
            return this.fProposal.getImage();
        }
    }
}

