/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.astview.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.astview.views.ASTAttribute;
import org.eclipse.php.astview.views.Binding;
import org.eclipse.php.astview.views.CommentsProperty;
import org.eclipse.php.astview.views.NodeProperty;
import org.eclipse.php.astview.views.PhpElement;
import org.eclipse.php.astview.views.SettingsProperty;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.IBinding;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;

public class ASTViewContentProvider
implements ITreeContentProvider {
    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof ASTNode) {
            ASTNode node = (ASTNode)child;
            ASTNode parent = node.getParent();
            if (parent != null) {
                StructuralPropertyDescriptor prop = node.getLocationInParent();
                return new NodeProperty(parent, prop);
            }
        } else if (child instanceof ASTAttribute) {
            return ((ASTAttribute)child).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof ASTAttribute) {
            return ((ASTAttribute)parent).getChildren();
        }
        if (parent instanceof ASTNode) {
            return this.getNodeChildren((ASTNode)parent);
        }
        return new Object[0];
    }

    private Object[] getNodeChildren(ASTNode node) {
        ArrayList<Object> res = new ArrayList<Object>();
        if (node instanceof Expression) {
            Expression expression = (Expression)node;
            try {
                ITypeBinding expressionTypeBinding = expression.resolveTypeBinding();
                res.add(this.createExpressionTypeBinding(node, expressionTypeBinding));
            }
            catch (Exception expressionTypeBinding) {
                // empty catch block
            }
        }
        List list = node.structuralPropertiesForType();
        int i = 0;
        while (i < list.size()) {
            StructuralPropertyDescriptor curr = (StructuralPropertyDescriptor)list.get(i);
            res.add(new NodeProperty(node, curr));
            ++i;
        }
        if (node instanceof Program) {
            Program root = (Program)node;
            res.add(new PhpElement(root, root.getSourceModule()));
            res.add(new CommentsProperty(root));
            res.add(new SettingsProperty(root));
        }
        return res.toArray();
    }

    private Binding createBinding(ASTNode parent, IBinding binding) {
        String label = Binding.getBindingLabel(binding);
        return new Binding(parent, label, binding, true);
    }

    private Object createExpressionTypeBinding(ASTNode parent, ITypeBinding binding) {
        String label = "> (Expression) type binding";
        return new Binding(parent, label, (IBinding)binding, true);
    }

    public boolean hasChildren(Object parent) {
        return this.getChildren(parent).length > 0;
    }
}

