/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.buildpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.php.composer.core.ComposerPlugin;
import org.eclipse.php.composer.core.buildpath.BuildPathParser;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.core.resources.IComposerProject;
import org.eclipse.wst.validation.ValidationFramework;

public class BuildPathManager {
    private IComposerProject composerProject;
    private IPath[] exclusions;
    private IPath vendorPath;
    private IPath composerPath;

    public BuildPathManager(IComposerProject composerProject) {
        this.composerProject = composerProject;
    }

    public void update() throws CoreException {
        this.update((IProgressMonitor)new NullProgressMonitor());
    }

    public void update(IProgressMonitor monitor) throws CoreException {
        IPath[] inclusions;
        if (!this.composerProject.isValidComposerJson()) {
            Logger.log(1, "Stop BuildPathManager, composer.json invalid");
            return;
        }
        this.vendorPath = this.composerProject.getProject().getFullPath().append(this.composerProject.getVendorDir());
        this.composerPath = this.vendorPath.append("composer");
        IProject project = this.composerProject.getProject();
        IScriptProject scriptProject = this.composerProject.getScriptProject();
        BuildPathParser parser = new BuildPathParser(this.composerProject);
        List<BuildPathParser.BuildPathInfo> paths = parser.getPathsInfo();
        IEclipsePreferences prefs = ComposerPlugin.getDefault().getProjectPreferences(project);
        ArrayList<IPath> exs = new ArrayList<IPath>();
        try {
            String encoded = prefs.get("org.eclipse.php.composer.corebuildpath.includes.excludes", "");
            inclusions = scriptProject.decodeBuildpathEntry(encoded).getInclusionPatterns();
            exs.addAll(Arrays.asList(scriptProject.decodeBuildpathEntry(encoded).getExclusionPatterns()));
        }
        catch (Exception exception) {
            inclusions = new IPath[]{};
        }
        IPath[] iPathArray = inclusions;
        int n = inclusions.length;
        int n2 = 0;
        while (n2 < n) {
            IPath inclusion = iPathArray[n2];
            paths.add(new BuildPathParser.BuildPathInfo(inclusion.toString(), 2));
            ++n2;
        }
        Iterator eit = exs.iterator();
        while (eit.hasNext()) {
            String exc = ((IPath)eit.next()).removeTrailingSeparator().toString();
            Iterator<BuildPathParser.BuildPathInfo> it = paths.iterator();
            while (it.hasNext()) {
                BuildPathParser.BuildPathInfo info = it.next();
                if (!info.path.equals(exc)) continue;
                it.remove();
            }
        }
        this.exclusions = exs.toArray(new IPath[0]);
        ArrayList<IBuildpathEntry> buildPath = new ArrayList<IBuildpathEntry>(Arrays.asList(scriptProject.getRawBuildpath()));
        Iterator it = buildPath.iterator();
        while (it.hasNext()) {
            IBuildpathEntry entry = (IBuildpathEntry)it.next();
            if (entry.getEntryKind() != 3 || entry.getExtraAttribute("composer") == null) continue;
            it.remove();
        }
        Collections.sort(paths);
        Collections.sort(buildPath, new Comparator<IBuildpathEntry>(){

            @Override
            public int compare(IBuildpathEntry o1, IBuildpathEntry o2) {
                return o1.getPath().toString().compareTo(o2.getPath().toString());
            }
        });
        for (BuildPathParser.BuildPathInfo path : paths) {
            Path entry = new Path(path.path);
            IFolder folder = project.getFolder((IPath)entry);
            if (folder == null || !folder.exists()) continue;
            this.addPath(folder.getFullPath(), buildPath, path.type);
        }
        DLTKCore.create((IProject)project).setRawBuildpath(buildPath.toArray(new IBuildpathEntry[0]), monitor);
        IFolder folder = project.getFolder((IPath)new Path(this.composerProject.getVendorDir()));
        if (folder != null && folder.exists()) {
            if (!folder.isDerived()) {
                folder.setDerived(true, monitor);
            }
            ValidationFramework.getDefault().disableValidation((IResource)folder);
        }
    }

    private void addPath(IPath path, List<IBuildpathEntry> entries, int type) {
        IBuildpathEntry parent = null;
        int parentLength = 0;
        Iterator<IBuildpathEntry> it = entries.iterator();
        while (it.hasNext()) {
            IBuildpathEntry entry = it.next();
            if (entry.getEntryKind() != 3) continue;
            if (entry.getPath().equals((Object)path)) {
                it.remove();
                continue;
            }
            IPath entryPath = entry.getPath();
            if (!entryPath.isPrefixOf(path) || parent != null && entryPath.toString().length() <= parentLength) continue;
            parent = entry;
            parentLength = parent.getPath().toString().length();
        }
        if (parent != null) {
            ArrayList<IPath> exclusions = new ArrayList<IPath>();
            exclusions.addAll(Arrays.asList(parent.getExclusionPatterns()));
            IPath diff = path.removeFirstSegments(path.matchingFirstSegments(parent.getPath()));
            if (parent.getPath().equals((Object)this.composerPath)) {
                diff = diff.uptoSegment(1);
            }
            if (!exclusions.contains(diff = diff.removeTrailingSeparator().addTrailingSeparator())) {
                exclusions.add(diff);
            }
            entries.remove(parent);
            if (parent.getExtraAttribute("composer") != null) {
                parent = DLTKCore.newSourceEntry((IPath)parent.getPath(), (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])exclusions.toArray(new IPath[0]), (IBuildpathAttribute[])new IBuildpathAttribute[]{DLTKCore.newBuildpathAttribute((String)"composer", (String)parent.getExtraAttribute("composer"))});
                entries.add(parent);
            }
        }
        if (this.vendorPath.equals((Object)path) || this.composerPath.equals((Object)path)) {
            entries.add(DLTKCore.newSourceEntry((IPath)path, (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])BuildpathEntry.EXCLUDE_NONE, (IBuildpathAttribute[])new IBuildpathAttribute[]{DLTKCore.newBuildpathAttribute((String)"composer", (String)"vendor")}));
        } else {
            ArrayList<IPath> ex = new ArrayList<IPath>();
            IPath[] iPathArray = this.exclusions;
            int n = this.exclusions.length;
            int n2 = 0;
            while (n2 < n) {
                IPath exclusion = iPathArray[n2];
                if (!exclusion.toString().startsWith("*")) {
                    exclusion = this.composerProject.getProject().getFullPath().append(exclusion);
                }
                if (path.equals((Object)exclusion)) {
                    return;
                }
                if (path.removeTrailingSeparator().isPrefixOf(exclusion)) {
                    ex.add(exclusion.removeFirstSegments(path.matchingFirstSegments(exclusion)));
                } else if (exclusion.toString().startsWith("*")) {
                    ex.add(exclusion);
                }
                ++n2;
            }
            entries.add(DLTKCore.newSourceEntry((IPath)path, (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])ex.toArray(new IPath[0]), (IBuildpathAttribute[])new IBuildpathAttribute[]{DLTKCore.newBuildpathAttribute((String)"composer", (String)this.getTypeName(type))}));
        }
    }

    protected String getTypeName(int type) {
        switch (type) {
            case 2: {
                return "source";
            }
            case 4: {
                return "vendor";
            }
        }
        return null;
    }

    public static void setExclusionPattern(IScriptProject project, IBuildpathEntry entry) {
        try {
            String encoded = project.encodeBuildpathEntry(entry);
            IEclipsePreferences prefs = ComposerPlugin.getDefault().getProjectPreferences(project.getProject());
            prefs.put("org.eclipse.php.composer.corebuildpath.includes.excludes", encoded);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }
}

