/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.performance.selection;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.performance.AbstractPDTTTest;
import org.eclipse.php.core.tests.performance.PHPCorePerformanceTests;
import org.eclipse.php.core.tests.performance.PerformanceMonitor;
import org.eclipse.php.core.tests.performance.codeassist.CodeAssistPdttFile;
import org.eclipse.php.internal.core.PHPVersion;

public class SelectionEngineTestsWrapper
extends AbstractPDTTTest {
    protected static final char SELECTION_CHAR = '|';
    protected static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected IProject project;
    protected IFile testFile;
    private PerformanceMonitor perfMonitor;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/project/selection/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/project/selection/php53"});
    }

    public static void tearDownSuite() throws Exception {
    }

    public SelectionEngineTestsWrapper() {
        super("");
    }

    public Test suite(Map map) {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(map.get("project").toString());
        this.perfMonitor = PHPCorePerformanceTests.getPerformanceMonitor();
        TestSuite suite = new TestSuite("Auto Selection Engine Tests");
        PHPVersion phpVersion = (PHPVersion)map.get("phpVersion");
        String[] stringArray = TESTS.get(phpVersion);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String testsDirectory = stringArray[n2];
            testsDirectory = testsDirectory.replaceAll("project", map.get("project").toString());
            String[] stringArray2 = SelectionEngineTestsWrapper.getPDTTFiles(testsDirectory, PHPCorePerformanceTests.getDefault().getBundle());
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                final String fileName = stringArray2[n4];
                try {
                    final CodeAssistPdttFile pdttFile = new CodeAssistPdttFile(PHPCorePerformanceTests.getDefault().getBundle(), fileName);
                    SelectionEngineTests test = new SelectionEngineTests(this, fileName){

                        protected void setUp() throws Exception {
                        }

                        protected void tearDown() throws Exception {
                            if (testFile != null) {
                                testFile.delete(true, null);
                                testFile = null;
                            }
                        }

                        protected void runTest() throws Throwable {
                            perfMonitor.execute("PerformanceTests.testSelectionEngine_" + fileName, new PerformanceMonitor.Operation(){

                                @Override
                                public void run() throws Exception {
                                    IModelElement[] elements = this.getSelection(pdttFile.getFile());
                                }
                            }, 1, 10);
                        }
                    };
                    suite.addTest((Test)test);
                }
                catch (Exception e) {
                    suite.addTest((Test)new TestCase(fileName){

                        protected void runTest() throws Throwable {
                            throw e;
                        }
                    });
                }
                ++n4;
            }
            ++n2;
        }
        return suite;
    }

    protected SourceRange createFile(String data) throws Exception {
        int left = data.indexOf(124);
        if (left == -1) {
            throw new IllegalArgumentException("Selection characters are not set");
        }
        int right = (data = String.valueOf(data.substring(0, left)) + data.substring(left + 1)).indexOf(124);
        if (right == -1) {
            throw new IllegalArgumentException("Selection is not closed");
        }
        data = String.valueOf(data.substring(0, right)) + data.substring(right + 1);
        this.testFile = this.project.getFile("pdttest/test.php");
        this.testFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
        this.project.refreshLocal(1, null);
        this.project.build(10, null);
        TestUtils.waitForIndexer();
        return new SourceRange(left, right - left);
    }

    protected IModelElement[] getSelection(String data) throws Exception {
        SourceRange range = this.createFile(data);
        ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)this.testFile);
        IModelElement[] elements = sourceModule.codeSelect(range.getOffset(), range.getLength());
        return elements;
    }

    public class SelectionEngineTests
    extends AbstractPDTTTest {
        public SelectionEngineTests(String description) {
            super(description);
        }
    }
}

