/* The following code was generated by JFlex 1.6.1 */

/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/
/*nlsXXX*/
package org.eclipse.php.internal.core.documentModel.parser;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockMarker;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockTokenizer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.util.Debug;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.parser.ContextRegionContainer;
import org.eclipse.wst.xml.core.internal.parser.IntStack;
import org.eclipse.wst.xml.core.internal.parser.regions.XMLParserRegionFactory;
import org.eclipse.wst.xml.core.internal.regions.DOMRegionContext;



/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.6.1
 * from the specification file <tt>PHPTokenizer.jflex</tt>
 */
public class PHPTokenizer implements BlockTokenizer, PHPRegionContext, DOMRegionContext {

	/** This character denotes the end of file */
	public static final int YYEOF = -1;

	/** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

	/** lexical states */
  public static final int YYINITIAL = 0;
  public static final int ST_CDATA_TEXT = 2;
  public static final int ST_CDATA_END = 4;
  public static final int ST_XML_COMMENT = 6;
  public static final int ST_XML_COMMENT_END = 8;
  public static final int ST_PI = 10;
  public static final int ST_PI_WS = 12;
  public static final int ST_PI_CONTENT = 14;
  public static final int ST_XML_PI_ATTRIBUTE_NAME = 16;
  public static final int ST_XML_PI_EQUALS = 18;
  public static final int ST_XML_PI_ATTRIBUTE_VALUE = 20;
  public static final int ST_XML_PI_TAG_CLOSE = 22;
  public static final int ST_DHTML_ATTRIBUTE_NAME = 24;
  public static final int ST_DHTML_EQUALS = 26;
  public static final int ST_DHTML_ATTRIBUTE_VALUE = 28;
  public static final int ST_XML_TAG_NAME = 30;
  public static final int ST_XML_ATTRIBUTE_NAME = 32;
  public static final int ST_XML_EQUALS = 34;
  public static final int ST_XML_ATTRIBUTE_VALUE = 36;
  public static final int ST_XML_DECLARATION = 38;
  public static final int ST_XML_DECLARATION_CLOSE = 40;
  public static final int ST_XML_DOCTYPE_DECLARATION = 42;
  public static final int ST_XML_DOCTYPE_EXTERNAL_ID = 44;
  public static final int ST_XML_DOCTYPE_ID_PUBLIC = 46;
  public static final int ST_XML_DOCTYPE_ID_SYSTEM = 48;
  public static final int ST_XML_ELEMENT_DECLARATION = 50;
  public static final int ST_XML_ELEMENT_DECLARATION_CONTENT = 52;
  public static final int ST_XML_ATTLIST_DECLARATION = 54;
  public static final int ST_XML_ATTLIST_DECLARATION_CONTENT = 56;
  public static final int ST_BLOCK_TAG_SCAN = 58;
  public static final int ST_PHP_CONTENT = 60;
  public static final int ST_XML_ATTRIBUTE_VALUE_SQUOTED = 62;
  public static final int ST_XML_ATTRIBUTE_VALUE_DQUOTED = 64;
  public static final int ST_BLOCK_TAG_INTERNAL_SCAN = 66;
  public static final int ST_ABORT_EMBEDDED = 68;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 
    16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 
    24, 24, 25, 25, 26, 26, 27, 27, 28, 28, 29, 29, 30, 30, 31, 31, 
    32, 32, 33, 33, 33, 33
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\6\1\23\2\0\1\15\22\0\1\15\1\22\1\12\1\56"+
    "\1\17\1\20\1\13\1\14\1\17\1\17\1\17\1\17\1\17\1\10"+
    "\1\7\1\3\12\16\1\11\1\62\1\1\1\5\1\2\1\4\1\17"+
    "\1\27\1\63\1\25\1\26\1\45\1\60\1\34\1\70\1\40\1\34"+
    "\1\34\1\53\1\54\1\42\1\41\1\44\1\34\1\36\1\57\1\30"+
    "\1\61\2\34\1\52\1\43\1\34\1\24\1\0\1\21\1\0\1\11"+
    "\1\0\1\47\1\63\1\64\1\50\1\35\1\60\1\34\1\67\1\40"+
    "\2\34\1\33\1\32\1\42\1\41\1\44\1\34\1\36\1\37\1\46"+
    "\1\61\1\34\1\34\1\31\1\51\1\34\1\0\1\55\72\0\1\66"+
    "\10\0\27\65\1\0\37\65\1\0\72\65\2\0\13\65\2\0\10\65"+
    "\1\0\65\65\1\0\104\65\11\0\44\65\3\0\2\65\4\0\36\65"+
    "\70\0\131\65\22\0\7\65\16\0\2\66\56\0\106\66\32\0\2\66"+
    "\44\0\1\65\1\66\3\65\1\0\1\65\1\0\24\65\1\0\54\65"+
    "\1\0\7\65\3\0\1\65\1\0\1\65\1\0\1\65\1\0\1\65"+
    "\1\0\22\65\15\0\14\65\1\0\102\65\1\0\14\65\1\0\44\65"+
    "\1\0\4\66\11\0\65\65\2\0\2\65\2\0\2\65\3\0\34\65"+
    "\2\0\10\65\2\0\2\65\67\0\46\65\2\0\1\65\7\0\46\65"+
    "\12\0\21\66\1\0\27\66\1\0\3\66\1\0\1\66\1\0\2\66"+
    "\1\0\1\66\13\0\33\65\5\0\3\65\56\0\32\65\5\0\1\66"+
    "\12\65\10\66\15\0\12\66\6\0\1\66\107\65\2\0\5\65\1\0"+
    "\17\65\1\0\4\65\1\0\1\65\17\66\2\65\2\66\1\0\4\66"+
    "\2\0\12\66\u0207\0\3\66\1\0\65\65\2\0\1\66\1\65\20\66"+
    "\3\0\4\66\3\0\12\65\2\66\2\0\12\66\21\0\3\66\1\0"+
    "\10\65\2\0\2\65\2\0\26\65\1\0\7\65\1\0\1\65\3\0"+
    "\4\65\2\0\1\66\1\0\7\66\2\0\2\66\2\0\3\66\11\0"+
    "\1\66\4\0\2\65\1\0\3\65\2\66\2\0\12\66\2\65\20\0"+
    "\1\66\2\0\6\65\4\0\2\65\2\0\26\65\1\0\7\65\1\0"+
    "\2\65\1\0\2\65\1\0\2\65\2\0\1\66\1\0\5\66\4\0"+
    "\2\66\2\0\3\66\13\0\4\65\1\0\1\65\7\0\12\66\2\66"+
    "\3\65\14\0\3\66\1\0\7\65\1\0\1\65\1\0\3\65\1\0"+
    "\26\65\1\0\7\65\1\0\2\65\1\0\5\65\2\0\1\66\1\65"+
    "\10\66\1\0\3\66\1\0\3\66\22\0\1\65\5\0\12\66\21\0"+
    "\3\66\1\0\10\65\2\0\2\65\2\0\26\65\1\0\7\65\1\0"+
    "\2\65\2\0\4\65\2\0\1\66\1\65\6\66\3\0\2\66\2\0"+
    "\3\66\10\0\2\66\4\0\2\65\1\0\3\65\4\0\12\66\22\0"+
    "\2\66\1\0\6\65\3\0\3\65\1\0\4\65\3\0\2\65\1\0"+
    "\1\65\1\0\2\65\3\0\2\65\3\0\3\65\3\0\10\65\1\0"+
    "\3\65\4\0\5\66\3\0\3\66\1\0\4\66\11\0\1\66\17\0"+
    "\11\66\21\0\3\66\1\0\10\65\1\0\3\65\1\0\27\65\1\0"+
    "\12\65\1\0\5\65\4\0\7\66\1\0\3\66\1\0\4\66\7\0"+
    "\2\66\11\0\2\65\4\0\12\66\22\0\2\66\1\0\10\65\1\0"+
    "\3\65\1\0\27\65\1\0\12\65\1\0\5\65\4\0\7\66\1\0"+
    "\3\66\1\0\4\66\7\0\2\66\7\0\1\65\1\0\2\65\4\0"+
    "\12\66\22\0\2\66\1\0\10\65\1\0\3\65\1\0\27\65\1\0"+
    "\20\65\4\0\6\66\2\0\3\66\1\0\4\66\11\0\1\66\10\0"+
    "\2\65\4\0\12\66\221\0\56\65\1\0\1\65\1\66\2\65\7\66"+
    "\5\0\6\65\1\66\10\66\1\0\12\66\47\0\2\65\1\0\1\65"+
    "\2\0\2\65\1\0\1\65\2\0\1\65\6\0\4\65\1\0\7\65"+
    "\1\0\3\65\1\0\1\65\1\0\1\65\2\0\2\65\1\0\2\65"+
    "\1\0\1\65\1\66\2\65\6\66\1\0\2\66\1\65\2\0\5\65"+
    "\1\0\1\66\1\0\6\66\2\0\12\66\76\0\2\66\6\0\12\66"+
    "\13\0\1\66\1\0\1\66\1\0\1\66\4\0\2\66\10\65\1\0"+
    "\41\65\7\0\24\66\1\0\6\66\4\0\6\66\1\0\1\66\1\0"+
    "\25\66\3\0\7\66\1\0\1\66\346\0\46\65\12\0\47\65\11\0"+
    "\1\65\1\0\2\65\1\0\3\65\1\0\1\65\1\0\2\65\1\0"+
    "\5\65\51\0\1\65\1\0\1\65\1\0\1\65\13\0\1\65\1\0"+
    "\1\65\1\0\1\65\3\0\2\65\3\0\1\65\5\0\3\65\1\0"+
    "\1\65\1\0\1\65\1\0\1\65\1\0\1\65\3\0\2\65\3\0"+
    "\2\65\1\0\1\65\50\0\1\65\11\0\1\65\2\0\1\65\2\0"+
    "\2\65\7\0\2\65\1\0\1\65\1\0\7\65\50\0\1\65\4\0"+
    "\1\65\10\0\1\65\u0c06\0\234\65\4\0\132\65\6\0\26\65\2\0"+
    "\6\65\2\0\46\65\2\0\6\65\2\0\10\65\1\0\1\65\1\0"+
    "\1\65\1\0\1\65\1\0\37\65\2\0\65\65\1\0\7\65\1\0"+
    "\1\65\3\0\3\65\1\0\7\65\3\0\4\65\2\0\6\65\4\0"+
    "\15\65\5\0\3\65\1\0\7\65\323\0\15\66\4\0\1\66\104\0"+
    "\1\65\3\0\2\65\2\0\1\65\121\0\3\65\u0e82\0\1\66\1\0"+
    "\1\65\31\0\11\65\6\66\1\0\5\66\13\0\124\65\4\0\2\66"+
    "\2\0\2\66\2\0\132\65\1\0\3\66\6\0\50\65\u1cd3\0\u51a6\65"+
    "\u0c5a\0\u2ba4\65\134\0\u0800\0\u1ffe\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\22\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\1\4\0\1\2\2\0\3\2\3\0\1\3\1\4"+
    "\12\2\1\5\1\2\1\6\5\0\1\1\1\7\2\10"+
    "\2\11\3\10\1\12\2\13\2\10\1\2\4\14\1\15"+
    "\3\16\1\10\1\17\1\20\1\21\1\10\1\21\3\10"+
    "\1\22\1\10\1\23\1\24\1\3\1\10\2\3\1\4"+
    "\1\25\1\10\2\26\1\7\1\27\1\30\1\31\1\7"+
    "\1\10\1\32\1\33\1\7\1\34\4\10\1\35\2\10"+
    "\1\36\1\10\3\36\1\37\1\10\3\37\1\40\1\10"+
    "\2\40\2\5\1\41\1\42\1\10\2\42\2\6\1\43"+
    "\2\44\3\45\1\46\1\47\1\50\1\46\1\51\1\52"+
    "\2\53\1\54\1\0\1\1\1\0\1\1\3\0\1\55"+
    "\3\14\1\56\1\57\2\0\1\21\6\0\1\3\2\0"+
    "\1\60\1\61\1\0\1\62\1\0\1\31\6\0\1\63"+
    "\5\0\2\36\2\0\2\36\2\0\1\63\3\0\1\37"+
    "\3\0\1\63\3\0\2\40\2\0\2\40\1\0\2\53"+
    "\1\5\3\0\2\42\2\0\2\42\1\0\2\53\1\6"+
    "\1\64\1\65\3\0\2\1\1\66\2\0\1\67\1\70"+
    "\1\71\2\72\1\14\6\0\1\36\2\0\1\40\1\0"+
    "\2\5\1\0\1\42\1\0\2\6\1\0\1\73\1\0"+
    "\1\1\1\74\1\0\2\14\7\0\2\5\1\0\2\6"+
    "\2\0\2\14\5\0\2\5\2\6\1\53\1\0\1\14"+
    "\1\75\3\0\1\76\1\77\1\53\1\5\1\53\1\6"+
    "\1\0\1\14\1\100\1\101\1\102\1\5\1\6\1\0"+
    "\1\14\1\5\1\6\1\103\1\14\2\103\4\14\1\104";

  private static int [] zzUnpackAction() {
    int [] result = new int[320];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\71\0\162\0\253\0\344\0\u011d\0\u0156\0\u018f"+
    "\0\u01c8\0\u0201\0\u023a\0\u0273\0\u02ac\0\u02e5\0\u031e\0\u0357"+
    "\0\u0390\0\u03c9\0\u0402\0\u043b\0\u0474\0\u04ad\0\u04e6\0\u051f"+
    "\0\u0558\0\u0591\0\u05ca\0\u0603\0\u063c\0\u0675\0\u06ae\0\u06e7"+
    "\0\u0720\0\u0759\0\u0792\0\u07cb\0\u0804\0\u083d\0\u0876\0\u08af"+
    "\0\u0876\0\u08af\0\u08e8\0\u0876\0\u0876\0\u08af\0\u0921\0\u095a"+
    "\0\u0993\0\u09cc\0\u0a05\0\u0a3e\0\u0a77\0\u0ab0\0\u0876\0\u08af"+
    "\0\u0ae9\0\u0b22\0\u0b5b\0\u0876\0\u0b94\0\u0b94\0\u0bcd\0\u0c06"+
    "\0\u0c3f\0\u0ae9\0\u0876\0\u0c78\0\u0cb1\0\u0876\0\u0cea\0\u0d23"+
    "\0\u0d5c\0\u0d95\0\u0dce\0\u0876\0\u0e07\0\u0e40\0\u0e79\0\u0eb2"+
    "\0\u0eeb\0\u0876\0\u0f24\0\u0f5d\0\u0f96\0\u0fcf\0\u1008\0\u1041"+
    "\0\u0876\0\u107a\0\u10b3\0\u10ec\0\u1125\0\u115e\0\u1197\0\u11d0"+
    "\0\u1209\0\u1209\0\u1242\0\u127b\0\u12b4\0\u12ed\0\u12ed\0\u1326"+
    "\0\u135f\0\u1398\0\u13d1\0\u13d1\0\u140a\0\u1443\0\u147c\0\u14b5"+
    "\0\u0876\0\u14ee\0\u14ee\0\u1527\0\u1560\0\u1599\0\u15d2\0\u0876"+
    "\0\u0876\0\u08af\0\u0876\0\u08af\0\u160b\0\u1644\0\u167d\0\u0876"+
    "\0\u16b6\0\u0876\0\u0876\0\u16ef\0\u0876\0\u1728\0\u1761\0\u179a"+
    "\0\u17d3\0\u180c\0\u1845\0\u187e\0\u18b7\0\u0876\0\u18f0\0\u1929"+
    "\0\u1962\0\u0876\0\u0876\0\u0b94\0\u0c06\0\u0876\0\u0c3f\0\u0c78"+
    "\0\u0cea\0\u0d23\0\u199b\0\u0d5c\0\u0876\0\u19d4\0\u0d95\0\u0876"+
    "\0\u1a0d\0\u0f24\0\u1a46\0\u0fcf\0\u0876\0\u1008\0\u1728\0\u1a7f"+
    "\0\u1ab8\0\u1af1\0\u1125\0\u0876\0\u1b2a\0\u1b63\0\u1209\0\u1b9c"+
    "\0\u1242\0\u0876\0\u1bd5\0\u1c0e\0\u1c47\0\u1c47\0\u1c80\0\u1cb9"+
    "\0\u12b4\0\u1209\0\u12ed\0\u1cf2\0\u1326\0\u0876\0\u1d2b\0\u135f"+
    "\0\u1398\0\u12ed\0\u13d1\0\u1d64\0\u140a\0\u0876\0\u1d9d\0\u1dd6"+
    "\0\u1e0f\0\u1e0f\0\u1e48\0\u1e81\0\u1eba\0\u147c\0\u1ef3\0\u14ee"+
    "\0\u1f2c\0\u1527\0\u0876\0\u1f65\0\u1f9e\0\u1fd7\0\u1fd7\0\u2010"+
    "\0\u2049\0\u2082\0\u1599\0\u20bb\0\u0876\0\u0876\0\u20f4\0\u212d"+
    "\0\u2166\0\u219f\0\u21d8\0\u0876\0\u2211\0\u224a\0\u0876\0\u0876"+
    "\0\u0876\0\u2283\0\u09cc\0\u22bc\0\u22f5\0\u232e\0\u2367\0\u23a0"+
    "\0\u23d9\0\u1bd5\0\u2412\0\u2412\0\u1d9d\0\u244b\0\u244b\0\u2484"+
    "\0\u24bd\0\u1f65\0\u24f6\0\u24f6\0\u252f\0\u2568\0\u25a1\0\u0876"+
    "\0\u25da\0\u2613\0\u0876\0\u264c\0\u2685\0\u26be\0\u26f7\0\u2730"+
    "\0\u2769\0\u27a2\0\u27db\0\u1c80\0\u1e48\0\u2814\0\u284d\0\u2010"+
    "\0\u2886\0\u28bf\0\u28f8\0\u2931\0\u296a\0\u29a3\0\u29dc\0\u2a15"+
    "\0\u2a4e\0\u2a87\0\u2ac0\0\u2af9\0\u2b32\0\u2b6b\0\u2ba4\0\u28f8"+
    "\0\u2bdd\0\u2c16\0\u09cc\0\u2c4f\0\u2c88\0\u2cc1\0\u0876\0\u0876"+
    "\0\u2af9\0\u2cfa\0\u2b6b\0\u2d33\0\u2d6c\0\u2da5\0\u0876\0\u0876"+
    "\0\u0876\0\u2dde\0\u2e17\0\u2e50\0\u2e89\0\u2ec2\0\u2efb\0\u0876"+
    "\0\u2f34\0\u147c\0\u1599\0\u2f6d\0\u2fa6\0\u2fdf\0\u3018\0\u09cc";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[320];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\43\1\44\11\43\1\45\4\43\1\46\50\43\1\47"+
    "\1\50\67\47\1\51\1\52\17\51\1\53\1\51\1\54"+
    "\45\51\1\55\1\56\67\55\1\51\1\52\6\51\1\57"+
    "\12\51\1\54\46\51\1\52\2\51\1\60\1\51\1\61"+
    "\2\51\1\62\3\51\1\61\5\51\1\61\1\51\4\62"+
    "\1\63\6\62\1\64\11\62\1\65\2\62\2\51\3\62"+
    "\1\51\3\62\1\51\2\62\1\51\1\52\2\51\1\60"+
    "\1\51\1\66\6\51\1\66\5\51\1\66\45\51\1\67"+
    "\1\70\2\67\1\71\16\67\1\54\45\67\1\51\1\52"+
    "\2\51\1\72\1\51\1\61\2\51\1\73\3\51\1\61"+
    "\5\51\1\61\1\51\30\73\2\51\3\73\1\51\3\73"+
    "\1\51\2\73\1\51\1\52\2\51\1\72\1\74\1\61"+
    "\2\51\1\73\3\51\1\61\5\51\1\61\1\51\30\73"+
    "\2\51\3\73\1\51\3\73\1\51\2\73\1\75\1\52"+
    "\1\51\1\76\1\77\1\75\1\61\3\75\1\100\1\75"+
    "\1\101\1\61\5\75\1\61\45\75\1\51\1\52\2\51"+
    "\1\102\16\51\1\54\46\51\1\52\1\103\1\104\5\51"+
    "\1\105\11\51\1\54\1\51\30\105\2\51\3\105\1\51"+
    "\3\105\1\51\2\105\1\51\1\52\1\103\1\104\1\51"+
    "\1\106\3\51\1\105\11\51\1\54\1\51\30\105\2\51"+
    "\3\105\1\51\3\105\1\51\2\105\1\107\1\52\1\103"+
    "\1\110\2\107\1\51\3\107\1\111\1\107\1\112\1\51"+
    "\5\107\1\54\45\107\1\113\1\44\1\114\1\115\5\113"+
    "\1\116\13\113\30\117\2\113\3\117\1\113\3\117\1\113"+
    "\2\117\1\51\1\120\1\114\1\115\2\51\1\61\2\51"+
    "\1\121\3\51\1\61\5\51\1\61\1\51\30\121\2\51"+
    "\3\121\1\51\3\121\1\51\2\121\1\51\1\120\1\114"+
    "\1\115\1\51\1\122\1\61\2\51\1\121\3\51\1\61"+
    "\5\51\1\61\1\51\30\121\2\51\3\121\1\51\3\121"+
    "\1\51\2\121\1\123\1\124\1\114\1\125\2\123\1\61"+
    "\3\123\1\126\1\123\1\127\1\61\5\123\1\61\45\123"+
    "\1\51\1\130\1\131\3\51\1\61\6\51\1\61\5\51"+
    "\1\61\2\51\1\132\1\133\5\51\1\134\7\51\1\134"+
    "\1\51\1\133\1\132\21\51\1\52\1\131\3\51\1\61"+
    "\6\51\1\61\5\51\1\61\1\135\45\51\1\52\1\131"+
    "\3\51\1\61\2\51\1\136\3\51\1\61\5\51\1\61"+
    "\1\135\30\136\2\51\3\136\1\51\3\136\1\51\2\136"+
    "\1\51\1\52\1\131\3\51\1\61\6\51\1\61\5\51"+
    "\1\61\1\135\12\51\1\137\4\51\1\140\12\51\1\137"+
    "\11\51\1\141\1\52\1\131\1\142\2\141\1\61\3\141"+
    "\1\143\1\141\1\144\1\61\5\141\1\61\1\145\44\141"+
    "\1\146\1\52\1\131\1\147\2\146\1\61\3\146\1\150"+
    "\1\146\1\151\1\61\5\146\1\61\1\152\44\146\1\153"+
    "\1\52\1\131\1\154\2\153\1\61\3\153\1\155\1\153"+
    "\1\156\1\61\5\153\1\61\45\153\1\157\1\160\1\161"+
    "\66\157\1\162\1\52\1\131\1\163\2\162\1\61\3\162"+
    "\1\164\1\162\1\165\1\61\5\162\1\61\45\162\1\166"+
    "\1\167\1\170\66\166\1\171\1\172\67\171\1\173\1\174"+
    "\2\173\1\175\13\173\1\175\50\173\1\176\1\177\12\176"+
    "\1\200\54\176\1\201\1\177\10\201\1\202\56\201\1\51"+
    "\1\52\21\51\1\54\45\51\1\43\1\0\11\43\1\0"+
    "\4\43\1\0\50\43\3\0\1\203\1\204\13\0\1\205"+
    "\1\0\1\206\54\0\1\207\2\0\1\210\3\0\1\207"+
    "\5\0\1\207\1\0\30\210\1\0\1\211\3\210\1\0"+
    "\3\210\1\0\2\210\6\0\1\207\2\0\1\212\3\0"+
    "\1\207\5\0\1\207\1\0\30\212\2\0\3\212\1\0"+
    "\3\212\1\0\2\212\75\0\1\204\13\0\1\205\1\0"+
    "\1\213\67\0\1\214\57\0\1\215\62\0\1\216\74\0"+
    "\1\61\6\0\1\61\5\0\1\61\54\0\3\62\4\0"+
    "\1\62\6\0\30\62\2\0\3\62\1\0\6\62\7\0"+
    "\3\62\4\0\1\62\6\0\5\62\1\217\21\62\1\220"+
    "\2\0\3\62\1\0\6\62\7\0\3\62\4\0\1\62"+
    "\6\0\5\62\1\221\21\62\1\221\2\0\3\62\1\0"+
    "\6\62\7\0\3\62\4\0\1\62\6\0\5\62\1\220"+
    "\21\62\1\220\2\0\3\62\1\0\6\62\6\0\1\66"+
    "\6\0\1\66\5\0\1\66\47\0\1\222\70\0\1\223"+
    "\75\0\3\73\4\0\1\73\6\0\30\73\2\0\3\73"+
    "\1\0\6\73\1\75\2\0\1\224\2\75\1\0\3\75"+
    "\1\0\1\75\2\0\5\75\1\0\46\75\1\0\1\223"+
    "\1\224\2\75\1\0\3\75\1\0\1\75\2\0\5\75"+
    "\1\0\45\75\1\225\1\0\10\225\1\226\56\225\1\227"+
    "\1\0\12\227\1\226\54\227\2\0\1\103\1\230\74\0"+
    "\3\105\4\0\1\105\6\0\30\105\2\0\3\105\1\0"+
    "\6\105\1\107\2\0\1\231\2\107\1\0\3\107\1\0"+
    "\1\107\2\0\5\107\1\0\46\107\1\0\1\103\1\232"+
    "\2\107\1\0\3\107\1\0\1\107\2\0\5\107\1\0"+
    "\45\107\1\111\1\0\1\233\1\234\2\111\1\233\3\111"+
    "\1\235\1\111\2\233\5\111\1\233\45\111\1\112\1\0"+
    "\1\236\1\237\2\112\1\236\3\112\1\236\1\112\1\235"+
    "\1\236\5\112\1\236\45\112\1\113\3\0\21\113\30\0"+
    "\2\113\3\0\1\113\3\0\1\113\4\0\1\240\66\0"+
    "\1\113\3\0\3\113\3\116\4\113\1\116\6\113\30\117"+
    "\2\113\3\117\1\113\3\117\1\116\2\117\7\0\3\117"+
    "\4\0\1\117\6\0\30\117\2\0\3\117\1\0\6\117"+
    "\3\0\1\203\1\204\4\0\1\241\6\0\1\205\1\0"+
    "\1\206\2\0\30\241\2\0\3\241\1\0\3\241\1\0"+
    "\2\241\7\0\3\121\4\0\1\121\6\0\30\121\2\0"+
    "\3\121\1\0\6\121\1\123\2\0\1\242\2\123\1\0"+
    "\3\123\1\0\1\123\2\0\5\123\1\0\45\123\3\0"+
    "\1\203\1\204\4\0\1\243\6\0\1\205\1\0\1\206"+
    "\2\0\30\243\2\0\3\243\1\0\3\243\1\0\2\243"+
    "\1\123\1\0\1\240\1\242\2\123\1\0\3\123\1\0"+
    "\1\123\2\0\5\123\1\0\45\123\1\244\1\0\10\244"+
    "\1\245\56\244\1\246\1\0\12\246\1\245\54\246\3\0"+
    "\1\203\1\204\13\0\1\205\1\0\1\247\107\0\1\250"+
    "\57\0\1\251\15\0\1\251\55\0\1\252\17\0\1\252"+
    "\15\0\21\253\1\254\47\253\7\0\3\136\4\0\1\136"+
    "\6\0\30\136\2\0\3\136\1\0\6\136\43\0\1\255"+
    "\5\0\1\255\100\0\1\256\7\0\1\141\2\0\1\257"+
    "\2\141\1\0\3\141\1\0\1\141\2\0\5\141\1\0"+
    "\45\141\1\143\1\0\1\260\1\261\2\143\1\260\3\143"+
    "\1\262\1\143\2\260\5\143\1\260\45\143\1\263\1\0"+
    "\1\264\1\265\2\266\1\264\3\266\1\264\1\263\1\267"+
    "\1\270\3\266\1\263\1\266\1\270\1\263\30\266\1\263"+
    "\7\266\2\263\2\266\1\145\2\253\1\271\2\145\1\253"+
    "\3\145\1\253\1\145\2\253\3\145\1\272\1\145\1\253"+
    "\45\145\1\146\2\0\1\273\2\146\1\0\3\146\1\0"+
    "\1\146\2\0\5\146\1\0\45\146\1\150\2\274\1\275"+
    "\2\150\1\274\3\150\1\276\1\150\2\274\5\150\1\274"+
    "\45\150\1\151\2\277\1\300\2\151\1\277\3\151\1\277"+
    "\1\151\1\276\1\277\5\151\1\277\45\151\1\152\2\253"+
    "\1\301\2\152\1\253\3\152\1\253\1\152\2\253\3\152"+
    "\1\302\1\152\1\253\45\152\1\153\2\0\1\303\2\153"+
    "\1\0\3\153\1\0\1\153\2\0\5\153\1\0\45\153"+
    "\1\155\1\0\1\304\1\305\2\155\1\304\3\155\1\306"+
    "\1\155\2\304\5\155\1\304\45\155\1\307\1\0\1\310"+
    "\1\311\2\312\1\310\3\312\1\310\1\307\1\313\1\314"+
    "\3\312\1\307\1\312\1\314\1\307\30\312\1\307\7\312"+
    "\2\307\2\312\2\157\1\0\70\157\1\0\1\157\1\315"+
    "\13\157\1\316\1\157\1\317\46\157\1\162\2\0\1\320"+
    "\2\162\1\0\3\162\1\0\1\162\2\0\5\162\1\0"+
    "\45\162\1\164\1\0\1\321\1\322\2\164\1\321\3\164"+
    "\1\323\1\164\2\321\5\164\1\321\45\164\1\324\1\0"+
    "\1\325\1\326\2\327\1\325\3\327\1\325\1\324\1\330"+
    "\1\331\3\327\1\324\1\327\1\331\1\324\30\327\1\324"+
    "\7\327\2\324\2\327\2\166\1\0\70\166\1\0\1\166"+
    "\1\332\13\166\1\333\1\166\1\334\46\166\2\0\1\335"+
    "\66\0\1\176\1\0\12\176\1\0\54\176\3\0\1\336"+
    "\1\204\13\0\1\205\1\0\1\213\46\0\1\201\1\0"+
    "\10\201\1\0\56\201\5\0\1\205\36\0\1\337\34\0"+
    "\1\340\13\0\1\341\52\0\1\207\2\0\1\43\3\0"+
    "\1\207\5\0\1\207\1\0\30\43\2\0\3\43\1\0"+
    "\3\43\1\0\2\43\1\342\1\0\4\342\1\343\3\210"+
    "\1\342\1\0\1\342\1\343\1\210\1\342\1\0\2\342"+
    "\1\343\1\342\30\210\2\342\3\210\1\344\6\210\16\0"+
    "\1\345\12\0\1\346\37\0\1\342\1\0\4\342\1\343"+
    "\3\212\1\342\1\0\1\342\1\343\1\212\1\342\1\0"+
    "\2\342\1\343\1\342\30\212\2\342\3\212\1\347\6\212"+
    "\24\0\1\341\46\0\1\350\70\0\1\351\75\0\3\62"+
    "\4\0\1\62\6\0\6\62\1\352\17\62\1\353\1\62"+
    "\2\0\3\62\1\0\6\62\7\0\3\62\4\0\1\62"+
    "\6\0\6\62\1\353\17\62\1\353\1\62\2\0\3\62"+
    "\1\0\6\62\7\0\3\62\4\0\1\62\6\0\17\62"+
    "\1\354\10\62\2\0\3\62\1\0\6\62\1\233\1\0"+
    "\10\233\1\235\56\233\1\236\1\0\12\236\1\235\54\236"+
    "\7\0\3\241\4\0\1\241\6\0\30\241\2\0\3\241"+
    "\1\0\6\241\7\0\3\243\4\0\1\243\6\0\30\243"+
    "\2\0\3\243\1\0\6\243\25\0\1\355\36\0\1\355"+
    "\34\0\1\356\15\0\1\356\57\0\1\357\7\0\1\357"+
    "\62\0\1\360\17\0\1\360\74\0\1\361\5\0\1\260"+
    "\1\0\10\260\1\262\56\260\1\263\1\0\1\264\1\362"+
    "\2\263\1\264\3\263\1\264\1\263\1\262\1\264\5\263"+
    "\1\264\45\263\1\264\1\0\12\264\1\262\54\264\1\263"+
    "\1\0\1\264\1\362\2\263\1\264\3\263\1\264\1\263"+
    "\1\363\1\264\5\263\1\264\45\263\14\0\1\364\54\0"+
    "\1\264\1\0\12\264\1\363\54\264\12\274\1\276\56\274"+
    "\14\277\1\276\54\277\1\304\1\0\10\304\1\306\56\304"+
    "\1\307\1\0\1\310\1\365\2\307\1\310\3\307\1\310"+
    "\1\307\1\306\1\310\5\307\1\310\45\307\1\310\1\0"+
    "\12\310\1\306\54\310\1\307\1\0\1\310\1\365\2\307"+
    "\1\310\3\307\1\310\1\307\1\366\1\310\5\307\1\310"+
    "\45\307\14\0\1\367\54\0\1\310\1\0\12\310\1\366"+
    "\54\310\2\157\1\0\2\157\1\316\36\157\1\370\26\157"+
    "\1\0\21\157\1\371\44\157\1\321\1\0\10\321\1\323"+
    "\56\321\1\324\1\0\1\325\1\372\2\324\1\325\3\324"+
    "\1\325\1\324\1\323\1\325\5\324\1\325\45\324\1\325"+
    "\1\0\12\325\1\323\54\325\1\324\1\0\1\325\1\372"+
    "\2\324\1\325\3\324\1\325\1\324\1\373\1\325\5\324"+
    "\1\325\45\324\14\0\1\374\54\0\1\325\1\0\12\325"+
    "\1\373\54\325\2\166\1\0\2\166\1\333\36\166\1\375"+
    "\26\166\1\0\21\166\1\376\44\166\67\0\2\377\10\0"+
    "\1\u0100\105\0\1\u0101\43\0\1\342\1\0\11\342\1\0"+
    "\4\342\1\0\41\342\1\0\7\342\1\0\4\342\1\343"+
    "\4\342\1\0\1\342\1\343\2\342\1\0\2\342\1\343"+
    "\36\342\1\u0102\6\342\16\0\1\345\43\0\1\u0103\24\0"+
    "\1\u0104\6\0\3\u0104\5\0\1\u0104\7\0\1\u0104\1\0"+
    "\2\u0104\7\0\1\u0104\2\0\2\u0104\13\0\1\62\1\u0105"+
    "\1\62\4\0\1\62\6\0\30\62\2\0\3\62\1\0"+
    "\6\62\7\0\3\62\4\0\1\62\6\0\14\62\1\u0106"+
    "\13\62\2\0\3\62\1\0\6\62\30\0\1\u0107\15\0"+
    "\1\u0107\55\0\1\u0108\17\0\1\u0108\47\0\1\u0109\21\0"+
    "\1\u0109\44\0\1\u010a\15\0\1\u010a\55\0\1\u010b\17\0"+
    "\1\u010b\20\0\3\u010c\1\0\3\u010c\2\0\1\267\4\u010c"+
    "\1\0\2\u010c\1\0\30\u010c\1\0\7\u010c\2\0\2\u010c"+
    "\3\0\3\u010d\1\0\3\u010d\2\0\1\313\4\u010d\1\0"+
    "\2\u010d\1\0\30\u010d\1\0\7\u010d\2\0\2\u010d\2\157"+
    "\1\0\64\157\2\u010e\2\157\1\0\22\157\1\u010f\43\157"+
    "\3\0\3\u0110\1\0\3\u0110\2\0\1\330\4\u0110\1\0"+
    "\2\u0110\1\0\30\u0110\1\0\7\u0110\2\0\2\u0110\2\166"+
    "\1\0\64\166\2\u0111\2\166\1\0\22\166\1\u0112\43\166"+
    "\44\0\1\u0113\10\0\1\u0113\41\0\1\u0114\124\0\1\u0102"+
    "\24\0\1\u0104\6\0\3\u0104\5\0\1\u0104\7\0\1\u0104"+
    "\1\0\2\u0104\7\0\1\u0104\1\0\1\u0103\2\u0104\13\0"+
    "\3\62\4\0\1\62\6\0\12\62\1\u0115\15\62\2\0"+
    "\3\62\1\0\6\62\7\0\3\62\4\0\1\62\6\0"+
    "\11\62\1\u0116\16\62\2\0\3\62\1\0\6\62\43\0"+
    "\1\u0117\5\0\1\u0117\57\0\1\u0118\65\0\1\u0119\7\0"+
    "\1\u0119\60\0\1\u011a\7\0\1\u011a\63\0\1\u011b\30\0"+
    "\2\157\1\0\41\157\1\u011c\10\157\1\u011c\15\157\1\0"+
    "\23\157\1\u011d\42\157\2\166\1\0\41\166\1\u011e\10\166"+
    "\1\u011e\15\166\1\0\23\166\1\u011f\42\166\6\0\1\u0120"+
    "\6\0\1\u0120\5\0\1\u0120\74\0\1\u0121\50\0\3\62"+
    "\4\0\1\62\6\0\21\62\1\u0122\6\62\2\0\3\62"+
    "\1\0\6\62\7\0\3\62\4\0\1\62\6\0\3\62"+
    "\1\u0123\15\62\1\u0123\6\62\2\0\3\62\1\0\6\62"+
    "\44\0\1\u0124\63\0\1\u0125\17\0\1\u0125\53\0\1\u0126"+
    "\60\0\1\u0127\21\0\1\u0127\41\0\1\u0128\36\0\1\u0128"+
    "\4\0\2\157\1\0\3\157\1\u0129\6\157\1\u0129\5\157"+
    "\1\u0129\47\157\1\0\24\157\1\u012a\41\157\2\166\1\0"+
    "\3\166\1\u012b\6\166\1\u012b\5\166\1\u012b\47\166\1\0"+
    "\24\166\1\u012c\41\166\30\0\1\u012d\47\0\3\62\4\0"+
    "\1\62\6\0\24\62\1\u012e\3\62\2\0\3\62\1\0"+
    "\6\62\35\0\1\u012f\7\0\1\u012f\53\0\1\u0130\15\0"+
    "\1\u0130\52\0\1\u0131\15\0\1\u0131\22\0\2\157\1\0"+
    "\25\157\1\u0132\40\157\2\166\1\0\25\166\1\u0133\40\166"+
    "\27\0\1\u0134\50\0\3\62\4\0\1\62\6\0\6\62"+
    "\1\u0135\21\62\2\0\3\62\1\0\6\62\2\157\1\0"+
    "\24\157\1\u0136\41\157\2\166\1\0\24\166\1\u0137\41\166"+
    "\24\0\1\u0138\53\0\3\62\4\0\1\62\6\0\10\62"+
    "\1\u0139\17\62\2\0\3\62\1\0\6\62\2\157\1\0"+
    "\21\157\1\u013a\44\157\2\166\1\0\21\166\1\u013b\44\166"+
    "\7\0\3\62\4\0\1\62\6\0\12\62\1\u013c\15\62"+
    "\2\0\3\62\1\0\6\62\7\0\3\62\4\0\1\62"+
    "\6\0\30\62\2\0\3\62\1\0\4\62\1\u013d\1\62"+
    "\7\0\3\62\4\0\1\62\6\0\10\62\1\u013e\17\62"+
    "\2\0\3\62\1\0\6\62\7\0\3\62\4\0\1\62"+
    "\6\0\10\62\1\u013f\17\62\2\0\3\62\1\0\6\62"+
    "\7\0\3\62\4\0\1\62\6\0\21\62\1\u0140\6\62"+
    "\2\0\3\62\1\0\6\62";

  private static int [] zzUnpackTrans() {
    int [] result = new int[12369];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


	/* error codes */
	private static final int ZZ_UNKNOWN_ERROR = 0;
	private static final int ZZ_NO_MATCH = 1;
	private static final int ZZ_PUSHBACK_2BIG = 2;

	/* error messages for the codes above */
	private static final String ZZ_ERROR_MSG[] = {
		"Unknown internal scanner error",		//$NON-NLS-1$
		"Error: could not match input",			//$NON-NLS-1$
		"Error: pushback value was too large"	//$NON-NLS-1$
	};

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\1\4\0\1\1\2\0\3\1\3\0\17\1\5\0"+
    "\4\1\1\11\1\1\1\11\2\1\2\11\11\1\1\11"+
    "\4\1\1\11\6\1\1\11\2\1\1\11\5\1\1\11"+
    "\5\1\1\11\6\1\1\11\27\1\1\11\6\1\2\11"+
    "\1\1\1\11\4\1\1\11\1\1\2\11\1\1\1\11"+
    "\1\1\1\0\1\1\1\0\1\1\3\0\1\11\3\1"+
    "\2\11\2\0\1\11\6\0\1\11\2\0\1\11\1\1"+
    "\1\0\1\1\1\0\1\11\6\0\1\11\5\0\1\11"+
    "\1\1\2\0\2\1\2\0\1\1\3\0\1\11\3\0"+
    "\1\1\3\0\1\11\1\1\2\0\2\1\1\0\3\1"+
    "\3\0\1\11\1\1\2\0\2\1\1\0\3\1\2\11"+
    "\3\0\2\1\1\11\2\0\3\11\3\1\6\0\1\1"+
    "\2\0\1\1\1\0\2\1\1\0\1\1\1\0\2\1"+
    "\1\0\1\11\1\0\1\1\1\11\1\0\2\1\7\0"+
    "\2\1\1\0\2\1\2\0\2\1\5\0\5\1\1\0"+
    "\2\1\3\0\2\11\4\1\1\0\1\1\3\11\2\1"+
    "\1\0\3\1\1\11\10\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[320];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

	/** the input device */
	private java.io.Reader zzReader;

	/** the current state of the DFA */
	private int zzState;

	/** the current lexical state */
	private int zzLexicalState = YYINITIAL;

	/** this buffer contains the current text to be matched and is
		the source of the yytext() string */
	private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

	/** the textposition at the last accepting state */
	private int zzMarkedPos;

	/** the current text position in the buffer */
	private int zzCurrentPos;

	/** startRead marks the beginning of the yytext() string in the buffer */
	private int zzStartRead;

	/** endRead marks the last character in the buffer, that has been read
		from input */
	private int zzEndRead;

	/** number of newlines encountered up to the start of the matched text */
	private int yyline;

	/** the number of characters up to the start of the matched text */
	private int yychar;

	/**
	 * the number of characters from the last newline up to the start of the
	 * matched text
	 */
	//private int yycolumn;

	/**
	 * zzAtBOL == true <=> the scanner is currently at the beginning of a line
	 */
	//private boolean zzAtBOL = true;

	/** zzAtEOF == true <=> the scanner is at the EOF */
	private boolean zzAtEOF;

	/** denotes if the user-EOF-code has already been executed */
	private boolean zzEOFDone;

	/**
	 * The number of occupied positions in zzBuffer beyond zzEndRead.
	 * When a lead/high surrogate has been read from the input stream
	 * into the final zzBuffer position, this will have a value of 1;
	 * otherwise, it will have a value of 0.
	 */
	private int zzFinalHighSurrogate = 0;

  /* user code: */
	private int fTokenCount = 0;

	// required holders for white-space compacting
	private boolean fShouldLoadBuffered = false;
	private String fBufferedContext = null;
	private String fBufferedText = null;
	private int fBufferedStart = 1;
	private int fBufferedLength = 0;

	// help for php container text region
	private ContextRegionContainer fBufferedEmbeddedContainer = null;
	private String f_context = null;

	// state stack for handling embedded regions
	private IntStack fStateStack = new IntStack();

	// a "hint" as to what an embedded region should be evaluated
	private String fEmbeddedHint = UNDEFINED;
	// a "hint" as to what state to enter once an embedded region has
	// been completed
	private int fEmbeddedPostState = YYINITIAL;
	// the container used to create embedded regions
	private ContextRegionContainer fEmbeddedContainer = null;
	private static final String PROXY_CONTEXT = "PROXY_CONTEXT";

	private String context = null;
	private String text = null;
	private int start = 0;
	private int textLength = 0;
	private int length = 0;

	// offset for tracking position specific block tags
	private int fOffset = 0;

	// the name of the current tag being opened
	private String fCurrentTagName = null;

	// the list of tag name BlockMarkers
	private List fBlockMarkers = new ArrayList();

	// required to not seek text blocks on an end tag
	private boolean fIsBlockingEnabled = false;
	private boolean fIsCaseSensitiveBlocking = true;

	// the name of the current tag inside of an embedded region
	private String internalTagName = null;
	private String internalContext = null;

	private final XMLParserRegionFactory fRegionFactory = new XMLParserRegionFactory();
	private PHPVersion phpVersion = ProjectOptions.getDefaultPhpVersion();
/**
 * user method
 */
protected final boolean containsTagName(char[] markerTagName, int offset, int tagnameLength) {
	for(int j = 0; j < fBlockMarkers.size(); j++) {
		BlockMarker marker = (BlockMarker) fBlockMarkers.get(j);
		if(marker.getTagName().length() == tagnameLength) {
			boolean matchesSoFar = true;
			for(int i = 0; i < tagnameLength && matchesSoFar; i++) {
				if(marker.isCaseSensitive()) {
					if(marker.getTagName().charAt(i) != markerTagName[i + offset])
						matchesSoFar = false;
				} else {
					if(Character.toLowerCase(marker.getTagName().charAt(i)) != Character.toLowerCase(markerTagName[i + offset]))
						matchesSoFar = false;
				}
			}
			if(matchesSoFar)
				return true;
		}
	}
	return false;
}
/**
 * user method
 *
 * Return ALL of the regions scannable within the remaining text
 * Note: for verification use
 */
public final List getRegions() {
	List tokens = new ArrayList();
	ITextRegion region = null;
	try {
		region = getNextToken();
		while(region != null) {
			if (region != null) {
				tokens.add(region);
			}
			region = getNextToken();
		}
	}
	catch (StackOverflowError e) {
		Logger.logException(getClass().getName()+": input could not be tokenized correctly at position " + getOffset(), e);//$NON-NLS-1$
		throw e;
	}
	catch (Exception e) {
		// Since this is convenience method and NOT the recommended
		// way of getting tokens, many errors are simply hidden
		Logger.logException("Exception not handled retrieving regions: " + e.getLocalizedMessage(), e);//$NON-NLS-1$
	}
	return tokens;
}
/**
 * user method
 */
protected final boolean containsTagName(String markerTagName) {
	Iterator blocks = fBlockMarkers.iterator();
	while(blocks.hasNext()) {
		BlockMarker marker = (BlockMarker) blocks.next();
		if(marker.isCaseSensitive()) {
			if(marker.getTagName().equals(markerTagName))
				return true;
		} else {
			if(marker.getTagName().equalsIgnoreCase(markerTagName))
				return true;
		}
	}
	return false;
}
/**
 * user method
 */
public final void addBlockMarker(BlockMarker marker) {
	if(containsTagName(marker.getTagName()))
		return;
	fBlockMarkers.add(marker);
}
/**
 * user method
 */
public final void removeBlockMarker(BlockMarker marker) {
	fBlockMarkers.remove(marker);
}
/**
 * user method
 */
public final void removeBlockMarker(String tagname) {
	if (fBlockMarkers != null) {
		Iterator blocks = fBlockMarkers.iterator();
		while (blocks.hasNext()) {
			if (((BlockMarker) blocks.next()).getTagName().equals(tagname))
				blocks.remove();
		}
	}
}
/* user method */
public boolean getBlockMarkerCaseSensitivity() {
	return getBlockMarkerCaseSensitivity(fCurrentTagName);
}
/* user method */
public boolean getBlockMarkerCaseSensitivity(String name) {
	Iterator iterator = fBlockMarkers.iterator();
	while(iterator.hasNext()) {
		BlockMarker marker = (BlockMarker) iterator.next();
		boolean casesensitive = marker.isCaseSensitive();
		if(casesensitive && marker.getTagName().equals(name))
			return casesensitive;
		else if(!casesensitive && marker.getTagName().equalsIgnoreCase(name))
			return casesensitive;
	}
	return true;
}
/* user method */
public String getBlockMarkerContext() {
	return getBlockMarkerContext(fCurrentTagName);
}
/* user method */
public String getBlockMarkerContext(String name) {
	Iterator iterator = fBlockMarkers.iterator();
	while(iterator.hasNext()) {
		BlockMarker marker = (BlockMarker) iterator.next();
		if(marker.getTagName().equals(name))
			return marker.getContext();
	}
	return BLOCK_TEXT;
}
/* user method */
public List getBlockMarkers() {
	return fBlockMarkers;
}
/* user method */
public final int getOffset() {
	return fOffset + yychar;
}
private final boolean isBlockMarker() {
	return isBlockMarker(fCurrentTagName);
}
private final boolean isBlockMarker(String tagName) {
	if (!fIsBlockingEnabled)
		return false;
	return containsTagName(tagName);
}
/**
 * user method
 */
public final void beginBlockTagScan(String newTagName) {
	beginBlockMarkerScan(newTagName, BLOCK_TEXT);
}
/**
 * user method
 *
 * Special tokenizer setup.  Allows tokenization to be initiated at the
 * start of a text block within a "newTagName" tag.
 *
 * Example:
 *	Tokenizer toker = new Tokenizer();
 *	toker.setCaseSensitiveBlocking(false);
 *	toker.reset(new java.io.StringReader("afiuhqwkejhtasihgalkwhtq</scripter></scr></script>asgdasga"));
 *	toker.beginBlockMarkerScan("script", BLOCK_TEXT);
 *	toker.getRegions();
 *
 * Returns:
 *	BLOCK_TEXT: 0-40
 *	XML_END_TAG_OPEN: 41-42
 *	XML_TAG_NAME: 43-48
 *	XML_TAG_CLOSE: 49-49
 *	XML_CONTENT: 50-57
 *
 */
public final void beginBlockMarkerScan(String newTagName, String blockcontext) {
	yybegin(ST_BLOCK_TAG_SCAN);
	fCurrentTagName = newTagName;
}
/**
 * Method doScan.
 *
 * Returns a context region for all of the text from the current position upto the end of input or
 * to right *before* the first occurrence of searchString
 *
 * @param searchString - target string to search for ex.: "-->", "</tagname"
 * @param requireTailSeparator - whether the target must be immediately followed by whitespace or '>'
 * @param context - the context of the scanned region if non-zero length
 * @param exitState - the state to go to if the region was of non-zero length
 * @param abortState - the state to go to if the searchString was found immediately
 * @return String - the context found: the desired context on a non-zero length match, the abortContext on immediate success
 * @throws IOException
 */
private final String doScan(String searchString, boolean allowPHP, boolean requireTailSeparator, String searchContext, int exitState, int immediateFallbackState) throws IOException {
	boolean stillSearching = true;
	// Disable further block (probably)
	fIsBlockingEnabled = false;
	int searchStringLength = searchString.length();
	int n = 0;
	boolean same = false;
	while (stillSearching) {
		n = 0;
		// Ensure that enough data from the input exists to compare against the search String.
		n = yy_advance();
		while(n != YYEOF && zzCurrentPos < searchStringLength)
			n = yy_advance();
		// If the input was too short or we've exhausted the input, stop immediately.
		if (n == YYEOF) {
			stillSearching = false;
		} else {

			/**
			 * Look for starting PHPs "<?"
			 */
			// Look for a PHP beginning at the current position; this case wouldn't be handled by the preceding section
			// since it relies upon *having* closeTagStringLength amount of input to work as designed. Must be sure we don't
			// spill over the end of the buffer while checking.
			if(allowPHP && zzStartRead != fLastInternalBlockStart && zzCurrentPos > 0 && zzCurrentPos < zzEndRead - 1 &&
					zzBuffer[zzCurrentPos - 1] == '<' &&
					(zzBuffer[zzCurrentPos] == '?' || (zzBuffer[zzCurrentPos] == '%' && ProjectOptions.isSupportingAspTags(project)))) {
				fLastInternalBlockStart = zzMarkedPos = zzCurrentPos - 1;
				zzCurrentPos = zzMarkedPos + 1;
				int resumeState = yystate();
				yybegin(ST_BLOCK_TAG_INTERNAL_SCAN);
				if(zzMarkedPos == zzStartRead) {
					String jspContext = primGetNextToken();
					yybegin(resumeState);
					return jspContext;
				}
				return searchContext;
			}

			// 2) zzCurrentPos - jspstarter.length : There's not searchStringLength of input available; check for a JSP 2 spots back in what we could read
			// ---
			// Look for a JSP beginning at the current position; this case wouldn't be handled by the preceding section
			// since it relies upon *having* closeTagStringLength amount of input to work as designed.  Must be sure we don't
			// spill over the end of the buffer while checking.
			else if(allowPHP && zzStartRead != fLastInternalBlockStart && zzCurrentPos > 0 && zzCurrentPos < zzEndRead - 1 &&
					zzBuffer[zzCurrentPos - 1] == '<' && zzBuffer[zzCurrentPos] == '?') {
				fLastInternalBlockStart = zzMarkedPos = zzCurrentPos - 1;
				zzCurrentPos = zzMarkedPos + 1;
				int resumeState = yystate();
				yybegin(ST_BLOCK_TAG_INTERNAL_SCAN);
				if(zzMarkedPos == zzStartRead) {
					String jspContext = primGetNextToken();
					yybegin(resumeState);
					return jspContext;
				}
				return searchContext;
			}
			// 3) zzCurrentPos..(zzCurrentPos + jspStartlength - 1) : Check at the start of the block one time
			// ---
			// Look for a JSP beginning immediately in the block area; this case wouldn't be handled by the preceding section
			// since it relies upon zzCurrentPos equaling exactly the previous end +1 to work as designed.
			else if(allowPHP && zzStartRead != fLastInternalBlockStart && zzStartRead > 0 &&
					zzStartRead < zzEndRead - 1 && zzBuffer[zzStartRead] == '<' && zzBuffer[zzStartRead + 1] == '?') {
				fLastInternalBlockStart = zzMarkedPos = zzStartRead;
				zzCurrentPos = zzMarkedPos + 1;
				int resumeState = yystate();
				yybegin(ST_BLOCK_TAG_INTERNAL_SCAN);
				if(zzMarkedPos == zzStartRead) {
					String jspContext = primGetNextToken();
					yybegin(resumeState);
					return jspContext;
				}
				return searchContext;
			}

			// Check the characters in the target versus the last targetLength characters read from the buffer
			// and see if it matches
			if (n == YYEOF) {
				stillSearching = false;
			} else {
				same = true;
				// Ensure that we've not encountered a complete block (<%%>) that was *shorter* than the closeTagString and
				// thus found twice at current-targetLength [since the first scan would have come out this far anyway].
				// Check the characters in the target versus the last targetLength characters read from the buffer
				// and see if it matches

				// safety check for array accesses (zzCurrentPos is the *last* character we can check against)
				if(zzCurrentPos >= searchStringLength && zzCurrentPos <= zzEndRead) {
					for(int i = 0; i < searchStringLength; i++) {
						if(same && fIsCaseSensitiveBlocking)
							same = zzBuffer[i + zzCurrentPos - searchStringLength] == searchString.charAt(i);
						else if(same && !fIsCaseSensitiveBlocking)
							same = Character.toLowerCase(zzBuffer[i + zzCurrentPos - searchStringLength]) == Character.toLowerCase(searchString.charAt(i));
					}
				}
				// safety check failed; no match is possible right now
				else {
					same = false;
				}
			}
			if (same && requireTailSeparator && zzCurrentPos < zzEndRead) {
				// Additional check for close tags to ensure that targetString="</script" doesn't match
				// "</scriptS"
				char lastCheckChar = zzBuffer[zzCurrentPos];
				// Succeed on "</script>" and "</script "
				if(lastCheckChar == '>' || Character.isWhitespace(lastCheckChar))
					stillSearching = false;
			} else {
				stillSearching = !same || (zzCurrentPos < zzStartRead + searchStringLength);
			}
		}
	}
	if (n != YYEOF || same) {
		// We've stopped short of the end or definitely found a match
		zzMarkedPos = zzCurrentPos - searchStringLength;
		zzCurrentPos = zzMarkedPos + 1;
		// If the searchString occurs at the very beginning of what would have
		// been a Block, resume scanning normally immediately
		if (zzMarkedPos == zzStartRead) {
			yybegin(immediateFallbackState);
			return primGetNextToken();
		}
	} else {
		// We ran through the rest of the input
		zzMarkedPos = zzCurrentPos;
		zzCurrentPos++;
	}
	yybegin(exitState);
	// If the ending occurs at the very beginning of what would have
	// been a Block, resume scanning normally immediately
	if(zzMarkedPos == zzStartRead)
		return primGetNextToken();
	return searchContext;
}

/**
 * Method doScanEndPhp
 *
 * @see doScan(searchString, req...)
 * this version can handle two strings as options to search string
 * it originally written to support ?> or %> close tags to php
 * The two strings must be on the same length
 *
 * @param context - the context of the scanned region if non-zero length
 * @param exitState - the state to go to if the region was of non-zero length
 * @param abortState - the state to go to if the searchString was found immediately
 * @return String - the context found: the desired context on a non-zero length match, the abortContext on immediate success
 * @throws IOException
 */
private PhpScriptRegion bufferedTextRegion = null;
private final String doScanEndPhp(String searchContext, int exitState, int immediateFallbackState) throws IOException {
	yypushback(1); // begin with the last char

	final AbstractPhpLexer phpLexer = getPhpLexer();
	PhpScriptRegion region = new PhpScriptRegion(searchContext, yychar, project, phpLexer);

	// restore the locations / states
	reset(zzReader, phpLexer.getZZBuffer(), phpLexer.getParameters());

	bufferedTextRegion = region;

	yybegin(exitState);
	return searchContext;
}

/**
 * @param project
 * @param stream
 * @return a new lexer for the given project with the given stream initialized with current parameters
 */
private AbstractPhpLexer getPhpLexer() {
	final AbstractPhpLexer lexer = PhpLexerFactory.createLexer(zzReader, phpVersion);
	int[] currentParameters = getParameters();
	try {
		// set initial lexer state - we use reflection here since we don't know the constant value of
		// of this state in specific PHP version lexer
		currentParameters[6] = lexer.getClass().getField("ST_PHP_IN_SCRIPTING").getInt(lexer);
	} catch (Exception e) {
		Logger.logException(e);
	}
	lexer.reset(zzReader, zzBuffer, currentParameters);

	lexer.setAspTags(ProjectOptions.isSupportingAspTags(project));
	return lexer;
}

// call the doScan without searching for PHP internal code
private final String doScan(String searchString, boolean requireTailSeparator, String searchContext, int exitState, int immediateFallbackState) throws IOException {
	return doScan(searchString, true, requireTailSeparator, searchContext, exitState, immediateFallbackState);
}

	/* user method */
	private final void assembleEmbeddedTagSequence(String startType, String endTagName) {
		assembleEmbeddedContainer(startType, null, endTagName);
	}
	/* user method */
	private final void assembleEmbeddedContainer(String startType, String[] endTypes) {
		assembleEmbeddedContainer(startType, endTypes, null);
	}
	/* user method */
	private final void assembleEmbeddedContainer(String startType, String endType) {
		assembleEmbeddedContainer(startType, new String[]{endType}, null);
	}
	/**
	 *  user method
	 *
	 * Assembles an embedded container beginning with the given startType as
	 * the first ContextRegion within it and of the type fEmbeddedHint.  The
	 * endTypes[] array contains the context types that will cause a successful
	 * exit.  Use of the endTagName parameter alters this behavior to force an
	 * exit on an XML_TAG_CLOSE after seeing an XML_TAG_NAME whose significant
	 * text matches the endTagName String.  All contents in between are
	 * insignificant, and yes, this means comments are allowed inside.
	 **/
	private final void assembleEmbeddedContainer(String startType, String[] endTypes, String endTagName) {
		// the context of the region being added to the embedded container
		internalContext = startType;
		// keep track of where this container began; to provide relative indeces for the regions
		int containerStart = yychar;
		boolean notFinished = true;
		// keep track of where we seem to be so that the endTagName can be checked
		boolean isInEndTag = false;
		boolean isInFirstTag = true;
		// create the embedded container and setup its "type"
		if (fEmbeddedContainer == null) {
			fEmbeddedContainer = new ContextRegionContainer();
			fEmbeddedContainer.setType(fEmbeddedHint);
			fEmbeddedContainer.setStart(containerStart);
			// TODO: parent region needs to be set .... but not sure where to get it from
			// fEmbeddedContainer.setParent(parentRegion);
		}
		containerStart = fEmbeddedContainer.getStart();
		while (notFinished) {
			// add the region to the container
			if (internalContext != null && internalContext != PROXY_CONTEXT) {

				ITextRegion newToken;
				// if it is php content we extract the tokens
				if (internalContext == PHP_CONTENT) {
					newToken = bufferedTextRegion;
					bufferedTextRegion.adjustStart(-containerStart);
				} else {
					newToken = fRegionFactory.createToken(internalContext, yychar - containerStart, yylength(), yylength());
				}
				fEmbeddedContainer.getRegions().add(newToken);
				fEmbeddedContainer.setLength(fEmbeddedContainer.getLength() + newToken.getLength());
				fEmbeddedContainer.setTextLength(fEmbeddedContainer.getTextLength() + newToken.getLength());
				// DW, 4/16/2003 token regions no longer have parents
				//newToken.setParent(fEmbeddedContainer);
			}
			try {
				// longscan determines whether to attempt a blockTagScan within the embedded container
				boolean longscan = false;
				// save the tokenizer state in case of a block tag scan
				int previousState = yystate();
				String previousCurrentTagName = fCurrentTagName;
				int previousPostState = fEmbeddedPostState;
				String previousEmbeddedHint = fEmbeddedHint;
				// determine if a block tag scan is necessary
				if (internalContext == XML_TAG_NAME) {
					internalTagName = yytext();
					if(!isNestable(internalTagName)) {
						internalTagName = null;
						// snagged a tag name we shouldn't have
						fEmbeddedPostState = ST_ABORT_EMBEDDED;
						notFinished = false;
					}
				} else if (internalContext == XML_TAG_OPEN || internalContext == XML_END_TAG_OPEN) {
					internalTagName = null;
				}
				// do upkeep for endTagName usage; must be here since the next token could be the close
				if (internalContext == XML_END_TAG_OPEN) {
					isInEndTag = true;
				} else if (internalContext == XML_TAG_CLOSE) {
					isInFirstTag = isInEndTag = false;
				} else {
					ITextRegionList embeddedRegions = fEmbeddedContainer.getRegions();
					if (embeddedRegions.size() > 2 && (embeddedRegions.get(embeddedRegions.size() - 1)).getType() == XML_TAG_CLOSE && (embeddedRegions.get(embeddedRegions.size() - 3)).getType() == XML_TAG_OPEN && internalTagName != null) {
						if (containsTagName(internalTagName)) {
							longscan = true;
							yybegin(ST_BLOCK_TAG_SCAN);
						}
					}
				}
				if (longscan)
					fCurrentTagName = internalTagName;
				// read the next region and context
				internalContext = primGetNextToken();
				if (longscan) {
					// Returning from a block tag scan requires restoring some state variables
					// as well as handling the block region and setting up for normal scanning
					// inside the embedded container

					ITextRegion newToken;
					// if it is php content we extract the tokens
					if (internalContext == PHP_CONTENT) {
						newToken = bufferedTextRegion;
						bufferedTextRegion.adjustStart(-containerStart);
					} else {
						newToken = fRegionFactory.createToken(internalContext, yychar - containerStart, yylength(), yylength());
					}

					fEmbeddedContainer.getRegions().add(newToken);
					fEmbeddedContainer.setLength(fEmbeddedContainer.getLength() + newToken.getLength());
					fEmbeddedContainer.setTextLength(fEmbeddedContainer.getTextLength() + newToken.getLength());
					// DW, 4/16/2003 token regions no longer have parents
					// newToken.setParent(fEmbeddedContainer);
					longscan = false;
					fEmbeddedPostState = previousPostState;
					fEmbeddedHint = previousEmbeddedHint;
					fCurrentTagName = previousCurrentTagName;
					yybegin(previousState);
					internalContext = primGetNextToken();
				}
			} catch (IOException e) {
				// primGetNextToken() calls may throw an IOException
				Logger.logException(e);
				internalContext = null;
				notFinished = false;
				break;
			} catch (Exception f) {
				// some other exception happened; never should
				Logger.logException(f);
				// ... but IllegalArgumentException(CoreMessages.getString("UnknownPHPVersion_*"))
				// can be thrown from doScanEndPhp(), so avoid infinite loops
				internalContext = null;
				notFinished = false;
				break;
			}
			boolean isEndingType = yystate() == ST_ABORT_EMBEDDED;
			if(!isEndingType) {
				// check for ending context
				if (endTagName == null) {
					for (int i = 0; i < endTypes.length; i++) {
						isEndingType = isEndingType || (internalContext == endTypes[i]);
					}
				} else {
					isEndingType = ((isInEndTag && internalContext == XML_TAG_CLOSE) || (isInFirstTag && internalContext == XML_EMPTY_TAG_CLOSE)) && internalTagName != null && internalTagName.equals(endTagName);
				}
			}
			ITextRegionList embeddedList = fEmbeddedContainer.getRegions();
			notFinished = notFinished && ((!isEndingType) && !isEOF() && (endTagName != null || internalContext != UNDEFINED) && !(internalContext == PROXY_CONTEXT && (embeddedList.get(embeddedList.size() - 1)).getType() == UNDEFINED));
		}
		// finish adding the last context
		if (internalContext != null && internalContext != PROXY_CONTEXT) {
			ITextRegion newToken = fRegionFactory.createToken(internalContext, yychar - containerStart, yylength(), yylength());
			fEmbeddedContainer.getRegions().add(newToken);
			// DW, 4/16/2003 token regions no longer have parents
			//newToken.setParent(fEmbeddedContainer);
			fEmbeddedContainer.setLength(yychar - containerStart + yylength());
			fEmbeddedContainer.setTextLength(yychar - containerStart + yylength());
		}
		yybegin(fEmbeddedPostState);
	}

	/**
	 * user method
	 */
	private boolean isNestable(String tagName) {
		return false; //true is for jsp
	}

/**
 * user method
 *
 * A generic lookahead-like operation
 */
private final String doBlockScan(String target, String targetContext, int immediateFallbackState) throws IOException {
	return doScan(target, false, targetContext, immediateFallbackState, immediateFallbackState);
}
/**
 * user method
 * does a lookahead for the current tag name
 */
private final String doBlockTagScan() throws IOException {
	fIsCaseSensitiveBlocking = getBlockMarkerCaseSensitivity();
	return doScan("</" + fCurrentTagName, true, getBlockMarkerContext(fCurrentTagName), YYINITIAL, YYINITIAL);
}

private IProject project;

/**
 * this method is only intended to be called at creation of a new
 * PHPTokenizer (and before first scan) to avoid problems with
 * bufferedTextRegion and other cached informations depending on project
 * properties and settings
 */
public void setProject(@Nullable IProject project) {
	this.project = project;
	this.phpVersion = ProjectOptions.getPhpVersion(project);
	this.bufferedTextRegion = null;
}

// NB: this method resets the lexer only partially
private void reset(java.io.Reader reader, char[] buffer, int[] parameters) {
	this.phpVersion = ProjectOptions.getPhpVersion(project);
	this.bufferedTextRegion = null;
	this.zzReader = reader;
	this.zzBuffer = buffer;
	this.zzFinalHighSurrogate = 0;
	this.zzMarkedPos = parameters[0];
	this._zzPushbackPos = parameters[1];
	this.zzCurrentPos = parameters[2];
	this.zzStartRead = parameters[3];
	this.zzEndRead = parameters[4];
	this.yyline = parameters[5];
	this.yychar = this.zzStartRead - this._zzPushbackPos;
}

public int[] getParameters() {
	return new int[]{zzMarkedPos, _zzPushbackPos, zzCurrentPos, zzStartRead, zzEndRead, yyline, zzLexicalState};
}

/**
 * user method
 *
 * Converts the raw context String returned by the primGetNextToken()
 * method into a full ITextRegion by pulling in values for the
 * current offset within the scanning text.
 *
 * Returns null when EOF is encountered and attaches intermittently
 * discovered whitespace onto the end of useful regions.
 *
 * Note that this algorithm caches the token following the one being returned
 * so that whitespace can be collapsed.
 */
public final ITextRegion getNextToken() throws IOException {
	fEmbeddedContainer = null;
	// load the starting non-whitespace token (assume that it is so)
	if (fShouldLoadBuffered) {
		if (fBufferedEmbeddedContainer != null) {
			ITextRegion container = fBufferedEmbeddedContainer;
			fBufferedEmbeddedContainer = null;
			fShouldLoadBuffered = false;
			return container;
		}
		context = fBufferedContext;
		text = fBufferedText;
		start = fBufferedStart;
		textLength = length = fBufferedLength;
		fShouldLoadBuffered = false;
	} else {
		context = primGetNextToken();
		if (context == PROXY_CONTEXT) {
			return fEmbeddedContainer;
		} else if (context == XML_TAG_OPEN) {
			fIsBlockingEnabled = true;
		} else if (context == XML_END_TAG_OPEN) {
			fIsBlockingEnabled = false;
		}
		text = yytext();
		if (context == XML_TAG_NAME) {
			if(containsTagName(zzBuffer, zzStartRead, zzMarkedPos - zzStartRead))
				fCurrentTagName = text;
			else
				fCurrentTagName = null;
		} else if (context == XML_TAG_OPEN) {
			fIsBlockingEnabled = true;
		} else if (context == XML_END_TAG_OPEN) {
			fIsBlockingEnabled = false;
		}
		start = yychar;
		textLength = length = yylength();
		if (zzAtEOF) {
			fTokenCount++;
			return null;
		}
	}

	// store the next token
	f_context = primGetNextToken();
	if (f_context == PROXY_CONTEXT) {
		fBufferedEmbeddedContainer = fEmbeddedContainer;
		fShouldLoadBuffered = true;
	} else if (f_context == XML_TAG_NAME) {
		if(containsTagName(zzBuffer, zzStartRead, zzMarkedPos - zzStartRead))
			fCurrentTagName = yytext();
		else
			fCurrentTagName = null;
	} else if (f_context == XML_TAG_OPEN) {
		fIsBlockingEnabled = true;
	} else if (f_context == XML_END_TAG_OPEN) {
		fIsBlockingEnabled = false;
	}
	fBufferedContext = f_context;
	fBufferedText = yytext();
	if (fBufferedContext == XML_TAG_NAME) {
		if(containsTagName(zzBuffer, zzStartRead, zzMarkedPos - zzStartRead))
			fCurrentTagName = fBufferedText;
		else
			fCurrentTagName = null;
	} else if (fBufferedContext == XML_TAG_OPEN) {
		fIsBlockingEnabled = true;
	} else if (fBufferedContext == XML_END_TAG_OPEN) {
		fIsBlockingEnabled = false;
	}
	fBufferedStart = yychar;
	fBufferedLength = yylength();
	if (fBufferedContext == WHITE_SPACE) {
		fShouldLoadBuffered = false;
		length += fBufferedLength;
	}else {
		fShouldLoadBuffered = true;
	}
	if (context == null) {
		// EOF
		if (Debug.debugTokenizer) {
			System.out.println(getClass().getName() + " discovered " + fTokenCount + " tokens."); //$NON-NLS-1$ //$NON-NLS-2$
		}
		return null;
	}
	fTokenCount++;

	// if it is php content we extract the tokens
	if (context == PHP_CONTENT) {
		return bufferedTextRegion;
	} else {
		return fRegionFactory.createToken(context, start, textLength, length, null, fCurrentTagName);
	}
}

/* user method */
public PHPTokenizer() {
	super();
}
/* user method */
public PHPTokenizer(char[] charArray) {
	this(new CharArrayReader(charArray));
}
/* user method */
public void reset(char[] charArray) {
	reset(new CharArrayReader(charArray), 0);
}
/* user method */
public void reset(char[] charArray, int newOffset) {
	reset(new CharArrayReader(charArray), newOffset);
}
/* user method */
public void reset(java.io.InputStream in) {
	reset(new java.io.InputStreamReader(in), 0);
}
/* user method */
public void reset(java.io.InputStream in, int newOffset) {
	reset(new java.io.InputStreamReader(in), newOffset);
}
/* user method */
public void reset(java.io.Reader in) {
	reset(in, 0);
}
/**
 * user method *
 *
 * Reset internal counters and vars to "newly created" values, in the hopes
 * that resetting a pre-existing tokenizer is faster than creating a new one.
 *
 * This method contains code blocks that were essentially duplicated from the
 * <em>generated</em> output of this specification before this method was
 * added.  Those code blocks were under the above copyright.
 */
public void reset(java.io.Reader in, int newOffset) {
	if (Debug.debugTokenizer) {
		System.out.println("resetting tokenizer");//$NON-NLS-1$
	}
	this.phpVersion = ProjectOptions.getPhpVersion(project);
	this.bufferedTextRegion = null;
	fOffset = newOffset;

	/* the input device */
	zzReader = in;

	/* the current state of the DFA */
	zzState = 0;

	/* the current lexical state */
	zzLexicalState = YYINITIAL;

	/* this buffer contains the current text to be matched and is
	the source of the yytext() string */
	java.util.Arrays.fill(zzBuffer, (char) 0);

	/* the textposition at the last accepting state */
	zzMarkedPos = 0;

	/* the textposition at the last state to be included in yytext */
	_zzPushbackPos = 0;

	/* the current text position in the buffer */
	zzCurrentPos = 0;

	/* startRead marks the beginning of the yytext() string in the buffer */
	zzStartRead = 0;

	/**
	 * endRead marks the last character in the buffer, that has been read
	 * from input
	 */
	zzEndRead = 0;

	/* The number of occupied positions in zzBuffer beyond zzEndRead */
	zzFinalHighSurrogate = 0;

	/* number of newlines encountered up to the start of the matched text */
	yyline = 0;

	/* the number of characters up to the start of the matched text */
	yychar = 0;

	/* zzAtBOL == true <=> the scanner is currently at the beginning of a line */
	//zzAtBOL = true;

	/* zzAtEOF == true <=> the scanner has returned a value for EOF */
	zzAtEOF = false;


	/* user vars: */
	fLastInternalBlockStart = -1;

	fTokenCount = 0;

	fShouldLoadBuffered = false;
	fBufferedContext = null;
	fBufferedText = null;
	fBufferedStart = 1;
	fBufferedLength = 0;
	fStateStack = new IntStack();

	context = null;
	text = null;
	start = 0;
	textLength = 0;
	length = 0;
}

	/**
	 * user method
	 *
	 */
	public BlockTokenizer newInstance() {
		PHPTokenizer newInstance = new PHPTokenizer();
		// global tagmarkers can be shared; they have no state and
		// are never destroyed (e.g. 'release')
		for(int i = 0; i < fBlockMarkers.size(); i++) {
			BlockMarker blockMarker = (BlockMarker) fBlockMarkers.get(i);
			if(blockMarker.isGlobal())
				newInstance.addBlockMarker(blockMarker);
		}
		return newInstance;
	}
/* user method */
private final String scanXMLCommentText() throws IOException {
	// Scan for '-->' and return the text up to that point as
	//   XML_COMMENT_TEXT unless the string occurs IMMEDIATELY, in which
	//  case change to the ST_XML_COMMENT_END state and return the next
	//  context as usual.
	return doScan("-->", true, false, XML_COMMENT_TEXT, ST_XML_COMMENT_END, ST_XML_COMMENT_END);
}


	/** the textposition at the last state to be included in yytext */
	private int _zzPushbackPos;

	// where the last internal container block was found
	private int fLastInternalBlockStart = -1;

	/**
	 * Creates a new scanner
	 *
	 * @param   in  the java.io.Reader to read input from.
	 */
  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PHPTokenizer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1404) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>false</code>, iff there was new input.
	 *
	 * @exception   java.io.IOException  if any I/O-Error occurs
	 */
	private boolean zzRefill() throws java.io.IOException {

		/* first: make room (if you can) */
		if (zzStartRead > 0) {
			zzEndRead += zzFinalHighSurrogate;
			zzFinalHighSurrogate = 0;
			System.arraycopy(zzBuffer, zzStartRead,
							zzBuffer, 0,
							zzEndRead-zzStartRead);

			/* translate stored positions */
			zzEndRead-= zzStartRead;
			zzCurrentPos-= zzStartRead;
			zzMarkedPos-= zzStartRead;
			_zzPushbackPos-= zzStartRead;
			fLastInternalBlockStart = -1;
			zzStartRead = 0;
		}

		/* is the buffer big enough? */
		if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
			/* if not: blow it up */
			char newBuffer[] = new char[zzBuffer.length*2];
			System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
			zzBuffer = newBuffer;
			zzEndRead += zzFinalHighSurrogate;
			zzFinalHighSurrogate = 0;
		}

		/* fill the buffer with new input */
		int requested = zzBuffer.length - zzEndRead;
		int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

		/* not supposed to occur according to specification of java.io.Reader */
		if (numRead == 0) {
			throw new java.io.IOException("Reader returned 0 characters.");
		}
		if (numRead > 0) {
			zzEndRead += numRead;
			/* If numRead == requested, we might have requested to few chars to
			   encode a full Unicode character. We assume that a Reader would
			   otherwise never return half characters. */
			if (numRead == requested) {
				if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
					--zzEndRead;
					zzFinalHighSurrogate = 1;
				}
			}
			/* potentially more input available */
			return false;
		}

		/* numRead < 0 ==> end of stream */
		return true;
	}


	/**
	 * Gets the next input character.
	 *
	 * @return      the next character of the input stream, EOF if the
	 *              end of the stream is reached.
	 * @exception   IOException  if any I/O-Error occurs
	 */
	private int yy_advance() throws java.io.IOException {

		/* standard case */
		if (zzCurrentPos < zzEndRead) return zzBuffer[zzCurrentPos++];

		/* if the eof is reached, we don't need to work hard */
		if (zzAtEOF) return YYEOF;

		/* otherwise: need to refill the buffer */

		/* first: make room (if you can) */
		if (zzRefill()) {
			return YYEOF;
		}

		return zzBuffer[zzCurrentPos++];
	}


	/**
	 * Closes the input stream.
	 */
	public final void yyclose() throws java.io.IOException {
		zzAtEOF = true;            /* indicate end of file */
		zzEndRead = zzStartRead;  /* invalidate buffer    */

		if (zzReader != null)
			zzReader.close();
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>ZZ_INITIAL</tt>.
	 *
	 * Internal scan buffer is resized down to its initial length, if it has grown.
	 *
	 * @param reader   the new input stream
	 */
	public final void yyreset(java.io.Reader reader) {
		zzReader = reader;
		//zzAtBOL  = true;
		zzAtEOF  = false;
		zzEOFDone = false;
		zzEndRead = zzStartRead = 0;
		zzCurrentPos = zzMarkedPos = _zzPushbackPos = 0;
		fLastInternalBlockStart = -1;
		zzFinalHighSurrogate = 0;
		yyline = yychar /*= yycolumn*/ = 0;
		zzLexicalState = YYINITIAL;
		if (zzBuffer.length > ZZ_BUFFERSIZE)
			zzBuffer = new char[ZZ_BUFFERSIZE];
	}


	/**
	 * Returns the current lexical state.
	 */
	public final int yystate() {
		return zzLexicalState;
	}


	/**
	 * Enters a new lexical state
	 *
	 * @param newState the new lexical state
	 */
	public final void yybegin(int newState) {
		zzLexicalState = newState;
	}


	/**
	 * Returns the text matched by the current regular expression.
	 */
	public final String yytext() {
		return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
	}


	/**
	 * Returns the character at position <tt>pos</tt> from the
	 * matched text.
	 *
	 * It is equivalent to yytext().charAt(pos), but faster
	 *
	 * @param pos the position of the character to fetch.
	 *            A value from 0 to yylength()-1.
	 *
	 * @return the character at position pos
	 */
	public final char yycharat(int pos) {
		return zzBuffer[zzStartRead+pos];
	}


	/**
	 * Returns the length of the matched text region.
	 */
	public final int yylength() {
		return zzMarkedPos-zzStartRead;
	}


	/**
	 * Reports an error that occured while scanning.
	 *
	 * In a wellformed scanner (no or only correct usage of
	 * yypushback(int) and a match-all fallback rule) this method
	 * will only be called with things that "Can't Possibly Happen".
	 * If this method is called, something is seriously wrong
	 * (e.g. a JFlex bug producing a faulty scanner etc.).
	 *
	 * Usual syntax/scanner level error handling should be done
	 * in error fallback rules.
	 *
	 * @param   errorCode  the code of the errormessage to display
	 */
  private void zzScanError(int errorCode) {
		String message;
		try {
			message = ZZ_ERROR_MSG[errorCode];
		}
		catch (ArrayIndexOutOfBoundsException e) {
			message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
		}

		Logger.log(Logger.ERROR, message);
		try {
    throw new Error(message);
		} catch(Error e) {
			// BC
		}
	}


	/**
	 * Pushes the specified amount of characters back into the input stream.
	 *
	 * They will be read again by then next call of the scanning method
	 *
	 * @param number  the number of characters to be read again.
	 *                This number must not be greater than yylength()!
	 */
  public void yypushback(int number)  {
		if ( number > yylength() )
			zzScanError(ZZ_PUSHBACK_2BIG);

		zzMarkedPos -= number;
	}


	/**
	 * user method - common.sse
	 */
	private final void dump(String s) {
		if (Debug.debugTokenizer) {
			System.out.println(s + " (" + yychar + "-" + //$NON-NLS-1$ //$NON-NLS-2$
				(yylength() + yychar) + "):\'" + //$NON-NLS-1$
				StringUtils.escape(yytext()) + "\'"); //$NON-NLS-1$
		}
	}


	/**
	 * user method - common.sse
	 */
	public final boolean isEOF() {
		return zzAtEOF;
	}


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() {
    if (!zzEOFDone) {
      zzEOFDone = true;
    // do nothing, this is the downstream parser's job

    }
  }


	/**
	 * Resumes scanning until the next regular expression is matched,
	 * the end of input is encountered or an I/O-Error occurs.
	 *
	 * @return      the next token
	 * @exception   java.io.IOException  if any I/O-Error occurs
	 */
  public String primGetNextToken() throws java.io.IOException {
	int zzInput;
	int zzAction;

	// cached fields:
	int zzCurrentPosL;
	int zzMarkedPosL;
	int zzEndReadL = zzEndRead;
	char [] zzBufferL = zzBuffer;
	char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

	while (true) {
		zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          zzR = false;
          break;
        case '\r':
          yyline++;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
          }
          break;
        default:
          zzR = false;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
		zzAction = -1;

		zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


		zzForAction: {
			while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
				zzAction = zzState;
				zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
				}

			}
		}

			// store back cached position
			zzMarkedPos = zzMarkedPosL;

			if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
				zzAtEOF = true;
            zzDoEOF();
        return null;
			}
			else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { if(Debug.debugTokenizer)
		dump("\nXML content");//$NON-NLS-1$
	return XML_CONTENT;
            }
          case 69: break;
          case 2: 
            { if(Debug.debugTokenizer)
		dump("white space");//$NON-NLS-1$
	return WHITE_SPACE;
            }
          case 70: break;
          case 3: 
            { if(Debug.debugTokenizer)
		dump("DHTML processing instruction attribute value");//$NON-NLS-1$
	fEmbeddedHint = XML_TAG_ATTRIBUTE_NAME;
	fEmbeddedPostState = ST_XML_EQUALS;
	yybegin(ST_DHTML_ATTRIBUTE_NAME);
	return XML_TAG_ATTRIBUTE_VALUE;
            }
          case 71: break;
          case 4: 
            { // inappropriate tag name
	if(!fStateStack.empty() && (fStateStack.peek() == ST_XML_ATTRIBUTE_VALUE_SQUOTED || fStateStack.peek() == ST_XML_ATTRIBUTE_VALUE_DQUOTED)) {
		yybegin(ST_ABORT_EMBEDDED);
		yypushback(yylength() - 1);
		return XML_TAG_ATTRIBUTE_VALUE;
	}
	yybegin(YYINITIAL);
	return XML_CONTENT;
            }
          case 72: break;
          case 5: 
            { if(Debug.debugTokenizer)
		dump("elementdecl contentspec");//$NON-NLS-1$
	return XML_ELEMENT_DECL_CONTENT;
            }
          case 73: break;
          case 6: 
            { if(Debug.debugTokenizer)
		dump("attlist contentspec");//$NON-NLS-1$
	return XML_ATTLIST_DECL_CONTENT;
            }
          case 74: break;
          case 7: 
            { if(Debug.debugTokenizer)
		dump("\nstart tag open");//$NON-NLS-1$
	fEmbeddedHint = XML_TAG_NAME;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
	yybegin(ST_XML_TAG_NAME);
	return XML_TAG_OPEN;
            }
          case 75: break;
          case 8: 
            { if (Debug.debugTokenizer)
		System.out.println("!!!unexpected!!!: \"" + yytext() + "\":" + //$NON-NLS-1$ //$NON-NLS-2$
			yychar + "-" + (yychar + yylength()));//$NON-NLS-1$
	return UNDEFINED;
            }
          case 76: break;
          case 9: 
            { if(Debug.debugTokenizer)
		dump("CDATA text");//$NON-NLS-1$
	fEmbeddedPostState = ST_CDATA_TEXT;
	fEmbeddedHint = XML_CDATA_TEXT;
	String blockContext = doBlockScan("]]>", XML_CDATA_TEXT, ST_CDATA_END);//$NON-NLS-1$
	if(blockContext == XML_CDATA_TEXT)
		yybegin(ST_CDATA_END);
	return blockContext;
            }
          case 77: break;
          case 10: 
            { if(Debug.debugTokenizer)
		dump("LINE FEED");//$NON-NLS-1$
	return WHITE_SPACE;
            }
          case 78: break;
          case 11: 
            { if(Debug.debugTokenizer)
		dump("comment content");//$NON-NLS-1$
	return scanXMLCommentText();
            }
          case 79: break;
          case 12: 
            { if(Debug.debugTokenizer)
		dump("processing instruction target");//$NON-NLS-1$
	fEmbeddedHint = XML_CONTENT;
	yybegin(ST_PI_WS);
	return XML_TAG_NAME;
            }
          case 80: break;
          case 13: 
            { yybegin(ST_PI_CONTENT);
	return WHITE_SPACE;
            }
          case 81: break;
          case 14: 
            { // block scan until close is found
	return doScan("?>", false, false, XML_PI_CONTENT, ST_XML_PI_TAG_CLOSE, ST_XML_PI_TAG_CLOSE);
            }
          case 82: break;
          case 15: 
            { if(Debug.debugTokenizer)
		dump("XML processing instruction attribute name");//$NON-NLS-1$
	yybegin(ST_XML_PI_EQUALS);
	return XML_TAG_ATTRIBUTE_NAME;
            }
          case 83: break;
          case 16: 
            { if(Debug.debugTokenizer)
		dump("XML processing instruction '='");//$NON-NLS-1$
	fEmbeddedHint = XML_TAG_ATTRIBUTE_VALUE;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
	yybegin(ST_XML_PI_ATTRIBUTE_VALUE);
	return XML_TAG_ATTRIBUTE_EQUALS;
            }
          case 84: break;
          case 17: 
            { if(Debug.debugTokenizer)
		dump("XML processing instruction attribute value");//$NON-NLS-1$
	fEmbeddedHint = XML_TAG_ATTRIBUTE_NAME;
	fEmbeddedPostState = ST_XML_EQUALS;
	yybegin(ST_XML_PI_ATTRIBUTE_NAME);
	return XML_TAG_ATTRIBUTE_VALUE;
            }
          case 85: break;
          case 18: 
            { if(Debug.debugTokenizer)
		dump("DHTML processing instruction end");//$NON-NLS-1$
	fEmbeddedHint = UNDEFINED;
	yybegin(YYINITIAL);
	return XML_PI_CLOSE;
            }
          case 86: break;
          case 19: 
            { if(Debug.debugTokenizer)
		dump("DHTML processing instruction attribute name");//$NON-NLS-1$
	yybegin(ST_DHTML_EQUALS);
	return XML_TAG_ATTRIBUTE_NAME;
            }
          case 87: break;
          case 20: 
            { if(Debug.debugTokenizer)
		dump("DHTML processing instruction '='");//$NON-NLS-1$
	fEmbeddedHint = XML_TAG_ATTRIBUTE_VALUE;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
	yybegin(ST_DHTML_ATTRIBUTE_VALUE);
	return XML_TAG_ATTRIBUTE_EQUALS;
            }
          case 88: break;
          case 21: 
            { // tag close
	fEmbeddedHint = UNDEFINED;
	if(isBlockMarker()) {
		fEmbeddedHint = getBlockMarkerContext();
		fEmbeddedPostState = ST_BLOCK_TAG_SCAN;
		yybegin(ST_BLOCK_TAG_SCAN);
	}
	else
		yybegin(YYINITIAL);
	return XML_TAG_CLOSE;
            }
          case 89: break;
          case 22: 
            { if(Debug.debugTokenizer)
		dump("tag name");//$NON-NLS-1$
	fEmbeddedHint = XML_TAG_ATTRIBUTE_NAME;
	fEmbeddedPostState = ST_XML_EQUALS;
	yybegin(ST_XML_ATTRIBUTE_NAME);
	return XML_TAG_NAME;
            }
          case 90: break;
          case 23: 
            { // attr name
	fEmbeddedHint = XML_TAG_ATTRIBUTE_NAME;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
	yybegin(ST_XML_EQUALS);
	return XML_TAG_ATTRIBUTE_NAME;
            }
          case 91: break;
          case 24: 
            { // equals
	fEmbeddedHint = XML_TAG_ATTRIBUTE_VALUE;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
	yybegin(ST_XML_ATTRIBUTE_VALUE);
	return XML_TAG_ATTRIBUTE_EQUALS;
            }
          case 92: break;
          case 25: 
            { // attr value
	fEmbeddedHint = XML_TAG_ATTRIBUTE_NAME;
	fEmbeddedPostState = ST_XML_EQUALS;
	yybegin(ST_XML_ATTRIBUTE_NAME);
	return XML_TAG_ATTRIBUTE_VALUE;
            }
          case 93: break;
          case 26: 
            { fEmbeddedHint = XML_TAG_ATTRIBUTE_VALUE;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_VALUE_DQUOTED;
	yybegin(ST_XML_ATTRIBUTE_VALUE_DQUOTED);
	fStateStack.push(yystate());
	assembleEmbeddedContainer(XML_TAG_ATTRIBUTE_VALUE_DQUOTE, XML_TAG_ATTRIBUTE_VALUE_DQUOTE);
	fStateStack.pop();
	fEmbeddedHint = XML_TAG_ATTRIBUTE_NAME;
	fEmbeddedPostState = ST_XML_EQUALS;
	yybegin(ST_XML_ATTRIBUTE_NAME);
	return PROXY_CONTEXT;
            }
          case 94: break;
          case 27: 
            { // begin embedded region: " + fEmbeddedHint
	fEmbeddedHint = XML_TAG_ATTRIBUTE_VALUE;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_VALUE_SQUOTED;
	yybegin(ST_XML_ATTRIBUTE_VALUE_SQUOTED);
	fStateStack.push(yystate());
	// JSP attribute value start - complex single quoted
	assembleEmbeddedContainer(XML_TAG_ATTRIBUTE_VALUE_SQUOTE, XML_TAG_ATTRIBUTE_VALUE_SQUOTE);
	fStateStack.pop();
	fEmbeddedHint = XML_TAG_ATTRIBUTE_NAME;
	fEmbeddedPostState = ST_XML_EQUALS;
	yybegin(ST_XML_ATTRIBUTE_NAME);
	return PROXY_CONTEXT;
            }
          case 95: break;
          case 28: 
            { if(Debug.debugTokenizer)
		dump("declaration end");//$NON-NLS-1$
	if (Debug.debugTokenizer) {
		if(fStateStack.peek() != YYINITIAL)
			System.out.println("end embedded region");//$NON-NLS-1$
	}
	yybegin(fStateStack.pop());
	return XML_DECLARATION_CLOSE;
            }
          case 96: break;
          case 29: 
            { if(Debug.debugTokenizer)
		dump("doctype type");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_EXTERNAL_ID);
	return XML_DOCTYPE_NAME;
            }
          case 97: break;
          case 30: 
            { if(Debug.debugTokenizer)
		dump("doctype public reference");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_ID_SYSTEM);
	return XML_DOCTYPE_EXTERNAL_ID_PUBREF;
            }
          case 98: break;
          case 31: 
            { if(Debug.debugTokenizer)
		dump("doctype system reference");//$NON-NLS-1$
	yybegin(ST_XML_DECLARATION_CLOSE);
	return XML_DOCTYPE_EXTERNAL_ID_SYSREF;
            }
          case 99: break;
          case 32: 
            { if(Debug.debugTokenizer)
		dump("elementdecl name");//$NON-NLS-1$
	yybegin(ST_XML_ELEMENT_DECLARATION_CONTENT);
	return XML_ELEMENT_DECL_NAME;
            }
          case 100: break;
          case 33: 
            { if(Debug.debugTokenizer)
		dump("elementdecl close");//$NON-NLS-1$
	if (Debug.debugTokenizer) {
		if(fStateStack.peek() != YYINITIAL)
			System.out.println("end embedded region");//$NON-NLS-1$
	}
	yybegin(fStateStack.pop());
	return XML_DECLARATION_CLOSE;
            }
          case 101: break;
          case 34: 
            { if(Debug.debugTokenizer)
		dump("attlist name");//$NON-NLS-1$
	yybegin(ST_XML_ATTLIST_DECLARATION_CONTENT);
	return XML_ATTLIST_DECL_NAME;
            }
          case 102: break;
          case 35: 
            { if(Debug.debugTokenizer)
		dump("attlist close");//$NON-NLS-1$
	if (Debug.debugTokenizer) {
		if(fStateStack.peek() != YYINITIAL)
			System.out.println("end embedded region");//$NON-NLS-1$
	}
	yybegin(fStateStack.pop());
	return XML_DECLARATION_CLOSE;
            }
          case 103: break;
          case 36: 
            { return doBlockTagScan();
            }
          case 104: break;
          case 37: 
            { return doScanEndPhp(PHP_CONTENT, ST_PHP_CONTENT, ST_PHP_CONTENT);
            }
          case 105: break;
          case 38: 
            { return XML_TAG_ATTRIBUTE_VALUE;
            }
          case 106: break;
          case 39: 
            { // begin embedded region: " + fEmbeddedHint
	int incomingState = yystate();
	fEmbeddedHint = XML_TAG_ATTRIBUTE_VALUE;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
	// tag inside of JSP attribute value start
	yybegin(ST_XML_TAG_NAME);
	assembleEmbeddedContainer(XML_TAG_OPEN, new String[]{XML_TAG_CLOSE, XML_EMPTY_TAG_CLOSE});
	if(yystate() != ST_ABORT_EMBEDDED) {
		// set incoming state when container
		// was correctly assembled
		yybegin(incomingState);
	}
	return PROXY_CONTEXT;
            }
          case 107: break;
          case 40: 
            { return XML_TAG_ATTRIBUTE_VALUE_SQUOTE;
            }
          case 108: break;
          case 41: 
            { return XML_TAG_ATTRIBUTE_VALUE_DQUOTE;
            }
          case 109: break;
          case 42: 
            { // end tag open
	fEmbeddedHint = XML_TAG_NAME;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
	yybegin(ST_XML_TAG_NAME);
	return XML_END_TAG_OPEN;
            }
          case 110: break;
          case 43: 
            { if(Debug.debugTokenizer)
		dump("\nprocessing instruction start");//$NON-NLS-1$
	if ("<?".equals(yytext()) //$NON-NLS-1$
			&& !ProjectOptions.useShortTags(project)) {
		yybegin(ST_PI);
		return XML_PI_OPEN;
	} else if ("<?=".equals(yytext()) //$NON-NLS-1$
			&& !PHPVersion.PHP5_3.isLessThan(phpVersion)
			&& !ProjectOptions.useShortTags(project)) {
		yybegin(ST_PI);
		return XML_PI_OPEN;
	} else if ("<%".equals(yytext()) //$NON-NLS-1$
			&& !ProjectOptions.isSupportingAspTags(project)) {
		yypushback(1);
		yybegin(ST_XML_TAG_NAME);
		return XML_TAG_OPEN;
	} else {
		// removeing trailing whitespaces for the php open
		String phpStart = yytext();
		int i = phpStart.length() - 1;
		while (i >= 0
				&& Character.isWhitespace(phpStart.charAt(i--))) {
			yypushback(1);
		}
		fStateStack.push(yystate());// YYINITIAL
		if (fStateStack.peek() == YYINITIAL) {
			// the simple case, just a regular scriptlet out in
			// content
			yybegin(ST_PHP_CONTENT);
			return PHP_OPEN;
		} else {
			if (yystate() == ST_XML_ATTRIBUTE_VALUE_DQUOTED)
				fEmbeddedPostState = ST_XML_ATTRIBUTE_VALUE_DQUOTED;
			else if (yystate() == ST_XML_ATTRIBUTE_VALUE_SQUOTED)
				fEmbeddedPostState = ST_XML_ATTRIBUTE_VALUE_SQUOTED;
			else if (yystate() == ST_CDATA_TEXT) {
				fEmbeddedPostState = ST_CDATA_TEXT;
				fEmbeddedHint = XML_CDATA_TEXT;
			}
			yybegin(ST_PHP_CONTENT);
			assembleEmbeddedContainer(PHP_OPEN, PHP_CLOSE);
			if (yystate() == ST_ABORT_EMBEDDED) {
				// leave with unchanged state
				return PROXY_CONTEXT;
			}
			// required help for successive embedded regions
			if (yystate() == ST_XML_TAG_NAME) {
				fEmbeddedHint = XML_TAG_NAME;
				fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
			} else if ((yystate() == ST_XML_ATTRIBUTE_NAME || yystate() == ST_XML_EQUALS)) {
				fEmbeddedHint = XML_TAG_ATTRIBUTE_NAME;
				fEmbeddedPostState = ST_XML_EQUALS;
			} else if (yystate() == ST_XML_ATTRIBUTE_VALUE) {
				fEmbeddedHint = XML_TAG_ATTRIBUTE_VALUE;
				fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
			}
			return PROXY_CONTEXT;
		}
	}
            }
          case 111: break;
          case 44: 
            { fStateStack.push(yystate());
	if(Debug.debugTokenizer)
		dump("\ndeclaration start");//$NON-NLS-1$
	yybegin(ST_XML_DECLARATION);
	return XML_DECLARATION_OPEN;
            }
          case 112: break;
          case 45: 
            { if(Debug.debugTokenizer)
		dump("processing instruction end");//$NON-NLS-1$
	fEmbeddedHint = UNDEFINED;
	yybegin(YYINITIAL);
	return XML_PI_CLOSE;
            }
          case 113: break;
          case 46: 
            { // ended with nothing inside
	fEmbeddedHint = UNDEFINED;
	yybegin(YYINITIAL);
	return XML_PI_CLOSE;
            }
          case 114: break;
          case 47: 
            { if(Debug.debugTokenizer)
		dump("XML processing instruction end");//$NON-NLS-1$
	fEmbeddedHint = UNDEFINED;
	yybegin(YYINITIAL);
	return XML_PI_CLOSE;
            }
          case 115: break;
          case 48: 
            { yybegin(YYINITIAL);
	fEmbeddedHint = UNDEFINED;
	// empty tag close
	return XML_EMPTY_TAG_CLOSE;
            }
          case 116: break;
          case 49: 
            { String tagName = yytext().substring(1);
	// pushback to just after the opening bracket
	yypushback(yylength() - 1);
	/*
	 * If this tag can not be nested or we're already searching for an
	 * attribute name, equals, or value, return immediately.
	 */
	if (!isNestable(tagName) || (!fStateStack.empty() && (fStateStack.peek() == ST_XML_ATTRIBUTE_NAME || fStateStack.peek() == ST_XML_EQUALS || fStateStack.peek() == ST_XML_ATTRIBUTE_VALUE))) {
		yybegin(ST_XML_TAG_NAME);
		return XML_TAG_OPEN;
	}
	if(Debug.debugTokenizer)
		dump("tag in place of attr name");//$NON-NLS-1$
	fEmbeddedHint = XML_TAG_ATTRIBUTE_NAME;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
	fStateStack.push(yystate());
	// embedded container should be looking for the name (again) next
	yybegin(ST_XML_TAG_NAME);
	assembleEmbeddedTagSequence(XML_TAG_OPEN, tagName); // ?
	fStateStack.pop();
	yybegin(ST_XML_EQUALS);
	return PROXY_CONTEXT;
            }
          case 117: break;
          case 50: 
            { String tagName = yytext().substring(1);
	// pushback to just after the opening bracket
	yypushback(yylength() - 1);
	/*
	 * If this tag can not be nested or we're already searching for an
	 * attribute name, equals, or value, return immediately.
	 */
	if (!isNestable(tagName) || (!fStateStack.empty() && (fStateStack.peek() == ST_XML_ATTRIBUTE_NAME || fStateStack.peek() == ST_XML_EQUALS || fStateStack.peek() == ST_XML_ATTRIBUTE_VALUE))) {
		yybegin(ST_XML_TAG_NAME);
		return XML_TAG_OPEN;
	}
	if(Debug.debugTokenizer)
		dump("tag in place of attr value");//$NON-NLS-1$
	fEmbeddedHint = XML_TAG_ATTRIBUTE_VALUE;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
	fStateStack.push(yystate());
	// embedded container should be looking for the name (again) next
	yybegin(ST_XML_TAG_NAME);
	assembleEmbeddedTagSequence(XML_TAG_OPEN, tagName); // ?
	fStateStack.pop();
	yybegin(ST_XML_ATTRIBUTE_NAME);
	return PROXY_CONTEXT;
            }
          case 118: break;
          case 51: 
            { return XML_DOCTYPE_INTERNAL_SUBSET;
            }
          case 119: break;
          case 52: 
            { yybegin(fStateStack.pop());
	return PHP_CLOSE;
            }
          case 120: break;
          case 53: 
            { // begin embedded region: " + fEmbeddedHint);//$NON-NLS-1$
	int incomingState = yystate();
	fEmbeddedHint = XML_TAG_ATTRIBUTE_VALUE;
	fEmbeddedPostState = ST_XML_ATTRIBUTE_NAME;
	// Php attribute value start - end tag
	yybegin(ST_XML_TAG_NAME);
	assembleEmbeddedContainer(XML_END_TAG_OPEN, new String[]{XML_TAG_CLOSE, XML_EMPTY_TAG_CLOSE});
	if(yystate() != ST_ABORT_EMBEDDED) {
		// set incoming state when container
		// was correctly assembled
		yybegin(incomingState);
	}
	return PROXY_CONTEXT;
            }
          case 121: break;
          case 54: 
            { if(Debug.debugTokenizer)
		dump("\nEntityRef");//$NON-NLS-1$
	return XML_ENTITY_REFERENCE;
            }
          case 122: break;
          case 55: 
            { if(Debug.debugTokenizer)
		dump("\nPEReference");//$NON-NLS-1$
	return XML_PE_REFERENCE;
            }
          case 123: break;
          case 56: 
            { if(Debug.debugTokenizer)
		dump("CDATA end");//$NON-NLS-1$
	yybegin(fStateStack.pop());
	return XML_CDATA_CLOSE;
            }
          case 124: break;
          case 57: 
            { if(Debug.debugTokenizer)
		dump("comment end");//$NON-NLS-1$
	fEmbeddedHint = UNDEFINED;
	yybegin(YYINITIAL);
	return XML_COMMENT_CLOSE;
            }
          case 125: break;
          case 58: 
            { if(Debug.debugTokenizer)
		dump("XML processing instruction target");//$NON-NLS-1$
	fEmbeddedHint = XML_TAG_ATTRIBUTE_NAME;
	fEmbeddedPostState = ST_XML_EQUALS;
	yybegin(ST_XML_PI_ATTRIBUTE_NAME);
	return XML_TAG_NAME;
            }
          case 126: break;
          case 59: 
            { if(Debug.debugTokenizer)
		dump("\ncomment start");//$NON-NLS-1$
	fEmbeddedHint = XML_COMMENT_TEXT;
	fEmbeddedPostState = ST_XML_COMMENT;
	yybegin(ST_XML_COMMENT);
	return XML_COMMENT_OPEN;
            }
          case 127: break;
          case 60: 
            { if(Debug.debugTokenizer)
		dump("\nCharRef");//$NON-NLS-1$
	return XML_CHAR_REFERENCE;
            }
          case 128: break;
          case 61: 
            { if(Debug.debugTokenizer)
		dump("DHTML processing instruction target");//$NON-NLS-1$
	fEmbeddedHint = XML_TAG_ATTRIBUTE_NAME;
	fEmbeddedPostState = ST_XML_EQUALS;
	yybegin(ST_DHTML_ATTRIBUTE_NAME);
	return XML_TAG_NAME;
            }
          case 129: break;
          case 62: 
            { if(Debug.debugTokenizer)
		dump("doctype external id");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_ID_SYSTEM);
	return XML_DOCTYPE_EXTERNAL_ID_SYSTEM;
            }
          case 130: break;
          case 63: 
            { if(Debug.debugTokenizer)
		dump("doctype external id");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_ID_PUBLIC);
	return XML_DOCTYPE_EXTERNAL_ID_PUBLIC;
            }
          case 131: break;
          case 64: 
            { if(Debug.debugTokenizer)
		dump("doctype");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_DECLARATION);
	return XML_DOCTYPE_DECLARATION;
            }
          case 132: break;
          case 65: 
            { if(Debug.debugTokenizer)
		dump("attlist");//$NON-NLS-1$
	yybegin(ST_XML_ATTLIST_DECLARATION);
	return XML_ATTLIST_DECLARATION;
            }
          case 133: break;
          case 66: 
            { if(Debug.debugTokenizer)
		dump("element");//$NON-NLS-1$
	yybegin(ST_XML_ELEMENT_DECLARATION);
	return XML_ELEMENT_DECLARATION;
            }
          case 134: break;
          case 67: 
            { if(Debug.debugTokenizer)
		dump("\nCDATA start");//$NON-NLS-1$
	fStateStack.push(yystate());
	yybegin(ST_CDATA_TEXT);
	return XML_CDATA_OPEN;
            }
          case 135: break;
          case 68: 
            { if(Debug.debugTokenizer)
		dump("XSL processing instruction target");//$NON-NLS-1$
	fEmbeddedPostState = ST_XML_EQUALS;
	yybegin(ST_XML_PI_ATTRIBUTE_NAME);
	return XML_TAG_NAME;
            }
          case 136: break;
		default:
            zzScanError(ZZ_NO_MATCH);
				}
			}
		}
	}


}
