/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.compiler_ast.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.compiler.ast.parser.AbstractPHPSourceParser;
import org.eclipse.php.internal.core.compiler.ast.parser.PHPSourceParserFactory;
import org.eclipse.php.internal.core.compiler.ast.visitor.TypeDeclarationVisitor;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class TypeDeclarationVisitorTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    private AbstractPHPSourceParser parser;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/astutils/type_declaration_visitor/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/astutils/type_declaration_visitor/php5", "/workspace/astutils/type_declaration_visitor/php53"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/astutils/type_declaration_visitor/php54"});
        TESTS.put(PHPVersion.PHP5_5, new String[]{"/workspace/astutils/type_declaration_visitor/php54", "/workspace/astutils/type_declaration_visitor/php55"});
    }

    public TypeDeclarationVisitorTests(PHPVersion version, String[] fileNames) {
        this.parser = PHPSourceParserFactory.createParser((PHPVersion)version);
    }

    @Test
    public void visitor(String fileName) throws Exception {
        PdttFile pdttFile = new PdttFile(fileName);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdttFile.getFile().trim().getBytes());
        ModuleDeclaration moduleDeclaration = (ModuleDeclaration)this.parser.parse((Reader)new InputStreamReader(inputStream), null, ProjectOptions.useShortTags(null));
        final StringBuilder builder = new StringBuilder();
        moduleDeclaration.traverse((ASTVisitor)new TypeDeclarationVisitor(){

            public void visitType(TypeDeclaration s) {
                builder.append(s.getName());
                builder.append('\n');
            }
        });
        String actual = builder.toString();
        String expected = pdttFile.getExpected();
        PDTTUtils.assertContents(expected, actual);
    }
}

