/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.selection;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.codeassist.CodeAssistPdttFile;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class SelectionEngineTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();
    protected static final String SELECTION_CHAR = "|";
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected IProject project;
    protected IFile testFile = null;
    protected List<IFile> otherFiles = new ArrayList<IFile>();
    protected PHPVersion version;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/selection/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/selection/php5", "/workspace/selection/php53"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/selection/php5", "/workspace/selection/php53", "/workspace/selection/php54"});
        TESTS.put(PHPVersion.PHP5_5, new String[]{"/workspace/selection/php5", "/workspace/selection/php53", "/workspace/selection/php54", "/workspace/selection/php55"});
        TESTS.put(PHPVersion.PHP5_6, new String[]{"/workspace/selection/php5", "/workspace/selection/php53", "/workspace/selection/php54", "/workspace/selection/php55", "/workspace/selection/php56"});
        TESTS.put(PHPVersion.PHP7_0, new String[]{"/workspace/selection/php5", "/workspace/selection/php53", "/workspace/selection/php54", "/workspace/selection/php55", "/workspace/selection/php56", "/workspace/selection/php7"});
        TESTS.put(PHPVersion.PHP7_1, new String[]{"/workspace/selection/php5", "/workspace/selection/php53", "/workspace/selection/php54", "/workspace/selection/php55", "/workspace/selection/php56", "/workspace/selection/php7", "/workspace/selection/php71"});
    }

    public SelectionEngineTests(PHPVersion version, String[] fileNames) {
        this.version = version;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        this.project = TestUtils.createProject("AutoSelectionEngine_" + this.version.toString());
        TestUtils.setProjectPhpVersion(this.project, this.version);
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        TestUtils.deleteProject(this.project);
    }

    @Test
    public void selection(String fileName) throws Exception {
        int n;
        CodeAssistPdttFile pdttFile = new CodeAssistPdttFile(fileName);
        IModelElement[] elements = this.getSelection(pdttFile);
        CodeAssistPdttFile.ExpectedProposal[] expectedProposals = pdttFile.getExpectedProposals();
        boolean addFileAndNamespace = pdttFile.getOtherFiles().length > 0;
        boolean proposalsEqual = true;
        if (elements.length == expectedProposals.length) {
            CodeAssistPdttFile.ExpectedProposal[] expectedProposalArray = pdttFile.getExpectedProposals();
            n = expectedProposalArray.length;
            int n2 = 0;
            while (n2 < n) {
                CodeAssistPdttFile.ExpectedProposal expectedProposal = expectedProposalArray[n2];
                boolean found = false;
                IModelElement[] iModelElementArray = elements;
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IModelElement modelElement = iModelElementArray[n4];
                    if (modelElement.getElementType() == expectedProposal.type && this.getProposalName(modelElement, addFileAndNamespace).equalsIgnoreCase(expectedProposal.name)) {
                        found = true;
                        break;
                    }
                    ++n4;
                }
                if (!found) {
                    proposalsEqual = false;
                    break;
                }
                ++n2;
            }
        } else {
            proposalsEqual = false;
        }
        if (!proposalsEqual) {
            StringBuilder errorBuf = new StringBuilder();
            errorBuf.append("\nEXPECTED ELEMENTS LIST:\n-----------------------------\n");
            errorBuf.append(pdttFile.getExpected());
            errorBuf.append("\nACTUAL ELEMENTS LIST:\n-----------------------------\n");
            IModelElement[] iModelElementArray = elements;
            int n5 = elements.length;
            n = 0;
            while (n < n5) {
                IModelElement modelElement = iModelElementArray[n];
                switch (modelElement.getElementType()) {
                    case 8: {
                        errorBuf.append("field");
                        break;
                    }
                    case 9: {
                        errorBuf.append("method");
                        break;
                    }
                    case 7: {
                        errorBuf.append("type");
                    }
                }
                errorBuf.append('(').append(this.getProposalName(modelElement, addFileAndNamespace)).append(")\n");
                ++n;
            }
            Assert.fail((String)errorBuf.toString());
        }
    }

    @After
    public void after() throws Exception {
        if (this.testFile != null) {
            TestUtils.deleteFile(this.testFile);
            this.testFile = null;
        }
        for (IFile otherFile : this.otherFiles) {
            TestUtils.deleteFile(otherFile);
        }
        this.otherFiles.clear();
    }

    protected String getProposalName(IModelElement modelElement, boolean addFileAndNamespace) {
        StringBuilder out = new StringBuilder();
        if (addFileAndNamespace) {
            IType namespace = PHPModelUtils.getCurrentNamespace((IModelElement)modelElement);
            String namespaceName = namespace != null ? namespace.getElementName() : "";
            out.append(modelElement.getPath().lastSegment()).append('|').append(namespaceName).append('|').append(modelElement.getElementName());
        } else {
            out.append(modelElement.getElementName());
        }
        return out.toString();
    }

    protected ISourceRange createFile(PdttFile pdttFile) throws Exception {
        String cursor = SelectionEngineTests.getCursor(pdttFile) != null ? SelectionEngineTests.getCursor(pdttFile) : SELECTION_CHAR;
        String data = pdttFile.getFile();
        int left = data.indexOf(cursor);
        if (left == -1) {
            throw new IllegalArgumentException("Selection characters are not set");
        }
        int right = (data = String.valueOf(data.substring(0, left)) + data.substring(left + 1)).indexOf(cursor);
        if (right == -1) {
            throw new IllegalArgumentException("Selection is not closed");
        }
        data = String.valueOf(data.substring(0, right)) + data.substring(right + 1);
        this.testFile = TestUtils.createFile(this.project, "FILE.php", data);
        return new SourceRange(left, right - left);
    }

    protected ISourceModule getSourceModule() {
        return DLTKCore.createSourceModuleFrom((IFile)this.testFile);
    }

    protected IModelElement[] getSelection(CodeAssistPdttFile pdttFile) throws Exception {
        ISourceRange range = this.createFile(pdttFile);
        int i = 0;
        int len = pdttFile.getOtherFiles().length;
        while (i < len) {
            this.otherFiles.add(TestUtils.createFile(this.project, "FILE" + i + ".php", pdttFile.getOtherFile(i)));
            ++i;
        }
        TestUtils.waitForIndexer();
        ISourceModule sourceModule = this.getSourceModule();
        IModelElement[] elements = sourceModule.codeSelect(range.getOffset(), range.getLength());
        return elements;
    }

    private static String getCursor(PdttFile pdttFile) {
        Map<String, String> config = pdttFile.getConfig();
        return config.get("cursor");
    }
}

