/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocTagContext;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalTypesStrategy;

public class PHPDocReturnTypeStrategy
extends GlobalTypesStrategy {
    private static final String[] PRIMITIVE_TYPES = new String[]{"string", "int", "integer", "float", "bool", "boolean", "array", "resource", "null", "callable", "NULL", "double"};
    private static final String[] KEYWORDS = new String[]{"mixed", "void", "object", "false", "true", "self", "static", "$this"};

    public PHPDocReturnTypeStrategy(ICompletionContext context) {
        super(context, 0, 2048);
    }

    public PHPDocReturnTypeStrategy(ICompletionContext context, int trueFlag, int falseFlag) {
        super(context, trueFlag, falseFlag);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof PHPDocTagContext)) {
            return;
        }
        super.apply(reporter);
        if (!((PHPDocTagContext)context).isGlobal()) {
            String prefix = ((PHPDocTagContext)context).getPrefix();
            ISourceRange replaceRange = this.getReplacementRange(context);
            int i = 0;
            while (i < PRIMITIVE_TYPES.length) {
                this.reportKeyword(reporter, replaceRange, PRIMITIVE_TYPES[i], prefix);
                ++i;
            }
            i = 0;
            while (i < KEYWORDS.length) {
                this.reportKeyword(reporter, replaceRange, KEYWORDS[i], prefix);
                ++i;
            }
        }
    }

    private void reportKeyword(ICompletionReporter reporter, ISourceRange replaceRange, String keyword, String prefix) {
        if (keyword.startsWith(prefix)) {
            reporter.reportKeyword(keyword, "", replaceRange);
        }
    }

    @Override
    protected int getExtraInfo() {
        return 2;
    }
}

