/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.Reference;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class Include
extends Reference {
    public static final int IT_REQUIRE = 0;
    public static final int IT_REQUIRE_ONCE = 1;
    public static final int IT_INCLUDE = 2;
    public static final int IT_INCLUDE_ONCE = 3;
    private final Expression expr;
    private final int includeType;

    public Include(int start, int end, Expression expr, int type) {
        super(start, end);
        assert (expr != null);
        this.expr = expr;
        this.includeType = type;
    }

    public String getType() {
        switch (this.getIncludeType()) {
            case 0: {
                return "require";
            }
            case 1: {
                return "require_once";
            }
            case 2: {
                return "include";
            }
            case 3: {
                return "include_once";
            }
        }
        throw new IllegalArgumentException();
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Expression)this);
        if (visit) {
            this.expr.traverse(visitor);
        }
        visitor.endvisit((Expression)this);
    }

    public int getKind() {
        return 36;
    }

    public Expression getExpr() {
        return this.expr;
    }

    public int getIncludeType() {
        return this.includeType;
    }

    public String getStringRepresentation() {
        return this.getType();
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

