/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.search;

import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.BodyDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ConstantDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FullyQualifiedTraitMethodReference;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.FunctionName;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.TraitAlias;
import org.eclipse.php.internal.core.ast.nodes.TraitDeclaration;
import org.eclipse.php.internal.core.ast.nodes.TraitUseStatement;
import org.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.core.search.AbstractOccurrencesFinder;
import org.eclipse.php.internal.core.search.IOccurrencesFinder;
import org.eclipse.php.internal.core.search.Messages;

public class ClassMembersOccurrencesFinder
extends AbstractOccurrencesFinder {
    public static final String ID = "ClassMembersOccurrencesFinder";
    private String classMemberName;
    private String typeDeclarationName;
    private boolean isMethod;
    private ITypeBinding dispatcherType;
    private ASTNode erroneousNode;
    private boolean isIncludesuper;
    private List<IType> traitList;

    public void setIncludesuper(boolean isIncludesuper) {
        this.isIncludesuper = isIncludesuper;
    }

    @Override
    public String initialize(Program root, ASTNode node) {
        this.fASTRoot = root;
        this.fProblems = ClassMembersOccurrencesFinder.getProblems(root);
        this.typeDeclarationName = null;
        this.isMethod = false;
        PHPVersion phpVersion = PHPVersion.PHP5_4;
        if (root.getSourceModule().getScriptProject() != null && root.getSourceModule().getScriptProject().getProject() != null) {
            phpVersion = ProjectOptions.getPhpVersion(root.getSourceModule().getScriptProject().getProject());
        }
        if (node.getType() == 33) {
            Identifier identifier = (Identifier)node;
            this.classMemberName = identifier.getName();
            ASTNode parent = identifier.getParent();
            int type = parent.getType();
            this.isMethod = type == 29 || parent.getLocationInParent() == FunctionName.NAME_PROPERTY || parent.getLocationInParent() == FunctionInvocation.FUNCTION_PROPERTY || type == 73 || type == 74;
            this.dispatcherType = this.resolveDispatcherType(identifier);
            if (this.dispatcherType != null && phpVersion.isGreaterThan(PHPVersion.PHP5_3)) {
                String memberName = this.getRealName(identifier);
                this.traitList = this.dispatcherType.getTraitList(this.isMethod, memberName, false);
            }
            while (this.typeDeclarationName == null && parent != this.fASTRoot) {
                if (type == 12 || type == 40) {
                    this.typeDeclarationName = ((TypeDeclaration)parent).getName().getName();
                    break;
                }
                parent = parent.getParent();
                type = parent.getType();
            }
            if (this.hasProblems(node.getStart(), node.getEnd())) {
                this.erroneousNode = node;
            }
            return null;
        }
        this.fDescription = "OccurrencesFinder_occurrence_description";
        return this.fDescription;
    }

    private ITypeBinding resolveDispatcherType(Identifier identifier) {
        ITypeBinding typeBinding = null;
        ASTNode parent = identifier.getParent();
        if (parent.getType() == 60) {
            Variable var = (Variable)parent;
            ASTNode varParent = var.getParent();
            while (varParent.getType() == 0) {
                varParent = varParent.getParent();
            }
            if (varParent.getType() == 24 && ((FieldAccess)varParent).getDispatcher() != null) {
                typeBinding = ((FieldAccess)varParent).getDispatcher().resolveTypeBinding();
            } else if (varParent.getType() == 52) {
                typeBinding = ((StaticFieldAccess)varParent).getClassName().resolveTypeBinding();
            } else if (varParent.getType() == 31) {
                FunctionInvocation fi;
                FunctionName fn = (FunctionName)varParent;
                if (fn.getParent().getType() == 30 && (fi = (FunctionInvocation)fn.getParent()).getParent().getType() == 43 && ((MethodInvocation)fi.getParent()).getDispatcher() != null) {
                    typeBinding = ((MethodInvocation)fi.getParent()).getDispatcher().resolveTypeBinding();
                }
            } else if (varParent.getType() == 63) {
                return this.resolveDeclaringClassType(var.getParent());
            }
        } else if (parent.getType() == 31) {
            FunctionInvocation fi;
            FunctionName fn = (FunctionName)parent;
            if (fn.getParent().getType() == 30 && (fi = (FunctionInvocation)fn.getParent()).getParent().getType() == 53) {
                typeBinding = ((StaticMethodInvocation)fi.getParent()).getClassName().resolveTypeBinding();
            }
        } else if (parent.getType() == 10) {
            StaticConstantAccess sca = (StaticConstantAccess)parent;
            typeBinding = sca.getClassName().resolveTypeBinding();
        } else if (parent.getType() == 52) {
            StaticFieldAccess sfa = (StaticFieldAccess)parent;
            typeBinding = sfa.getClassName().resolveTypeBinding();
        } else {
            if (parent.getType() == 42) {
                MethodDeclaration md = (MethodDeclaration)parent;
                return this.resolveDeclaringClassType(md);
            }
            if (parent.getType() == 29) {
                FunctionDeclaration fd = (FunctionDeclaration)parent;
                return this.resolveDeclaringClassType(fd);
            }
            if (parent.getType() == 11) {
                ConstantDeclaration ccd = (ConstantDeclaration)parent;
                return this.resolveDeclaringClassType(ccd);
            }
            if (parent.getType() == 73) {
                FullyQualifiedTraitMethodReference reference = (FullyQualifiedTraitMethodReference)parent;
                typeBinding = reference.getClassName().resolveTypeBinding();
                ITypeBinding temp = this.getTypeBinding(typeBinding, reference.getFunctionName().getName());
                if (temp != null) {
                    return temp;
                }
            } else if (parent.getType() == 74) {
                TraitAlias traitAlias = (TraitAlias)parent;
                List<NamespaceName> nameList = ((TraitUseStatement)traitAlias.getParent().getParent()).getTraitList();
                String memberName = null;
                if (identifier == traitAlias.getFunctionName()) {
                    Expression expression = traitAlias.getTraitMethod();
                    if (expression.getType() == 73) {
                        FullyQualifiedTraitMethodReference fqtm = (FullyQualifiedTraitMethodReference)expression;
                        memberName = fqtm.getFunctionName().getName();
                    } else {
                        memberName = ((Identifier)expression).getName();
                    }
                } else {
                    memberName = identifier.getName();
                }
                for (NamespaceName namespaceName : nameList) {
                    typeBinding = namespaceName.resolveTypeBinding();
                    ITypeBinding temp = this.getTypeBinding(typeBinding, memberName);
                    if (temp == null) continue;
                    return temp;
                }
                return null;
            }
        }
        if (typeBinding != null && (typeBinding.isClass() || typeBinding.isTrait()) && typeBinding.getPHPElement() != null) {
            return typeBinding;
        }
        return null;
    }

    private ITypeBinding getTypeBinding(ITypeBinding typeBinding, String memberName) {
        if (typeBinding != null && typeBinding.isTrait() && typeBinding.getPHPElement() != null) {
            try {
                IModelElement[] members;
                IModelElement[] iModelElementArray = members = ((IType)typeBinding.getPHPElement()).getChildren();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelElement modelElement = iModelElementArray[n2];
                    if (modelElement.getElementName().equals(memberName) || modelElement.getElementName().equals("$" + memberName)) {
                        if (modelElement instanceof IMethod) {
                            if (this.dispatcherType == null && typeBinding.getPHPElement() != null) {
                                this.isMethod = true;
                            }
                        } else if (this.dispatcherType == null && typeBinding.getPHPElement() != null) {
                            this.isMethod = false;
                        }
                        return typeBinding;
                    }
                    ++n2;
                }
            }
            catch (ModelException modelException) {}
        }
        return null;
    }

    private boolean isDispatcherTypeEquals(Identifier identifier, boolean includeSuper) {
        ITypeBinding type = this.resolveDispatcherType(identifier);
        if (type != null && this.traitList != null && !this.traitList.isEmpty()) {
            String memberName = this.getRealName(identifier);
            List<IType> traitList1 = type.getTraitList(this.isMethod, memberName, false);
            for (IType trait1 : traitList1) {
                for (IType trait : this.traitList) {
                    if (!trait1.equals(trait)) continue;
                    return true;
                }
            }
        }
        return type != null && (type.equals(this.dispatcherType) || includeSuper && (type.isSubTypeCompatible(this.dispatcherType) || this.dispatcherType.isSubTypeCompatible(type)));
    }

    private String getRealName(Identifier identifier) {
        TraitAlias traitAlias;
        String memberName = this.classMemberName;
        if (identifier.getParent().getType() == 74 && identifier == (traitAlias = (TraitAlias)identifier.getParent()).getFunctionName()) {
            Expression expression = traitAlias.getTraitMethod();
            if (expression.getType() == 73) {
                FullyQualifiedTraitMethodReference fqtm = (FullyQualifiedTraitMethodReference)expression;
                memberName = fqtm.getFunctionName().getName();
            } else {
                memberName = ((Identifier)expression).getName();
            }
        }
        return memberName;
    }

    protected ITypeBinding resolveDeclaringClassType(ASTNode node) {
        IType[] types = new IType[2];
        ASTNode parent = node.getParent();
        TypeDeclaration typeDeclaration = null;
        NamespaceDeclaration namespaceDeclaration = null;
        while (typeDeclaration == null && parent != null) {
            if (parent.getType() == 12 || parent.getType() == 40) {
                typeDeclaration = (TypeDeclaration)parent;
            }
            parent = parent.getParent();
        }
        while (namespaceDeclaration == null && parent != null) {
            if (parent.getType() == 64) {
                namespaceDeclaration = (NamespaceDeclaration)parent;
            }
            parent = parent.getParent();
        }
        if (typeDeclaration != null) {
            ITypeBinding typeBinding;
            if (namespaceDeclaration != null && namespaceDeclaration.getName() != null) {
                ISourceModule source = namespaceDeclaration.getProgramRoot().getSourceModule();
                IType iType = types[0] = source != null ? source.getType(namespaceDeclaration.getName().getName()) : null;
            }
            if ((typeBinding = typeDeclaration.resolveTypeBinding()) != null) {
                return typeBinding;
            }
        }
        return null;
    }

    @Override
    protected void findOccurrences() {
        this.fDescription = this.isMethod ? Messages.format(BASE_DESCRIPTION, String.valueOf(this.classMemberName) + "()") : Messages.format(BASE_DESCRIPTION, this.classMemberName);
        if (this.erroneousNode != null) {
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(this.erroneousNode.getStart(), this.erroneousNode.getLength(), this.getOccurrenceType(this.erroneousNode), this.fDescription));
        } else {
            this.fASTRoot.accept(this);
        }
    }

    @Override
    public boolean visit(ClassDeclaration classDeclaration) {
        this.checkTypeDeclaration(classDeclaration);
        return false;
    }

    @Override
    public boolean visit(TraitDeclaration traitDeclaration) {
        this.checkTypeDeclaration(traitDeclaration);
        return false;
    }

    @Override
    public boolean visit(InterfaceDeclaration interfaceDeclaration) {
        this.checkTypeDeclaration(interfaceDeclaration);
        return false;
    }

    @Override
    public boolean visit(MethodInvocation methodInvocation) {
        if (this.isMethod) {
            this.checkDispatch(methodInvocation.getMethod().getFunctionName().getName());
        }
        return super.visit(methodInvocation);
    }

    @Override
    public boolean visit(FieldAccess fieldAccess) {
        if (!this.isMethod) {
            this.checkDispatch(fieldAccess.getField().getName());
        }
        return super.visit(fieldAccess);
    }

    @Override
    public boolean visit(StaticConstantAccess classConstantAccess) {
        Identifier constant = classConstantAccess.getConstant();
        if (!this.isMethod && this.classMemberName.equals(constant.getName())) {
            if (this.dispatcherType != null) {
                if (this.isDispatcherTypeEquals(constant, this.isIncludesuper)) {
                    this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(constant.getStart(), constant.getLength(), this.getOccurrenceType(constant), this.fDescription));
                }
            } else {
                this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(constant.getStart(), constant.getLength(), this.getOccurrenceType(constant), this.fDescription));
            }
        }
        return true;
    }

    @Override
    public boolean visit(StaticMethodInvocation methodInvocation) {
        if (this.isMethod) {
            this.checkDispatch(methodInvocation.getMethod().getFunctionName().getName());
        }
        return super.visit(methodInvocation);
    }

    @Override
    public boolean visit(FullyQualifiedTraitMethodReference fieldAccess) {
        this.checkDispatch(fieldAccess.getFunctionName());
        return super.visit(fieldAccess);
    }

    @Override
    public boolean visit(StaticFieldAccess fieldAccess) {
        if (!this.isMethod) {
            this.checkDispatch(fieldAccess.getField().getName());
        }
        return super.visit(fieldAccess);
    }

    @Override
    public boolean visit(TraitAlias node) {
        if (this.dispatcherType != null) {
            Expression expression = node.getTraitMethod();
            if (expression.getType() == 73) {
                this.visit((FullyQualifiedTraitMethodReference)expression);
            } else {
                this.checkDispatch(expression);
            }
            if (node.getFunctionName() != null) {
                this.checkDispatch(node.getFunctionName());
            }
            return false;
        }
        return super.visit(node);
    }

    private void checkDispatch(ASTNode node) {
        VariableBase id;
        while (node.getType() == 0) {
            node = ((ArrayAccess)node).getName();
        }
        if (node.getType() == 33 && ((Identifier)(id = (Identifier)node)).getName().equals(this.classMemberName)) {
            if (this.dispatcherType != null) {
                if (this.isDispatcherTypeEquals((Identifier)id, this.isIncludesuper)) {
                    if (id.getParent() instanceof Variable) {
                        this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(id.getParent().getStart(), id.getParent().getLength(), this.getOccurrenceType(node), this.fDescription));
                    } else {
                        this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(node.getStart(), node.getLength(), this.getOccurrenceType(node), this.fDescription));
                    }
                }
            } else if (id.getParent() instanceof Variable) {
                this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(id.getParent().getStart(), id.getParent().getLength(), this.getOccurrenceType(node), this.fDescription));
            } else {
                this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(node.getStart(), node.getLength(), this.getOccurrenceType(node), this.fDescription));
            }
        }
        if (node instanceof Variable) {
            id = (Variable)node;
            this.checkDispatch(((Variable)id).getName());
        }
    }

    private void checkTypeDeclaration(TypeDeclaration typeDeclaration) {
        assert (typeDeclaration != null);
        Block body = typeDeclaration.getBody();
        List<Statement> statements = body.statements();
        for (Statement statement : statements) {
            Object variableNames;
            BodyDeclaration classVariableDeclaration;
            if (statement.getType() == 42) {
                Identifier functionName;
                MethodDeclaration classMethodDeclaration = (MethodDeclaration)statement;
                if (!this.isMethod || !this.classMemberName.equals((functionName = classMethodDeclaration.getFunction().getFunctionName()).getName())) continue;
                if (this.dispatcherType != null) {
                    if (!this.isDispatcherTypeEquals(functionName, this.isIncludesuper)) continue;
                    this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(functionName.getStart(), functionName.getLength(), this.getOccurrenceType(functionName), this.fDescription));
                    continue;
                }
                this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(functionName.getStart(), functionName.getLength(), this.getOccurrenceType(functionName), this.fDescription));
                continue;
            }
            if (statement.getType() == 25) {
                if (this.isMethod) continue;
                classVariableDeclaration = (FieldsDeclaration)statement;
                variableNames = ((FieldsDeclaration)classVariableDeclaration).getVariableNames();
                int j = 0;
                while (j < ((Object)variableNames).length) {
                    assert (((Variable)variableNames[j]).getName().getType() == 33);
                    Identifier variable = (Identifier)((Variable)variableNames[j]).getName();
                    if (this.classMemberName.equals(variable.getName())) {
                        if (this.dispatcherType != null) {
                            if (this.isDispatcherTypeEquals(variable, this.isIncludesuper)) {
                                this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(variable.getStart() - 1, variable.getLength() + 1, 1, this.fDescription));
                            }
                        } else {
                            this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(variable.getStart() - 1, variable.getLength() + 1, 1, this.fDescription));
                        }
                    }
                    ++j;
                }
                continue;
            }
            if (statement.getType() != 11) continue;
            classVariableDeclaration = (ConstantDeclaration)statement;
            variableNames = ((ConstantDeclaration)classVariableDeclaration).names();
            Iterator iterator = variableNames.iterator();
            while (iterator.hasNext()) {
                Identifier name = (Identifier)iterator.next();
                if (!this.classMemberName.equals(name.getName())) continue;
                if (this.dispatcherType != null) {
                    if (!this.isDispatcherTypeEquals(name, this.isIncludesuper)) continue;
                    this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(name.getStart(), name.getLength(), this.getOccurrenceType(name), this.fDescription));
                    continue;
                }
                this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(name.getStart(), name.getLength(), this.getOccurrenceType(name), this.fDescription));
            }
        }
        body.accept(this);
    }

    @Override
    protected int getOccurrenceType(ASTNode node) {
        if (node.getParent().getType() == 11 || this.isInAssignment(node)) {
            return 1;
        }
        return 2;
    }

    protected boolean isInAssignment(ASTNode node) {
        FieldAccess fAccess;
        Variable var;
        return node.getParent().getType() == 60 && (var = (Variable)node.getParent()).getParent().getType() == 24 && (fAccess = (FieldAccess)var.getParent()).getLocationInParent() == Assignment.LEFT_HAND_SIDE_PROPERTY;
    }

    @Override
    public String getElementName() {
        return this.classMemberName;
    }

    @Override
    public String getID() {
        return ID;
    }
}

