/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.model.IPHPDataType;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.AbstractDBGpValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpValueBuilder;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.w3c.dom.Node;

public abstract class DBGpVariable
extends DBGpElement
implements IVariable,
IVariableFacet,
IPHPDataType {
    protected final int fStackLevel;
    protected final Set<IVariableFacet.Facet> fFacets = new HashSet<IVariableFacet.Facet>();
    protected IPHPDataType.DataType fDataType;
    protected Node fDescriptor;
    protected String fName;
    protected String fFullName;
    protected String fAddress;
    protected AbstractDBGpValue fValue;
    protected boolean fHasValueChanged = false;
    protected boolean fIsDirty = true;

    public DBGpVariable(IDebugTarget target, Node descriptor, int stackLevel, IVariableFacet.Facet ... facets) {
        super(target);
        this.fStackLevel = stackLevel;
        this.addFacets(facets);
        this.update(descriptor);
    }

    @Override
    public IPHPDataType.DataType getDataType() {
        return this.fDataType;
    }

    public void setValue(String value) throws DebugException {
        if (!this.verifyValue(value)) {
            Status stat = new Status(2, "org.eclipse.php.debug.core", PHPDebugCoreMessages.XDebug_DBGpVariable_0);
            throw new DebugException((IStatus)stat);
        }
        if (!((DBGpTarget)this.getDebugTarget()).setProperty(this, value)) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.php.debug.core", 5010, PHPDebugCoreMessages.XDebug_DBGpVariable_1, null));
        }
        this.fValue.setValue(value);
        this.fireChangeEvent(512);
    }

    public void setValue(IValue value) throws DebugException {
        this.setValue(value.getValueString());
    }

    public boolean supportsValueModification() {
        return this.fValue.supportsValueModification();
    }

    public boolean verifyValue(String value) throws DebugException {
        return this.fValue.verifyValue(value);
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return this.verifyValue(value.getValueString());
    }

    @Override
    public boolean hasFacet(IVariableFacet.Facet facet) {
        return this.fFacets.contains((Object)facet);
    }

    @Override
    public void addFacets(IVariableFacet.Facet ... facets) {
        IVariableFacet.Facet[] facetArray = facets;
        int n = facets.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableFacet.Facet facet = facetArray[n2];
            this.fFacets.add(facet);
            ++n2;
        }
    }

    public IValue getValue() throws DebugException {
        return this.fValue;
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    public String getReferenceTypeName() throws DebugException {
        if (this.getName().equals("<class>")) {
            return "class";
        }
        return this.fValue.getDataType().getText();
    }

    public boolean hasValueChanged() throws DebugException {
        return this.fHasValueChanged;
    }

    protected abstract Kind getKind();

    protected abstract Node getNode(int var1);

    protected int getStackLevel() {
        return this.fStackLevel;
    }

    protected String getFullName() {
        return this.fFullName;
    }

    protected Node getDescriptor() {
        return this.fDescriptor;
    }

    protected void update(Node descriptor) {
        this.fDescriptor = descriptor;
        this.fName = DBGpResponse.getAttribute(this.fDescriptor, "name");
        this.fFullName = DBGpResponse.getAttribute(this.fDescriptor, "fullname");
        this.fAddress = DBGpResponse.getAttribute(this.fDescriptor, "address");
        String facets = DBGpResponse.getAttribute(this.fDescriptor, "facet");
        if (facets.contains("static")) {
            this.addFacets(IVariableFacet.Facet.MOD_STATIC);
        }
        if (facets.contains("public")) {
            this.addFacets(IVariableFacet.Facet.MOD_PUBLIC);
        } else if (facets.contains("protected")) {
            this.addFacets(IVariableFacet.Facet.MOD_PROTECTED);
        } else if (facets.contains("private")) {
            this.addFacets(IVariableFacet.Facet.MOD_PRIVATE);
        }
        if (this.hasFacet(IVariableFacet.Facet.KIND_ARRAY_MEMBER)) {
            this.fName = String.valueOf('[') + this.fName + ']';
        } else if (this.hasFacet(IVariableFacet.Facet.MOD_STATIC) && this.fName.startsWith(":")) {
            this.fName = this.fName.substring(this.fName.lastIndexOf(58) + 1);
        } else if (this.fName.equals("::")) {
            this.fName = "<class>";
        }
        if (this.fFullName.length() > 1 && this.fName.equals(this.fFullName.substring(1))) {
            this.fName = this.fFullName;
        }
        String type = DBGpResponse.getAttribute(this.fDescriptor, "type");
        String previousValueString = null;
        if (this.fValue != null) {
            previousValueString = this.fValue.fValueString;
        }
        this.fDataType = IPHPDataType.DataType.find(type);
        if (this.fValue != null && this.fValue.getDataType() == this.fDataType) {
            this.fValue.update(this.fDescriptor);
        } else {
            this.fValue = new DBGpValueBuilder().build(this);
        }
        if (previousValueString != null) {
            this.fHasValueChanged = !previousValueString.equals(this.fValue.fValueString);
        }
    }

    public static enum Kind {
        STACK,
        EVAL;

    }
}

