/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.communication;

import com.ibm.icu.text.MessageFormat;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.debug.core.debugger.handlers.IDebugMessageHandler;
import org.eclipse.php.debug.core.debugger.handlers.IDebugRequestHandler;
import org.eclipse.php.debug.core.debugger.messages.IDebugMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugNotificationMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugRequestMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugResponseMessage;
import org.eclipse.php.internal.core.util.BlockingQueue;
import org.eclipse.php.internal.core.util.collections.IntHashtable;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.DebugSessionIdGenerator;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.launching.PHPProcess;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.zend.communication.CommunicationAdministrator;
import org.eclipse.php.internal.debug.core.zend.communication.CommunicationClient;
import org.eclipse.php.internal.debug.core.zend.communication.OpenRemoteFileRequestor;
import org.eclipse.php.internal.debug.core.zend.communication.ResponseHandler;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugMessagesRegistry;
import org.eclipse.php.internal.debug.core.zend.debugger.PHPSessionLaunchMapper;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerSettingsUtil;
import org.eclipse.php.internal.debug.core.zend.debugger.handlers.FileContentDebugHandler;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.DebugMessageImpl;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.DebugSessionStartedNotification;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.OutputNotification;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.SetProtocolRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.SetProtocolResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.StartRequest;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPMultiDebugTarget;
import org.eclipse.php.internal.debug.core.zend.testConnection.DebugServerTestController;
import org.eclipse.php.internal.debug.core.zend.testConnection.DebugServerTestEvent;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DebugConnection {
    public static final String REMOTE_LAUNCH_TYPE_ID = "org.eclipse.php.debug.core.remotePHPLaunchConfigurationType";
    public static final String REMOTE_DEBUG_LAUNCH_NAME = "PHP Debug";
    private static final Lock HOOK_LOCK = new ReentrantLock(true);
    private static final long HOOK_TIMEOUT = 10000L;
    private final IDebugMessage CONNECTION_CLOSED = new DebugMessageImpl(){

        @Override
        public void deserialize(DataInputStream in) throws IOException {
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public void serialize(DataOutputStream out) throws IOException {
        }
    };
    protected static final int START_MESSAGE_ID = new DebugSessionStartedNotification().getType();
    protected int debugResponseTimeout;
    protected PHPDebugTarget debugTarget;
    protected boolean isValidProtocol;
    private Socket socket;
    private DataInputStream connectionIn;
    private DataOutputStream connectionOut;
    private boolean isInitialized;
    private MessageReceiver messageReceiver;
    private MessageHandler messageHandler;
    private CommunicationClient communicationClient;
    private CommunicationAdministrator communicationAdministrator;
    private IntHashtable requestsTable;
    private IntHashtable responseTable;
    private Hashtable<Integer, ResponseHandler> responseHandlers;
    private ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private DataOutputStream dataOutputStream = new DataOutputStream(this.byteArrayOutputStream);
    private int lastRequestID = 1000;
    private Map<Integer, IDebugMessageHandler> messageHandlers;
    private boolean isConnected = true;

    public DebugConnection(Socket socket) {
        this.socket = socket;
        this.connect();
    }

    public synchronized void disconnect() {
        this.messageReceiver.shutdown();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public CommunicationClient getCommunicationClient() {
        return this.communicationClient;
    }

    public CommunicationAdministrator getCommunicationAdministrator() {
        return this.communicationAdministrator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(Object msg) {
        if (!this.isConnected) {
            return;
        }
        try {
            DataOutputStream dataOutputStream = this.connectionOut;
            synchronized (dataOutputStream) {
                this.byteArrayOutputStream.reset();
                ((IDebugMessage)msg).serialize(this.dataOutputStream);
                this.connectionOut.writeInt(this.byteArrayOutputStream.size());
                this.byteArrayOutputStream.writeTo(this.connectionOut);
                this.connectionOut.flush();
            }
        }
        catch (SocketException se) {
            if (PHPDebugPlugin.DEBUG) {
                Logger.log(2, se.getMessage(), se);
            }
        }
        catch (Exception exc) {
            PHPDebugPlugin.log(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendRequest(Object request) throws Exception {
        if (!this.isConnected) {
            return null;
        }
        Logger.debugMSG("SENDING SYNCHRONOUS REQUEST: " + request);
        try {
            IDebugRequestMessage theMsg = (IDebugRequestMessage)request;
            DataOutputStream dataOutputStream = this.connectionOut;
            synchronized (dataOutputStream) {
                this.byteArrayOutputStream.reset();
                theMsg.setID(this.lastRequestID++);
                theMsg.serialize(this.dataOutputStream);
                int messageSize = this.byteArrayOutputStream.size();
                this.requestsTable.put(theMsg.getID(), (Object)theMsg);
                this.connectionOut.writeInt(messageSize);
                this.byteArrayOutputStream.writeTo(this.connectionOut);
                this.connectionOut.flush();
            }
            IDebugResponseMessage response = null;
            int timeoutTick = 500;
            int waitedTime = 0;
            while (response == null && this.isConnected()) {
                Object object = request;
                synchronized (object) {
                    response = (IDebugResponseMessage)this.responseTable.remove(theMsg.getID());
                    if (response == null) {
                        if (waitedTime > this.debugResponseTimeout / 4) {
                            PHPLaunchUtilities.showWaitForDebuggerMessage(this);
                        }
                        request.wait(timeoutTick);
                    }
                }
                if (response == null) {
                    response = (IDebugResponseMessage)this.responseTable.remove(theMsg.getID());
                }
                if (response != null || !this.isConnected()) continue;
                Logger.debugMSG("COMMUNICATION PROBLEMS (response is null)");
                if (waitedTime < this.debugResponseTimeout - timeoutTick) {
                    waitedTime += timeoutTick;
                    this.handlePeerResponseTimeout();
                } else {
                    this.disconnect();
                    PHPLaunchUtilities.hideWaitForDebuggerMessage();
                    PHPLaunchUtilities.showLaunchErrorMessage();
                }
                if (!this.isConnected()) break;
            }
            PHPLaunchUtilities.hideWaitForDebuggerMessage();
            Logger.debugMSG("RECEIVED RESPONSE: " + response);
            return response;
        }
        catch (IOException e) {
            PHPDebugPlugin.log(e);
        }
        catch (InterruptedException e) {
            PHPDebugPlugin.log(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(Object request, ResponseHandler responseHandler) {
        if (!this.isConnected) {
            return;
        }
        Logger.debugMSG("SENDING ASYNCHRONOUS REQUEST: " + request);
        int msgId = this.lastRequestID++;
        IDebugRequestMessage theMsg = (IDebugRequestMessage)request;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            theMsg.setID(msgId);
            theMsg.serialize(dataOutputStream);
            int messageSize = byteArrayOutputStream.size();
            DataOutputStream dataOutputStream2 = this.connectionOut;
            synchronized (dataOutputStream2) {
                this.requestsTable.put(msgId, request);
                this.responseHandlers.put(msgId, responseHandler);
                this.connectionOut.writeInt(messageSize);
                byteArrayOutputStream.writeTo(this.connectionOut);
                this.connectionOut.flush();
            }
        }
        catch (Exception e) {
            String message = "Exception for request NO." + theMsg.getType() + e.toString();
            Logger.debugMSG(message);
            Logger.logException(e);
            responseHandler.handleResponse(request, null);
            this.responseHandlers.remove(msgId);
        }
    }

    public void setCommunicationAdministrator(CommunicationAdministrator admin) {
        this.communicationAdministrator = admin;
    }

    public void setCommunicationClient(CommunicationClient client) {
        this.communicationClient = client;
    }

    protected boolean hookLaunch(SessionDescriptor sessionDescriptor) throws CoreException {
        ILaunch launch = PHPSessionLaunchMapper.get(sessionDescriptor.getId());
        if (launch == null) {
            launch = this.fetchLaunch(sessionDescriptor);
        } else if (sessionDescriptor.isPrimary() && !launch.isTerminated()) {
            try {
                launch.terminate();
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        if (launch != null) {
            this.cleanup(launch);
            if (this.isServerLaunch(launch)) {
                this.hookServerLaunch(launch, sessionDescriptor);
            } else {
                this.hookPHPExeLaunch(launch, sessionDescriptor);
            }
            return true;
        }
        return false;
    }

    protected void hookServerLaunch(ILaunch launch, SessionDescriptor sessionDescriptor) throws CoreException {
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        IProject project = this.getProject(launchConfiguration);
        this.messageReceiver.setTransferEncoding(launchConfiguration.getAttribute("debugTransferEncoding", ""));
        this.messageReceiver.setOutputEncoding(launchConfiguration.getAttribute("debugOutputEncoding", ""));
        String URL2 = launchConfiguration.getAttribute("base_url", "");
        boolean stopAtFirstLine = project == null ? true : PHPProjectPreferences.getStopAtFirstLine(project);
        int requestPort = PHPDebugPlugin.getDebugPort("org.eclipse.php.debug.core.zendDebugger");
        try {
            requestPort = Integer.valueOf(launch.getAttribute("port"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean runWithDebug = launchConfiguration.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", true);
        if (launch.getLaunchMode().equals("debug")) {
            runWithDebug = false;
        }
        PHPProcess process = new PHPProcess(launch, URL2);
        this.debugTarget = (PHPDebugTarget)this.createDebugTarget(this, launch, URL2, requestPort, process, runWithDebug, stopAtFirstLine, project);
        this.bindTarget(launch);
    }

    protected void hookPHPExeLaunch(ILaunch launch, SessionDescriptor sessionDescriptor) throws CoreException {
        IResource resource;
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        this.messageReceiver.setTransferEncoding(launchConfiguration.getAttribute("debugTransferEncoding", ""));
        this.messageReceiver.setOutputEncoding(launchConfiguration.getAttribute("debugOutputEncoding", ""));
        String phpExeString = launchConfiguration.getAttribute("ATTR_LOCATION", null);
        String fileNameString = launchConfiguration.getAttribute("ATTR_FILE", null);
        boolean runWithDebugInfo = launchConfiguration.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", true);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = null;
        String file = launchConfiguration.getAttribute("ATTR_FILE", null);
        if (file != null && (resource = workspaceRoot.findMember(file)) != null) {
            project = resource.getProject();
        }
        if (launch.getLaunchMode().equals("debug")) {
            runWithDebugInfo = false;
        }
        String debugFileName = fileNameString;
        Path filePath = new Path(fileNameString);
        IResource res = workspaceRoot.findMember((IPath)filePath);
        if (res != null) {
            IFile fileToDebug = (IFile)res;
            debugFileName = fileToDebug.getName();
        }
        boolean stopAtFirstLine = PHPProjectPreferences.getStopAtFirstLine(project);
        int requestPort = PHPDebugPlugin.getDebugPort("org.eclipse.php.debug.core.zendDebugger");
        try {
            requestPort = Integer.valueOf(launch.getAttribute("port"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Path phpExe = new Path(phpExeString);
        PHPProcess process = new PHPProcess(launch, phpExe.toOSString());
        this.debugTarget = (PHPDebugTarget)this.createDebugTarget(this, launch, phpExeString, debugFileName, requestPort, process, runWithDebugInfo, stopAtFirstLine, project);
        this.bindTarget(launch);
    }

    protected void hookFileContentSession(DebugSessionStartedNotification notification, String fileName, int lineNumber) {
        try {
            FileContentDebugHandler handler = new FileContentDebugHandler(this);
            RemoteDebugger debugger = (RemoteDebugger)handler.getRemoteDebugger();
            if (!debugger.isActive()) {
                throw new IllegalStateException("Could not read the content of the file. The debugger is not connected.");
            }
            try {
                debugger.setProtocol(2012121702);
                try {
                    fileName = URLDecoder.decode(fileName, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                byte[] content = debugger.getFileContent(fileName);
                if (content == null) {
                    content = new byte[]{};
                }
                OpenRemoteFileRequestor requester = new OpenRemoteFileRequestor(notification);
                requester.fileContentReceived(content, fileName, lineNumber);
            }
            finally {
                debugger.closeDebugSession();
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    protected void hookError(Object cause) {
    }

    protected ILaunch fetchLaunch(SessionDescriptor sessionDescriptor) throws CoreException {
        String originalURL;
        String query = sessionDescriptor.getStartedNotification().getQuery();
        String additionalOptions = sessionDescriptor.getStartedNotification().getOptions();
        int sessionID = sessionDescriptor.getId();
        String fileContentRequestFile = this.getFileContentRequestPath(query);
        if (fileContentRequestFile != null) {
            this.hookFileContentSession(sessionDescriptor.getStartedNotification(), fileContentRequestFile, this.getLineNumber(query));
            return null;
        }
        if (sessionID > 0 && sessionID <= DebugSessionIdGenerator.getLastGenerated()) {
            if (PHPDebugPlugin.DEBUG) {
                Logger.log(4, "Terminating a requested session.\nThe session id received is lower than the last generated.");
            }
            return null;
        }
        ILaunchConfigurationType lcType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(REMOTE_LAUNCH_TYPE_ID);
        DebugUITools.setLaunchPerspective((ILaunchConfigurationType)lcType, (String)"debug", (String)"org.eclipse.debug.ui.DebugPerspective");
        ILaunchConfigurationWorkingCopy wc = lcType.newInstance(null, REMOTE_DEBUG_LAUNCH_NAME);
        wc.setAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", true);
        if (additionalOptions != null && additionalOptions.indexOf("no_remote=1") > -1) {
            wc.setAttribute("debugNoRemote", true);
        }
        if ((originalURL = this.getOriginalURL(additionalOptions)) == null) {
            originalURL = sessionDescriptor.getStartedNotification().getUri();
        }
        wc.setAttribute("webServerDebugger", Boolean.toString(true));
        wc.setAttribute("base_url", originalURL);
        Server serverLookup = ServersManager.findByURL((String)originalURL);
        if (serverLookup != null) {
            wc.setAttribute("name", serverLookup.getName());
        }
        wc.doSave();
        ILaunch launch = DebugUITools.buildAndLaunch((ILaunchConfiguration)wc, (String)"debug", (IProgressMonitor)new NullProgressMonitor());
        if (sessionID < 0) {
            sessionID = DebugSessionIdGenerator.generateSessionID();
        }
        PHPSessionLaunchMapper.put(sessionID, launch);
        if (PHPDebugPlugin.DEBUG) {
            System.out.println("Added a remote launch mapping to session with ID: " + sessionID);
        }
        return launch;
    }

    protected IDebugTarget createDebugTarget(DebugConnection thread, ILaunch launch, String url, int requestPort, PHPProcess process, boolean runWithDebug, boolean stopAtFirstLine, IProject project) throws CoreException {
        return new PHPDebugTarget(thread, launch, url, requestPort, process, runWithDebug, stopAtFirstLine, project);
    }

    protected IDebugTarget createDebugTarget(DebugConnection thread, ILaunch launch, String phpExeString, String debugFileName, int requestPort, PHPProcess process, boolean runWithDebugInfo, boolean stopAtFirstLine, IProject project) throws CoreException {
        return new PHPDebugTarget(thread, launch, phpExeString, debugFileName, requestPort, (IProcess)process, runWithDebugInfo, stopAtFirstLine, project);
    }

    protected IProject getProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = configuration.getAttribute("org.eclipse.php.debug.core.PHP_Project", null);
        if (projectName != null) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return null;
    }

    protected boolean setProtocol(int protocolID) {
        SetProtocolRequest request = new SetProtocolRequest();
        request.setProtocolID(protocolID);
        try {
            int responceProtocolID;
            Object response = this.sendRequest(request);
            if (response != null && response instanceof SetProtocolResponse && (responceProtocolID = ((SetProtocolResponse)response).getProtocolID()) == protocolID) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return false;
    }

    protected boolean verifyProtocolID(int serverProtocolID) {
        if (serverProtocolID < 2012121702) {
            return this.setProtocol(2012121702);
        }
        return true;
    }

    protected boolean isServerLaunch(ILaunch launch) {
        return Boolean.toString(true).equals(launch.getAttribute("webServerDebugger"));
    }

    private void hookDebugSession(DebugSessionStartedNotification debugSessionStartedNotification) throws CoreException {
        try {
            try {
                HOOK_LOCK.tryLock(10000L, TimeUnit.MILLISECONDS);
                SessionDescriptor sessionDescriptor = new SessionDescriptor(debugSessionStartedNotification);
                if (!this.hookLaunch(sessionDescriptor)) {
                    this.hookError("No session id");
                }
            }
            catch (InterruptedException e) {
                Logger.logException(e);
                HOOK_LOCK.unlock();
            }
        }
        finally {
            HOOK_LOCK.unlock();
        }
    }

    private void bindTarget(ILaunch launch) throws CoreException {
        IDebugTarget target = launch.getDebugTarget();
        if (target != null) {
            if (target instanceof PHPMultiDebugTarget) {
                PHPMultiDebugTarget multi = (PHPMultiDebugTarget)target;
                multi.addSubTarget(this.debugTarget);
            } else if (target instanceof PHPDebugTarget) {
                IProcess[] processes;
                PHPDebugTarget single = (PHPDebugTarget)target;
                launch.removeDebugTarget((IDebugTarget)single);
                IProcess[] iProcessArray = processes = launch.getProcesses();
                int n = processes.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcess p = iProcessArray[n2];
                    launch.removeProcess(p);
                    ++n2;
                }
                PHPProcess process = new PHPProcess(launch, "Parallel Requests' Process");
                PHPMultiDebugTarget multi = new PHPMultiDebugTarget(launch, process);
                multi.addSubTarget(single);
                multi.addSubTarget(this.debugTarget);
                launch.addDebugTarget((IDebugTarget)multi);
                launch.addProcess((IProcess)process);
            }
        } else {
            launch.addDebugTarget((IDebugTarget)this.debugTarget);
            launch.addProcess(this.debugTarget.getProcess());
        }
    }

    private void cleanup(ILaunch launch) {
        IDebugTarget element;
        IDebugTarget[] debugTargets = launch.getDebugTargets();
        IProcess[] processes = launch.getProcesses();
        ILaunch currentLaunch = launch;
        IDebugTarget[] iDebugTargetArray = debugTargets;
        int n = debugTargets.length;
        int n2 = 0;
        while (n2 < n) {
            element = iDebugTargetArray[n2];
            if (element.isTerminated()) {
                currentLaunch.removeDebugTarget(element);
            }
            ++n2;
        }
        iDebugTargetArray = processes;
        n = processes.length;
        n2 = 0;
        while (n2 < n) {
            element = iDebugTargetArray[n2];
            if (element.isTerminated()) {
                currentLaunch.removeProcess((IProcess)element);
            }
            ++n2;
        }
    }

    private IDebugMessageHandler createMessageHandler(IDebugMessage message) {
        if (!this.messageHandlers.containsKey(message.getType())) {
            IDebugMessageHandler requestHandler = DebugMessagesRegistry.getHandler(message);
            this.messageHandlers.put(message.getType(), requestHandler);
        }
        return this.messageHandlers.get(message.getType());
    }

    private void handlePeerResponseTimeout() {
        this.getCommunicationClient().handlePeerResponseTimeout();
    }

    private void connect() {
        this.requestsTable = new IntHashtable();
        this.responseTable = new IntHashtable();
        this.responseHandlers = new Hashtable();
        this.messageHandlers = new HashMap<Integer, IDebugMessageHandler>();
        try {
            this.socket.setTcpNoDelay(true);
            this.connectionIn = new DataInputStream(this.socket.getInputStream());
            this.connectionOut = new DataOutputStream(this.socket.getOutputStream());
            this.messageHandler = new MessageHandler();
            this.messageReceiver = new MessageReceiver();
            this.messageHandler.schedule();
            this.messageReceiver.schedule();
            this.isInitialized = true;
        }
        catch (Exception e) {
            PHPDebugPlugin.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanSocket() {
        Closeable closeable;
        block31: {
            block29: {
                if (!this.isInitialized) {
                    return;
                }
                if (this.socket != null) {
                    try {
                        this.socket.shutdownInput();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.socket.shutdownOutput();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.socket != null) {
                    try {
                        try {
                            this.socket.close();
                        }
                        catch (Exception exception) {
                            this.socket = null;
                            break block29;
                        }
                    }
                    catch (Throwable throwable) {
                        this.socket = null;
                        throw throwable;
                    }
                    this.socket = null;
                }
            }
            if (this.connectionIn != null) {
                try {
                    try {
                        closeable = this.connectionIn;
                        synchronized (closeable) {
                            this.connectionIn.close();
                        }
                    }
                    catch (Exception exception) {
                        this.connectionIn = null;
                        break block31;
                    }
                }
                catch (Throwable throwable) {
                    this.connectionIn = null;
                    throw throwable;
                }
                this.connectionIn = null;
            }
        }
        if (this.connectionOut != null) {
            try {
                try {
                    closeable = this.connectionOut;
                    synchronized (closeable) {
                        this.connectionOut.close();
                    }
                }
                catch (Exception exception) {
                    this.connectionOut = null;
                }
            }
            finally {
                this.connectionOut = null;
            }
        }
    }

    private void terminate() {
        if (!this.isConnected()) {
            return;
        }
        this.isConnected = false;
        this.cleanSocket();
        Logger.debugMSG("DEBUG CONNECTION: Socket Cleaned");
    }

    private void setResponseTimeout(DebugSessionStartedNotification startedNotification) {
        this.debugResponseTimeout = Platform.getPreferencesService().getInt("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.DEBUG_RESPONSE_TIMEOUT, 60000, null);
        int customResponseTimeout = ZendDebuggerSettingsUtil.getResponseTimeout(startedNotification);
        if (customResponseTimeout != -1) {
            this.debugResponseTimeout = customResponseTimeout;
        }
    }

    protected String getOriginalURL(String additionalOptions) {
        if (additionalOptions == null || additionalOptions.equals("")) {
            return null;
        }
        String optionKey = "&original_url=";
        int startIndex = additionalOptions.indexOf(optionKey);
        if (startIndex < 0) {
            return null;
        }
        int endIndex = (additionalOptions = additionalOptions.substring(startIndex + optionKey.length())).indexOf(38);
        if (endIndex > -1) {
            additionalOptions = additionalOptions.substring(0, endIndex);
        }
        return additionalOptions;
    }

    protected String getFileContentRequestPath(String query) {
        return this.extractParameterFromQuery(query, "get_file_content");
    }

    protected int getLineNumber(String query) {
        try {
            return Integer.parseInt(this.extractParameterFromQuery(query, "line_number"));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    protected String extractParameterFromQuery(String query, String parameter) {
        int queryStartIndex = query.indexOf(String.valueOf(parameter) + "=");
        if (queryStartIndex > -1) {
            String value = query.substring(queryStartIndex + parameter.length() + 1);
            int paramSeparatorIndex = value.indexOf(38);
            if (paramSeparatorIndex > -1) {
                value = value.substring(0, paramSeparatorIndex);
            }
            return value;
        }
        return null;
    }

    private class MessageHandler
    extends Job {
        private BlockingQueue inputMessageQueue;
        private ByteArrayOutputStream byteArray;
        private DataOutputStream outArray;

        public MessageHandler() {
            super("Debug Message Handler");
            this.inputMessageQueue = new BlockingQueue(100);
            this.byteArray = new ByteArrayOutputStream();
            this.outArray = new DataOutputStream(this.byteArray);
            this.setSystem(true);
            this.setUser(false);
            this.setPriority(30);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            while (!monitor.isCanceled()) {
                try {
                    IDebugMessage incomingMessage = (IDebugMessage)this.inputMessageQueue.queueOut();
                    Logger.debugMSG("NEW MESSAGE RECEIVED: " + incomingMessage);
                    try {
                        boolean isDebugConnectionTest = false;
                        if (incomingMessage instanceof DebugSessionStartedNotification) {
                            DebugSessionStartedNotification sessionStartedMessage = (DebugSessionStartedNotification)incomingMessage;
                            DebugConnection.this.setResponseTimeout(sessionStartedMessage);
                            boolean bl = isDebugConnectionTest = sessionStartedMessage.getQuery().indexOf("testConnection=true") != -1;
                            if (isDebugConnectionTest) {
                                String sourceHost = DebugConnection.this.socket.getInetAddress().getHostAddress();
                                if (DebugConnection.this.verifyProtocolID(sessionStartedMessage.getServerProtocolID())) {
                                    DebugConnection.this.sendRequest(new StartRequest());
                                    DebugServerTestController.getInstance().notifyTestListener(new DebugServerTestEvent(sourceHost, 0));
                                } else {
                                    DebugServerTestController.getInstance().notifyTestListener(new DebugServerTestEvent(sourceHost, 2));
                                }
                            } else {
                                DebugConnection.this.hookDebugSession(sessionStartedMessage);
                            }
                        }
                        if (DebugConnection.this.debugTarget != null) {
                            IDebugMessageHandler messageHandler = DebugConnection.this.createMessageHandler(incomingMessage);
                            if (messageHandler != null) {
                                Logger.debugMSG("CREATING MESSAGE HANDLER: " + messageHandler.getClass().getName().replaceFirst(".*\\.", ""));
                                messageHandler.handle(incomingMessage, DebugConnection.this.debugTarget);
                                if (!(messageHandler instanceof IDebugRequestHandler)) continue;
                                IDebugResponseMessage response = ((IDebugRequestHandler)messageHandler).getResponseMessage();
                                DataOutputStream dataOutputStream = DebugConnection.this.connectionOut;
                                synchronized (dataOutputStream) {
                                    this.byteArray.reset();
                                    response.serialize(this.outArray);
                                    DebugConnection.this.connectionOut.writeInt(this.byteArray.size());
                                    this.byteArray.writeTo(DebugConnection.this.connectionOut);
                                    DebugConnection.this.connectionOut.flush();
                                    continue;
                                }
                            }
                            if (incomingMessage instanceof IDebugResponseMessage) {
                                IDebugResponseMessage r = (IDebugResponseMessage)incomingMessage;
                                int requestId = r.getID();
                                IDebugRequestMessage req = (IDebugRequestMessage)DebugConnection.this.requestsTable.remove(requestId);
                                ResponseHandler handler = (ResponseHandler)DebugConnection.this.responseHandlers.remove(requestId);
                                handler.handleResponse(req, r);
                                continue;
                            }
                            if (incomingMessage != DebugConnection.this.CONNECTION_CLOSED) continue;
                            this.handleClosed();
                            continue;
                        }
                        this.handleClosed();
                    }
                    catch (Exception e) {
                        PHPDebugPlugin.log(e);
                    }
                    continue;
                }
                catch (Exception e) {
                    PHPDebugPlugin.log(e);
                    this.shutdown();
                    continue;
                }
                break;
            }
            return Status.OK_STATUS;
        }

        public void queueIn(IDebugMessage m) {
            this.inputMessageQueue.queueIn((Object)m);
        }

        void shutdown() {
            this.cancel();
            this.inputMessageQueue.releaseReaders();
            this.inputMessageQueue.clear();
        }

        void connectionClosed() {
            this.queueIn(DebugConnection.this.CONNECTION_CLOSED);
        }

        private void handleClosed() {
            if (DebugConnection.this.getCommunicationAdministrator() != null) {
                DebugConnection.this.getCommunicationAdministrator().connectionClosed();
            }
            this.shutdown();
            DebugConnection.this.terminate();
        }
    }

    private class MessageReceiver
    extends Job {
        private String transferEncoding;
        private String outputEncoding;

        public MessageReceiver() {
            super("Debug Message Receiver");
            this.setSystem(true);
            this.setUser(false);
            this.setPriority(30);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            while (true) {
                try {
                    while (true) {
                        if (monitor.isCanceled()) {
                            return Status.OK_STATUS;
                        }
                        int length = DebugConnection.this.connectionIn.readInt();
                        if (length < 0) {
                            String message = "Socket error (length is negative): possibly Server is SSL, Client is not.";
                            Logger.debugMSG(message);
                            Logger.log(4, message);
                            this.shutdown();
                            continue;
                        }
                        short messageType = DebugConnection.this.connectionIn.readShort();
                        if (!DebugConnection.this.isValidProtocol && messageType != START_MESSAGE_ID) {
                            this.showProtocolError();
                            this.shutdown();
                            continue;
                        }
                        DebugConnection.this.isValidProtocol = true;
                        IDebugMessage message = DebugMessagesRegistry.getMessage(messageType);
                        if (message != null) {
                            if (message instanceof OutputNotification) {
                                message.setTransferEncoding(this.outputEncoding);
                            } else {
                                message.setTransferEncoding(this.transferEncoding);
                            }
                        }
                        if (message instanceof IDebugNotificationMessage) {
                            message.deserialize(DebugConnection.this.connectionIn);
                            DebugConnection.this.messageHandler.queueIn(message);
                            continue;
                        }
                        if (message instanceof IDebugResponseMessage) {
                            message.deserialize(DebugConnection.this.connectionIn);
                            int messageId = ((IDebugResponseMessage)message).getID();
                            ResponseHandler handler = (ResponseHandler)DebugConnection.this.responseHandlers.get(messageId);
                            if (handler == null) {
                                DebugConnection.this.responseTable.put(messageId, (Object)message);
                                IDebugRequestMessage request = (IDebugRequestMessage)DebugConnection.this.requestsTable.remove(messageId);
                                if (request != null) {
                                    IDebugRequestMessage iDebugRequestMessage = request;
                                    synchronized (iDebugRequestMessage) {
                                        request.notifyAll();
                                    }
                                }
                                DebugConnection.this.responseTable.remove(messageId);
                                continue;
                            }
                            DebugConnection.this.messageHandler.queueIn(message);
                            continue;
                        }
                        if (!(message instanceof IDebugRequestMessage)) continue;
                        message.deserialize(DebugConnection.this.connectionIn);
                        DebugConnection.this.messageHandler.queueIn(message);
                    }
                }
                catch (IOException e) {
                    this.shutdown();
                    continue;
                }
                catch (Exception e) {
                    PHPDebugPlugin.log(e);
                    this.shutdown();
                    continue;
                }
                break;
            }
        }

        public void setTransferEncoding(String transferEncoding) {
            this.transferEncoding = transferEncoding;
        }

        public void setOutputEncoding(String outputEncoding) {
            this.outputEncoding = outputEncoding;
        }

        void shutdown() {
            this.cancel();
            DebugConnection.this.messageHandler.connectionClosed();
            DebugConnection.this.terminate();
        }

        private void showProtocolError() {
            final String errorMessage = MessageFormat.format((String)PHPDebugCoreMessages.Debugger_Incompatible_Protocol, (Object[])new Object[]{String.valueOf(2012121702)});
            Status status = new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, null);
            DebugPlugin.log((IStatus)status);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debugger Error", (String)errorMessage);
                }
            });
        }
    }

    protected class SessionDescriptor {
        private int id;
        private int ordinal;
        private DebugSessionStartedNotification startedNotification;

        public SessionDescriptor(DebugSessionStartedNotification startedNotification) {
            this.startedNotification = startedNotification;
            this.id = -1;
            this.ordinal = -1;
            this.build();
        }

        public DebugSessionStartedNotification getStartedNotification() {
            return this.startedNotification;
        }

        private void build() {
            String params = this.startedNotification.getQuery().contains("debug_session_id") ? this.startedNotification.getQuery() : this.startedNotification.getOptions();
            List<String> parameters = Arrays.asList(params.split("&"));
            Iterator<String> i = parameters.iterator();
            while (i.hasNext()) {
                Integer parsedOrdinal;
                String parameter = i.next();
                if (!parameter.startsWith("debug_session_id")) continue;
                int idx = parameter.indexOf(61);
                Integer parsedId = this.parseInt(parameter.substring(idx + 1));
                if (parsedId != null) {
                    this.id = parsedId;
                }
                if (!i.hasNext() || (parsedOrdinal = this.parseInt(i.next())) == null) continue;
                this.ordinal = parsedOrdinal;
            }
        }

        private Integer parseInt(String number) {
            try {
                return Integer.parseInt(number);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public int getId() {
            return this.id;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public boolean isPrimary() {
            return this.getOrdinal() < 0;
        }

        public boolean isUnknown() {
            return this.getId() < 0 && this.getOrdinal() < 0;
        }
    }
}

