/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.PHPToolkitUtil;
import org.eclipse.php.internal.core.util.FileUtils;
import org.eclipse.php.internal.debug.core.PHPRuntime;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIImages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.launching.LaunchUtil;
import org.eclipse.php.internal.debug.ui.launching.LaunchUtilities;
import org.eclipse.php.internal.debug.ui.preferences.phps.NewPHPsComboBlock;
import org.eclipse.php.internal.ui.preferences.ScrolledCompositeImpl;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PHPExecutableLaunchTab
extends AbstractLaunchConfigurationTab {
    protected final IPropertyChangeListener fPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            PHPExecutableLaunchTab.this.handleSelectedPHPexeChanged();
        }
    };
    protected Text fileTextField;
    protected Button argumentVariablesButton;
    protected Text prgmArgumentsText;
    protected boolean enableFileSelection = true;
    protected Button fileLocationButton = null;
    protected WidgetListener fListener = new WidgetListener();
    protected Text locationField;
    protected NewPHPsComboBlock phpsComboBlock = new NewPHPsComboBlock();
    protected SelectionAdapter selectionAdapter;

    public void createControl(Composite parent) {
        ScrolledCompositeImpl scrolledCompositeImpl = new ScrolledCompositeImpl(parent, 768);
        Composite mainComposite = new Composite((Composite)scrolledCompositeImpl, 0);
        this.setControl((Control)scrolledCompositeImpl);
        mainComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        scrolledCompositeImpl.setContent((Control)mainComposite);
        scrolledCompositeImpl.setLayout((Layout)layout);
        scrolledCompositeImpl.setFont(parent.getFont());
        this.createLocationComponent(mainComposite);
        if (this.enableFileSelection) {
            this.createFileSelectionComponent(mainComposite);
        }
        this.createArgumentsComponent(mainComposite);
        this.createVerticalSpacer(mainComposite, 1);
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.locally_debugging_a_php_script");
    }

    public Image getImage() {
        return PHPDebugUIImages.get("IMG_OBJ_PHP_EXE_LAUNCH");
    }

    public String getName() {
        return PHPDebugUIMessages.PHPExecutableLaunchTab_2;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (this.enableFileSelection) {
            this.updateArgument(configuration);
        }
        try {
            this.prgmArgumentsText.setText(configuration.getAttribute("exeDebugArguments", ""));
        }
        catch (CoreException e) {
            Logger.log(4, "Error reading configuration", e);
        }
        this.isValid(configuration);
        this.updatePHPFromConfig(configuration);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        block15: {
            block17: {
                String phpFile;
                block16: {
                    block14: {
                        this.setErrorMessage(null);
                        this.setWarningMessage(null);
                        String phpExe = launchConfig.getAttribute("ATTR_LOCATION", "");
                        boolean phpExeExists = true;
                        try {
                            File file = new File(phpExe);
                            if (!file.exists()) {
                                phpExeExists = false;
                            }
                        }
                        catch (NullPointerException e) {
                            phpExeExists = false;
                        }
                        if (phpExeExists) break block14;
                        this.setErrorMessage(PHPDebugUIMessages.PHP_Location_Message);
                        return false;
                    }
                    if (!this.enableFileSelection) break block15;
                    phpFile = launchConfig.getAttribute("ATTR_FILE", "");
                    if (!FileUtils.resourceExists((String)phpFile)) break block16;
                    IResource fileToData = ResourcesPlugin.getWorkspace().getRoot().findMember(phpFile);
                    if (fileToData.getType() != 1 || !PHPToolkitUtil.isPhpFile((IFile)((IFile)fileToData))) {
                        this.setErrorMessage(String.valueOf(phpFile) + PHPDebugUIMessages.PHPExecutableLaunchTab_isNotPHPFile);
                        return false;
                    }
                    break block15;
                }
                if (!new File(phpFile).exists()) break block17;
                if (!PHPToolkitUtil.hasPhpExtention((String)phpFile)) {
                    this.setErrorMessage(String.valueOf(phpFile) + PHPDebugUIMessages.PHPExecutableLaunchTab_isNotPHPFile);
                    return false;
                }
                break block15;
            }
            this.setErrorMessage(PHPDebugUIMessages.PHP_File_Not_Exist);
            return false;
        }
        try {
            String exeProgramArgs;
            PHPexeItem phpExeItem;
            PHPexeItem pHPexeItem = phpExeItem = this.phpsComboBlock != null ? this.phpsComboBlock.getPHPexe() : null;
            if (phpExeItem == null) {
                String storedPHPexePath = launchConfig.getAttribute("org.eclipse.php.debug.core.PHP_CONTAINER", null);
                phpExeItem = storedPHPexePath != null ? PHPRuntime.getPHPexeItem((IPath)Path.fromPortableString((String)storedPHPexePath)) : null;
            }
            String string = exeProgramArgs = this.prgmArgumentsText != null ? this.prgmArgumentsText.getText() : null;
            if (exeProgramArgs == null) {
                exeProgramArgs = launchConfig.getAttribute("exeDebugArguments", "");
            }
            if (!exeProgramArgs.isEmpty() && phpExeItem != null && !"CLI".equals(phpExeItem.getSapiType())) {
                this.setWarningMessage(PHPDebugUIMessages.PHPExecutableLaunchTab_argumentsWillNotBePassed);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String scriptArguments;
        if (this.phpsComboBlock.isDefaultPHP()) {
            configuration.setAttribute("org.eclipse.php.debug.core.PHP_CONTAINER", null);
        } else {
            IPath containerPath = this.phpsComboBlock.getPath();
            String portablePath = null;
            if (containerPath != null) {
                portablePath = containerPath.toPortableString();
            }
            configuration.setAttribute("org.eclipse.php.debug.core.PHP_CONTAINER", portablePath);
        }
        String selectedExecutable = this.phpsComboBlock.getSelectedExecutablePath();
        if (selectedExecutable.length() == 0) {
            configuration.setAttribute("ATTR_LOCATION", null);
        } else {
            configuration.setAttribute("ATTR_LOCATION", selectedExecutable);
        }
        String iniPath = this.phpsComboBlock.getSelectedIniPath();
        if (iniPath.length() == 0) {
            configuration.setAttribute("ATTR_INI_LOCATION", null);
        } else {
            configuration.setAttribute("ATTR_INI_LOCATION", iniPath);
        }
        if (this.enableFileSelection) {
            configuration.setAttribute("ATTR_FILE", this.fileTextField.getText().trim());
            configuration.setAttribute("ATTR_FILE_FULL_PATH", this.fileTextField.getData().toString().trim());
        }
        configuration.setAttribute("exeDebugArguments", (scriptArguments = this.prgmArgumentsText.getText().trim()).length() > 0 ? scriptArguments : null);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        try {
            String executableLocation = configuration.getAttribute("ATTR_LOCATION", "");
            if (executableLocation.equals("")) {
                PHPexes phpExes = PHPexes.getInstance();
                PHPexeItem phpExeItem = phpExes.getDefaultItem();
                if (phpExeItem == null) {
                    return;
                }
                executableLocation = phpExeItem.getExecutable().toString();
                configuration.setAttribute("ATTR_LOCATION", executableLocation);
                String iniPath = phpExeItem.getINILocation() != null ? phpExeItem.getINILocation().toString() : null;
                configuration.setAttribute("ATTR_INI_LOCATION", iniPath);
            }
            configuration.setAttribute("exeDebugArguments", null);
        }
        catch (CoreException e) {
            Logger.log(4, "Error setting default configuration", e);
        }
    }

    public void addControlAccessibleListener(Control control, String controlName) {
        String[] strs = controlName.split("&");
        StringBuffer stripped = new StringBuffer();
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            stripped.append(element);
            ++n2;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stripped.toString()));
    }

    public void setEnableFileSelection(boolean enabled) {
        if (enabled == this.enableFileSelection) {
            return;
        }
        this.enableFileSelection = enabled;
        if (this.argumentVariablesButton != null) {
            this.argumentVariablesButton.setVisible(enabled);
        }
        if (this.fileTextField != null) {
            this.fileTextField.setVisible(enabled);
        }
    }

    protected void createFileSelectionComponent(Composite parent) {
        Group group = new Group(parent, 0);
        String groupName = PHPDebugUIMessages.PHP_File;
        group.setText(groupName);
        GridLayout layout = new GridLayout(3, false);
        GridData gd = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        group.setFont(parent.getFont());
        this.fileTextField = new Text((Composite)group, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fileTextField.setLayoutData((Object)gd);
        this.fileTextField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fileTextField, group.getText());
        this.fileTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(PHPExecutableLaunchTab.this.fileTextField.getText());
                String location = "";
                if (resource == null) {
                    PHPExecutableLaunchTab.this.fileTextField.setData((Object)location);
                    return;
                }
                location = resource.getLocation() == null ? resource.getFullPath().toString() : resource.getLocation().toOSString();
                PHPExecutableLaunchTab.this.fileTextField.setData((Object)location);
            }
        });
        this.argumentVariablesButton = this.createPushButton((Composite)group, PHPDebugUIMessages.Browse, null);
        gd = (GridData)this.argumentVariablesButton.getLayoutData();
        gd.horizontalSpan = 1;
        this.argumentVariablesButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.argumentVariablesButton, this.argumentVariablesButton.getText());
    }

    protected void createLocationComponent(Composite parent) {
        Layout layout;
        this.phpsComboBlock.createControl(parent);
        Control control = this.phpsComboBlock.getControl();
        if (control instanceof Composite && (layout = ((Composite)control).getLayout()) instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout;
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
        }
        this.phpsComboBlock.addPropertyChangeListener(this.fPropertyChangeListener);
        GridData gd = new GridData(768);
        control.setLayoutData((Object)gd);
    }

    protected void createArgumentsComponent(final Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(1808));
        group.setText(PHPDebugUIMessages.PHPExecutableLaunchTab_scriptArguments);
        this.prgmArgumentsText = new Text((Composite)group, 2626);
        this.prgmArgumentsText.setLayoutData((Object)new GridData(1808));
        this.prgmArgumentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                PHPExecutableLaunchTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.addControlAccessibleListener((Control)this.prgmArgumentsText, group.getText());
        Button pgrmArgVariableButton = this.createPushButton((Composite)group, PHPDebugUIMessages.PHPExecutableLaunchTab_variables, null);
        pgrmArgVariableButton.setLayoutData((Object)new GridData(128));
        pgrmArgVariableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(PHPExecutableLaunchTab.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    PHPExecutableLaunchTab.this.prgmArgumentsText.insert(variable);
                    PHPExecutableLaunchTab.this.prgmArgumentsText.setFont(parent.getFont());
                }
            }
        });
    }

    protected String getWorkingDirectoryLabel() {
        return PHPDebugUIMessages.WorkingDirectory;
    }

    protected void handleBreakButtonSelected() {
        this.updateLaunchConfigurationDialog();
    }

    protected void handleFileLocationButtonSelected() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0);
        fileDialog.setFileName(this.locationField.getText());
        String text = fileDialog.open();
        if (text != null) {
            this.locationField.setText(text);
        }
    }

    protected void handleSelectedPHPexeChanged() {
        this.updateLaunchConfigurationDialog();
    }

    protected void handleChangeFileToDebug(Text textField) {
        IResource resource = LaunchUtilities.getFileFromDialog(null, this.getShell(), LaunchUtil.getFileExtensions(), LaunchUtil.getRequiredNatures(), true);
        if (resource instanceof IFile) {
            textField.setText(resource.getFullPath().toString());
            String fileLocation = "";
            IPath location = resource.getLocation();
            fileLocation = location != null ? location.toOSString() : resource.getFullPath().toString();
            textField.setData((Object)fileLocation);
        }
    }

    protected void updatePHPFromConfig(ILaunchConfiguration config) {
        try {
            if (this.enableFileSelection) {
                this.phpsComboBlock.setProject(this.getFileProject(this.fileTextField.getText()));
            } else {
                this.phpsComboBlock.setProject(this.getFileProject(config.getAttribute("org.eclipse.php.debug.core.PHP_Project", null)));
            }
            String path = config.getAttribute("org.eclipse.php.debug.core.PHP_CONTAINER", null);
            this.phpsComboBlock.setPath(path != null ? Path.fromPortableString((String)path) : null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected IProject getFileProject(String phpFile) {
        if (FileUtils.resourceExists((String)phpFile)) {
            IResource fileToData = ResourcesPlugin.getWorkspace().getRoot().findMember(phpFile);
            return fileToData.getProject();
        }
        return null;
    }

    protected void updateArgument(ILaunchConfiguration configuration) {
        String arguments = "";
        String fullPath = "";
        try {
            arguments = configuration.getAttribute("ATTR_FILE", "");
            fullPath = configuration.getAttribute("ATTR_FILE_FULL_PATH", "");
        }
        catch (CoreException ce) {
            Logger.log(4, "Error reading configuration", ce);
        }
        if (this.fileTextField != null) {
            this.fileTextField.setText(arguments);
            this.fileTextField.setData((Object)fullPath);
        }
    }

    protected boolean isLaunchMode(String mode) {
        return mode.equals(this.getLaunchConfigurationDialog().getMode());
    }

    private static class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String name) {
            this.controlName = name;
        }

        public void getName(AccessibleEvent e) {
            e.result = this.controlName;
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            PHPExecutableLaunchTab.this.updateLaunchConfigurationDialog();
            PHPExecutableLaunchTab.this.phpsComboBlock.setProject(PHPExecutableLaunchTab.this.getFileProject(PHPExecutableLaunchTab.this.fileTextField.getText()));
        }

        public void widgetSelected(SelectionEvent e) {
            PHPExecutableLaunchTab.this.setDirty(true);
            Object source = e.getSource();
            if (source == PHPExecutableLaunchTab.this.fileLocationButton) {
                PHPExecutableLaunchTab.this.handleFileLocationButtonSelected();
            } else if (source == PHPExecutableLaunchTab.this.argumentVariablesButton) {
                PHPExecutableLaunchTab.this.handleChangeFileToDebug(PHPExecutableLaunchTab.this.fileTextField);
            }
        }
    }
}

