/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.preferences.BasePathValidator;
import org.eclipse.php.internal.debug.ui.preferences.ControlValidationException;
import org.eclipse.php.internal.debug.ui.preferences.IPageValidator;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.ui.preferences.AbstractPHPPreferencePageBlock;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.ide.IDEEncoding;
import org.osgi.service.prefs.BackingStoreException;

public class PHPDebugPreferencesBlock
extends AbstractPHPPreferencePageBlock {
    private static final String UNRESOLVED_PHP_VERSION = PHPDebugUIMessages.PHPDebugPreferencesBlock_3;
    private static final String SERVERS_PAGE_ID = "org.eclipse.php.server.internal.ui.PHPServersPreferencePage";
    private static final String PHP_EXE_PAGE_ID = "org.eclipse.php.debug.ui.preferencesphps.PHPsPreferencePage";
    private Button fStopAtFirstLine;
    private Combo fDefaultServer;
    private Combo fDefaultPHPExe;
    private Combo fDebugEncodingSettings;
    private Combo fOutputEncodingSettings;
    private PreferencePage propertyPage;
    private URL autoGeneratedURL;
    private Text fAutoGeneratedURLText;
    private Text fDefaultBasePath;
    private final boolean isPropertyPage;
    private String defaultBasePath;
    private IPageValidator pageValidator = null;
    private Label fServerDebugger;
    private Label fCLIDebugger;
    private boolean isProjectSpecific;

    public boolean isPropertyPage() {
        return this.isPropertyPage;
    }

    public PHPDebugPreferencesBlock(boolean isPropertyPage) {
        this.isPropertyPage = !isPropertyPage;
    }

    public void setCompositeAddon(Composite parent) {
        Composite composite = this.addPageContents(parent);
        this.addProjectPreferenceSubsection(composite);
    }

    public void initializeValues(PreferencePage propertyPage) {
        IEclipsePreferences node;
        this.propertyPage = propertyPage;
        IPreferencesService service = Platform.getPreferencesService();
        IScopeContext[] preferenceScopes = this.createPreferenceScopes(propertyPage);
        IProject project = this.getProject(propertyPage);
        boolean stopAtFirstLine = service.getBoolean("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, true, null);
        String serverName = ServersManager.getDefaultServer(null).getName();
        String phpExeName = InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core").get(PHPDebugCorePreferenceNames.DEFAULT_PHP, null);
        if (phpExeName == null || phpExeName.isEmpty()) {
            phpExeName = PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined;
        }
        String transferEncoding = service.getString("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.TRANSFER_ENCODING, null, null);
        String outputEncoding = service.getString("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.OUTPUT_ENCODING, null, null);
        this.loadServers(this.fDefaultServer);
        String serverDebuggerId = PHPDebugPlugin.getDebuggerId((String)serverName);
        boolean exeLoaded = false;
        if (preferenceScopes[0] instanceof ProjectScope && this.isProjectSpecific && (node = preferenceScopes[0].getNode(this.getPreferenceNodeQualifier())) != null && project != null) {
            String projectServerName;
            if (this.getBasePathValue(project) == null || this.getBasePathValue(project).equals("")) {
                this.setBasePathValue(project, project.getName());
            }
            if (!(projectServerName = ServersManager.getDefaultServer((IProject)project).getName()).equals("")) {
                serverName = projectServerName;
                stopAtFirstLine = node.getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, stopAtFirstLine);
                transferEncoding = node.get(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, transferEncoding);
                outputEncoding = node.get(PHPDebugCorePreferenceNames.OUTPUT_ENCODING, outputEncoding);
                PHPexeItem item = PHPDebugPlugin.getPHPexeItem((IProject)project);
                if (item != null && item.getName() != null) {
                    phpExeName = item.getName();
                }
                serverDebuggerId = PHPDebugPlugin.getDebuggerId((String)serverName);
                this.loadPHPExes(this.fDefaultPHPExe, PHPexes.getInstance().getAllItems());
                exeLoaded = true;
            }
        }
        if (!exeLoaded) {
            this.loadPHPExes(this.fDefaultPHPExe, PHPexes.getInstance().getAllItems());
        }
        this.fStopAtFirstLine.setSelection(stopAtFirstLine);
        this.fDefaultServer.select(this.fDefaultServer.indexOf(serverName));
        this.fServerDebugger.setText(PHPDebuggersRegistry.getDebuggerName((String)serverDebuggerId));
        if (this.fDefaultPHPExe.indexOf(phpExeName) != -1) {
            this.fDefaultPHPExe.select(this.fDefaultPHPExe.indexOf(phpExeName));
        } else {
            this.fDefaultPHPExe.select(0);
        }
        PHPexeItem item = PHPexes.getInstance().getItem(this.fDefaultPHPExe.getText());
        if (item != null) {
            this.fCLIDebugger.setText(PHPDebuggersRegistry.getDebuggerName((String)item.getDebuggerID()));
        } else {
            this.fCLIDebugger.setText(PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined);
        }
        this.fDebugEncodingSettings.setText(transferEncoding);
        this.fOutputEncodingSettings.setText(outputEncoding);
        if (this.isPropertyPage()) {
            this.defaultBasePath = this.getBasePathValue(project);
            this.initAutoGenerateListener();
            this.fDefaultBasePath.setText(this.defaultBasePath);
        }
    }

    private String getBasePathValue(IProject project) {
        String basepath = PHPProjectPreferences.getDefaultBasePath((IProject)project);
        return basepath;
    }

    private void setBasePathValue(IProject project, String value) {
        PHPProjectPreferences.setDefaultBasePath((IProject)project, (String)value);
    }

    public void initAutoGenerateListener() {
        this.fDefaultBasePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    try {
                        if (PHPDebugPreferencesBlock.this.pageValidator != null) {
                            PHPDebugPreferencesBlock.this.pageValidator.validate(new BasePathValidator(PHPDebugPreferencesBlock.this.fDefaultBasePath));
                        }
                        PHPDebugPreferencesBlock.this.refreshAutoGeneratedBaseURLDisplay();
                    }
                    catch (ControlValidationException e1) {
                        e1.printStackTrace();
                    }
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private String getSelectedServerName() {
        return this.fDefaultServer.getText();
    }

    private void dispalyAutoGeneratedURL(URL url) {
        this.fAutoGeneratedURLText.setText(url.toString());
    }

    public boolean performOK(boolean isProjectSpecific) {
        this.savePreferences(isProjectSpecific);
        return true;
    }

    public void performApply(boolean isProjectSpecific) {
        this.performOK(isProjectSpecific);
    }

    public boolean performCancel() {
        return true;
    }

    public void performDefaults() {
        IEclipsePreferences prefs = PHPDebugPlugin.getDefaultPreferences();
        this.fStopAtFirstLine.setSelection(prefs.getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, true));
        this.loadServers(this.fDefaultServer);
        String serverDebuggerId = PHPDebugPlugin.getDebuggerId((String)this.fDefaultServer.getText());
        this.fServerDebugger.setText(PHPDebuggersRegistry.getDebuggerName((String)serverDebuggerId));
        this.loadPHPExes(this.fDefaultPHPExe, PHPexes.getInstance().getAllItems());
        PHPexeItem item = PHPexes.getInstance().getItem(this.fDefaultPHPExe.getText());
        if (item != null) {
            this.fCLIDebugger.setText(PHPDebuggersRegistry.getDebuggerName((String)item.getDebuggerID()));
        }
        this.fDebugEncodingSettings.setText(prefs.get(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, null));
        this.fOutputEncodingSettings.setText(prefs.get(PHPDebugCorePreferenceNames.OUTPUT_ENCODING, null));
    }

    protected String getPreferenceNodeQualifier() {
        return PHPProjectPreferences.getPreferenceNodeQualifier();
    }

    private void addProjectPreferenceSubsection(Composite composite) {
        Group defultServerGroup = new Group(composite, 0);
        defultServerGroup.setText(PHPDebugUIMessages.PHPDebugPreferencesBlock_0);
        defultServerGroup.setFont(composite.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 10;
        defultServerGroup.setLayout((Layout)layout);
        defultServerGroup.setLayoutData((Object)new GridData(1808));
        Label label = this.addLabelControl((Composite)defultServerGroup, PHPDebugUIMessages.PhpDebugPreferencePage_9, "defaultPHPServer");
        GridData gd = new GridData();
        gd.widthHint = 90;
        label.setLayoutData((Object)gd);
        this.fDefaultServer = this.addCombo((Composite)defultServerGroup, 2);
        this.addLink((Composite)defultServerGroup, PHPDebugUIMessages.PhpDebugPreferencePage_serversLink, SERVERS_PAGE_ID);
        label = this.addLabelControl((Composite)defultServerGroup, PHPDebugUIMessages.PHPDebugPreferencesBlock_ServerDebugger, null);
        gd = new GridData();
        gd.widthHint = 90;
        label.setLayoutData((Object)gd);
        this.fServerDebugger = new Label((Composite)defultServerGroup, 0);
        gd = new GridData(768);
        gd.horizontalIndent = 2;
        this.fServerDebugger.setLayoutData((Object)gd);
        Group defultCLIGroup = new Group(composite, 0);
        defultCLIGroup.setText(PHPDebugUIMessages.PHPDebugPreferencesBlock_CLISettings);
        defultCLIGroup.setFont(composite.getFont());
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 10;
        defultCLIGroup.setLayout((Layout)layout);
        defultCLIGroup.setLayoutData((Object)new GridData(1808));
        label = this.addLabelControl((Composite)defultCLIGroup, PHPDebugUIMessages.PhpDebugPreferencePage_12, PHPDebugCorePreferenceNames.DEFAULT_PHP);
        gd = new GridData();
        gd.widthHint = 90;
        label.setLayoutData((Object)gd);
        this.fDefaultPHPExe = this.addCombo((Composite)defultCLIGroup, 2);
        this.addLink((Composite)defultCLIGroup, PHPDebugUIMessages.PhpDebugPreferencePage_installedPHPsLink, PHP_EXE_PAGE_ID);
        label = this.addLabelControl((Composite)defultCLIGroup, PHPDebugUIMessages.PHPDebugPreferencesBlock_CLIDebugger, null);
        gd = new GridData();
        gd.widthHint = 90;
        label.setLayoutData((Object)gd);
        this.fCLIDebugger = new Label((Composite)defultCLIGroup, 0);
        gd = new GridData(768);
        gd.horizontalIndent = 2;
        this.fCLIDebugger.setLayoutData((Object)gd);
        new Label(composite, 0);
        Group encodingGroup = new Group(composite, 0);
        encodingGroup.setText(PHPDebugUIMessages.PHPDebugPreferencesBlock_2);
        encodingGroup.setLayout((Layout)new GridLayout(2, false));
        encodingGroup.setLayoutData((Object)new GridData(1808));
        this.addLabelControl((Composite)encodingGroup, PHPDebugUIMessages.PHPDebugPreferencesAddon_debugTransferEncoding, PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
        this.fDebugEncodingSettings = this.addEncodingSettings((Composite)encodingGroup);
        this.addLabelControl((Composite)encodingGroup, PHPDebugUIMessages.PHPDebugPreferencesAddon_debugOutputEncoding, PHPDebugCorePreferenceNames.OUTPUT_ENCODING);
        this.fOutputEncodingSettings = this.addEncodingSettings((Composite)encodingGroup);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean isValid = PHPDebugPreferencesBlock.this.isValidEncoding(((Combo)e.getSource()).getText());
                if (isValid) {
                    PHPDebugPreferencesBlock.this.propertyPage.setErrorMessage(null);
                } else {
                    PHPDebugPreferencesBlock.this.propertyPage.setErrorMessage(PHPDebugUIMessages.PHPDebugPreferencesAddon_unsupportedEncoding);
                }
                PHPDebugPreferencesBlock.this.propertyPage.setValid(isValid);
            }
        };
        this.fDebugEncodingSettings.addModifyListener(modifyListener);
        this.fOutputEncodingSettings.addModifyListener(modifyListener);
        new Label(composite, 0);
        if (this.isPropertyPage()) {
            this.createBaseURLGroup(composite);
        }
        this.fStopAtFirstLine = this.addCheckBox(composite, PHPDebugUIMessages.PhpDebugPreferencePage_1, PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, 0);
        this.fDefaultPHPExe.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPexeItem item = PHPexes.getInstance().getItem(PHPDebugPreferencesBlock.this.fDefaultPHPExe.getText());
                if (item != null) {
                    PHPDebugPreferencesBlock.this.fCLIDebugger.setText(PHPDebuggersRegistry.getDebuggerName((String)item.getDebuggerID()));
                } else {
                    PHPDebugPreferencesBlock.this.fCLIDebugger.setText(PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined);
                }
            }
        });
        this.fDefaultServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    PHPDebugPreferencesBlock.this.refreshAutoGeneratedBaseURLDisplay();
                    String serverDebuggerId = PHPDebugPlugin.getDebuggerId((String)PHPDebugPreferencesBlock.this.fDefaultServer.getText());
                    PHPDebugPreferencesBlock.this.fServerDebugger.setText(PHPDebuggersRegistry.getDebuggerName((String)serverDebuggerId));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        });
    }

    private void createBaseURLGroup(Composite composite) {
        Group baseURLGroup = this.createGroup(composite, PHPDebugUIMessages.PHPDebugPreferencesBlock_9);
        this.addBasePathLabelAndText(baseURLGroup);
        this.addBaseURLLabelAndText(baseURLGroup);
    }

    private void addBaseURLLabelAndText(Group baseURLGroup) {
        this.addLabelControl((Composite)baseURLGroup, PHPDebugUIMessages.PHPDebugPreferencesBlock_10, PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
        this.addBaseURLText((Composite)baseURLGroup);
    }

    private URL generateBaseURL(Server server, IPath basePath) throws MalformedURLException {
        URL serverUrl = server.getRootURL();
        Path file = new Path(serverUrl.getFile());
        file = !file.isEmpty() ? file.append(basePath) : basePath;
        URL generatedBaseURL = new URL(serverUrl.getProtocol(), serverUrl.getHost(), serverUrl.getPort(), file.toString());
        return generatedBaseURL;
    }

    private Text addBaseURLText(Composite parent) {
        this.fAutoGeneratedURLText = this.addText(parent, 2, 24);
        return this.fAutoGeneratedURLText;
    }

    private void addBasePathLabelAndText(Group baseURLGroup) {
        this.addLabelControl((Composite)baseURLGroup, PHPDebugUIMessages.PHPDebugPreferencesBlock_11, PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
        this.addBasePathText((Composite)baseURLGroup);
    }

    private Text addBasePathText(Composite parent) {
        this.fDefaultBasePath = this.addText(parent, 2, 2064);
        return this.fDefaultBasePath;
    }

    private IPath getDefaultBasePath() {
        if (this.fDefaultBasePath != null) {
            return new Path(this.fDefaultBasePath.getText());
        }
        return null;
    }

    private Server getDefaultServer() {
        return ServersManager.getServer((String)this.fDefaultServer.getText());
    }

    private void displayDefaultBaseURL(URL generatedBaseURL) {
        this.fAutoGeneratedURLText.setText(generatedBaseURL.toString());
    }

    private Group createGroup(Composite composite, String groupName) {
        Group newGroup = new Group(composite, 0);
        newGroup.setText(groupName);
        newGroup.setLayout((Layout)new GridLayout(2, false));
        newGroup.setLayoutData((Object)new GridData(1808));
        return newGroup;
    }

    private void loadPHPExes(Combo combo, PHPexeItem[] items) {
        combo.removeAll();
        if (items == null || items.length == 0) {
            combo.add(PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined);
            combo.select(0);
            return;
        }
        PHPexeItem[] pHPexeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            PHPexeItem element = pHPexeItemArray[n2];
            String name = element.getName();
            if (name == null) {
                name = UNRESOLVED_PHP_VERSION;
            }
            combo.add(name);
            ++n2;
        }
        combo.select(0);
    }

    private void loadServers(Combo combo) {
        combo.removeAll();
        Server[] servers = ServersManager.getServers();
        if (servers != null) {
            Server[] serverArray = servers;
            int n = servers.length;
            int n2 = 0;
            while (n2 < n) {
                Server element = serverArray[n2];
                combo.add(element.getName());
                ++n2;
            }
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        }
    }

    private void addLink(Composite parent, String label, final String propertyPageID) {
        Link link = new Link(parent, 0);
        link.setFont(parent.getFont());
        link.setLayoutData((Object)new GridData(0x1000008, 1, false, false));
        link.setText(label);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)PHPDebugPreferencesBlock.this.propertyPage.getShell(), (String)propertyPageID, null, null);
                dialog.setBlockOnOpen(true);
                dialog.addPageChangedListener(new IPageChangedListener(){

                    public void pageChanged(PageChangedEvent event) {
                        PHPDebugPreferencesBlock.this.refreshDebuggers();
                    }
                });
                dialog.open();
                if (!PHPDebugPreferencesBlock.this.fDefaultServer.isDisposed() && !PHPDebugPreferencesBlock.this.fDefaultPHPExe.isDisposed()) {
                    PHPDebugPreferencesBlock.this.refreshDebuggers();
                }
            }
        });
    }

    private void refreshDebuggers() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                String selectedServer = PHPDebugPreferencesBlock.this.fDefaultServer.getText();
                PHPDebugPreferencesBlock.this.loadServers(PHPDebugPreferencesBlock.this.fDefaultServer);
                int index = PHPDebugPreferencesBlock.this.fDefaultServer.indexOf(selectedServer);
                if (index != -1) {
                    PHPDebugPreferencesBlock.this.fDefaultServer.select(index);
                }
                String serverDebuggerId = PHPDebugPlugin.getDebuggerId((String)PHPDebugPreferencesBlock.this.fDefaultServer.getText());
                PHPDebugPreferencesBlock.this.fServerDebugger.setText(PHPDebuggersRegistry.getDebuggerName((String)serverDebuggerId));
                String selectedPHP = PHPDebugPreferencesBlock.this.fDefaultPHPExe.getText();
                PHPDebugPreferencesBlock.this.loadPHPExes(PHPDebugPreferencesBlock.this.fDefaultPHPExe, PHPexes.getInstance().getAllItems());
                index = PHPDebugPreferencesBlock.this.fDefaultPHPExe.indexOf(selectedPHP);
                PHPDebugPreferencesBlock.this.fDefaultPHPExe.select(index != -1 ? index : 0);
                PHPexeItem item = PHPexes.getInstance().getItem(PHPDebugPreferencesBlock.this.fDefaultPHPExe.getText());
                if (item != null) {
                    PHPDebugPreferencesBlock.this.fCLIDebugger.setText(PHPDebuggersRegistry.getDebuggerName((String)item.getDebuggerID()));
                } else {
                    PHPDebugPreferencesBlock.this.fCLIDebugger.setText(PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined);
                }
            }
        });
    }

    private void selectComboItem(Combo combo, int itemIndex) {
        if (itemIndex < 0) {
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        } else {
            combo.select(itemIndex);
        }
    }

    private Combo addEncodingSettings(Composite parent) {
        Combo encodingCombo = new Combo(parent, 0);
        GridData data = new GridData();
        encodingCombo.setLayoutData((Object)data);
        List encodings = IDEEncoding.getIDEEncodings();
        String[] encodingStrings = new String[encodings.size()];
        encodings.toArray(encodingStrings);
        encodingCombo.setItems(encodingStrings);
        return encodingCombo;
    }

    private Combo addCombo(Composite parent, int horizontalIndent) {
        Combo combo = new Combo(parent, 2060);
        GridData gd = new GridData(768);
        gd.horizontalIndent = horizontalIndent;
        combo.setLayoutData((Object)gd);
        return combo;
    }

    private Text addText(Composite parent, int horizontalIndent, int style) {
        Text text = new Text(parent, style);
        GridData gd = new GridData(768);
        gd.horizontalIndent = horizontalIndent;
        text.setLayoutData((Object)gd);
        return text;
    }

    private void savePreferences(boolean isProjectSpecific) {
        IEclipsePreferences prefs = PHPDebugPlugin.getInstancePreferences();
        IScopeContext[] preferenceScopes = this.createPreferenceScopes(this.propertyPage);
        IEclipsePreferences debugUINode = preferenceScopes[0].getNode(this.getPreferenceNodeQualifier());
        String phpExe = this.fDefaultPHPExe.getText();
        IProject project = this.getProject(this.propertyPage);
        if (isProjectSpecific && debugUINode != null && preferenceScopes[0] instanceof ProjectScope && project != null) {
            debugUINode.putBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, this.fStopAtFirstLine.getSelection());
            if (!PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined.equals(phpExe)) {
                debugUINode.put(PHPDebugCorePreferenceNames.DEFAULT_PHP, phpExe);
            }
            debugUINode.put(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, this.fDebugEncodingSettings.getText());
            debugUINode.put(PHPDebugCorePreferenceNames.OUTPUT_ENCODING, this.fOutputEncodingSettings.getText());
            ServersManager.setDefaultServer((IProject)project, (String)this.fDefaultServer.getText());
            Server server = ServersManager.getServer((String)this.fDefaultServer.getText());
            this.setBasePathValue(project, this.fDefaultBasePath.getText());
        } else if (project == null) {
            prefs.putBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, this.fStopAtFirstLine.getSelection());
            prefs.put(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, this.fDebugEncodingSettings.getText());
            prefs.put(PHPDebugCorePreferenceNames.OUTPUT_ENCODING, this.fOutputEncodingSettings.getText());
            if (!PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined.equals(phpExe)) {
                prefs.put(PHPDebugCorePreferenceNames.DEFAULT_PHP, phpExe);
            }
            ServersManager.setDefaultServer((IProject)project, (String)this.fDefaultServer.getText());
        } else if (debugUINode != null) {
            debugUINode.remove(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE);
            debugUINode.remove(PHPDebugCorePreferenceNames.DEFAULT_PHP);
            ServersManager.setDefaultServer((IProject)project, null);
            debugUINode.remove(PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
            debugUINode.remove(PHPDebugCorePreferenceNames.OUTPUT_ENCODING);
        }
        try {
            if (debugUINode != null) {
                debugUINode.flush();
            }
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Logger.logException(e);
        }
    }

    private String getServerDebuggerId() {
        return PHPDebugPlugin.getDebuggerId((String)this.fDefaultServer.getText());
    }

    private boolean isValidEncoding(String enc) {
        try {
            return Charset.isSupported(enc);
        }
        catch (IllegalCharsetNameException e) {
            return false;
        }
    }

    private void resolveAndSetBaseURL() throws MalformedURLException {
        Server server = this.getDefaultServer();
        IPath basePath = this.getDefaultBasePath();
        if (basePath != null) {
            URL baseURL = this.generateBaseURL(server, basePath);
            this.displayDefaultBaseURL(baseURL);
        }
    }

    private void refreshAutoGeneratedBaseURLDisplay() throws MalformedURLException {
        if (!this.isPropertyPage) {
            return;
        }
        Path path = new Path(this.fDefaultBasePath.getText());
        this.defaultBasePath = this.fDefaultBasePath.getText();
        Server server = ServersManager.getServer((String)this.getSelectedServerName());
        this.autoGeneratedURL = this.generateBaseURL(server, (IPath)path);
        this.dispalyAutoGeneratedURL(this.autoGeneratedURL);
    }

    public void setValidator(IPageValidator pageValidator) {
        this.pageValidator = pageValidator;
    }

    void setIsProjectSpecific(boolean isProjectSpecific) {
        this.isProjectSpecific = isProjectSpecific;
    }
}

