/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences.stepFilter;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.internal.core.PHPToolkitUtil;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.internal.debug.ui.preferences.stepFilter.IncPathFile;

public class PHPResourceContentProvider
implements ITreeContentProvider {
    public Object[] getChildren(Object parentElement) {
        try {
            if (parentElement instanceof IContainer) {
                IResource[] members;
                LinkedList<Object> r = new LinkedList<Object>();
                IContainer container = (IContainer)parentElement;
                IResource[] iResourceArray = members = container.members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (member instanceof IContainer && member.isAccessible() && !this.isResourceFiltered(member)) {
                        if (member instanceof IProject) {
                            IProject project = (IProject)member;
                            if (project.hasNature("org.eclipse.php.core.PHPNature")) {
                                r.add(member);
                            }
                        } else {
                            r.add(member);
                        }
                    }
                    ++n2;
                }
                if (parentElement instanceof IProject) {
                    IncludePath[] includePath;
                    IProject project = (IProject)parentElement;
                    IncludePath[] includePathArray = includePath = IncludePathManager.getInstance().getIncludePaths(project);
                    int n3 = includePath.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IBuildpathEntry buildpathEntry;
                        IncludePath path = includePathArray[n4];
                        if (path.isBuildpath() && ((buildpathEntry = (IBuildpathEntry)path.getEntry()).getEntryKind() == 1 || buildpathEntry.getEntryKind() == 4)) {
                            r.add(buildpathEntry);
                        }
                        ++n4;
                    }
                }
                return r.toArray();
            }
            if (parentElement instanceof IBuildpathEntry) {
                IBuildpathEntry buildpathEntry = (IBuildpathEntry)parentElement;
                IPath path = buildpathEntry.getPath();
                File file = null;
                if (buildpathEntry.getEntryKind() == 1) {
                    file = path.toFile();
                } else if (buildpathEntry.getEntryKind() == 4 && (path = DLTKCore.getResolvedVariablePath((IPath)path)) != null) {
                    file = path.toFile();
                }
                if (file != null) {
                    return this.getChildren(new IncPathFile(buildpathEntry, file));
                }
            } else if (parentElement instanceof IncPathFile) {
                IncPathFile ipFile = (IncPathFile)parentElement;
                File file = ipFile.file;
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    ArrayList<IncPathFile> r = new ArrayList<IncPathFile>(files.length);
                    File[] fileArray = files;
                    int n = files.length;
                    int n5 = 0;
                    while (n5 < n) {
                        File currentFile = fileArray[n5];
                        r.add(new IncPathFile(ipFile.IBuildpathEntry, currentFile));
                        ++n5;
                    }
                    return r.toArray();
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return new Object[0];
    }

    private boolean isResourceFiltered(IResource member) {
        if (member instanceof IFile) {
            return !PHPToolkitUtil.isPhpFile((IFile)((IFile)member));
        }
        return false;
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        if (element instanceof IncPathFile) {
            IncPathFile ipFile = (IncPathFile)element;
            return new IncPathFile(ipFile.IBuildpathEntry, ipFile.file.getParentFile());
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

