/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.formatter.core.CodeFormatterPreferences;
import org.eclipse.php.formatter.core.Logger;
import org.eclipse.php.internal.core.format.FormatPreferencesSupport;
import org.eclipse.php.internal.core.format.IFormatterCommonPrferences;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.osgi.service.prefs.Preferences;

public class PHPCodeFormatterCommonPreferences
implements IFormatterCommonPrferences {
    private CodeFormatterPreferences fCodeFormatterPreferences = CodeFormatterPreferences.getDefaultPreferences();
    private static final Map<String, Object> defaultPrefrencesValues = CodeFormatterPreferences.getDefaultPreferences().getMap();

    public int getIndentationWrappedLineSize(IDocument document) {
        CodeFormatterPreferences preferences = this.getPreferences(document);
        if (preferences == null) {
            return FormatPreferencesSupport.getInstance().getIndentationWrappedLineSize(document);
        }
        return preferences.line_wrap_wrapped_lines_indentation;
    }

    public int getIndentationArrayInitSize(IDocument document) {
        CodeFormatterPreferences preferences = this.getPreferences(document);
        if (preferences == null) {
            return FormatPreferencesSupport.getInstance().getIndentationArrayInitSize(document);
        }
        return preferences.line_wrap_array_init_indentation;
    }

    public int getIndentationSize(IDocument document) {
        CodeFormatterPreferences preferences = this.getPreferences(document);
        if (preferences == null) {
            return FormatPreferencesSupport.getInstance().getIndentationSize(document);
        }
        return preferences.indentationSize;
    }

    public char getIndentationChar(IDocument document) {
        CodeFormatterPreferences preferences = this.getPreferences(document);
        if (preferences == null) {
            return FormatPreferencesSupport.getInstance().getIndentationChar(document);
        }
        return preferences.indentationChar;
    }

    private CodeFormatterPreferences getPreferences(IDocument document) {
        block16: {
            IStructuredModel structuredModel = null;
            try {
                if (!(document instanceof IStructuredDocument)) break block16;
                structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
                if (structuredModel == null) {
                    try {
                        CodeFormatterPreferences preferences;
                        CodeFormatterPreferences codeFormatterPreferences = preferences = this.getPreferences((IProject)null);
                        return codeFormatterPreferences;
                    }
                    catch (Exception preferences) {
                        if (structuredModel != null) {
                            structuredModel.releaseFromRead();
                        }
                        return null;
                    }
                }
                IProject project = PHPCodeFormatterCommonPreferences.getProject(structuredModel);
                if (project == null) {
                    Logger.logException(new IllegalStateException("Cann't resolve file name"));
                }
                try {
                    CodeFormatterPreferences preferences;
                    CodeFormatterPreferences codeFormatterPreferences = preferences = this.getPreferences(project);
                    return codeFormatterPreferences;
                }
                catch (Exception exception) {
                    try {
                    }
                    catch (Exception e) {
                        Logger.logException(e);
                    }
                }
            }
            finally {
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
            }
        }
        return null;
    }

    private CodeFormatterPreferences getPreferences(IProject project) throws Exception {
        IEclipsePreferences node = null;
        if (project != null) {
            ProjectScope scope = new ProjectScope(project);
            node = scope.getNode("org.eclipse.php.formatter.core");
        }
        if (node == null || node.get("formatterProfile", null) == null) {
            IScopeContext context = InstanceScope.INSTANCE;
            node = context.getNode("org.eclipse.php.formatter.core");
        }
        HashMap<String, Object> p = new HashMap<String, Object>(defaultPrefrencesValues);
        if (node != null && node.keys().length > 0) {
            Set propertiesNames = p.keySet();
            for (String property : propertiesNames) {
                String value = node.get(property, null);
                if (value == null) continue;
                p.put(property, value);
            }
        } else {
            IPreferencesService service = Platform.getPreferencesService();
            String[] lookup = service.getLookupOrder("org.eclipse.php.formatter.core", null);
            Preferences[] nodes = new Preferences[lookup.length];
            int i = 0;
            while (i < lookup.length) {
                nodes[i] = service.getRootNode().node(lookup[i]).node("org.eclipse.php.formatter.core");
                ++i;
            }
            for (String property : p.keySet()) {
                String value = service.get(property, null, nodes);
                if (value == null) continue;
                p.put(property, value);
            }
        }
        this.fCodeFormatterPreferences.setPreferencesValues(p);
        return this.fCodeFormatterPreferences;
    }

    private static final IProject getProject(IStructuredModel doModelForPHP) {
        IFile file;
        String id = doModelForPHP.getId();
        if (id != null && (file = PHPCodeFormatterCommonPreferences.getFile(id)) != null) {
            return file.getProject();
        }
        return null;
    }

    private static IFile getFile(String id) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(id));
    }

    public int getTabSize(IDocument document) {
        CodeFormatterPreferences preferences = this.getPreferences(document);
        if (preferences == null) {
            return FormatPreferencesSupport.getInstance().getIndentationSize(document);
        }
        return preferences.tabSize;
    }

    public boolean useTab(IDocument document) {
        return this.getIndentationChar(document) == '\t';
    }
}

